/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.agreement.ability.bo.AgrAgreementSkuChangeStockReqBO;
import com.tydic.agreement.ability.bo.AgrAgreementSkuChangeStockRspBO;
import com.tydic.agreement.ability.bo.AgrSkuChangeStockBO;
import com.tydic.agreement.atom.api.AgrSyncSkuStatusToCommidityAtomService;
import com.tydic.agreement.atom.bo.AgrSyncSkuStatusToCommidityAtomReqBO;
import com.tydic.agreement.atom.bo.AgrSyncSkuStatusToCommidityAtomRspBO;
import com.tydic.agreement.busi.api.AgrAgreementSkuChangeStockBusiService;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.po.AgreementSkuPO;
import com.tydic.uac.exception.BusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgrAgreementSkuChangeStockBusiServiceImpl
implements AgrAgreementSkuChangeStockBusiService {
    private static final Byte CONSUME = 1;
    private static final Byte RETURN = 2;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgrSyncSkuStatusToCommidityAtomService agrSyncSkuStatusToCommidityAtomService;

    @Override
    public AgrAgreementSkuChangeStockRspBO stockChange(AgrAgreementSkuChangeStockReqBO reqBO) {
        AgreementSkuPO agreementSkuPO;
        String msg;
        AgrAgreementSkuChangeStockRspBO rspBO = new AgrAgreementSkuChangeStockRspBO();
        ArrayList<Long> errorSkuIds = new ArrayList<Long>();
        rspBO.setFailedSkuIds(errorSkuIds);
        HashMap<Long, AgreementPO> agreementPOMap = new HashMap<Long, AgreementPO>();
        Date now = new Date();
        List<Long> agreementSkuIds = reqBO.getSkuStockChangeList().stream().map(AgrSkuChangeStockBO::getAgreementSkuId).collect(Collectors.toList());
        Map<Object, Object> agreementSkuIdMap = new HashMap();
        ArrayList<Long> stockChangeOkAgreementIds = new ArrayList<Long>();
        Map<Object, Object> agreementSkuIdPOMap = new HashMap();
        ArrayList<Long> errorFailSkuIds = new ArrayList<Long>();
        if (CollectionUtils.isEmpty(agreementSkuIds)) {
            throw new ZTBusinessException("\u534f\u8bae\u660e\u7ec6id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AgreementSkuPO searchPO = new AgreementSkuPO();
        searchPO.setAgreementSkuIds(agreementSkuIds);
        List<AgreementSkuPO> agreementSkuPOS = this.agreementSkuMapper.getList(searchPO);
        agreementSkuIdMap = agreementSkuPOS.stream().collect(Collectors.toMap(AgreementSkuPO::getAgreementSkuId, AgreementSkuPO::getSaleStatus));
        agreementSkuIdPOMap = agreementSkuPOS.stream().collect(Collectors.toMap(AgreementSkuPO::getAgreementSkuId, e -> e));
        for (Object agrSkuChangeStockBO : reqBO.getSkuStockChangeList()) {
            int update;
            String saleStatus;
            if (agreementPOMap.get(agrSkuChangeStockBO.getAgreementId()) == null) {
                AgreementPO agreementPO = new AgreementPO();
                agreementPO.setAgreementId(agrSkuChangeStockBO.getAgreementId());
                AgreementPO result = this.agreementMapper.getModelBy(agreementPO);
                agreementPOMap.put(agrSkuChangeStockBO.getAgreementId(), result);
            }
            if ("3".equals(saleStatus = (String)agreementSkuIdMap.get(agrSkuChangeStockBO.getAgreementSkuId()))) {
                errorFailSkuIds.add(agrSkuChangeStockBO.getAgreementSkuId());
                continue;
            }
            if ("1".equals(saleStatus)) continue;
            BigDecimal amount = agrSkuChangeStockBO.getChangeAmount();
            if (agrSkuChangeStockBO.getType().equals(CONSUME)) {
                update = this.agreementSkuMapper.AgrAgreementSkuStockChangeSub(agrSkuChangeStockBO.getAgreementId(), agrSkuChangeStockBO.getAgreementSkuId(), amount, reqBO.getIsCloudFlag());
                if (update == 0) {
                    errorSkuIds.add(agrSkuChangeStockBO.getAgreementSkuId());
                    continue;
                }
                stockChangeOkAgreementIds.add(agrSkuChangeStockBO.getAgreementId());
                continue;
            }
            if (!agrSkuChangeStockBO.getType().equals(RETURN)) continue;
            update = this.agreementSkuMapper.AgrAgreementSkuStockChangeAdd(agrSkuChangeStockBO.getAgreementId(), agrSkuChangeStockBO.getAgreementSkuId(), amount, reqBO.getIsCloudFlag());
            if (update == 0) {
                errorSkuIds.add(agrSkuChangeStockBO.getAgreementSkuId());
                continue;
            }
            stockChangeOkAgreementIds.add(agrSkuChangeStockBO.getAgreementId());
        }
        if (!CollectionUtils.isEmpty(errorFailSkuIds)) {
            msg = "";
            for (Long errorFailSkuId : errorFailSkuIds) {
                agreementSkuPO = (AgreementSkuPO)agreementSkuIdPOMap.get(errorFailSkuId);
                AgreementPO agreementPO = (AgreementPO)agreementPOMap.get(agreementSkuPO.getAgreementId());
                msg = msg + "[\u534f\u8bae\u7f16\u53f7\uff1a" + agreementPO.getPlaAgreementCode() + ",\u7269\u6599\u7f16\u7801\uff1a" + agreementSkuPO.getMaterialCode() + "\u660e\u7ec6\u72b6\u6001\u4e3a\u5931\u6548]";
            }
            if (!CollectionUtils.isEmpty(errorSkuIds)) {
                for (Long errorSkuId : errorSkuIds) {
                    agreementSkuPO = (AgreementSkuPO)agreementSkuIdPOMap.get(errorSkuId);
                    AgreementPO agreementPO = (AgreementPO)agreementPOMap.get(agreementSkuPO.getAgreementId());
                    msg = msg + "[\u534f\u8bae\u7f16\u53f7\uff1a" + agreementPO.getPlaAgreementCode() + ",\u7269\u6599\u7f16\u7801\uff1a" + agreementSkuPO.getMaterialCode() + "\u660e\u7ec6\u5e93\u5b58\u91cf\u4e0d\u8db3]";
                }
            }
            throw new ZTBusinessException(msg);
        }
        if (!CollectionUtils.isEmpty(errorSkuIds)) {
            msg = "";
            for (Long errorSkuId : errorSkuIds) {
                agreementSkuPO = (AgreementSkuPO)agreementSkuIdPOMap.get(errorSkuId);
                AgreementPO agreementPO = (AgreementPO)agreementPOMap.get(agreementSkuPO.getAgreementId());
                msg = msg + "[\u534f\u8bae\u7f16\u53f7\uff1a" + agreementPO.getPlaAgreementCode() + ",\u7269\u6599\u7f16\u7801\uff1a" + agreementSkuPO.getMaterialCode() + "\u660e\u7ec6\u5e93\u5b58\u91cf\u4e0d\u8db3]";
            }
            throw new ZTBusinessException(msg);
        }
        if (!CollectionUtils.isEmpty(stockChangeOkAgreementIds)) {
            for (Long agreementId : stockChangeOkAgreementIds) {
                HashSet<Long> agreementIds;
                Integer totalNum = this.agreementSkuMapper.selectSkuCount(agreementId);
                Integer totalLimitNum = this.agreementSkuMapper.selectLimitSkuCount(agreementId);
                if (totalNum == 0 || !totalNum.equals(totalLimitNum)) continue;
                long stockNumber = this.agreementSkuMapper.selectCurrentSkuStock(agreementId);
                AgreementPO agreementPO = (AgreementPO)agreementPOMap.get(agreementId);
                if (agreementPO == null) continue;
                AgreementPO updatePO = new AgreementPO();
                updatePO.setAgreementId(agreementId);
                if (stockNumber <= 0L && agreementPO.getAgreementStatus().equals(AgrCommConstant.AgreementStatus.ENABLE)) {
                    updatePO.setAgreementStatus(AgrCommConstant.AgreementStatus.CLOSE);
                    this.agreementMapper.updateByCondition(updatePO);
                    agreementIds = new HashSet<Long>();
                    agreementIds.add(updatePO.getAgreementId());
                    this.syncUcc(agreementIds, AgrCommConstant.CommiditySkuStatus.INVALID);
                    continue;
                }
                if (!agreementPO.getExpDate().after(now) || !agreementPO.getEffDate().before(now)) continue;
                updatePO.setAgreementStatus(AgrCommConstant.AgreementStatus.ENABLE);
                this.agreementMapper.updateByCondition(updatePO);
                agreementIds = new HashSet();
                agreementIds.add(updatePO.getAgreementId());
                this.syncUcc(agreementIds, AgrCommConstant.CommiditySkuStatus.BE_SHELF);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f\uff01");
        return rspBO;
    }

    private void syncUcc(Set<Long> agreementIds, Byte status) {
        AgrSyncSkuStatusToCommidityAtomReqBO atomReqBO = new AgrSyncSkuStatusToCommidityAtomReqBO();
        atomReqBO.setAgreementIds(agreementIds);
        atomReqBO.setSkuStatus(status);
        AgrSyncSkuStatusToCommidityAtomRspBO atomRspBO = this.agrSyncSkuStatusToCommidityAtomService.syncSkuStatusToCommidity(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            throw new BusinessException(atomRspBO.getRespCode(), atomRspBO.getRespCode());
        }
    }
}

