/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.agreement.busi.api.AgrDeleteAgreementBusiService;
import com.tydic.agreement.busi.bo.AgrDeleteAgreementBusiReqBO;
import com.tydic.agreement.busi.bo.AgrDeleteAgreementBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.todo.ability.api.TodoWaitDoneWriteAbilityService;
import com.tydic.todo.ability.bo.TodoDeleteWaitDoneAbilityReqBO;
import com.tydic.uac.ability.UacQryAuditLogAbilityService;
import com.tydic.uac.ability.bo.UacQryAuditLogReqBO;
import com.tydic.uac.ability.bo.UacQryAuditLogRspBO;
import com.tydic.uac.bo.common.ApprovalLogBO;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AgrDeleteAgreementBusiServiceImpl
implements AgrDeleteAgreementBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrDeleteAgreementBusiServiceImpl.class);
    @Autowired
    private AgreementMapper agreementMapper;
    @Value(value="${AGR_CREATE_SYNC_CONTRACT_TOPIC:AGR_CREATE_SYNC_CONTRACT_TOPIC}")
    private String AGR_CREATE_SYNC_CONTRACT_TOPIC;
    @Value(value="${AGR_CREATE_SYNC_CONTRACT_TAG:AGR_CREATE_SYNC_CONTRACT_TOPIC}")
    private String AGR_CREATE_SYNC_CONTRACT_TAG;
    @Resource(name="agrSyncToContractMqServiceProvider")
    private ProxyMessageProducer agrSyncToContractMqServiceProvider;
    @Autowired
    private UacQryAuditLogAbilityService uacQryAuditLogAbilityService;
    @Autowired
    private TodoWaitDoneWriteAbilityService todoWaitDoneWriteAbilityService;

    @Override
    public AgrDeleteAgreementBusiRspBO deleteAgreementInfo(AgrDeleteAgreementBusiReqBO busiReqBO) {
        AgrDeleteAgreementBusiRspBO rsp = new AgrDeleteAgreementBusiRspBO();
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementIds(busiReqBO.getAgreementIds());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        List<AgreementPO> agreementPOs = this.agreementMapper.getList(agreementPO);
        if (agreementPOs.size() != busiReqBO.getAgreementIds().size()) {
            throw new BusinessException("22001", "\u6709\u4e0d\u5b58\u5728\u7684\u534f\u8baeId\uff01");
        }
        for (AgreementPO po : agreementPOs) {
            if (AgrCommConstant.AgreementStatus.DRAFT.equals(po.getAgreementStatus()) || AgrCommConstant.AgreementStatus.REJECT.equals(po.getAgreementStatus()) || AgrCommConstant.AgreementStatus.NO_CONFIRM.equals(po.getAgreementStatus())) continue;
            throw new BusinessException("22002", "\u534f\u8bae\u3010" + po.getAgreementId() + "\u3011\u4e0d\u80fd\u5220\u9664\uff0c\u53ea\u6709\u8349\u7a3f\u3001\u9a73\u56de\u548c\u672a\u63a5\u53d7\u72b6\u6001\u7684\u534f\u8bae\u53ef\u4ee5\u5220\u9664\uff01");
        }
        for (Long agreementId : busiReqBO.getAgreementIds()) {
            AgreementPO updateAgreementPO = new AgreementPO();
            updateAgreementPO.setAgreementId(agreementId);
            updateAgreementPO.setUpdateLoginId(busiReqBO.getMemIdIn());
            updateAgreementPO.setUpdateName(busiReqBO.getUserName());
            updateAgreementPO.setUpdateTime(new Date());
            updateAgreementPO.setIsDelete(AgrCommConstant.IsDelete.DELETED);
            int isUpdate = this.agreementMapper.deleteByUpdate(updateAgreementPO);
            if (isUpdate >= 1) continue;
            throw new BusinessException("22004", "\u534f\u8bae\u5220\u9664\u5931\u8d25\uff01");
        }
        for (AgreementPO agreementPO1 : agreementPOs) {
            HashMap<String, Number> content = new HashMap<String, Number>();
            content.put("agreementId", agreementPO1.getAgreementId());
            content.put("contractId", agreementPO1.getContractId());
            content.put("dealType", 0);
            this.agrSyncToContractMqServiceProvider.send(new ProxyMessage(this.AGR_CREATE_SYNC_CONTRACT_TOPIC, this.AGR_CREATE_SYNC_CONTRACT_TAG, JSON.toJSONString(content)));
        }
        this.deleteXtFlow(busiReqBO);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u5220\u9664\u6210\u529f\uff01");
        return rsp;
    }

    private void deleteXtFlow(AgrDeleteAgreementBusiReqBO busiReqBO) {
        try {
            CompletableFuture.runAsync(() -> busiReqBO.getAgreementIds().forEach(agrId -> {
                UacQryAuditLogReqBO reqBO = new UacQryAuditLogReqBO();
                reqBO.setObjId(agrId.toString());
                UacQryAuditLogRspBO uacQryAuditLogRspBO = this.uacQryAuditLogAbilityService.qryLastLog(reqBO);
                if (Objects.isNull(uacQryAuditLogRspBO) || !"0000".equals(uacQryAuditLogRspBO.getRespCode()) || CollectionUtils.isEmpty((Collection)uacQryAuditLogRspBO.getRows())) {
                    log.error("\u5220\u9664\u534f\u540c\u5f85\u529e\u6d41\u7a0b \u83b7\u53d6\u5ba1\u6279\u5386\u53f2\u8bb0\u5f55 \u5f02\u5e38 agrId:{}", agrId);
                    return;
                }
                List rows = uacQryAuditLogRspBO.getRows();
                ApprovalLogBO approvalLogBO = (ApprovalLogBO)rows.get(0);
                Long auditOrderId = approvalLogBO.getAuditOrderId();
                TodoDeleteWaitDoneAbilityReqBO todoDeleteWaitDoneAbilityReqBO = new TodoDeleteWaitDoneAbilityReqBO();
                todoDeleteWaitDoneAbilityReqBO.setUserHandlerNo(busiReqBO.getUserName());
                todoDeleteWaitDoneAbilityReqBO.setObjId(agrId.toString());
                todoDeleteWaitDoneAbilityReqBO.setFlowId(auditOrderId.toString());
                this.todoWaitDoneWriteAbilityService.deleteWaitDone(todoDeleteWaitDoneAbilityReqBO);
            }));
        }
        catch (Exception e) {
            log.error("deleteXtFlow sourceId:{} error:{}", busiReqBO.getAgreementIds(), (Object)e);
        }
    }
}

