/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.agreement.ability.bo.AgrAgreementBO;
import com.tydic.agreement.atom.api.AgrDicDictionaryAtomService;
import com.tydic.agreement.busi.api.AgrQryAgreementBySkuStatusBusiService;
import com.tydic.agreement.busi.bo.AgrQryAgreementBySkuStatusBusiReqBO;
import com.tydic.agreement.busi.bo.AgrQryAgreementBySkuStatusBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgreementMapper;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgrQryAgreementBySkuStatusBusiServiceImpl
implements AgrQryAgreementBySkuStatusBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrQryAgreementBySkuStatusBusiServiceImpl.class);
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgrDicDictionaryAtomService agrDicDictionaryAtomService;

    @Override
    public AgrQryAgreementBySkuStatusBusiRspBO qryAgreementBySkuStatus(AgrQryAgreementBySkuStatusBusiReqBO busiReqBO) {
        List<AgrAgreementBO> rows;
        AgrQryAgreementBySkuStatusBusiRspBO rsp = new AgrQryAgreementBySkuStatusBusiRspBO();
        if (busiReqBO.getIsSupermarketStaff() != null && busiReqBO.getSupermarketStaffFlag() == null) {
            busiReqBO.setSupermarketStaffFlag(busiReqBO.getIsSupermarketStaff());
        }
        if (busiReqBO.getPageQueryFlag().booleanValue()) {
            Page page = new Page(busiReqBO.getPageNo().intValue(), busiReqBO.getPageSize().intValue());
            rows = this.agreementMapper.getListPageWithSkuNum(busiReqBO, (Page<AgrAgreementBO>)page);
            rsp.setTotal(page.getTotalPages());
            rsp.setRecordsTotal(page.getTotalCount());
            rsp.setPageNo(page.getPageNo());
        } else {
            rows = this.agreementMapper.getListWithSkuNum(busiReqBO);
        }
        if (CollectionUtils.isEmpty(rows)) {
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return rsp;
        }
        if (AgrCommConstant.TranslateFlag.YES.equals(busiReqBO.getTranslateFlag())) {
            this.tanslate(rows);
        }
        rsp.setRows(rows);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u6839\u636e\u5546\u54c1\u72b6\u6001\u5206\u9875\u67e5\u8be2\u534f\u8bae\u6210\u529f\uff01");
        return rsp;
    }

    private void tanslate(List<AgrAgreementBO> rows) {
        Map<String, String> agreementModeStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "AGREEMENT_MODE_PCODE");
        Map<String, String> priceTypeStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "PRICE_TYPE_PCODE");
        Map<String, String> agreementTypeStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "AGREEMENT_TYPE_PCODE");
        Map<String, String> agreementSrcStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "AGREEMENT_SRC_PCODE");
        Map<String, String> agreementVarietyStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "AGREEMENT_VARIETY_PCODE");
        Map<String, String> currencyStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "CURRENCY_PCODE");
        Map<String, String> isDispatchStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "IS_DISPATCH_PCODE");
        Map<String, String> adjustPriceStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "ADJUST_PRICE_PCODE");
        Map<String, String> isAdjustPriceFormulaStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "IS_ADJUST_PRICE_FORMULA_PCODE");
        Map<String, String> isModifyBuyPriceStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "IS_MODIFY_BUY_PRICE_PCODE");
        Map<String, String> isAddPriceStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "IS_ADD_PRICE_PCODE");
        Map<String, String> agrLocationStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "AGR_LOCATION_PCODE");
        Map<String, String> agreementStatusStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "AGREEMENT_STATUS_PCODE");
        Map<String, String> assignStatusStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "ASSIGN_STATUS_PCODE");
        Map<String, String> supplierModeStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "SUPPLIER_MODE_PCODE");
        Map<String, String> tradeModeStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "TRADE_MODE");
        log.error("tradeModeStr\u7684\u503c==" + tradeModeStr.toString());
        for (AgrAgreementBO agrAgreementBO : rows) {
            if (null != agrAgreementBO.getAgreementMode()) {
                agrAgreementBO.setAgreementModeStr(agreementModeStr.get(agrAgreementBO.getAgreementMode().toString()));
            }
            if (null != agrAgreementBO.getPriceType()) {
                agrAgreementBO.setPriceTypeStr(priceTypeStr.get(agrAgreementBO.getPriceType().toString()));
            }
            if (null != agrAgreementBO.getAgreementType()) {
                agrAgreementBO.setAgreementTypeStr(agreementTypeStr.get(agrAgreementBO.getAgreementType().toString()));
            }
            if (null != agrAgreementBO.getAgreementSrc()) {
                agrAgreementBO.setAgreementSrcStr(agreementSrcStr.get(agrAgreementBO.getAgreementSrc().toString()));
            }
            if (null != agrAgreementBO.getAgreementVariety()) {
                agrAgreementBO.setAgreementVarietyStr(agreementVarietyStr.get(agrAgreementBO.getAgreementVariety().toString()));
            }
            if (null != agrAgreementBO.getCurrency()) {
                agrAgreementBO.setCurrencyStr(currencyStr.get(agrAgreementBO.getCurrency().toString()));
            }
            if (null != agrAgreementBO.getIsDispatch()) {
                agrAgreementBO.setIsDispatchStr(isDispatchStr.get(agrAgreementBO.getIsDispatch().toString()));
            }
            if (null != agrAgreementBO.getAdjustPrice()) {
                agrAgreementBO.setAdjustPriceStr(adjustPriceStr.get(agrAgreementBO.getAdjustPrice().toString()));
            }
            if (null != agrAgreementBO.getIsAdjustPriceFormula()) {
                agrAgreementBO.setIsAdjustPriceFormulaStr(isAdjustPriceFormulaStr.get(agrAgreementBO.getIsAdjustPriceFormula().toString()));
            }
            if (null != agrAgreementBO.getIsModifyBuyPrice()) {
                agrAgreementBO.setIsModifyBuyPriceStr(isModifyBuyPriceStr.get(agrAgreementBO.getIsModifyBuyPrice().toString()));
            }
            if (null != agrAgreementBO.getIsAddPrice()) {
                agrAgreementBO.setIsAddPriceStr(isAddPriceStr.get(agrAgreementBO.getIsAddPrice().toString()));
            }
            if (null != agrAgreementBO.getAgrLocation()) {
                agrAgreementBO.setAgrLocationStr(agrLocationStr.get(agrAgreementBO.getAgrLocation().toString()));
            }
            if (null != agrAgreementBO.getAgreementStatus()) {
                agrAgreementBO.setAgreementStatusStr(agreementStatusStr.get(agrAgreementBO.getAgreementStatus().toString()));
            }
            if (null != agrAgreementBO.getAssignStatus()) {
                agrAgreementBO.setAssignStatusStr(assignStatusStr.get(agrAgreementBO.getAssignStatus().toString()));
            }
            if (null != agrAgreementBO.getSupplierMode()) {
                agrAgreementBO.setSupplierModeStr(supplierModeStr.get(agrAgreementBO.getSupplierMode().toString()));
            }
            if (null == agrAgreementBO.getTradeMode()) continue;
            if (null != agrAgreementBO.getCloudWarehouseFlag() && agrAgreementBO.getCloudWarehouseFlag().equals(1)) {
                agrAgreementBO.setTradeModeStr("\u96c6\u91c7\u96c6\u4f9b-\u4e91\u4ed3\u534f\u8bae");
            } else {
                agrAgreementBO.setTradeModeStr(tradeModeStr.get(agrAgreementBO.getTradeMode().toString()));
            }
            log.error("TradeModeStr\u7684\u503c---------------" + tradeModeStr.get(agrAgreementBO.getTradeMode().toString()));
        }
    }
}

