/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.agreement.ability.bo.AgrAgreementSkuBO;
import com.tydic.agreement.atom.api.AgrDicDictionaryAtomService;
import com.tydic.agreement.busi.api.AgrQryAgreementSkuByPageBusiService;
import com.tydic.agreement.busi.bo.AgrQryAgreementSkuByPageBusiReqBO;
import com.tydic.agreement.busi.bo.AgrQryAgreementSkuByPageBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgreementSkuLogMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.utils.MoneyUtils;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgrQryAgreementSkuByPageBusiServiceImpl
implements AgrQryAgreementSkuByPageBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrQryAgreementSkuByPageBusiServiceImpl.class);
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgreementSkuLogMapper agreementSkuLogMapper;
    @Autowired
    private AgrDicDictionaryAtomService agrDicDictionaryAtomService;
    private static final byte TRADE = 1;
    private static final byte DEAL = 2;

    @Override
    public AgrQryAgreementSkuByPageBusiRspBO qryAgreementSkuByPage(AgrQryAgreementSkuByPageBusiReqBO busiReqBO) {
        List<AgrAgreementSkuBO> rows;
        AgrQryAgreementSkuByPageBusiRspBO rsp = new AgrQryAgreementSkuByPageBusiRspBO();
        if (busiReqBO.getPageQueryFlag().booleanValue()) {
            Page page = new Page(busiReqBO.getPageNo().intValue(), busiReqBO.getPageSize().intValue());
            busiReqBO.setVendorStatus(1);
            rows = this.agreementSkuMapper.getListPageByCondition(busiReqBO, (Page<AgrAgreementSkuBO>)page);
            rsp.setTotal(page.getTotalPages());
            rsp.setRecordsTotal(page.getTotalCount());
            rsp.setPageNo(page.getPageNo());
        } else {
            rows = this.agreementSkuMapper.getListByCondition(busiReqBO);
        }
        if (!CollectionUtils.isEmpty(rows)) {
            if (busiReqBO.getAgreementId() != null) {
                // empty if block
            }
            Map<String, String> isOilStrMap = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "IS_OIL_PCODE");
            Map<String, String> isDispatchStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "IS_DISPATCH_PCODE");
            Map<String, String> agreementStatusStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "AGREEMENT_STATUS_PCODE");
            Map<String, String> adjustPriceStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "ADJUST_PRICE_PCODE");
            Map<String, String> skuSourceStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "SKU_SOURCE_PCODE");
            Map<String, String> saleStatusStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "SALE_STATUS_PCODE");
            for (AgrAgreementSkuBO agrAgreementSkuBO : rows) {
                if (agrAgreementSkuBO.getContractItemStatus() != null) {
                    agrAgreementSkuBO.setContractItemStatusStr(AgrCommConstant.ContractItemStatusEnum.getDesc(agrAgreementSkuBO.getContractItemStatus()));
                }
                if (agrAgreementSkuBO.getIsOil() != null) {
                    agrAgreementSkuBO.setIsOilStr(isOilStrMap.get(agrAgreementSkuBO.getIsOil().toString()));
                }
                if (null != agrAgreementSkuBO.getIsDispatch()) {
                    agrAgreementSkuBO.setIsDispatchStr(isDispatchStr.get(agrAgreementSkuBO.getIsDispatch().toString()));
                }
                if (null != agrAgreementSkuBO.getAgreementStatus()) {
                    agrAgreementSkuBO.setAgreementStatusStr(agreementStatusStr.get(agrAgreementSkuBO.getAgreementStatus().toString()));
                }
                if (null != agrAgreementSkuBO.getAdjustPrice()) {
                    agrAgreementSkuBO.setAdjustPriceStr(adjustPriceStr.get(agrAgreementSkuBO.getAdjustPrice().toString()));
                }
                if (null != agrAgreementSkuBO.getSkuSource()) {
                    agrAgreementSkuBO.setSkuSourceStr(skuSourceStr.get(agrAgreementSkuBO.getSkuSource()));
                }
                if (null != agrAgreementSkuBO.getSaleStatus()) {
                    agrAgreementSkuBO.setSaleStatusStr(saleStatusStr.get(agrAgreementSkuBO.getSaleStatus()));
                }
                if (null != agrAgreementSkuBO.getTradeMode()) {
                    if (agrAgreementSkuBO.getTradeMode().equals((byte)1)) {
                        agrAgreementSkuBO.setProviderName(agrAgreementSkuBO.getVendorDepartmentName());
                    }
                    if (!agrAgreementSkuBO.getTradeMode().equals((byte)1)) {
                        agrAgreementSkuBO.setProviderName(agrAgreementSkuBO.getVendorName());
                    }
                }
                if (null != agrAgreementSkuBO.getIsInnerVendor()) {
                    agrAgreementSkuBO.setIsInnerVendorStr(agrAgreementSkuBO.getIsInnerVendor() == 0 ? "\u5426" : "\u662f");
                }
                if (agrAgreementSkuBO.getOrderMethod() == null || agrAgreementSkuBO.getOrderMethod() == 1) {
                    agrAgreementSkuBO.setOrderMethodStr("\u76f4\u63a5\u4e0b\u5355");
                } else if (agrAgreementSkuBO.getOrderMethod() == 2) {
                    agrAgreementSkuBO.setOrderMethodStr("\u8bae\u4ef7\u4e0b\u5355");
                }
                if (agrAgreementSkuBO.getTradeMode() != null) {
                    if (agrAgreementSkuBO.getTradeMode() == 1) {
                        agrAgreementSkuBO.setProtocolType("\u96c6\u91c7\u96c6\u4f9b");
                    } else if (agrAgreementSkuBO.getTradeMode() == 2) {
                        agrAgreementSkuBO.setProtocolType("\u96c6\u91c7\u5206\u7b7e");
                    }
                }
                try {
                    agrAgreementSkuBO.setBuyPrice(MoneyUtils.calculate2Decimals(agrAgreementSkuBO.getBuyPrice(), 8));
                    agrAgreementSkuBO.setBuyPriceSum(MoneyUtils.calculate2Decimals(agrAgreementSkuBO.getBuyPriceSum(), 2));
                    agrAgreementSkuBO.setSalePrice(MoneyUtils.calculate2Decimals(agrAgreementSkuBO.getSalePrice(), 8));
                    agrAgreementSkuBO.setSalePriceSum(MoneyUtils.calculate2Decimals(agrAgreementSkuBO.getSalePriceSum(), 2));
                    if (agrAgreementSkuBO.getBuyPrice() != null) {
                        agrAgreementSkuBO.setBuyPriceStr(agrAgreementSkuBO.getBuyPrice().toPlainString());
                    }
                    if (agrAgreementSkuBO.getBuyPriceSum() != null) {
                        agrAgreementSkuBO.setBuyPriceSumStr(agrAgreementSkuBO.getBuyPriceSum().toPlainString());
                    }
                    if (agrAgreementSkuBO.getSalePrice() != null) {
                        agrAgreementSkuBO.setSalePriceStr(agrAgreementSkuBO.getSalePrice().toPlainString());
                    }
                    if (agrAgreementSkuBO.getSalePriceSum() == null) continue;
                    agrAgreementSkuBO.setSalePriceSumStr(agrAgreementSkuBO.getSalePriceSum().toPlainString());
                }
                catch (Exception e) {
                    log.error("\u5355\u4f4d\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        if (CollectionUtils.isEmpty(rows)) {
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return rsp;
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u660e\u7ec6\u4fe1\u606f\u5206\u9875\u67e5\u8be2\u6210\u529f\uff01");
        rsp.setRows(rows);
        return rsp;
    }
}

