/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.agreement.ability.bo.AgrAgreementSkuChangeBO;
import com.tydic.agreement.atom.api.AgrDicDictionaryAtomService;
import com.tydic.agreement.busi.api.AgrQryAgreementSkuChangeBusiService;
import com.tydic.agreement.busi.bo.AgrQryAgreementSkuChangeBusiReqBO;
import com.tydic.agreement.busi.bo.AgrQryAgreementSkuChangeBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgreementSkuChangeMapper;
import com.tydic.agreement.po.AgreementSkuChangePO;
import com.tydic.agreement.utils.MoneyUtils;
import com.tydic.uoc.common.ability.api.UocAgreementItemOrderPurchaseAbilityService;
import com.tydic.uoc.common.ability.bo.UocAgreementItemOrderPurchaseAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocAgreementItemOrderPurchaseAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgrQryAgreementSkuChangeBusiServiceImpl
implements AgrQryAgreementSkuChangeBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrQryAgreementSkuChangeBusiServiceImpl.class);
    @Autowired
    private AgreementSkuChangeMapper agreementSkuChangeMapper;
    @Autowired
    private AgrDicDictionaryAtomService agrDicDictionaryAtomService;
    @Autowired
    private UocAgreementItemOrderPurchaseAbilityService uocAgreementItemOrderPurchaseAbilityService;

    @Override
    public AgrQryAgreementSkuChangeBusiRspBO qryAgreementSkuChange(AgrQryAgreementSkuChangeBusiReqBO busiReqBO) {
        List<AgreementSkuChangePO> agreementSkuChangePOs;
        AgrQryAgreementSkuChangeBusiRspBO rsp = new AgrQryAgreementSkuChangeBusiRspBO();
        ArrayList<AgrAgreementSkuChangeBO> rows = new ArrayList<AgrAgreementSkuChangeBO>();
        AgreementSkuChangePO agreementSkuChangePO = new AgreementSkuChangePO();
        BeanUtils.copyProperties((Object)((Object)busiReqBO), (Object)agreementSkuChangePO);
        if (!CollectionUtils.isEmpty(busiReqBO.getChangeIds())) {
            agreementSkuChangePO.setChangeIds(new HashSet<Long>(busiReqBO.getChangeIds()));
        }
        agreementSkuChangePO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        if (busiReqBO.getPageQueryFlag().booleanValue()) {
            Page page = new Page(busiReqBO.getPageNo().intValue(), busiReqBO.getPageSize().intValue());
            agreementSkuChangePOs = this.agreementSkuChangeMapper.getListPage(agreementSkuChangePO, (Page<AgreementSkuChangePO>)page);
            rsp.setTotal(page.getTotalPages());
            rsp.setRecordsTotal(page.getTotalCount());
            rsp.setPageNo(page.getPageNo());
        } else {
            agreementSkuChangePOs = this.agreementSkuChangeMapper.getList(agreementSkuChangePO);
        }
        if (CollectionUtils.isEmpty(agreementSkuChangePOs)) {
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return rsp;
        }
        for (AgreementSkuChangePO po : agreementSkuChangePOs) {
            AgrAgreementSkuChangeBO agrAgreementSkuChangeBO = new AgrAgreementSkuChangeBO();
            BeanUtils.copyProperties((Object)po, (Object)agrAgreementSkuChangeBO);
            rows.add(agrAgreementSkuChangeBO);
        }
        Map<String, String> skuSourceStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "SKU_SOURCE_PCODE");
        Map<String, String> saleStatusStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "SALE_STATUS_PCODE");
        Map<String, String> agrchangeType = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "CHANGE_TYPE_PCODE");
        if (busiReqBO.getAgreementId() != null) {
            // empty if block
        }
        HashSet<Long> agreementItems = new HashSet<Long>();
        for (AgrAgreementSkuChangeBO bo : rows) {
            bo.setBuyPrice(MoneyUtils.calculate2Decimals(bo.getBuyPrice(), 8));
            bo.setBuyPriceSum(MoneyUtils.calculate2Decimals(bo.getBuyPriceSum(), 2));
            bo.setSalePrice(MoneyUtils.calculate2Decimals(bo.getSalePrice(), 8));
            bo.setSalePriceSum(MoneyUtils.calculate2Decimals(bo.getSalePriceSum(), 2));
            if (null != bo.getIsOil()) {
                bo.setIsOilStr(this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "IS_OIL_PCODE", bo.getIsOil().toString()));
            }
            if (null != bo.getSkuSource()) {
                bo.setSkuSourceStr(skuSourceStr.get(bo.getSkuSource()));
            }
            if (null != bo.getSaleStatus()) {
                bo.setSaleStatusStr(saleStatusStr.get(bo.getSaleStatus()));
            }
            if (null != bo.getAgrChangeType()) {
                bo.setAgrChangeTypeStr(agrchangeType.get(bo.getAgrChangeType() + ""));
            }
            if (null != bo.getChangeType()) {
                if (bo.getChangeType() == 1) {
                    bo.setChangeTypeStr("\u65b0\u589e");
                } else if (bo.getChangeType() == 2) {
                    bo.setChangeTypeStr("\u4fee\u6539");
                } else if (bo.getChangeType() == 3) {
                    bo.setChangeTypeStr("\u5220\u9664");
                }
            }
            if (bo.getAgreementSkuId() == null) continue;
            agreementItems.add(bo.getAgreementSkuId());
        }
        if (!CollectionUtils.isEmpty(agreementItems)) {
            List list;
            UocAgreementItemOrderPurchaseAbilityReqBO uocReqBO = new UocAgreementItemOrderPurchaseAbilityReqBO();
            uocReqBO.setAgreementSkuItems(new ArrayList(agreementItems));
            UocAgreementItemOrderPurchaseAbilityRspBO rspBO = this.uocAgreementItemOrderPurchaseAbilityService.searchPurchaseCount(uocReqBO);
            if ("0000".equals(rspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)(list = rspBO.getItems()))) {
                Map<String, BigDecimal> map = list.stream().collect(Collectors.toMap(e -> e.getAgreementItemId(), e -> e.getPurchaseCount(), (k, v) -> k));
                for (AgrAgreementSkuChangeBO row : rows) {
                    row.setPurchaseCount(map.get(row.getAgreementSkuId() + ""));
                    log.error(map.toString());
                    log.error("\u63a5\u53e3\u8fd4\u56de\u4e0b\u5355\u91cf:" + map.get(row.getAgreementSkuId() + ""));
                }
            }
        }
        rsp.setRows(rows);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u660e\u7ec6\u53d8\u66f4\u5206\u9875\u67e5\u8be2\u6210\u529f\uff01");
        return rsp;
    }
}

