/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.agreement.ability.bo.AgrAgreementSkuBO;
import com.tydic.agreement.atom.api.AgrDicDictionaryAtomService;
import com.tydic.agreement.busi.api.AgrQryAgreementSkuWithSubjectByPageBusiService;
import com.tydic.agreement.busi.bo.AgrQryAgreementSkuWithSubjectByPageBusiReqBO;
import com.tydic.agreement.busi.bo.AgrQryAgreementSkuWithSubjectByPageBusiRspBO;
import com.tydic.agreement.dao.AgreementSkuMapper;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgrQryAgreementSkuWithSubjectByPageBusiServiceImpl
implements AgrQryAgreementSkuWithSubjectByPageBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrQryAgreementSkuWithSubjectByPageBusiServiceImpl.class);
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgrDicDictionaryAtomService agrDicDictionaryAtomService;

    @Override
    public AgrQryAgreementSkuWithSubjectByPageBusiRspBO qryAgreementSkuWithSubjectByPage(AgrQryAgreementSkuWithSubjectByPageBusiReqBO reqBO) {
        List<AgrAgreementSkuBO> rows;
        AgrQryAgreementSkuWithSubjectByPageBusiRspBO rsp = new AgrQryAgreementSkuWithSubjectByPageBusiRspBO();
        if (reqBO.getPageQueryFlag().booleanValue()) {
            Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
            rows = this.agreementSkuMapper.getListPageWithSubjectByCondition(reqBO, (Page<AgrAgreementSkuBO>)page);
            rsp.setTotal(page.getTotalPages());
            rsp.setRecordsTotal(page.getTotalCount());
            rsp.setPageNo(page.getPageNo());
        } else {
            rows = this.agreementSkuMapper.getListPageWithSubjectByCondition(reqBO, (Page<AgrAgreementSkuBO>)new Page(-1, -1));
        }
        if (!CollectionUtils.isEmpty(rows)) {
            Map<String, String> isOilStrMap = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "IS_OIL_PCODE");
            Map<String, String> isDispatchStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "IS_DISPATCH_PCODE");
            Map<String, String> agreementStatusStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "AGREEMENT_STATUS_PCODE");
            Map<String, String> adjustPriceStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcode("AGR", "ADJUST_PRICE_PCODE");
            for (AgrAgreementSkuBO agrAgreementSkuBO : rows) {
                if (agrAgreementSkuBO.getIsOil() != null) {
                    agrAgreementSkuBO.setIsOilStr(isOilStrMap.get(agrAgreementSkuBO.getIsOil().toString()));
                }
                if (null != agrAgreementSkuBO.getIsDispatch()) {
                    agrAgreementSkuBO.setIsDispatchStr(isDispatchStr.get(agrAgreementSkuBO.getIsDispatch().toString()));
                }
                if (null != agrAgreementSkuBO.getAgreementStatus()) {
                    agrAgreementSkuBO.setAgreementStatusStr(agreementStatusStr.get(agrAgreementSkuBO.getAgreementStatus().toString()));
                }
                if (null != agrAgreementSkuBO.getAdjustPrice()) {
                    agrAgreementSkuBO.setAdjustPriceStr(adjustPriceStr.get(agrAgreementSkuBO.getAdjustPrice().toString()));
                }
                try {
                    if (agrAgreementSkuBO.getBuyPrice() != null) {
                        agrAgreementSkuBO.setBuyPriceStr(agrAgreementSkuBO.getBuyPrice().toPlainString());
                    }
                    if (agrAgreementSkuBO.getBuyPriceSum() != null) {
                        agrAgreementSkuBO.setBuyPriceSumStr(agrAgreementSkuBO.getBuyPriceSum().toPlainString());
                    }
                    if (agrAgreementSkuBO.getSalePrice() != null) {
                        agrAgreementSkuBO.setSalePriceStr(agrAgreementSkuBO.getSalePrice().toPlainString());
                    }
                    if (agrAgreementSkuBO.getSalePriceSum() == null) continue;
                    agrAgreementSkuBO.setSalePriceSumStr(agrAgreementSkuBO.getSalePriceSum().toPlainString());
                }
                catch (Exception e) {
                    log.error("\u5355\u4f4d\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        if (CollectionUtils.isEmpty(rows)) {
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return rsp;
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u660e\u7ec6\u4fe1\u606f\u5206\u9875\u67e5\u8be2\u6210\u529f\uff01");
        rsp.setRows(rows);
        return rsp;
    }
}

