/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.bo.AgrPublicAbilityRspBO;
import com.tydic.agreement.busi.api.AgrShortNameListLineService;
import com.tydic.agreement.dao.AgrShortNameListLineMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgrShortNameListLinePO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgrShortNameListLineServiceImpl
implements AgrShortNameListLineService {
    private static final Logger log = LoggerFactory.getLogger(AgrShortNameListLineServiceImpl.class);
    @Autowired
    private AgrShortNameListLineMapper agrShortNameListLineMapper;

    @Override
    public AgrPublicAbilityRspBO insertShortNameList(List<AgrShortNameListLinePO> list) {
        AgrPublicAbilityRspBO rspBO = new AgrPublicAbilityRspBO();
        for (AgrShortNameListLinePO reqBO : list) {
            if (reqBO.getShorNamelistLineId() != null) continue;
            Long scopeId = Sequence.getInstance().nextId();
            reqBO.setShorNamelistLineId(scopeId);
            reqBO.setCreateTime(new Date());
            int isInsert = this.agrShortNameListLineMapper.insert(reqBO);
            if (isInsert >= 1) continue;
            throw new BusinessException("0101", "\u77ed\u540d\u5355\u65b0\u589e\u8868\u5931\u8d25\uff01");
        }
        rspBO.setRows(list);
        return rspBO;
    }

    @Override
    public AgrPublicAbilityRspBO deleteBy(AgrShortNameListLinePO po) {
        AgrPublicAbilityRspBO rsp = new AgrPublicAbilityRspBO();
        if (po.getShorNamelistLineId() == null) {
            throw new BusinessException("0001", "\u8bf7\u4f20\u5165id\uff01");
        }
        int isUpdate = this.agrShortNameListLineMapper.deleteBy(po);
        if (isUpdate < 1) {
            throw new BusinessException("22004", "\u77ed\u540d\u5355\u4fee\u6539\u5931\u8d25\uff01");
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u5220\u9664\u6210\u529f\uff01");
        return rsp;
    }

    @Override
    public AgrPublicAbilityRspBO updateStatus(AgrShortNameListLinePO po) {
        AgrPublicAbilityRspBO rsp = new AgrPublicAbilityRspBO();
        AgrShortNameListLinePO shortNameList = this.agrShortNameListLineMapper.getShortNameListCount(po);
        if (shortNameList.getCounts() > 0 && po.getShorNamelistLineStatus().equals("0")) {
            rsp.setCode("0000");
            rsp.setFlag(true);
            rsp.setMessage("\u5f53\u524d\u534f\u8bae\u5728\u77ed\u540d\u5355\uff08" + shortNameList.getShortNamelistNum() + "\uff09\u4e2d\u5df2\u5b58\u5728\u4e14\u4e3a\u542f\u7528\u72b6\u6001\uff1b\u5982\u4ecd\u9700\u7ee7\u7eed\u542f\u7528\uff0c\u8bf7\u5148\u505c\u7528/\u5220\u9664\u77ed\u540d\u5355\uff08" + shortNameList.getShortNamelistNum() + "\uff09\u4e2d\u7684\u8be5\u534f\u8bae\u8bb0\u5f55");
            return rsp;
        }
        int isUpdate = this.agrShortNameListLineMapper.updateStatus(po);
        if (isUpdate < 1) {
            throw new BusinessException("22004", "\u77ed\u540d\u5355\u660e\u7ec6\u72b6\u6001\u4fee\u6539\u5931\u8d25\uff01");
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u72b6\u6001\u4fee\u6539\u6210\u529f\uff01");
        return rsp;
    }

    @Override
    public AgrPublicAbilityRspBO getList(AgrShortNameListLinePO agrShortNameLineList) {
        AgrPublicAbilityRspBO rspBo = new AgrPublicAbilityRspBO();
        List<AgrShortNameListLinePO> list = this.agrShortNameListLineMapper.getList(agrShortNameLineList);
        rspBo.setRows(list);
        return rspBo;
    }

    @Override
    public AgrPublicAbilityRspBO getAgreementList(AgrShortNameListLinePO agrShortNameLineList) {
        AgrPublicAbilityRspBO rspBo = new AgrPublicAbilityRspBO();
        List<AgrShortNameListLinePO> list = this.agrShortNameListLineMapper.getAgreementList(agrShortNameLineList);
        rspBo.setRows(list);
        return rspBo;
    }

    @Override
    public AgrPublicAbilityRspBO getMaterialCount(AgrShortNameListLinePO agrShortNameLineList) {
        AgrPublicAbilityRspBO rspBo = new AgrPublicAbilityRspBO();
        List<AgrShortNameListLinePO> list = this.agrShortNameListLineMapper.getMaterialCount(agrShortNameLineList);
        ArrayList<AgrShortNameListLinePO> lists = new ArrayList<AgrShortNameListLinePO>();
        for (String agreementIds : agrShortNameLineList.getAgreementIds()) {
            AgrShortNameListLinePO entity = new AgrShortNameListLinePO();
            ArrayList<String> materialCodes = new ArrayList<String>();
            for (AgrShortNameListLinePO po : list) {
                if (!agreementIds.equals(String.valueOf(po.getAgreementId()))) continue;
                entity.setAgreementId(Long.valueOf(agreementIds));
                materialCodes.add(po.getMaterialCode());
            }
            entity.setMaterialCodes(materialCodes);
            lists.add(entity);
        }
        log.info("\u77ed\u540d\u5355\u7269\u8d44\uff1a" + ((Object)lists).toString());
        for (AgrShortNameListLinePO po : lists) {
            int materialCodeCount = 0;
            for (String materialCode : po.getMaterialCodes()) {
                for (String materialCodes : ((AgrShortNameListLinePO)lists.get(0)).getMaterialCodes()) {
                    if (!materialCode.equals(materialCodes)) continue;
                    ++materialCodeCount;
                }
            }
            log.info("materialCodeCount::" + materialCodeCount);
            log.info("lists.get(0).getMaterialCodes().size()::" + ((AgrShortNameListLinePO)lists.get(0)).getMaterialCodes().size());
            if (materialCodeCount == ((AgrShortNameListLinePO)lists.get(0)).getMaterialCodes().size() && ((AgrShortNameListLinePO)lists.get(0)).getMaterialCodes().size() == po.getMaterialCodes().size()) continue;
            rspBo.setT((Object)String.valueOf(2));
            rspBo.setCode("0000");
            return rspBo;
        }
        rspBo.setCode("0000");
        rspBo.setT((Object)String.valueOf(1));
        return rspBo;
    }

    @Override
    public AgrPublicAbilityRspBO getPlanBargainingCount(AgrShortNameListLinePO agrShortNameLineList) {
        AgrPublicAbilityRspBO rspBo = new AgrPublicAbilityRspBO();
        rspBo.setCode("0000");
        rspBo.setT((Object)String.valueOf(this.agrShortNameListLineMapper.getPlanBargainingCount(agrShortNameLineList)));
        return rspBo;
    }

    @Override
    public AgrPublicAbilityRspBO verificationUpdateStatus(AgrShortNameListLinePO po) {
        AgrPublicAbilityRspBO rsp = new AgrPublicAbilityRspBO();
        AgrShortNameListLinePO shortNameList = this.agrShortNameListLineMapper.getShortNameListCount(po);
        if (shortNameList.getCounts() > 0 && po.getShorNamelistLineStatus().equals("0")) {
            rsp.setCode("0000");
            rsp.setFlag(true);
            rsp.setMessage("\u5f53\u524d\u534f\u8bae\u5728\u77ed\u540d\u5355\uff08" + shortNameList.getShortNamelistNum() + "\uff09\u4e2d\u5df2\u5b58\u5728\u4e14\u4e3a\u542f\u7528\u72b6\u6001\uff1b\u5982\u4ecd\u9700\u7ee7\u7eed\u542f\u7528\uff0c\u8bf7\u5148\u505c\u7528/\u5220\u9664\u77ed\u540d\u5355\uff08" + shortNameList.getShortNamelistNum() + "\uff09\u4e2d\u7684\u8be5\u534f\u8bae\u8bb0\u5f55");
            return rsp;
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u72b6\u6001\u4fee\u6539\u6210\u529f\uff01");
        return rsp;
    }
}

