/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.agreement.ability.api.AgrBatchImportAgreementSkuChangeAbilityService;
import com.tydic.agreement.ability.bo.AgrAgreementSkuChangeBO;
import com.tydic.agreement.ability.bo.AgrBatchImportAgreementSkuChangeAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrBatchImportAgreementSkuChangeAbilityRspBO;
import com.tydic.agreement.ability.bo.AgrImoprtTemplateBO;
import com.tydic.agreement.atom.api.AgrDicDictionaryAtomService;
import com.tydic.agreement.atom.bo.AgrExternalImportResultLogAtomReqBO;
import com.tydic.agreement.atom.bo.AgrExternalImportResultLogAtomRspBO;
import com.tydic.agreement.atom.impl.CnncAgrExternalImportResultLogServiceHolder;
import com.tydic.agreement.busi.api.AgrCreateAgreementSkuChangeBusiService;
import com.tydic.agreement.busi.bo.AgrCreateAgreementSkuChangeBusiReqBO;
import com.tydic.agreement.busi.bo.AgrCreateAgreementSkuChangeBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.constants.AgrExtCommonConstant;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.utils.ExcelUtils;
import com.tydic.agreement.utils.HttpUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.entity.ContentType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"AGREEMENT_GROUP_DEV/2.1.0/com.tydic.agreement.ability.api.AgrBatchImportAgreementSkuChangeAbilityService"})
public class AgrBatchImportAgreementSkuChangeAbilityServiceImpl
implements AgrBatchImportAgreementSkuChangeAbilityService {
    private static final Logger log = LoggerFactory.getLogger(AgrBatchImportAgreementSkuChangeAbilityServiceImpl.class);
    @Autowired
    private AgrDicDictionaryAtomService agrDicDictionaryAtomService;
    @Autowired
    private AgrCreateAgreementSkuChangeBusiService agrCreateAgreementSkuChangeBusiService;
    @Autowired
    private CnncAgrExternalImportResultLogServiceHolder cnncAgrExternalImportResultLogServiceHolder;

    @PostMapping(value={"dealBatchImportAgreementSkuChange"})
    public AgrBatchImportAgreementSkuChangeAbilityRspBO dealBatchImportAgreementSkuChange(@RequestBody AgrBatchImportAgreementSkuChangeAbilityReqBO abilityReqBO) {
        AgrBatchImportAgreementSkuChangeAbilityRspBO abilityRspBO = new AgrBatchImportAgreementSkuChangeAbilityRspBO();
        if (null == abilityReqBO.getAgreementId()) {
            throw new BusinessException("0001", "\u534f\u8bae\u53d8\u66f4\u660e\u7ec6\u6279\u91cf\u5bfc\u5165API\u5165\u53c2\u3010agreementId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)abilityReqBO.getUrl())) {
            throw new BusinessException("0001", "\u534f\u8bae\u53d8\u66f4\u660e\u7ec6\u6279\u91cf\u5bfc\u5165API\u5165\u53c2\u3010url\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == abilityReqBO.getMemIdIn()) {
            throw new BusinessException("0001", "\u534f\u8bae\u53d8\u66f4\u660e\u7ec6\u6279\u91cf\u5bfc\u5165API\u5165\u53c2\u3010memIdIn\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)abilityReqBO.getChangeCode())) {
            throw new BusinessException("0001", "\u534f\u8bae\u53d8\u66f4\u660e\u7ec6\u6279\u91cf\u5bfc\u5165API\u5165\u53c2\u3010changeCode\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == abilityReqBO.getSkuChangeType()) {
            throw new BusinessException("0001", "\u534f\u8bae\u53d8\u66f4\u660e\u7ec6\u6279\u91cf\u5bfc\u5165API\u5165\u53c2\u3010skuChangeType\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List<AgrAgreementSkuChangeBO> agrAgreementSkuChangeBOS = this.analysisFile(abilityReqBO);
        AgrCreateAgreementSkuChangeBusiReqBO busiReqBO = new AgrCreateAgreementSkuChangeBusiReqBO();
        BeanUtils.copyProperties((Object)abilityReqBO, (Object)((Object)busiReqBO));
        busiReqBO.setAgrAgreementSkuChangeBOs(agrAgreementSkuChangeBOS);
        AgrCreateAgreementSkuChangeBusiRspBO busiRspBO = this.agrCreateAgreementSkuChangeBusiService.createAgreementSkuChange(busiReqBO);
        try {
            this.exportImportResults(busiReqBO, abilityReqBO);
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u8bb0\u5f55\u65b0\u589e\u51fa\u9519{}", (Object)e.getMessage());
        }
        BeanUtils.copyProperties((Object)((Object)busiRspBO), (Object)abilityRspBO);
        return abilityRspBO;
    }

    private List<AgrAgreementSkuChangeBO> analysisFile(AgrBatchImportAgreementSkuChangeAbilityReqBO abilityReqBO) {
        List agrAgreementSkuChangeBOS;
        ArrayList<String> title = new ArrayList<String>();
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        try {
            HttpUtil.deleteFile("temporaryfile/content.xlsx");
            File file = new File(System.getProperty("user.dir") + "/temporaryfile/content.xlsx");
            File fileParent = file.getParentFile();
            if (!fileParent.exists()) {
                fileParent.mkdirs();
            }
            HttpUtil.httpDownload(abilityReqBO.getUrl(), file.getAbsolutePath());
            FileInputStream fileInputStream = new FileInputStream(file);
            MockMultipartFile multipartFile = new MockMultipartFile(file.getName(), file.getName(), ContentType.APPLICATION_OCTET_STREAM.toString(), (InputStream)fileInputStream);
            if (abilityReqBO.getSkuChangeType() == 0) {
                ExcelUtils.getExcelDate((MultipartFile)multipartFile, data, title);
            } else {
                this.getExcelDateByImport((MultipartFile)multipartFile, data, title);
            }
            HttpUtil.deleteFile("temporaryfile/" + file.getName());
        }
        catch (Exception e) {
            throw new BusinessException("22052", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38\uff1a" + e);
        }
        if (CollectionUtils.isEmpty(title)) {
            throw new BusinessException("22052", "\u6587\u4ef6\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty(data)) {
            throw new BusinessException("22052", "\u6587\u4ef6\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        HashMap<String, Integer> dateMapIndex = new HashMap<String, Integer>();
        String pCode = abilityReqBO.getSkuChangeType() == 0 ? "IMPORT_SKU_CHANGE_TEMPLATE_PCODE" : "IMPORT_TEMPLATE_PCODE";
        String importTemplateStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", pCode, "1");
        List templateBOs = JSON.parseArray((String)importTemplateStr, AgrImoprtTemplateBO.class);
        block4: for (Object bo : templateBOs) {
            for (int i = 0; i < title.size(); ++i) {
                if (!((String)title.get(i)).equals(bo.getFieldName())) continue;
                dateMapIndex.put(bo.getFieldNameEng(), i);
                continue block4;
            }
        }
        ArrayList dateMaps = new ArrayList();
        for (List list : data) {
            HashMap dataMap = new HashMap();
            for (AgrImoprtTemplateBO bo : templateBOs) {
                Integer sheetKey = (Integer)dateMapIndex.get(bo.getFieldNameEng());
                if (null != sheetKey) {
                    Object content = list.get(sheetKey);
                    if (bo.getIsMustFill().booleanValue() && null == content) {
                        throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165\u3010" + bo.getFieldNameEng() + "\u3011\u5fc5\u586b\uff01");
                    }
                    if ("markupRate".equals(bo.getFieldNameEng())) {
                        String markupRate = (String)content;
                        if (StringUtils.isEmpty((Object)markupRate)) {
                            markupRate = "0";
                        }
                        markupRate = new BigDecimal(markupRate).divide(new BigDecimal(100)).toString();
                        content = markupRate;
                    }
                    if ("buyPrice".equals(bo.getFieldNameEng())) {
                        String buyPrice = (String)content;
                        if ((buyPrice = new BigDecimal(buyPrice).multiply(new BigDecimal(10000)).toString()).endsWith(".00")) {
                            buyPrice = buyPrice.substring(0, buyPrice.lastIndexOf(".00"));
                        }
                        content = buyPrice;
                    }
                    dataMap.put(bo.getFieldNameEng(), content);
                    continue;
                }
                throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165\u6570\u636e\u5e93\u6a21\u7248\u914d\u7f6e\u7684\u3010" + bo.getFieldNameEng() + "\u3011\u4e3a\u7a7a\uff01");
            }
            dateMaps.add(dataMap);
        }
        String jsonStr = JSON.toJSONString(dateMaps);
        try {
            agrAgreementSkuChangeBOS = JSON.parseArray((String)jsonStr, AgrAgreementSkuChangeBO.class);
        }
        catch (Exception exception) {
            log.error("\u586b\u5199\u6570\u636e\u4e0d\u7b26\u5408\u89c4\u8303\uff01" + exception);
            throw new BusinessException("22052", "\u586b\u5199\u6570\u636e\u4e0d\u7b26\u5408\u89c4\u8303\uff01");
        }
        for (AgrAgreementSkuChangeBO bo : agrAgreementSkuChangeBOS) {
            if (bo.getMarkupRate() == null) {
                bo.setMarkupRate(Double.valueOf(new BigDecimal("0").divide(new BigDecimal(100)).doubleValue()));
            }
            if (abilityReqBO.getSkuChangeType() == 1) {
                bo.setChangeType(AgrCommConstant.AgreementSkuChangeType.ADD);
            } else {
                bo.setChangeType(AgrCommConstant.AgreementSkuChangeType.UPDATE);
            }
            bo.setBuyPriceSum(Long.valueOf(new BigDecimal(bo.getBuyPrice()).multiply(bo.getBuyNumber()).longValue()));
            bo.setSalePrice(Long.valueOf(new BigDecimal(bo.getBuyPrice()).add(new BigDecimal(bo.getBuyPrice()).multiply(new BigDecimal(bo.getMarkupRate().toString()))).longValue()));
            bo.setSalePriceSum(Long.valueOf(new BigDecimal(bo.getSalePrice()).multiply(bo.getBuyNumber()).longValue()));
            bo.setMarkupRate(Double.valueOf(new BigDecimal(bo.getMarkupRate().toString()).multiply(new BigDecimal(100)).doubleValue()));
        }
        return agrAgreementSkuChangeBOS;
    }

    private void getExcelDateByImport(MultipartFile multipartFile, List<List<String>> data, List<String> title) {
        try {
            ExcelUtils.checkExcelVaild(multipartFile);
            Workbook workbook = ExcelUtils.getWorkbok(multipartFile);
            int count = 0;
            Sheet sheet = workbook.getSheetAt(0);
            for (Row row : sheet) {
                if (count < 10) {
                    ++count;
                    continue;
                }
                ArrayList<String> c = new ArrayList<String>();
                int end = row.getLastCellNum();
                if ("".equals(row.getCell(0).toString())) continue;
                for (int i = 0; i < end; ++i) {
                    Cell cell = row.getCell(i);
                    if (cell == null) {
                        c.add("");
                        continue;
                    }
                    Object obj = ExcelUtils.getValue(cell);
                    if (count == 10) {
                        title.add(String.valueOf(obj).trim());
                        continue;
                    }
                    if (count < 11) continue;
                    c.add(String.valueOf(obj).trim());
                }
                ++count;
                if (c.size() <= 0) continue;
                ArrayList<String> d = new ArrayList<String>();
                for (String str : c) {
                    if (str.endsWith(".00")) {
                        str = str.substring(0, str.length() - 3);
                    }
                    d.add(str);
                }
                data.add(d);
            }
        }
        catch (Exception e) {
            throw new BusinessException("22052", e.getMessage());
        }
    }

    private void exportImportResults(AgrCreateAgreementSkuChangeBusiReqBO reqBO, AgrBatchImportAgreementSkuChangeAbilityReqBO abilityReqBO) {
        ArrayList<Map<String, Object>> exportData = new ArrayList<Map<String, Object>>();
        Long successCount = 0L;
        Long failureCount = 0L;
        if (!CollectionUtils.isEmpty(reqBO.getAgrAgreementSkuChangeBOs())) {
            int index = 0;
            for (AgrAgreementSkuChangeBO skuPO : reqBO.getAgrAgreementSkuChangeBOs()) {
                LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>();
                item.put("\u5e8f\u53f7", ++index);
                item.put("\u7f16\u53f7", skuPO.getAgreementSkuId() != null ? skuPO.getAgreementSkuId() : "");
                item.put("\u7269\u8d44\u5206\u7c7b", skuPO.getCatalogName() != null ? skuPO.getCatalogName() : "");
                item.put("\u7269\u8d44\u7f16\u7801", skuPO.getMaterialId() != null ? skuPO.getMaterialId() : "");
                item.put("\u578b\u53f7", skuPO.getModel() != null ? skuPO.getModel() : "");
                item.put("\u89c4\u683c", skuPO.getSpec() != null ? skuPO.getSpec() : "");
                item.put("\u54c1\u724c", skuPO.getBrandName() != null ? skuPO.getBrandName() : "");
                item.put("\u4f9b\u8d27\u5468\u671f", skuPO.getSupplyCycle() != null ? skuPO.getSupplyCycle() : "");
                item.put("\u8ba1\u91cf\u5355\u4f4d", skuPO.getMeasureName() != null ? skuPO.getMeasureName() : "");
                item.put("\u7a0e\u6536\u7f16\u7801", skuPO.getTaxCatalog() != null ? skuPO.getTaxCatalog() : "");
                if (skuPO.getIsOil() != null) {
                    if (skuPO.getIsOil().equals((byte)0)) {
                        item.put("\u662f\u5426\u6210\u54c1\u6cb9", "\u5426");
                    } else {
                        item.put("\u662f\u5426\u6210\u54c1\u6cb9", "\u662f");
                    }
                } else {
                    item.put("\u662f\u5426\u6210\u54c1\u6cb9", "");
                }
                item.put("\u6570\u91cf", skuPO.getBuyNumber() != null ? skuPO.getBuyNumber() : "");
                item.put("\u91c7\u8d2d\u5355\u4ef7", skuPO.getBuyPrice() != null ? new BigDecimal(skuPO.getBuyPrice()).divide(new BigDecimal("10000")).setScale(2, 1) : "");
                item.put("\u52a0\u4ef7\u6bd4\u7387", skuPO.getMarkupRate() != null ? skuPO.getMarkupRate() : "");
                item.put("\u91c7\u8d2d\u603b\u8ba1", skuPO.getBuyPriceSum() != null ? new BigDecimal(skuPO.getBuyPriceSum()).divide(new BigDecimal("10000")).setScale(2, 1) : "");
                item.put("\u9500\u552e\u5355\u4ef7", skuPO.getSalePrice() != null ? new BigDecimal(skuPO.getSalePrice()).divide(new BigDecimal("10000")).setScale(2, 1) : "");
                item.put("\u9500\u552e\u603b\u4ef7", skuPO.getSalePriceSum() != null ? new BigDecimal(skuPO.getSalePriceSum()).divide(new BigDecimal("10000")).setScale(2, 1) : "");
                if (skuPO.getImpResult() != null) {
                    Long l;
                    Long l2;
                    if (skuPO.getImpResult().equals(AgrExtCommonConstant.ImportResult.SUCCESS)) {
                        item.put("\u5bfc\u5165\u7ed3\u679c", "\u6210\u529f");
                        item.put("\u5931\u8d25\u539f\u56e0", "");
                        l2 = successCount;
                        l = successCount = Long.valueOf(successCount + 1L);
                    } else {
                        item.put("\u5bfc\u5165\u7ed3\u679c", "\u5931\u8d25");
                        item.put("\u5931\u8d25\u539f\u56e0", skuPO.getImpRemark() != null ? skuPO.getImpRemark() : "");
                        l2 = failureCount;
                        l = failureCount = Long.valueOf(failureCount + 1L);
                    }
                } else {
                    item.put("\u5bfc\u5165\u7ed3\u679c", "\u5bfc\u5165\u5f02\u5e38");
                }
                LinkedHashMap copyItem = new LinkedHashMap(item);
                exportData.add(item);
            }
        }
        AgrExternalImportResultLogAtomReqBO agrExternalImportResultLogServiceReqBO = new AgrExternalImportResultLogAtomReqBO();
        agrExternalImportResultLogServiceReqBO.setExportData(exportData);
        agrExternalImportResultLogServiceReqBO.setFileName("\u534f\u8bae\u660e\u7ec6\u53d8\u66f4\u5bfc\u51fa\u8bb0\u5f55");
        agrExternalImportResultLogServiceReqBO.setFileUrl(abilityReqBO.getUrl());
        agrExternalImportResultLogServiceReqBO.setSuccessCount(successCount);
        agrExternalImportResultLogServiceReqBO.setFailureCount(failureCount);
        agrExternalImportResultLogServiceReqBO.setMemId(abilityReqBO.getMemIdIn());
        agrExternalImportResultLogServiceReqBO.setImpRemark("");
        agrExternalImportResultLogServiceReqBO.setImpResult(0);
        agrExternalImportResultLogServiceReqBO.setIsSkuChange(0);
        log.error("--\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u5bfc\u5165\u8bb0\u5f55\u670d\u52a1\u5165\u53c2\u4e3a:" + JSON.toJSONString((Object)agrExternalImportResultLogServiceReqBO));
        AgrExternalImportResultLogAtomRspBO agrExternalImportResultLogServiceRspBO = this.cnncAgrExternalImportResultLogServiceHolder.getAgrExternalImportResultLogService().importLog(agrExternalImportResultLogServiceReqBO);
        log.error("--\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u5bfc\u5165\u8bb0\u5f55\u670d\u52a1\u51fa\u53c2\u4e3a:" + JSON.toJSONString((Object)((Object)agrExternalImportResultLogServiceRspBO)));
    }
}

