/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.agreement.ability.bo.AgrAgreementSkuBO;
import com.tydic.agreement.ability.bo.AgrImoprtTemplateBO;
import com.tydic.agreement.atom.api.AgrDicDictionaryAtomService;
import com.tydic.agreement.atom.bo.AgrExternalImportResultLogAtomReqBO;
import com.tydic.agreement.atom.bo.AgrExternalImportResultLogAtomRspBO;
import com.tydic.agreement.atom.impl.CnncAgrExternalImportResultLogServiceHolder;
import com.tydic.agreement.busi.api.AgrBatchImportAgreementSkuBusiService;
import com.tydic.agreement.busi.api.AgrCnncAgrExportImportResultsBusiService;
import com.tydic.agreement.busi.bo.AgrBatchImportAgreementSkuBusiReqBO;
import com.tydic.agreement.busi.bo.AgrBatchImportAgreementSkuBusiRspBO;
import com.tydic.agreement.busi.bo.AgrExportImportResultsBusiReqBO;
import com.tydic.agreement.busi.bo.AgrExportImportResultsBusiRspBO;
import com.tydic.agreement.busi.bo.AgrQryAgreementSkuByPageBusiReqBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.constants.AgrExtCommonConstant;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.po.AgreementSkuPO;
import com.tydic.agreement.utils.ExcelUtils;
import com.tydic.agreement.utils.HttpUtil;
import com.tydic.commodity.zone.ability.api.UccAgrSkuImportCheckAbilityService;
import com.tydic.commodity.zone.ability.bo.UccAgrSkuImportCheckAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccAgrSkuImportCheckAbilityRspBO;
import com.tydic.commodity.zone.ability.bo.UccAgrSkuImportCheckBO;
import com.tydic.uac.exception.BusinessException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.http.entity.ContentType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AgrBatchImportAgreementSkuBusiServiceImpl
implements AgrBatchImportAgreementSkuBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrBatchImportAgreementSkuBusiServiceImpl.class);
    @Autowired
    private FileClient fileClient;
    @Autowired
    private AgrDicDictionaryAtomService agrDicDictionaryAtomService;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private UccAgrSkuImportCheckAbilityService uccAgrSkuImportCheckAbilityService;
    @Autowired
    private CnncAgrExternalImportResultLogServiceHolder cnncAgrExternalImportResultLogServiceHolder;
    @Autowired
    private AgrCnncAgrExportImportResultsBusiService cnncAgrExportImportResultsBusiService;

    @Override
    public AgrBatchImportAgreementSkuBusiRspBO dealAgrDetailedBatchImportAgreement(AgrBatchImportAgreementSkuBusiReqBO busiReqBO) {
        List agreementSkuPOs;
        AgrBatchImportAgreementSkuBusiRspBO rsp = new AgrBatchImportAgreementSkuBusiRspBO();
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(busiReqBO.getAgreementId());
        agreementPO.setSupplierId(busiReqBO.getSupplierId());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        AgreementPO agreement = this.agreementMapper.getModelBy(agreementPO);
        if (null == agreement) {
            throw new BusinessException("0101", "\u4e0d\u5b58\u5728\u8be5\u534f\u8bae\uff01");
        }
        if (!(AgrCommConstant.AgreementStatus.DRAFT.equals(agreement.getAgreementStatus()) || AgrCommConstant.AgreementStatus.REJECT.equals(agreement.getAgreementStatus()) || AgrCommConstant.AgreementStatus.NO_ASS.equals(agreement.getAgreementStatus()))) {
            throw new BusinessException("22002", "\u53ea\u6709\u8349\u7a3f\u4e2d,\u672a\u5b8c\u6210\u548c\u9a73\u56de\u72b6\u6001\u7684\u534f\u8bae\u53ef\u4ee5\u521b\u5efa\u534f\u8bae\u660e\u7ec6\uff01");
        }
        ArrayList<String> title = new ArrayList<String>();
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        try {
            HttpUtil.deleteFile("temporaryfile/content.xlsx");
            File file = new File(System.getProperty("user.dir") + "/temporaryfile/content.xlsx");
            File fileParent = file.getParentFile();
            if (!fileParent.exists()) {
                fileParent.mkdirs();
            }
            HttpUtil.httpDownload(busiReqBO.getUrl(), file.getAbsolutePath());
            FileInputStream fileInputStream = new FileInputStream(file);
            MockMultipartFile multipartFile = new MockMultipartFile(file.getName(), file.getName(), ContentType.APPLICATION_OCTET_STREAM.toString(), (InputStream)fileInputStream);
            this.getExcelDateByImport((MultipartFile)multipartFile, data, title, agreement);
            HttpUtil.deleteFile("temporaryfile/" + file.getName());
        }
        catch (Exception e) {
            throw new BusinessException("22052", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38\uff1a" + e);
        }
        if (CollectionUtils.isEmpty(title)) {
            throw new BusinessException("22052", "\u6587\u4ef6\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty(data)) {
            throw new BusinessException("22052", "\u6587\u4ef6\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        HashMap<String, Integer> dateMapIndex = new HashMap<String, Integer>();
        String importTemplateStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "IMPORT_TEMPLATE_PCODE", "1");
        List templateBOs = JSON.parseArray((String)importTemplateStr, AgrImoprtTemplateBO.class);
        block4: for (AgrImoprtTemplateBO bo : templateBOs) {
            for (int i = 0; i < title.size(); ++i) {
                if (!((String)title.get(i)).equals(bo.getFieldName())) continue;
                dateMapIndex.put(bo.getFieldNameEng(), i);
                continue block4;
            }
        }
        ArrayList importDataMaps = new ArrayList();
        ArrayList dateMaps = new ArrayList();
        for (List list : data) {
            boolean importErrMsgFlag = false;
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            StringBuilder importRemark = new StringBuilder();
            for (AgrImoprtTemplateBO bo : templateBOs) {
                Integer sheetKey = (Integer)dateMapIndex.get(bo.getFieldNameEng());
                if (null == sheetKey) {
                    importErrMsgFlag = true;
                    importRemark.setLength(0);
                    importRemark.append("\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165\u6570\u636e\u5e93\u6a21\u7248\u914d\u7f6e\u7684\u3010").append(bo.getFieldNameEng()).append("\u3011\u4e3a\u7a7a\uff01");
                    continue;
                }
                if (sheetKey >= list.size()) continue;
                Object content = list.get(sheetKey);
                if (bo.getIsMustFill().booleanValue()) {
                    if (null == content || "".equals(content) || "null".equals(content)) {
                        importErrMsgFlag = true;
                        importRemark.setLength(0);
                        importRemark.append("\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165\u3010").append(bo.getFieldName()).append("\u3011\u5fc5\u586b\uff01");
                        continue;
                    }
                } else if ("null".equals(content)) {
                    content = "";
                }
                if ("isOil".equals(bo.getFieldNameEng())) {
                    String isOil = (String)content;
                    if (StringUtils.isEmpty((Object)isOil)) {
                        isOil = "0";
                    } else if (!"0".equals(isOil) && !"1".equals(isOil)) {
                        importErrMsgFlag = true;
                        importRemark.setLength(0);
                        importRemark.append("\u662f\u5426\u6210\u54c1\u6cb9\u53ea\u80fd\u586b0\u6216\u80051\uff0c0\u54261\u662f");
                        continue;
                    }
                }
                if ("markupRate".equals(bo.getFieldNameEng())) {
                    String markupRate = (String)content;
                    if (StringUtils.isEmpty((Object)markupRate)) {
                        markupRate = "0";
                    }
                    if (agreement.getTradeMode() == 2 && !markupRate.equals("0")) {
                        importErrMsgFlag = true;
                        importRemark.setLength(0);
                        importRemark.append("\u534f\u8bae\u7684\u8d38\u6613\u6a21\u5f0f\u4e3a\u64ae\u5408\u6a21\u5f0f\u65f6\u52a0\u4ef7\u6bd4\u7387\u5fc5\u987b\u4e3a0");
                        continue;
                    }
                    markupRate = new BigDecimal(markupRate).divide(new BigDecimal(100)).toString();
                    content = markupRate;
                }
                if ("buyPrice".equals(bo.getFieldNameEng())) {
                    String buyPrice = (String)content;
                    content = (buyPrice = new BigDecimal(buyPrice).multiply(new BigDecimal(10000)).toString()).endsWith(".00") ? buyPrice.substring(0, buyPrice.lastIndexOf(".00")) : buyPrice;
                }
                dataMap.put(bo.getFieldNameEng(), content);
            }
            if (importErrMsgFlag) {
                dataMap.put("impResult", AgrExtCommonConstant.ImportResult.FAILED);
                dataMap.put("impRemark", importRemark.toString());
            } else {
                dataMap.put("impRemark", "\u6210\u529f");
                dataMap.put("impResult", AgrExtCommonConstant.ImportResult.SUCCESS);
            }
            importDataMaps.add(dataMap);
        }
        String jsonStr = JSON.toJSONString(importDataMaps);
        log.info("\u83b7\u53d6\u5230\u7684\u6570\u636e\u5bf9\u8c61\uff1a" + jsonStr);
        try {
            agreementSkuPOs = JSON.parseArray((String)jsonStr, AgreementSkuPO.class);
        }
        catch (Exception exception) {
            throw new BusinessException("22052", "\u586b\u5199\u6570\u636e\u4e0d\u7b26\u5408\u89c4\u8303\uff01");
        }
        if (agreementSkuPOs.size() > 3000) {
            throw new BusinessException("0002", "\u534f\u8bae\u660e\u7ec6\u5bfc\u5165\u4e0d\u80fd\u8d85\u8fc7 3000\u6761\uff01");
        }
        ArrayList<UccAgrSkuImportCheckBO> arrayList = new ArrayList<UccAgrSkuImportCheckBO>();
        HashSet<String> materialCodeSet = new HashSet<String>();
        for (int i = 0; i < agreementSkuPOs.size(); ++i) {
            if (materialCodeSet.contains(((AgreementSkuPO)agreementSkuPOs.get(i)).getMaterialId())) {
                throw new BusinessException("0002", "\u5b58\u5728\u76f8\u540c\u7269\u6599\u201c" + ((AgreementSkuPO)agreementSkuPOs.get(i)).getMaterialName() + "\u201d\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165");
            }
            materialCodeSet.add(((AgreementSkuPO)agreementSkuPOs.get(i)).getMaterialId());
            ((AgreementSkuPO)agreementSkuPOs.get(i)).setMaterialCode(((AgreementSkuPO)agreementSkuPOs.get(i)).getMaterialId());
            UccAgrSkuImportCheckBO bo = new UccAgrSkuImportCheckBO();
            bo.setSerialNumber(Integer.valueOf(i));
            bo.setCommodityTypeName(((AgreementSkuPO)agreementSkuPOs.get(i)).getCommodityTypeName());
            bo.setCatalogCode(((AgreementSkuPO)agreementSkuPOs.get(i)).getCatalogId());
            bo.setMaterialCode(((AgreementSkuPO)agreementSkuPOs.get(i)).getMaterialId());
            bo.setMeasureName(((AgreementSkuPO)agreementSkuPOs.get(i)).getMeasureName());
            arrayList.add(bo);
        }
        AgrQryAgreementSkuByPageBusiReqBO qryAgreementSkuByPageBusiReqBO = new AgrQryAgreementSkuByPageBusiReqBO();
        qryAgreementSkuByPageBusiReqBO.setAgreementId(busiReqBO.getAgreementId());
        List<AgrAgreementSkuBO> originalList = this.agreementSkuMapper.getListByCondition(qryAgreementSkuByPageBusiReqBO);
        originalList.stream().forEach(agrAgreementSkuBO -> {
            if (materialCodeSet.contains(agrAgreementSkuBO.getMaterialCode())) {
                throw new BusinessException("0002", "\u5b58\u5728\u76f8\u540c\u7269\u6599\u201c" + agrAgreementSkuBO.getMaterialName() + "\u201d\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165");
            }
            materialCodeSet.add(agrAgreementSkuBO.getMaterialCode());
        });
        UccAgrSkuImportCheckAbilityReqBO uccAgrSkuImportCheckAbilityReqBO = new UccAgrSkuImportCheckAbilityReqBO();
        uccAgrSkuImportCheckAbilityReqBO.setRows(arrayList);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u534f\u8bae\u660e\u7ec6\u5bfc\u5165\u6821\u9a8c\u670d\u52a1\u5165\u53c2 \uff1a" + JSONObject.toJSONString((Object)uccAgrSkuImportCheckAbilityReqBO));
        }
        UccAgrSkuImportCheckAbilityRspBO uccAgrSkuImportCheckAbilityRspBO = this.uccAgrSkuImportCheckAbilityService.checkInfo(uccAgrSkuImportCheckAbilityReqBO);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u534f\u8bae\u660e\u7ec6\u5bfc\u5165\u6821\u9a8c\u670d\u52a1\u51fa\u53c2 \uff1a" + JSONObject.toJSONString((Object)uccAgrSkuImportCheckAbilityRspBO));
        }
        if ("0000".equals(uccAgrSkuImportCheckAbilityRspBO.getRespCode())) {
            Map uccRspMap = uccAgrSkuImportCheckAbilityRspBO.getRows().stream().collect(Collectors.toMap(UccAgrSkuImportCheckBO::getSerialNumber, Function.identity()));
            for (int i = 0; i < agreementSkuPOs.size(); ++i) {
                if (((UccAgrSkuImportCheckBO)uccRspMap.get(i)).isPass()) {
                    ((AgreementSkuPO)agreementSkuPOs.get(i)).setMeasureId(((UccAgrSkuImportCheckBO)uccRspMap.get(i)).getMeasureId());
                    ((AgreementSkuPO)agreementSkuPOs.get(i)).setMaterialId(((UccAgrSkuImportCheckBO)uccRspMap.get(i)).getMaterialId().toString());
                    ((AgreementSkuPO)agreementSkuPOs.get(i)).setCatalogId(((UccAgrSkuImportCheckBO)uccRspMap.get(i)).getCatalogId().toString());
                    ((AgreementSkuPO)agreementSkuPOs.get(i)).setCommodityTypeId(((UccAgrSkuImportCheckBO)uccRspMap.get(i)).getCommodityTypeId());
                    continue;
                }
                ((AgreementSkuPO)agreementSkuPOs.get(i)).setImpRemark(((UccAgrSkuImportCheckBO)uccRspMap.get(i)).getReson());
                ((AgreementSkuPO)agreementSkuPOs.get(i)).setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
            }
        } else {
            for (AgreementSkuPO agreementSkuPO : agreementSkuPOs) {
                agreementSkuPO.setImpRemark("\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165" + uccAgrSkuImportCheckAbilityRspBO.getRespDesc());
                agreementSkuPO.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
            }
        }
        ArrayList<AgreementSkuPO> insertSkuPoList = new ArrayList<AgreementSkuPO>();
        for (AgreementSkuPO po : agreementSkuPOs) {
            if (po.getMarkupRate() == null) {
                po.setMarkupRate(new BigDecimal("0").divide(new BigDecimal(100)).doubleValue());
            }
            po.setAgreementSkuId(Sequence.getInstance().nextId());
            po.setAgreementId(agreement.getAgreementId());
            po.setSupplierId(agreement.getSupplierId());
            po.setAgreementVersion(agreement.getAgreementVersion());
            po.setSkuStatus(AgrCommConstant.SkuStatus.TO_BE_RELEASED);
            po.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            po.setCreateLoginId(busiReqBO.getMemIdIn());
            po.setCreateName(busiReqBO.getUserName());
            po.setCreateTime(new Date());
            po.setBuyPriceSum(new BigDecimal(po.getBuyPrice()).multiply(po.getBuyNumber()).longValue());
            po.setSalePrice(new BigDecimal(po.getBuyPrice()).add(new BigDecimal(po.getBuyPrice()).multiply(new BigDecimal(po.getMarkupRate().toString()))).longValue());
            po.setSalePriceSum(new BigDecimal(po.getSalePrice()).multiply(po.getBuyNumber()).longValue());
            po.setMarkupRate(new BigDecimal(po.getMarkupRate().toString()).multiply(new BigDecimal(100)).doubleValue());
            if (!po.getImpResult().equals(AgrExtCommonConstant.ImportResult.SUCCESS)) continue;
            insertSkuPoList.add(po);
        }
        List agrAgreementSkuBOList = JSON.parseArray((String)JSON.toJSONString((Object)agreementSkuPOs), AgrAgreementSkuBO.class);
        AgrExportImportResultsBusiReqBO importResultsBusiReqBO = new AgrExportImportResultsBusiReqBO();
        importResultsBusiReqBO.setImportSkuList(agrAgreementSkuBOList);
        importResultsBusiReqBO.setTradeMode(agreement.getTradeMode());
        log.error("\u8c03\u7528\u5bfc\u51fa\u6587\u4ef6\u5165\u53c2:" + JSON.toJSONString((Object)importResultsBusiReqBO));
        AgrExportImportResultsBusiRspBO importResultsBusiRspBO = this.cnncAgrExportImportResultsBusiService.exportImportResults(importResultsBusiReqBO);
        log.error("\u8c03\u7528\u5bfc\u51fa\u6587\u4ef6\u51fa\u53c2:" + JSON.toJSONString((Object)((Object)importResultsBusiRspBO)));
        if (!importResultsBusiRspBO.getRespCode().equals("0000")) {
            rsp.setRespCode("8888");
            rsp.setRespCode(importResultsBusiRspBO.getRespCode());
            return rsp;
        }
        Long failedImportCounts = 0L;
        Long sucessImportCounts = 0L;
        for (AgreementSkuPO agreementSkuPO : agreementSkuPOs) {
            Long l;
            Long l2;
            if (agreementSkuPO.getImpResult().equals(AgrExtCommonConstant.ImportResult.FAILED)) {
                l2 = failedImportCounts;
                l = failedImportCounts = Long.valueOf(failedImportCounts + 1L);
                continue;
            }
            if (!agreementSkuPO.getImpResult().equals(AgrExtCommonConstant.ImportResult.SUCCESS)) continue;
            l2 = sucessImportCounts;
            l = sucessImportCounts = Long.valueOf(sucessImportCounts + 1L);
        }
        AgrExternalImportResultLogAtomReqBO agrExternalImportResultLogServiceReqBO = new AgrExternalImportResultLogAtomReqBO();
        agrExternalImportResultLogServiceReqBO.setExportData(importResultsBusiRspBO.getExportData());
        agrExternalImportResultLogServiceReqBO.setFileName(importResultsBusiRspBO.getFilePath());
        agrExternalImportResultLogServiceReqBO.setFileUrl(importResultsBusiRspBO.getFullFilePath());
        agrExternalImportResultLogServiceReqBO.setSuccessCount(sucessImportCounts);
        agrExternalImportResultLogServiceReqBO.setFailureCount(failedImportCounts);
        agrExternalImportResultLogServiceReqBO.setMemId(busiReqBO.getMemIdIn());
        agrExternalImportResultLogServiceReqBO.setImpRemark("");
        agrExternalImportResultLogServiceReqBO.setImpResult(0);
        agrExternalImportResultLogServiceReqBO.setIsSkuChange(0);
        log.error("--\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u5bfc\u5165\u8bb0\u5f55\u670d\u52a1\u5165\u53c2\u4e3a:" + JSON.toJSONString((Object)agrExternalImportResultLogServiceReqBO));
        AgrExternalImportResultLogAtomRspBO agrExternalImportResultLogServiceRspBO = this.cnncAgrExternalImportResultLogServiceHolder.getAgrExternalImportResultLogService().importLog(agrExternalImportResultLogServiceReqBO);
        log.error("--\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u5bfc\u5165\u8bb0\u5f55\u670d\u52a1\u51fa\u53c2\u4e3a:" + JSON.toJSONString((Object)((Object)agrExternalImportResultLogServiceRspBO)));
        if (insertSkuPoList.size() > 0) {
            int isInsert = this.agreementSkuMapper.insertBatch(insertSkuPoList);
            rsp.setRespDesc("\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165\u6210\u529f!\u603b\u5171\u3010" + data.size() + "\u3011\u6761\u6570\u636e\uff0c\u5bfc\u5165\u6210\u529f\u3010" + isInsert + "\u3011\u6761");
        }
        rsp.setImpId(agrExternalImportResultLogServiceRspBO.getImpId());
        rsp.setRespCode("0000");
        return rsp;
    }

    private void validateParam(List<AgreementSkuPO> agreementSkuPOs) {
        for (AgreementSkuPO po : agreementSkuPOs) {
            if (!StringUtils.isEmpty((Object)po.getSpec()) || !StringUtils.isEmpty((Object)po.getFigure())) continue;
            throw new BusinessException("0001", "\u89c4\u683c/\u578b\u53f7\u548c\u56fe\u53f7/\u5382\u5bb6\u96f6\u4ef6\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
    }

    private void getExcelDateByImport(MultipartFile multipartFile, List<List<String>> data, List<String> title, AgreementPO agreement) {
        try {
            ExcelUtils.checkExcelVaild(multipartFile);
            Workbook workbook = ExcelUtils.getWorkbok(multipartFile);
            int count = 0;
            Sheet sheet = workbook.getSheetAt(0);
            for (Row row : sheet) {
                if (count < 10) {
                    ++count;
                    continue;
                }
                ArrayList<String> c = new ArrayList<String>();
                int end = row.getLastCellNum();
                if (row.getCell(0) != null && "".equals(row.getCell(0).toString())) continue;
                for (int i = 0; i < end; ++i) {
                    Cell cell = row.getCell(i);
                    if (cell == null) {
                        c.add("");
                        continue;
                    }
                    Object obj = ExcelUtils.getValue(cell);
                    if (count == 10) {
                        title.add(String.valueOf(obj).trim());
                        continue;
                    }
                    if (count < 11) continue;
                    c.add(String.valueOf(obj).trim());
                }
                ++count;
                if (c.size() <= 0) continue;
                ArrayList<String> d = new ArrayList<String>();
                for (String str : c) {
                    if (str.endsWith(".00")) {
                        str = str.substring(0, str.length() - 3);
                    }
                    d.add(str);
                }
                data.add(d);
            }
        }
        catch (Exception e) {
            throw new BusinessException("22052", e.getMessage());
        }
    }
}

