/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.tydic.agreement.ability.bo.AgrAgreementBO;
import com.tydic.agreement.ability.bo.AgreementSettlementBO;
import com.tydic.agreement.atom.api.AgrCreateAgreementOtherAtomService;
import com.tydic.agreement.atom.api.AgrCreateAgreementSettlementAtomService;
import com.tydic.agreement.atom.bo.AgrCreateAgreementOtherAtomReqBO;
import com.tydic.agreement.atom.bo.AgrCreateAgreementOtherAtomRspBO;
import com.tydic.agreement.atom.bo.AgrCreateAgreementSettlementAtomReqBO;
import com.tydic.agreement.atom.bo.AgrCreateAgreementSettlementAtomRspBO;
import com.tydic.agreement.busi.api.AgrModifyAgreementSubjectBusiService;
import com.tydic.agreement.busi.bo.AgrModifyAgreementSubjectBusiReqBO;
import com.tydic.agreement.busi.bo.AgrModifyAgreementSubjectBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSettlementMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgreementPO;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgrModifyAgreementSubjectBusiServiceImpl
implements AgrModifyAgreementSubjectBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrModifyAgreementSubjectBusiServiceImpl.class);
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgreementSettlementMapper agreementSettlementMapper;
    @Autowired
    private AgrCreateAgreementOtherAtomService agrCreateAgreementOtherAtomService;
    @Autowired
    private AgrCreateAgreementSettlementAtomService agrCreateAgreementSettlementAtomService;

    @Override
    public AgrModifyAgreementSubjectBusiRspBO modifyAgreementSubjectInfo(AgrModifyAgreementSubjectBusiReqBO busiReqBO) {
        AgrModifyAgreementSubjectBusiRspBO rsp = new AgrModifyAgreementSubjectBusiRspBO();
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(busiReqBO.getAgreementId());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        AgreementPO agreement = this.agreementMapper.getModelBy(agreementPO);
        if (null == agreement) {
            throw new BusinessException("0101", "\u4e0d\u5b58\u5728\u8be5\u534f\u8bae\uff01");
        }
        if (!(AgrCommConstant.AgreementStatus.DRAFT.equals(agreement.getAgreementStatus()) || AgrCommConstant.AgreementStatus.REJECT.equals(agreement.getAgreementStatus()) || AgrCommConstant.AgreementStatus.NO_ASS.equals(agreement.getAgreementStatus()) || AgrCommConstant.AgreementStatus.NO_CONFIRM.equals(agreement.getAgreementStatus()))) {
            throw new BusinessException("22002", "\u53ea\u6709\u8349\u7a3f\u4e2d,\u9a73\u56de,\u672a\u5b8c\u6210\u548c\u672a\u63a5\u53d7\u72b6\u6001\u7684\u534f\u8bae\u53ef\u4ee5\u4fee\u6539\uff01");
        }
        AgreementPO updateAgreementPO = agreement;
        this.setUpdateValue(updateAgreementPO, busiReqBO.getAgrAgreementBO());
        updateAgreementPO.setUpdateLoginId(busiReqBO.getMemIdIn());
        updateAgreementPO.setUpdateName(busiReqBO.getUserName());
        updateAgreementPO.setUpdateTime(new Date());
        updateAgreementPO.setCreateOrgId(busiReqBO.getCompanyId());
        updateAgreementPO.setCreateOrgName(busiReqBO.getCompanyName());
        int isUpdate = this.agreementMapper.updateBy(updateAgreementPO);
        if (isUpdate < 1) {
            throw new BusinessException("0101", "\u534f\u8bae\u8868\u66f4\u65b0\u5931\u8d25\uff01");
        }
        if (!AgrCommConstant.AgreementStatus.NO_ASS.equals(busiReqBO.getAgrAgreementBO().getAgreementStatus())) {
            AgrCreateAgreementOtherAtomReqBO atomReqBO = new AgrCreateAgreementOtherAtomReqBO();
            atomReqBO.setMemIdIn(busiReqBO.getMemIdIn());
            atomReqBO.setSupplierId(agreement.getSupplierId());
            atomReqBO.setUserName(busiReqBO.getUserName());
            atomReqBO.setAgreementId(agreement.getAgreementId());
            atomReqBO.setAgreementVersion(agreement.getAgreementVersion());
            atomReqBO.setAgrAgreementAttachBOs(busiReqBO.getAgrAgreementAttachBOs());
            atomReqBO.setAgrAgreementScopeBOs(busiReqBO.getAgrAgreementBO().getAgrAgreementScopeBOs());
            atomReqBO.setScopeType(busiReqBO.getAgrAgreementBO().getScopeType());
            atomReqBO.setOperType("update");
            AgrCreateAgreementOtherAtomRspBO atomRspBO = this.agrCreateAgreementOtherAtomService.createAgreementOtherInfo(atomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new BusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
            }
            List<AgreementSettlementBO> paymentMethod = busiReqBO.getPaymentMethod();
            this.agreementSettlementMapper.deleteByAgreementId(agreement.getAgreementId());
            for (AgreementSettlementBO asb : paymentMethod) {
                AgrCreateAgreementSettlementAtomReqBO aas = new AgrCreateAgreementSettlementAtomReqBO();
                BeanUtils.copyProperties((Object)asb, (Object)((Object)aas));
                aas.setAgreementId(agreement.getAgreementId());
                aas.setOperType("update");
                AgrCreateAgreementSettlementAtomRspBO agreementSettlementInfo = this.agrCreateAgreementSettlementAtomService.createAgreementSettlementInfo(aas);
                if ("0000".equals(agreementSettlementInfo.getRespCode())) continue;
                throw new BusinessException(agreementSettlementInfo.getRespCode(), agreementSettlementInfo.getRespDesc());
            }
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u4e3b\u4f53\u4fee\u6539\u6210\u529f\uff01");
        return rsp;
    }

    private void setUpdateValue(AgreementPO updateAgreementPO, AgrAgreementBO agrAgreementBO) {
        updateAgreementPO.setAgreementMode(agrAgreementBO.getAgreementMode());
        updateAgreementPO.setAgreementVariety(agrAgreementBO.getAgreementVariety());
        updateAgreementPO.setEntAgreementCode(agrAgreementBO.getEntAgreementCode());
        updateAgreementPO.setAgreementName(agrAgreementBO.getAgreementName());
        updateAgreementPO.setMatterName(agrAgreementBO.getMatterName());
        updateAgreementPO.setAgreementSrc(agrAgreementBO.getAgreementSrc());
        updateAgreementPO.setVendorId(agrAgreementBO.getVendorId());
        updateAgreementPO.setVendorName(agrAgreementBO.getVendorName());
        updateAgreementPO.setVendorContact(agrAgreementBO.getVendorContact());
        updateAgreementPO.setVendorPhone(agrAgreementBO.getVendorPhone());
        updateAgreementPO.setAgreementType(agrAgreementBO.getAgreementType());
        updateAgreementPO.setEffDate(agrAgreementBO.getEffDate());
        updateAgreementPO.setExpDate(agrAgreementBO.getExpDate());
        updateAgreementPO.setPrePayEnt(agrAgreementBO.getPrePayEnt());
        updateAgreementPO.setMatPayEnt(agrAgreementBO.getMatPayEnt());
        updateAgreementPO.setProPayEnt(agrAgreementBO.getProPayEnt());
        updateAgreementPO.setVerPayEnt(agrAgreementBO.getVerPayEnt());
        updateAgreementPO.setPilPayEnt(agrAgreementBO.getPilPayEnt());
        updateAgreementPO.setQuaPayEnt(agrAgreementBO.getQuaPayEnt());
        updateAgreementPO.setMatPaySup(agrAgreementBO.getMatPaySup());
        updateAgreementPO.setProPaySup(agrAgreementBO.getProPaySup());
        updateAgreementPO.setVerPaySup(agrAgreementBO.getVerPaySup());
        updateAgreementPO.setPilPaySup(agrAgreementBO.getPilPaySup());
        updateAgreementPO.setQuaPaySup(agrAgreementBO.getQuaPaySup());
        updateAgreementPO.setPrePaySup(agrAgreementBO.getPrePaySup());
        updateAgreementPO.setPayClause(agrAgreementBO.getPayClause());
        updateAgreementPO.setWarantty(agrAgreementBO.getWarantty());
        updateAgreementPO.setSignTime(agrAgreementBO.getSignTime());
        updateAgreementPO.setScopeType(agrAgreementBO.getScopeType());
        updateAgreementPO.setPriceType(agrAgreementBO.getPriceType());
        updateAgreementPO.setAdjustPrice(agrAgreementBO.getAdjustPrice());
        updateAgreementPO.setTradeMode(agrAgreementBO.getTradeMode());
        updateAgreementPO.setRemark(agrAgreementBO.getRemark());
        updateAgreementPO.setExtField1(agrAgreementBO.getExtField1());
        updateAgreementPO.setExtField2(agrAgreementBO.getExtField2());
        updateAgreementPO.setExtField3(agrAgreementBO.getExtField3());
        updateAgreementPO.setVendorDepartmentId(agrAgreementBO.getVendorId());
        updateAgreementPO.setVendorDepartmentName(agrAgreementBO.getVendorName());
        updateAgreementPO.setAgreementSrcCode(agrAgreementBO.getAgreementSrcCode());
        updateAgreementPO.setAgreementSrcName(agrAgreementBO.getAgreementSrcName());
        updateAgreementPO.setBuyerCode(agrAgreementBO.getBuyerCode());
        updateAgreementPO.setBuyerName(agrAgreementBO.getBuyerName());
    }
}

