/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.ability.impl;

import com.tydic.agreement.ability.api.AgrCreateAgreementSkuChangeAbilityService;
import com.tydic.agreement.ability.bo.AgrAgreementSkuChangeBO;
import com.tydic.agreement.ability.bo.AgrCreateAgreementSkuChangeAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrCreateAgreementSkuChangeAbilityRspBO;
import com.tydic.agreement.busi.api.AgrCreateAgreementSkuChangeBusiService;
import com.tydic.agreement.busi.bo.AgrCreateAgreementSkuChangeBusiReqBO;
import com.tydic.agreement.busi.bo.AgrCreateAgreementSkuChangeBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.exceptions.BusinessException;
import java.math.BigDecimal;
import java.util.Collection;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGREEMENT_GROUP_DEV/2.1.0/com.tydic.agreement.ability.api.AgrCreateAgreementSkuChangeAbilityService"})
public class AgrCreateAgreementSkuChangeAbilityServiceImpl
implements AgrCreateAgreementSkuChangeAbilityService {
    @Autowired
    private AgrCreateAgreementSkuChangeBusiService agrCreateAgreementSkuChangeBusiService;

    @PostMapping(value={"createAgreementSkuChange"})
    public AgrCreateAgreementSkuChangeAbilityRspBO createAgreementSkuChange(@RequestBody AgrCreateAgreementSkuChangeAbilityReqBO abilityReqBO) {
        AgrCreateAgreementSkuChangeAbilityRspBO rsp = new AgrCreateAgreementSkuChangeAbilityRspBO();
        this.validateParam(abilityReqBO);
        AgrCreateAgreementSkuChangeBusiReqBO agrCreateAgreementSkuChangeBusiReqBO = new AgrCreateAgreementSkuChangeBusiReqBO();
        BeanUtils.copyProperties((Object)abilityReqBO, (Object)((Object)agrCreateAgreementSkuChangeBusiReqBO));
        AgrCreateAgreementSkuChangeBusiRspBO agrCreateAgreementSkuChangeBusiRspBO = this.agrCreateAgreementSkuChangeBusiService.createAgreementSkuChange(agrCreateAgreementSkuChangeBusiReqBO);
        BeanUtils.copyProperties((Object)((Object)agrCreateAgreementSkuChangeBusiRspBO), (Object)rsp);
        return rsp;
    }

    private void validateParam(AgrCreateAgreementSkuChangeAbilityReqBO abilityReqBO) {
        if (null == abilityReqBO.getMemIdIn()) {
            throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u53d8\u66f4\u65b0\u589eAPI\u5165\u53c2\u3010memIdIn\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == abilityReqBO.getAgreementId()) {
            throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u53d8\u66f4\u65b0\u589eAPI\u5165\u53c2\u3010agreementId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)abilityReqBO.getChangeCode())) {
            throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u53d8\u66f4\u65b0\u589eAPI\u5165\u53c2\u3010changeCode\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)abilityReqBO.getAgrAgreementSkuChangeBOs())) {
            throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u53d8\u66f4\u65b0\u589eAPI\u5165\u53c2\u3010agrAgreementSkuChangeBOs\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (AgrAgreementSkuChangeBO bo : abilityReqBO.getAgrAgreementSkuChangeBOs()) {
            if (null == bo.getChangeType()) {
                throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6\u53d8\u66f4\u65b0\u589eAPI\u5165\u53c2\u3010agrAgreementSkuChangeBOs.changeType\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (AgrCommConstant.AgreementSkuChangeType.ADD.equals(bo.getChangeType()) || AgrCommConstant.AgreementSkuChangeType.DELETE.equals(bo.getChangeType())) {
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)bo.getMaterialId())) {
                    throw new BusinessException("0001", "\u7269\u6599\u4e3b\u6570\u636e\u7f16\u7801\u3010materialId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)bo.getMaterialCode())) {
                    throw new BusinessException("0001", "\u7269\u6599\u4e3b\u6570\u636e\u7f16\u7801\u3010materialCode\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)bo.getMaterialName())) {
                    throw new BusinessException("0001", "\u7269\u8d44\u540d\u79f0\u3010materialName\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)bo.getMeasureName())) {
                    throw new BusinessException("0001", "\u8ba1\u91cf\u5355\u4f4d\u3010measureName\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (null == bo.getBuyNumber()) {
                    throw new BusinessException("0001", "\u6570\u91cf\u3010buyNumber\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (null == bo.getBuyPrice()) {
                    throw new BusinessException("0001", "\u91c7\u8d2d\u5355\u4ef7\u3010buyPrice\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (null == bo.getBuyPriceSum()) {
                    throw new BusinessException("0001", "\u91c7\u8d2d\u603b\u4ef7\u3010buyPriceSum\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (null == bo.getMarkupRate()) {
                    bo.setMarkupRate(Double.valueOf(0.0));
                }
                if (null == bo.getSupplyCycle()) {
                    throw new BusinessException("0001", "\u4f9b\u8d27\u5468\u671f\u3010supplyCycle\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
            } else if (AgrCommConstant.AgreementSkuChangeType.UPDATE.equals(bo.getChangeType())) {
                if (bo.getAgreementSkuId() == null) {
                    throw new BusinessException("0001", "\u534f\u8bae\u660e\u7ec6ID\u3010agreementSkuId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (null == bo.getBuyPrice()) {
                    throw new BusinessException("0001", "\u91c7\u8d2d\u5355\u4ef7\u3010buyPrice\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (null == bo.getBuyPriceSum()) {
                    throw new BusinessException("0001", "\u91c7\u8d2d\u603b\u4ef7\u3010buyPriceSum\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (null == bo.getMarkupRate()) {
                    bo.setMarkupRate(Double.valueOf(0.0));
                }
            } else {
                throw new BusinessException("0001", "\u64cd\u4f5c\u7c7b\u578b\u3010" + bo.getChangeType() + "\u3011\u4e0d\u652f\u6301");
            }
            if (AgrCommConstant.AgreementSkuChangeType.DELETE.equals(bo.getChangeType())) continue;
            BigDecimal buyNumber = bo.getBuyNumber();
            if (StringUtils.hasText((String)bo.getExtField1()) && StringUtils.hasText((String)bo.getExtField2())) {
                buyNumber = bo.getBuyNumber().add(new BigDecimal(bo.getExtField1()).subtract(new BigDecimal(bo.getExtField2())));
            }
            bo.setBuyPriceSum(Long.valueOf(new BigDecimal(bo.getBuyPrice()).multiply(buyNumber).longValue()));
            if (bo.getSalePrice() != null) continue;
            bo.setSalePrice(Long.valueOf(new BigDecimal(bo.getBuyPrice()).add(new BigDecimal(bo.getBuyPrice()).multiply(new BigDecimal(bo.getMarkupRate().toString())).divide(new BigDecimal(100))).longValue()));
            bo.setSalePriceSum(Long.valueOf(new BigDecimal(bo.getSalePrice()).multiply(buyNumber).longValue()));
        }
    }
}

