/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.tydic.agreement.ability.bo.AgrAgreementSkuChangeStockReqBO;
import com.tydic.agreement.ability.bo.AgrAgreementSkuChangeStockRspBO;
import com.tydic.agreement.ability.bo.AgrSkuChangeStockBO;
import com.tydic.agreement.busi.api.AgrAgreementSkuChangeStockBusiService;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.po.AgreementPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgrAgreementSkuChangeStockBusiServiceImpl
implements AgrAgreementSkuChangeStockBusiService {
    private static final Byte CONSUME = 1;
    private static final Byte RETURN = 2;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgreementMapper agreementMapper;

    @Override
    public AgrAgreementSkuChangeStockRspBO stockChange(AgrAgreementSkuChangeStockReqBO reqBO) {
        AgrAgreementSkuChangeStockRspBO rspBO = new AgrAgreementSkuChangeStockRspBO();
        ArrayList<Long> errorSkuIds = new ArrayList<Long>();
        rspBO.setFailedSkuIds(errorSkuIds);
        HashMap<Long, AgreementPO> agreementPOMap = new HashMap<Long, AgreementPO>();
        Date now = new Date();
        for (AgrSkuChangeStockBO agrSkuChangeStockBO : reqBO.getSkuStockChangeList()) {
            Integer totalLimitNum;
            Integer totalNum;
            int update;
            if (agreementPOMap.get(agrSkuChangeStockBO.getAgreementId()) == null) {
                AgreementPO agreementPO = new AgreementPO();
                agreementPO.setAgreementId(agrSkuChangeStockBO.getAgreementId());
                AgreementPO result = this.agreementMapper.getModelBy(agreementPO);
                agreementPOMap.put(agrSkuChangeStockBO.getAgreementId(), result);
            }
            BigDecimal amount = agrSkuChangeStockBO.getChangeAmount();
            if (agrSkuChangeStockBO.getType().equals(CONSUME)) {
                int update2 = this.agreementSkuMapper.AgrAgreementSkuStockChangeSub(agrSkuChangeStockBO.getAgreementId(), agrSkuChangeStockBO.getAgreementSkuId(), amount);
                if (update2 == 0) {
                    errorSkuIds.add(agrSkuChangeStockBO.getAgreementSkuId());
                }
            } else if (agrSkuChangeStockBO.getType().equals(RETURN) && (update = this.agreementSkuMapper.AgrAgreementSkuStockChangeAdd(agrSkuChangeStockBO.getAgreementId(), agrSkuChangeStockBO.getAgreementSkuId(), amount)) == 0) {
                errorSkuIds.add(agrSkuChangeStockBO.getAgreementSkuId());
            }
            if (!(totalNum = Integer.valueOf(this.agreementSkuMapper.selectSkuCount(agrSkuChangeStockBO.getAgreementId()))).equals(totalLimitNum = Integer.valueOf(this.agreementSkuMapper.selectLimitSkuCount(agrSkuChangeStockBO.getAgreementId())))) continue;
            long stockNumber = this.agreementSkuMapper.selectCurrentSkuStock(agrSkuChangeStockBO.getAgreementId());
            AgreementPO agreementPO = (AgreementPO)agreementPOMap.get(agrSkuChangeStockBO.getAgreementId());
            if (agreementPO == null) continue;
            AgreementPO updatePO = new AgreementPO();
            updatePO.setAgreementId(agrSkuChangeStockBO.getAgreementId());
            if (stockNumber <= 0L && agreementPO.getAgreementStatus().equals(AgrCommConstant.AgreementStatus.ENABLE)) {
                updatePO.setAgreementStatus(AgrCommConstant.AgreementStatus.CLOSE);
                this.agreementMapper.updateByCondition(updatePO);
                continue;
            }
            if (!agreementPO.getExpDate().after(now) || !agreementPO.getEffDate().before(now)) continue;
            updatePO.setAgreementStatus(AgrCommConstant.AgreementStatus.ENABLE);
            this.agreementMapper.updateByCondition(updatePO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f\uff01");
        return rspBO;
    }

    private void syncUcc() {
    }
}

