/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.agreement.ability.bo.AgrAgreementBO;
import com.tydic.agreement.atom.api.AgrCheckAgreementExistAndStatusAtomService;
import com.tydic.agreement.atom.bo.AgrCheckAgreementExistAndStatusAtomReqBO;
import com.tydic.agreement.atom.bo.AgrCheckAgreementExistAndStatusAtomRspBO;
import com.tydic.agreement.busi.api.AgrAgreementSubmitBusiService;
import com.tydic.agreement.busi.bo.AgrAgreementSubmitBusiReqBO;
import com.tydic.agreement.busi.bo.AgrAgreementSubmitBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.po.AgreementSkuPO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.uac.exception.BusinessException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="agrAgreementSubmitBusiService")
public class AgrAgreementSubmitBusiServiceImpl
implements AgrAgreementSubmitBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrAgreementSubmitBusiServiceImpl.class);
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgrCheckAgreementExistAndStatusAtomService agrCheckAgreementExistAndStatusAtomService;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Value(value="${AGR_CREATE_SYNC_CONTRACT_TOPIC}")
    private String AGR_CREATE_SYNC_CONTRACT_TOPIC;
    @Value(value="${AGR_CREATE_SYNC_CONTRACT_TAG}")
    private String AGR_CREATE_SYNC_CONTRACT_TAG;
    @Resource(name="agrSyncToContractMqServiceProvider")
    private ProxyMessageProducer agrSyncToContractMqServiceProvider;

    @Override
    public AgrAgreementSubmitBusiRspBO submitAgreementInfo(AgrAgreementSubmitBusiReqBO busiReqBO) {
        AgrAgreementSubmitBusiRspBO busiRspBO = new AgrAgreementSubmitBusiRspBO();
        AgrCheckAgreementExistAndStatusAtomReqBO atomReqBO = new AgrCheckAgreementExistAndStatusAtomReqBO();
        atomReqBO.setAgreementId(busiReqBO.getAgreementId());
        atomReqBO.setSupplierId(busiReqBO.getSupplierId());
        AgrCheckAgreementExistAndStatusAtomRspBO atomRspBO = this.agrCheckAgreementExistAndStatusAtomService.checkAgreementExistAndStatus(atomReqBO);
        if (!"0000".equals(atomRspBO.getRespCode())) {
            BeanUtils.copyProperties((Object)((Object)atomRspBO), (Object)((Object)busiRspBO));
            return busiRspBO;
        }
        if (AgrCommConstant.AgrSaveOrSubmit.SUBMIT.equals(busiReqBO.getOperType())) {
            if (atomRspBO.getAgrAgreementBO().getAgreementStatus().equals(AgrCommConstant.AgreementStatus.CONTRACT_CONFIRM)) {
                AgreementPO po = new AgreementPO();
                po.setAgreementStatus(AgrCommConstant.AgreementStatus.ENABLE);
                po.setAgreementId(busiReqBO.getAgreementId());
                po.setSupplierId(busiReqBO.getSupplierId());
                int count = this.agreementMapper.updateByCondition(po);
                if (count < 1) {
                    throw new BusinessException("22005", "\u66f4\u65b0\u534f\u8bae\u72b6\u6001\u5931\u8d25");
                }
                AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
                agreementSkuPO.setAgreementId(busiReqBO.getAgreementId());
                agreementSkuPO.setContractItemStatus("0");
                agreementSkuPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
                this.agreementSkuMapper.updateBy(agreementSkuPO);
            } else {
                AgreementPO po = new AgreementPO();
                UacNoTaskAuditCreateRspBO createRspBO = this.createProcess(busiReqBO.getAgreementId(), atomRspBO.getAgrAgreementBO(), busiReqBO);
                if (createRspBO.getNotFindFlag().booleanValue()) {
                    po.setAgreementStatus(AgrCommConstant.AgreementStatus.ENABLE);
                } else {
                    po.setAgreementStatus(AgrCommConstant.AgreementStatus.IN_AUDIT);
                }
                po.setAgreementId(busiReqBO.getAgreementId());
                po.setSupplierId(busiReqBO.getSupplierId());
                int count = this.agreementMapper.updateByCondition(po);
                if (count < 1) {
                    throw new BusinessException("22005", "\u66f4\u65b0\u534f\u8bae\u72b6\u6001\u5931\u8d25");
                }
                if (atomRspBO.getAgrAgreementBO().getAgreementStatus().equals(AgrCommConstant.AgreementStatus.NO_ASS)) {
                    HashMap<String, Number> content = new HashMap<String, Number>();
                    content.put("agreementId", busiReqBO.getAgreementId());
                    content.put("contractId", atomRspBO.getAgrAgreementBO().getContractId());
                    content.put("dealType", 1);
                    log.info("\u53d1\u6d88\u606f\u540c\u6b65\u5408\u540c\u4e2d\u5fc3\u5165\u53c2\u4e3a" + JSON.toJSONString(content));
                    this.agrSyncToContractMqServiceProvider.send(new ProxyMessage(this.AGR_CREATE_SYNC_CONTRACT_TOPIC, this.AGR_CREATE_SYNC_CONTRACT_TAG, JSON.toJSONString(content)));
                    log.info("\u53d1\u6d88\u606f\u540c\u6b65\u5408\u540c\u4e2d\u5fc3\u6210\u529f");
                }
            }
        } else if (AgrCommConstant.AgrSaveOrSubmit.CONTRACT_SUBMIT.equals(busiReqBO.getOperType())) {
            AgreementPO po = new AgreementPO();
            po.setAgreementStatus(AgrCommConstant.AgreementStatus.ENABLE);
            po.setAgreementId(busiReqBO.getAgreementId());
            po.setSupplierId(busiReqBO.getSupplierId());
            int count = this.agreementMapper.updateByCondition(po);
            if (count < 1) {
                throw new BusinessException("22005", "\u66f4\u65b0\u534f\u8bae\u72b6\u6001\u5931\u8d25");
            }
            AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
            agreementSkuPO.setAgreementId(busiReqBO.getAgreementId());
            agreementSkuPO.setContractItemStatus("0");
            agreementSkuPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            this.agreementSkuMapper.updateBy(agreementSkuPO);
        } else if (atomRspBO.getAgrAgreementBO().getAgreementStatus().equals(AgrCommConstant.AgreementStatus.CONTRACT_CONFIRM)) {
            AgreementPO po = new AgreementPO();
            po.setAgreementStatus(AgrCommConstant.AgreementStatus.ENABLE);
            po.setAgreementId(busiReqBO.getAgreementId());
            po.setSupplierId(busiReqBO.getSupplierId());
            int count = this.agreementMapper.updateByCondition(po);
            if (count < 1) {
                throw new BusinessException("22005", "\u66f4\u65b0\u534f\u8bae\u72b6\u6001\u5931\u8d25");
            }
        } else {
            AgreementPO po = new AgreementPO();
            po.setAgreementId(busiReqBO.getAgreementId());
            po.setAgreementStatus(AgrCommConstant.AgreementStatus.DRAFT);
            po.setSupplierId(busiReqBO.getSupplierId());
            int count = this.agreementMapper.updateByCondition(po);
            if (atomRspBO.getAgrAgreementBO().getAgreementStatus().equals(AgrCommConstant.AgreementStatus.NO_ASS)) {
                HashMap<String, Number> content = new HashMap<String, Number>();
                content.put("agreementId", busiReqBO.getAgreementId());
                content.put("contractId", atomRspBO.getAgrAgreementBO().getContractId());
                content.put("dealType", 1);
                log.info("\u53d1\u6d88\u606f\u540c\u6b65\u5408\u540c\u4e2d\u5fc3\u5165\u53c2\u4e3a" + JSON.toJSONString(content));
                this.agrSyncToContractMqServiceProvider.send(new ProxyMessage(this.AGR_CREATE_SYNC_CONTRACT_TOPIC, this.AGR_CREATE_SYNC_CONTRACT_TAG, JSON.toJSONString(content)));
                log.info("\u53d1\u6d88\u606f\u540c\u6b65\u5408\u540c\u4e2d\u5fc3\u6210\u529f");
            }
        }
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u534f\u8bae\u63d0\u4ea4\u4fdd\u5b58\u6210\u529f");
        return busiRspBO;
    }

    private UacNoTaskAuditCreateRspBO createProcess(Long agreementId, AgrAgreementBO agrAgreementBO, AgrAgreementSubmitBusiReqBO reqBO) {
        ArrayList<ApprovalObjBO> approvalObjInfo = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjType(AgrCommConstant.AuditObjType.AGREEMENT_AUDIT);
        approvalObjBO.setObjId(agreementId.toString());
        approvalObjInfo.add(approvalObjBO);
        ArrayList<UacNoTaskAuditCreateInfoReqBO> uacNoTaskAuditCreateInfoReqBOs = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(AgrCommConstant.AuditObjType.AGREEMENT_AUDIT);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(agreementId);
        uacNoTaskAuditCreateInfoReqBO.setRemark("\u534f\u8bae\u65b0\u589e\u5ba1\u6279");
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjInfo);
        uacNoTaskAuditCreateInfoReqBOs.add(uacNoTaskAuditCreateInfoReqBO);
        UacNoTaskAuditCreateReqBO uacNoTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        uacNoTaskAuditCreateReqBO.setMenuId("M001001");
        uacNoTaskAuditCreateReqBO.setOrgId(String.valueOf(reqBO.getOrgId()));
        uacNoTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        uacNoTaskAuditCreateReqBO.setCreateOperDept(reqBO.getOrgName());
        uacNoTaskAuditCreateReqBO.setCreateOperId(reqBO.getUserId().toString());
        uacNoTaskAuditCreateReqBO.setCreateOperName(reqBO.getName());
        uacNoTaskAuditCreateReqBO.setCreateBusiReqBO(uacNoTaskAuditCreateInfoReqBOs);
        log.error("\u5f00\u59cb\u8c03\u7528\u5ba1\u6279-----");
        log.error("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u521b\u5efaAPI\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uacNoTaskAuditCreateReqBO));
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(uacNoTaskAuditCreateReqBO);
        log.error("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u521b\u5efaAPI\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new BusinessException(uacNoTaskAuditCreateRspBO.getRespCode(), uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        return uacNoTaskAuditCreateRspBO;
    }

    private UacNoTaskAuditCreateRspBO createContractProcess(Long agreementId, AgrAgreementBO agrAgreementBO, AgrAgreementSubmitBusiReqBO reqBO) {
        ArrayList<ApprovalObjBO> approvalObjInfo = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjType(AgrCommConstant.AuditObjType.CONTRACT_AGREEMENT_AUDIT);
        approvalObjBO.setObjId(agreementId.toString());
        approvalObjInfo.add(approvalObjBO);
        ArrayList<UacNoTaskAuditCreateInfoReqBO> uacNoTaskAuditCreateInfoReqBOs = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(AgrCommConstant.AuditObjType.AGREEMENT_AUDIT);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(agreementId);
        uacNoTaskAuditCreateInfoReqBO.setRemark("\u5408\u540c\u53d8\u66f4\u534f\u8bae\u5f85\u53d8\u66f4\u751f\u6548\u5ba1\u6279");
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjInfo);
        uacNoTaskAuditCreateInfoReqBOs.add(uacNoTaskAuditCreateInfoReqBO);
        UacNoTaskAuditCreateReqBO uacNoTaskAuditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        uacNoTaskAuditCreateReqBO.setMenuId("M001001");
        uacNoTaskAuditCreateReqBO.setOrgId(String.valueOf(reqBO.getOrgId()));
        uacNoTaskAuditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        uacNoTaskAuditCreateReqBO.setCreateOperDept(reqBO.getOrgName());
        uacNoTaskAuditCreateReqBO.setCreateOperId(reqBO.getUserId().toString());
        uacNoTaskAuditCreateReqBO.setCreateOperName(reqBO.getName());
        uacNoTaskAuditCreateReqBO.setCreateBusiReqBO(uacNoTaskAuditCreateInfoReqBOs);
        log.error("\u5f00\u59cb\u8c03\u7528\u5ba1\u6279-----");
        log.error("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u521b\u5efaAPI\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uacNoTaskAuditCreateReqBO));
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(uacNoTaskAuditCreateReqBO);
        log.error("\u8c03\u7528\u5ba1\u6279\u6a21\u5757\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u521b\u5efaAPI\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new BusinessException(uacNoTaskAuditCreateRspBO.getRespCode(), uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        return uacNoTaskAuditCreateRspBO;
    }
}

