/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.agreement.ability.bo.AgrBatchImportAgreementSkuUpdateReqBO;
import com.tydic.agreement.ability.bo.AgrBatchImportAgreementSkuUpdateRspBO;
import com.tydic.agreement.ability.bo.AgrImoprtTemplateBO;
import com.tydic.agreement.atom.api.AgrDicDictionaryAtomService;
import com.tydic.agreement.atom.bo.AgrExternalImportResultLogAtomReqBO;
import com.tydic.agreement.atom.bo.AgrExternalImportResultLogAtomRspBO;
import com.tydic.agreement.atom.impl.CnncAgrExternalImportResultLogServiceHolder;
import com.tydic.agreement.busi.api.AgrBatchImportAgreementSkuUpdateBusiService;
import com.tydic.agreement.busi.api.AgrCnncAgrExportImportResultsBusiService;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.constants.AgrExtCommonConstant;
import com.tydic.agreement.constants.AgrExternalCommonConstant;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.po.AgreementSkuPO;
import com.tydic.agreement.utils.ExcelUtils;
import com.tydic.agreement.utils.HttpUtil;
import com.tydic.cfc.ability.api.CfcMeasureQryAbilityService;
import com.tydic.cfc.ability.bo.CfcMeasureQryAbilityBo;
import com.tydic.cfc.ability.bo.CfcMeasureQryAbilityReqBo;
import com.tydic.cfc.ability.bo.CfcMeasureQryAbilityRspBo;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.http.entity.ContentType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AgrBatchImportAgreementSkuUpdateBusiServiceImpl
implements AgrBatchImportAgreementSkuUpdateBusiService {
    private static final Logger log = LoggerFactory.getLogger(AgrBatchImportAgreementSkuUpdateBusiServiceImpl.class);
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgrDicDictionaryAtomService agrDicDictionaryAtomService;
    @Autowired
    private CnncAgrExternalImportResultLogServiceHolder cnncAgrExternalImportResultLogServiceHolder;
    @Autowired
    private AgrCnncAgrExportImportResultsBusiService cnncAgrExportImportResultsBusiService;
    @Autowired
    private CfcMeasureQryAbilityService cfcMeasureQryAbilityService;

    @Override
    public AgrBatchImportAgreementSkuUpdateRspBO importUpdate(AgrBatchImportAgreementSkuUpdateReqBO reqBO) {
        List list;
        AgrBatchImportAgreementSkuUpdateRspBO rsp = new AgrBatchImportAgreementSkuUpdateRspBO();
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(reqBO.getAgreementId());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        AgreementPO agreement = this.agreementMapper.getModelBy(agreementPO);
        if (null == agreement) {
            throw new com.tydic.uac.exception.BusinessException("0101", "\u4e0d\u5b58\u5728\u8be5\u534f\u8bae\uff01");
        }
        ArrayList<String> title = new ArrayList<String>();
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        try {
            String fileName = "content_" + new Date().getTime() + ".xlsx";
            File file = new File(System.getProperty("user.dir") + "/temporaryfile/" + fileName);
            File fileParent = file.getParentFile();
            if (!fileParent.exists()) {
                fileParent.mkdirs();
            }
            HttpUtil.httpDownload(reqBO.getUrl(), file.getAbsolutePath());
            FileInputStream fileInputStream = new FileInputStream(file);
            MockMultipartFile multipartFile = new MockMultipartFile(file.getName(), file.getName(), ContentType.APPLICATION_OCTET_STREAM.toString(), (InputStream)fileInputStream);
            this.getExcelDateByImport((MultipartFile)multipartFile, data, title, 0, 1);
            HttpUtil.deleteFile("temporaryfile/" + file.getName());
        }
        catch (Exception e) {
            throw new com.tydic.uac.exception.BusinessException("22052", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38\uff1a" + e);
        }
        if (CollectionUtils.isEmpty(title)) {
            throw new com.tydic.uac.exception.BusinessException("22052", "\u6587\u4ef6\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty(data)) {
            throw new com.tydic.uac.exception.BusinessException("22052", "\u6587\u4ef6\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        HashMap<String, Integer> dateMapIndex = new HashMap<String, Integer>();
        log.info("\u83b7\u53d6\u7684\u6807\u9898\u884c:{}", (Object)JSON.toJSONString(title));
        String importTemplateStr = this.agrDicDictionaryAtomService.queryDictBySysCodeAndPcodeAndCode("AGR", "IMPORT_UPDATE_TEMPLATE_PCODE", "1");
        List templateBOs = JSON.parseArray((String)importTemplateStr, AgrImoprtTemplateBO.class);
        block6: for (AgrImoprtTemplateBO bo : templateBOs) {
            for (int i = 0; i < title.size(); ++i) {
                if (!((String)title.get(i)).equals(bo.getFieldName().trim()) && !((String)title.get(i)).equals(bo.getFieldName())) continue;
                dateMapIndex.put(bo.getFieldNameEng(), i);
                continue block6;
            }
        }
        ArrayList importDataMaps = new ArrayList();
        ArrayList dataMaps = new ArrayList();
        for (List list2 : data) {
            boolean importErrMsgFlag = false;
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            StringBuilder importRemark = new StringBuilder();
            for (AgrImoprtTemplateBO bo : templateBOs) {
                Integer sheetKey = (Integer)dateMapIndex.get(bo.getFieldNameEng());
                if (null == sheetKey) {
                    importErrMsgFlag = true;
                    importRemark.setLength(0);
                    importRemark.append("\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u66f4\u65b0\u5bfc\u5165\u6570\u636e\u5e93\u6a21\u7248\u914d\u7f6e\u7684\u3010").append(bo.getFieldNameEng()).append("\u3011\u4e3a\u7a7a\uff01");
                    continue;
                }
                if (sheetKey >= list2.size()) continue;
                String content = (String)list2.get(sheetKey);
                if (bo.getIsMustFill().booleanValue()) {
                    if (null == content || "".equals(content) || "null".equals(content)) {
                        importErrMsgFlag = true;
                        importRemark.setLength(0);
                        importRemark.append("\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u5bfc\u5165\u3010").append(bo.getFieldName()).append("\u3011\u5fc5\u586b\uff01");
                        continue;
                    }
                } else if (null == content || "null".equals(content)) {
                    content = "";
                }
                if ("isOil".equals(bo.getFieldNameEng())) {
                    String isOil = content;
                    if (StringUtils.isEmpty((Object)isOil)) {
                        content = "0";
                    } else {
                        if (!"\u5426".equals(isOil) && !"\u662f".equals(isOil)) {
                            importErrMsgFlag = true;
                            importRemark.setLength(0);
                            importRemark.append("\u662f\u5426\u6210\u54c1\u6cb9\u53ea\u80fd\u586b\u662f\u6216\u8005\u5426");
                            continue;
                        }
                        if ("\u5426".equals(isOil)) {
                            content = "0";
                        }
                        if ("\u662f".equals(isOil)) {
                            content = "1";
                        }
                    }
                }
                if ("saleStatus".equals(bo.getFieldNameEng())) {
                    String saleStatus = content;
                    if (StringUtils.isEmpty((Object)saleStatus)) {
                        content = "0";
                    } else if (!("\u6709\u6548".equals(saleStatus) || "\u9650\u91cf".equals(saleStatus) || "\u5931\u6548".equals(saleStatus))) {
                        importErrMsgFlag = true;
                        importRemark.setLength(0);
                        importRemark.append("\u9500\u552e\u72b6\u6001\u53ea\u80fd\u586b\u6709\u6548/\u9650\u91cf/\u5931\u6548");
                    } else {
                        if ("\u6709\u6548".equals(saleStatus)) {
                            content = "1";
                        }
                        if ("\u9650\u91cf".equals(saleStatus)) {
                            content = "2";
                        }
                        if ("\u5931\u6548".equals(saleStatus)) {
                            content = "3";
                        }
                    }
                }
                if ("markupRate".equals(bo.getFieldNameEng())) {
                    String markupRate = content;
                    if (StringUtils.isEmpty((Object)markupRate)) {
                        markupRate = "0";
                    }
                    if (agreement.getTradeMode() == 2 && !markupRate.equals("0")) {
                        importErrMsgFlag = true;
                        importRemark.setLength(0);
                        importRemark.append("\u534f\u8bae\u7684\u4ea4\u6613\u6a21\u5f0f\u4e3a\u64ae\u5408\u6a21\u5f0f\u65f6\u52a0\u4ef7\u6bd4\u7387\u5fc5\u987b\u4e3a0");
                    }
                    content = markupRate = new BigDecimal(markupRate).divide(new BigDecimal(100)).toString();
                }
                if ("buyPrice".equals(bo.getFieldNameEng())) {
                    String buyPrice = content;
                    content = (buyPrice = new BigDecimal(buyPrice).multiply(new BigDecimal(10000)).toString()).endsWith(".00") ? buyPrice.substring(0, buyPrice.lastIndexOf(".00")) : buyPrice;
                    content = content.replace(".0", "");
                }
                if ("buyNumber".equals(bo.getFieldNameEng())) {
                    content = content.replace(",", "");
                }
                dataMap.put(bo.getFieldNameEng(), content);
            }
            if (dataMap.get("saleStatus") != null && dataMap.get("saleStatus").equals("2") && (dataMap.get("buyNumber") == null || dataMap.get("buyNumber").equals(""))) {
                importErrMsgFlag = true;
                importRemark.setLength(0);
                importRemark.append("\u9650\u91cf\u65f6\u6570\u91cf\u5fc5\u586b!");
            }
            if (importErrMsgFlag) {
                dataMap.put("impResult", AgrExtCommonConstant.ImportResult.FAILED);
                dataMap.put("impRemark", importRemark.toString());
                dataMaps.add(dataMap);
            } else {
                dataMap.put("impRemark", "\u6210\u529f");
                dataMap.put("impResult", AgrExtCommonConstant.ImportResult.SUCCESS);
            }
            importDataMaps.add(dataMap);
        }
        String jsonStr = JSON.toJSONString(importDataMaps);
        try {
            list = JSON.parseArray((String)jsonStr, AgreementSkuPO.class);
            log.info("\u5bfc\u5165\u6570\u636e:{}", (Object)jsonStr);
        }
        catch (Exception e) {
            log.error("\u586b\u5199\u6570\u636e\u4e0d\u7b26\u5408\u89c4\u8303\uff01" + e);
            throw new BusinessException("22052", "\u586b\u5199\u6570\u636e\u4e0d\u7b26\u5408\u89c4\u8303\uff01");
        }
        ArrayList<AgreementSkuPO> updateSkuPoList = new ArrayList<AgreementSkuPO>();
        HashSet<String> settlementUnitNameList = new HashSet<String>();
        for (AgreementSkuPO agreementSkuPO : list) {
            settlementUnitNameList.add(agreementSkuPO.getMeasureName());
        }
        if (!CollectionUtils.isEmpty(settlementUnitNameList)) {
            Map measureBoMap;
            CfcMeasureQryAbilityReqBo cfcMeasureQryAbilityReqBo = new CfcMeasureQryAbilityReqBo();
            cfcMeasureQryAbilityReqBo.setMeasureNameList(new ArrayList(settlementUnitNameList));
            CfcMeasureQryAbilityRspBo cfcMeasureQryAbilityRspBo = this.cfcMeasureQryAbilityService.qryMeasure(cfcMeasureQryAbilityReqBo);
            if (cfcMeasureQryAbilityRspBo.getRespCode().equals("0000") && !CollectionUtils.isEmpty(measureBoMap = cfcMeasureQryAbilityRspBo.getRows().stream().collect(Collectors.toMap(CfcMeasureQryAbilityBo::getMeasureName, Function.identity(), (key1, key2) -> key2)))) {
                for (AgreementSkuPO agreementSkuPO : list) {
                    CfcMeasureQryAbilityBo cfcMeasureQryAbilityBo = (CfcMeasureQryAbilityBo)measureBoMap.get(agreementSkuPO.getSettlementUnitName());
                    if (cfcMeasureQryAbilityBo != null) {
                        if (cfcMeasureQryAbilityBo.getStatus() == null || cfcMeasureQryAbilityBo.getStatus().equals("00")) {
                            agreementSkuPO.setImpRemark("\u7ed3\u7b97\u8ba1\u91cf\u5355\u4f4d" + agreementSkuPO.getSettlementUnitName() + "\u72b6\u6001\u4e3a\u505c\u7528\u72b6\u6001!");
                            agreementSkuPO.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                            continue;
                        }
                        agreementSkuPO.setSettlementUnitId(cfcMeasureQryAbilityBo.getId().toString());
                        continue;
                    }
                    agreementSkuPO.setImpRemark("\u7ed3\u7b97\u8ba1\u91cf\u5355\u4f4d" + agreementSkuPO.getSettlementUnitName() + "\u4e0d\u5b58\u5728!");
                    agreementSkuPO.setImpResult(AgrExtCommonConstant.ImportResult.FAILED);
                }
            }
        }
        BigDecimal bd = new BigDecimal("10000");
        for (AgreementSkuPO po : list) {
            if (!po.getImpResult().equals(AgrExtCommonConstant.ImportResult.SUCCESS)) continue;
            try {
                if (po.getMarkupRate() == null) {
                    po.setMarkupRate(new BigDecimal("0").divide(new BigDecimal(100)).doubleValue());
                }
                if (po.getBuyNumber() != null) {
                    po.setBuyPriceSum(new BigDecimal(po.getBuyPrice()).multiply(po.getBuyNumber()).longValue());
                    if (po.getSalePrice() == null) {
                        po.setSalePrice(new BigDecimal(po.getBuyPrice()).add(new BigDecimal(po.getBuyPrice()).multiply(new BigDecimal(po.getMarkupRate().toString()))).longValue());
                        BigDecimal bAmount = new BigDecimal(po.getSalePrice()).divide(bd).setScale(2, 4).multiply(bd).stripTrailingZeros();
                        po.setSalePrice(bAmount.longValue());
                    }
                }
                po.setSalePriceSum(new BigDecimal(po.getSalePrice()).multiply(po.getBuyNumber()).longValue());
                po.setMarkupRate(new BigDecimal(po.getMarkupRate().toString()).multiply(new BigDecimal(100)).doubleValue());
                po.setCurrentStockNumber(po.getBuyNumber());
                updateSkuPoList.add(po);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u6570\u636e\u8f6c\u6362\u5f02\u5e38:" + e.toString());
            }
        }
        Long impId = this.exportImportResults(list, reqBO);
        if (updateSkuPoList.size() > 0) {
            int j;
            int updateCount = 0;
            int n = j = updateSkuPoList.size() >= 1000 ? 1000 : updateSkuPoList.size();
            for (int i = 0; i < updateSkuPoList.size(); i += 1000) {
                List<AgreementSkuPO> updateList = updateSkuPoList.subList(i, j);
                updateCount += this.agreementSkuMapper.updateByBatch(updateList);
                j = j + 1000 > updateSkuPoList.size() ? updateSkuPoList.size() : j + 1000;
            }
            rsp.setRespDesc("\u534f\u8bae\u660e\u7ec6\u6279\u91cf\u66f4\u65b0\u5bfc\u5165\u6210\u529f!\u603b\u5171\u3010" + data.size() + "\u3011\u6761\u6570\u636e\uff0c\u66f4\u65b0\u6210\u529f\u3010" + updateCount + "\u3011\u6761");
        }
        rsp.setImpId(impId);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u6210\u529f");
        return rsp;
    }

    private void getExcelDateByImport(MultipartFile multipartFile, List<List<String>> data, List<String> title, int titleRow, int dataRow) {
        try {
            ExcelUtils.checkExcelVaild(multipartFile);
            Workbook workbook = ExcelUtils.getWorkbok(multipartFile);
            int count = 0;
            Sheet sheet = workbook.getSheetAt(0);
            for (Row row : sheet) {
                if (count < titleRow) {
                    ++count;
                    continue;
                }
                ArrayList<String> c = new ArrayList<String>();
                int end = row.getLastCellNum();
                if (row.getCell(0) != null && "".equals(row.getCell(0).toString())) continue;
                for (int i = 0; i < end; ++i) {
                    Cell cell = row.getCell(i);
                    if (cell == null) {
                        c.add("");
                        continue;
                    }
                    Object obj = ExcelUtils.getValue(cell);
                    if (count == titleRow) {
                        title.add(String.valueOf(obj).trim());
                        continue;
                    }
                    if (count < dataRow) continue;
                    c.add(String.valueOf(obj).trim());
                }
                ++count;
                if (c.size() <= 0) continue;
                ArrayList<String> d = new ArrayList<String>();
                for (String str : c) {
                    if (str.endsWith(".00")) {
                        str = str.substring(0, str.length() - 3);
                    }
                    d.add(str);
                }
                data.add(d);
            }
        }
        catch (Exception e) {
            throw new com.tydic.uac.exception.BusinessException("22052", e.getMessage());
        }
    }

    private Long exportImportResults(List<AgreementSkuPO> agreementSkuPOs, AgrBatchImportAgreementSkuUpdateReqBO abilityReqBO) {
        ArrayList<Map<String, Object>> exportData = new ArrayList<Map<String, Object>>();
        Long successCount = 0L;
        Long failureCount = 0L;
        if (!CollectionUtils.isEmpty(agreementSkuPOs)) {
            int index = 0;
            for (AgreementSkuPO skuPO : agreementSkuPOs) {
                LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>();
                item.put("\u5e8f\u53f7", ++index);
                item.put("\u7f16\u53f7", skuPO.getAgreementSkuId() != null ? skuPO.getAgreementSkuId() : "");
                item.put("\u54c1\u724c", skuPO.getBrandName() != null ? skuPO.getBrandName() : "");
                item.put("\u4f9b\u8d27\u5468\u671f", skuPO.getSupplyCycle() != null ? skuPO.getSupplyCycle() : "");
                if (skuPO.getIsOil() != null) {
                    if (skuPO.getIsOil().equals((byte)0)) {
                        item.put("\u662f\u5426\u6210\u54c1\u6cb9", "\u5426");
                    } else {
                        item.put("\u662f\u5426\u6210\u54c1\u6cb9", "\u662f");
                    }
                } else {
                    item.put("\u662f\u5426\u6210\u54c1\u6cb9", "");
                }
                item.put("\u7a0e\u6536\u7f16\u7801", skuPO.getTaxCatalog() != null ? skuPO.getTaxCatalog() : "");
                item.put("\u7a0e\u7387", skuPO.getTaxRate() != null ? skuPO.getTaxRate() : "");
                item.put("\u52a0\u4ef7\u6bd4\u7387", skuPO.getMarkupRate() != null ? skuPO.getMarkupRate() : "");
                if (skuPO.getSaleStatus() != null) {
                    item.put("\u9500\u552e\u72b6\u6001", skuPO.getSaleStatus() != null ? skuPO.getSaleStatus() : "");
                    if ("1".equals(skuPO.getSaleStatus())) {
                        item.put("\u9500\u552e\u72b6\u6001", "\u6709\u6548");
                    }
                    if ("2".equals(skuPO.getSaleStatus())) {
                        item.put("\u9500\u552e\u72b6\u6001", "\u9650\u91cf");
                    }
                    if ("3".equals(skuPO.getSaleStatus())) {
                        item.put("\u9500\u552e\u72b6\u6001", "\u65e0\u6548");
                    }
                }
                item.put("\u6570\u91cf", skuPO.getBuyNumber() != null ? skuPO.getBuyNumber() : "");
                item.put("\u8d28\u91cf\u6280\u672f\u8981\u6c42", skuPO.getQualityRequire() != null ? skuPO.getQualityRequire() : "");
                item.put("\u5907\u6ce8", skuPO.getRemark() != null ? skuPO.getRemark() : "");
                item.put("\u91c7\u8d2d\u5355\u4ef7", skuPO.getBuyPrice() != null ? new BigDecimal(skuPO.getBuyPrice()).divide(new BigDecimal("10000")).setScale(2, 1) : "");
                if (skuPO.getImpResult() != null) {
                    Long l;
                    Long l2;
                    if (skuPO.getImpResult().equals(AgrExtCommonConstant.ImportResult.SUCCESS)) {
                        item.put("\u5bfc\u5165\u7ed3\u679c", "\u6210\u529f");
                        item.put("\u5931\u8d25\u539f\u56e0", "");
                        l2 = successCount;
                        l = successCount = Long.valueOf(successCount + 1L);
                    } else {
                        item.put("\u5bfc\u5165\u7ed3\u679c", "\u5931\u8d25");
                        item.put("\u5931\u8d25\u539f\u56e0", skuPO.getImpRemark() != null ? skuPO.getImpRemark() : "");
                        l2 = failureCount;
                        l = failureCount = Long.valueOf(failureCount + 1L);
                    }
                } else {
                    item.put("\u5bfc\u5165\u7ed3\u679c", "\u5bfc\u5165\u5f02\u5e38");
                }
                LinkedHashMap copyItem = new LinkedHashMap(item);
                exportData.add(item);
            }
        }
        AgrExternalImportResultLogAtomReqBO agrExternalImportResultLogServiceReqBO = new AgrExternalImportResultLogAtomReqBO();
        agrExternalImportResultLogServiceReqBO.setExportData(exportData);
        agrExternalImportResultLogServiceReqBO.setFileName("\u534f\u8bae\u660e\u7ec6\u66f4\u65b0\u5bfc\u51fa\u8bb0\u5f55");
        agrExternalImportResultLogServiceReqBO.setFileUrl(abilityReqBO.getUrl());
        agrExternalImportResultLogServiceReqBO.setSuccessCount(successCount);
        agrExternalImportResultLogServiceReqBO.setFailureCount(failureCount);
        agrExternalImportResultLogServiceReqBO.setMemId(abilityReqBO.getMemIdIn());
        agrExternalImportResultLogServiceReqBO.setImpRemark("");
        agrExternalImportResultLogServiceReqBO.setImpResult(0);
        agrExternalImportResultLogServiceReqBO.setIsSkuChange(0);
        agrExternalImportResultLogServiceReqBO.setOutImpId(AgrExternalCommonConstant.AGR_SKU_IMPORT_LOG_ID);
        agrExternalImportResultLogServiceReqBO.setImpType("AGR_SKU_IMPORT");
        log.error("--\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u5bfc\u5165\u8bb0\u5f55\u670d\u52a1\u5165\u53c2\u4e3a:" + JSON.toJSONString((Object)agrExternalImportResultLogServiceReqBO));
        AgrExternalImportResultLogAtomRspBO agrExternalImportResultLogServiceRspBO = this.cnncAgrExternalImportResultLogServiceHolder.getAgrExternalImportResultLogService().importLog(agrExternalImportResultLogServiceReqBO);
        log.error("--\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u5bfc\u5165\u8bb0\u5f55\u670d\u52a1\u51fa\u53c2\u4e3a:" + JSON.toJSONString((Object)((Object)agrExternalImportResultLogServiceRspBO)));
        return agrExternalImportResultLogServiceRspBO.getImpId();
    }
}

