/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.agreement.ability.bo.AgrAgreementSkuChangeBO;
import com.tydic.agreement.busi.api.AgrCreateAgreementSkuChangeBusiService;
import com.tydic.agreement.busi.bo.AgrCreateAgreementSkuChangeBusiReqBO;
import com.tydic.agreement.busi.bo.AgrCreateAgreementSkuChangeBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgreementChangeMapper;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.dao.AgreementSkuChangeMapper;
import com.tydic.agreement.dao.AgreementSkuMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgreementChangePO;
import com.tydic.agreement.po.AgreementPO;
import com.tydic.agreement.po.AgreementSkuChangePO;
import com.tydic.agreement.po.AgreementSkuPO;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgrCreateAgreementSkuChangeBusiServiceImpl
implements AgrCreateAgreementSkuChangeBusiService {
    @Autowired
    private AgreementSkuChangeMapper agreementSkuChangeMapper;
    @Autowired
    private AgreementSkuMapper agreementSkuMapper;
    @Autowired
    private AgreementChangeMapper agreementChangeMapper;
    @Autowired
    private AgreementMapper agreementMapper;

    @Override
    public AgrCreateAgreementSkuChangeBusiRspBO createAgreementSkuChange(AgrCreateAgreementSkuChangeBusiReqBO busiReqBO) {
        int isInsert;
        AgrCreateAgreementSkuChangeBusiRspBO rsp = new AgrCreateAgreementSkuChangeBusiRspBO();
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(busiReqBO.getAgreementId());
        agreementPO.setSupplierId(busiReqBO.getSupplierId());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        AgreementPO agreement = this.agreementMapper.getModelBy(agreementPO);
        if (null == agreement) {
            throw new BusinessException("0101", "\u4e0d\u5b58\u5728\u8be5\u534f\u8bae\uff01");
        }
        AgreementChangePO agreementChangePO = new AgreementChangePO();
        agreementChangePO.setChangeCode(busiReqBO.getChangeCode());
        agreementChangePO.setAgreementId(busiReqBO.getAgreementId());
        agreementChangePO.setSupplierId(busiReqBO.getSupplierId());
        AgreementChangePO daoRsp = this.agreementChangeMapper.getModelBy(agreementChangePO);
        if (!(null == daoRsp || AgrCommConstant.ChangeApplyStatus.DRAFT.equals(daoRsp.getStatus()) || AgrCommConstant.ChangeApplyStatus.NO_PASS.equals(daoRsp.getStatus()) || AgrCommConstant.ChangeApplyStatus.NO_CONFIRM.equals(daoRsp.getStatus()))) {
            throw new BusinessException("22002", "\u53ea\u6709\u8349\u7a3f\u4e2d\u548c\u9a73\u56de\u72b6\u6001\u7684\u534f\u8bae\u53d8\u66f4\u53ef\u4ee5\u521b\u5efa\u534f\u8bae\u660e\u7ec6\u53d8\u66f4\uff01");
        }
        ArrayList<Long> agreementSkuIds = new ArrayList<Long>();
        ArrayList<AgreementSkuChangePO> agreementSkuChangePOs = new ArrayList<AgreementSkuChangePO>();
        for (AgrAgreementSkuChangeBO bo : busiReqBO.getAgrAgreementSkuChangeBOs()) {
            if (null != bo.getAgreementSkuId()) {
                agreementSkuIds.add(bo.getAgreementSkuId());
            }
            if (bo.getSaleStatus() != null && bo.getSaleStatus().equals("2")) {
                AgreementSkuPO agreementSkuPO = new AgreementSkuPO();
                agreementSkuPO.setAgreementSkuId(bo.getAgreementSkuId());
                agreementSkuPO = this.agreementSkuMapper.getModelBy(agreementSkuPO);
                if (bo.getBuyNumber().compareTo(agreementSkuPO.getCurrentStockNumber()) < 0) {
                    throw new BusinessException("22002", "\u660e\u7ec6\u3010" + bo.getAgreementSkuId() + "\u3011\u6570\u91cf\u53d8\u66f4\u4e0d\u80fd\u5c11\u4e8e\u5df2\u4f7f\u7528\u7684\u6570\u91cf\uff01");
                }
            }
            AgreementSkuChangePO agreementSkuChangePO = new AgreementSkuChangePO();
            BeanUtils.copyProperties((Object)bo, (Object)agreementSkuChangePO);
            agreementSkuChangePO.setSkuChangeId(Sequence.getInstance().nextId());
            agreementSkuChangePO.setAgreementVersion(agreement.getAgreementVersion());
            agreementSkuChangePO.setAgreementId(busiReqBO.getAgreementId());
            agreementSkuChangePO.setSupplierId(agreement.getSupplierId());
            agreementSkuChangePO.setChangeCode(busiReqBO.getChangeCode());
            agreementSkuChangePO.setSkuStatus(AgrCommConstant.SkuStatus.TO_BE_RELEASED);
            agreementSkuChangePO.setCreateLoginId(busiReqBO.getMemIdIn());
            agreementSkuChangePO.setCreateName(busiReqBO.getUserName());
            agreementSkuChangePO.setCreateTime(new Date());
            agreementSkuChangePO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
            agreementSkuChangePOs.add(agreementSkuChangePO);
        }
        if (!CollectionUtils.isEmpty(agreementSkuIds)) {
            AgreementSkuChangePO agreementSkuChangePO1 = new AgreementSkuChangePO();
            agreementSkuChangePO1.setAgreementId(busiReqBO.getAgreementId());
            agreementSkuChangePO1.setSupplierId(agreement.getSupplierId());
            agreementSkuChangePO1.setChangeCode(busiReqBO.getChangeCode());
            agreementSkuChangePO1.setAgreementSkuIds(agreementSkuIds);
            this.agreementSkuChangeMapper.deleteBy(agreementSkuChangePO1);
        }
        if ((isInsert = this.agreementSkuChangeMapper.insertBatch(agreementSkuChangePOs)) != agreementSkuChangePOs.size()) {
            throw new BusinessException("22003", "\u534f\u8bae\u660e\u7ec6\u53d8\u66f4\u8868\u65b0\u589e\u5931\u8d25\uff01");
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u660e\u7ec6\u53d8\u66f4\u65b0\u589e\u6210\u529f\uff01");
        return rsp;
    }
}

