/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.agreement.busi.api.AgrDeleteAgreementBusiService;
import com.tydic.agreement.busi.bo.AgrDeleteAgreementBusiReqBO;
import com.tydic.agreement.busi.bo.AgrDeleteAgreementBusiRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.exceptions.BusinessException;
import com.tydic.agreement.po.AgreementPO;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AgrDeleteAgreementBusiServiceImpl
implements AgrDeleteAgreementBusiService {
    @Autowired
    private AgreementMapper agreementMapper;
    @Value(value="${AGR_CREATE_SYNC_CONTRACT_TOPIC:AGR_CREATE_SYNC_CONTRACT_TOPIC}")
    private String AGR_CREATE_SYNC_CONTRACT_TOPIC;
    @Value(value="${AGR_CREATE_SYNC_CONTRACT_TAG:AGR_CREATE_SYNC_CONTRACT_TOPIC}")
    private String AGR_CREATE_SYNC_CONTRACT_TAG;
    @Resource(name="agrSyncToContractMqServiceProvider")
    private ProxyMessageProducer agrSyncToContractMqServiceProvider;

    @Override
    public AgrDeleteAgreementBusiRspBO deleteAgreementInfo(AgrDeleteAgreementBusiReqBO busiReqBO) {
        AgrDeleteAgreementBusiRspBO rsp = new AgrDeleteAgreementBusiRspBO();
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementIds(busiReqBO.getAgreementIds());
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        List<AgreementPO> agreementPOs = this.agreementMapper.getList(agreementPO);
        if (agreementPOs.size() != busiReqBO.getAgreementIds().size()) {
            throw new BusinessException("22001", "\u6709\u4e0d\u5b58\u5728\u7684\u534f\u8baeId\uff01");
        }
        for (AgreementPO po : agreementPOs) {
            if (AgrCommConstant.AgreementStatus.DRAFT.equals(po.getAgreementStatus()) || AgrCommConstant.AgreementStatus.REJECT.equals(po.getAgreementStatus()) || AgrCommConstant.AgreementStatus.NO_CONFIRM.equals(po.getAgreementStatus())) continue;
            throw new BusinessException("22002", "\u534f\u8bae\u3010" + po.getAgreementId() + "\u3011\u4e0d\u80fd\u5220\u9664\uff0c\u53ea\u6709\u8349\u7a3f\u3001\u9a73\u56de\u548c\u672a\u63a5\u53d7\u72b6\u6001\u7684\u534f\u8bae\u53ef\u4ee5\u5220\u9664\uff01");
        }
        for (Long agreementId : busiReqBO.getAgreementIds()) {
            AgreementPO updateAgreementPO = new AgreementPO();
            updateAgreementPO.setAgreementId(agreementId);
            updateAgreementPO.setUpdateLoginId(busiReqBO.getMemIdIn());
            updateAgreementPO.setUpdateName(busiReqBO.getUserName());
            updateAgreementPO.setUpdateTime(new Date());
            updateAgreementPO.setIsDelete(AgrCommConstant.IsDelete.DELETED);
            int isUpdate = this.agreementMapper.deleteByUpdate(updateAgreementPO);
            if (isUpdate >= 1) continue;
            throw new BusinessException("22004", "\u534f\u8bae\u5220\u9664\u5931\u8d25\uff01");
        }
        for (AgreementPO agreementPO1 : agreementPOs) {
            HashMap<String, Number> content = new HashMap<String, Number>();
            content.put("agreementId", agreementPO1.getAgreementId());
            content.put("contractId", agreementPO1.getContractId());
            content.put("dealType", 0);
            this.agrSyncToContractMqServiceProvider.send(new ProxyMessage(this.AGR_CREATE_SYNC_CONTRACT_TOPIC, this.AGR_CREATE_SYNC_CONTRACT_TAG, JSON.toJSONString(content)));
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u534f\u8bae\u5220\u9664\u6210\u529f\uff01");
        return rsp;
    }
}

