/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.agreement.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.agreement.ability.api.AgrSyncAgreementSkuFromContractAbilityService;
import com.tydic.agreement.ability.bo.AgrSyncAgreementSkuFromContractReqBO;
import com.tydic.agreement.ability.bo.AgrSyncAgreementSkuFromContractRspBO;
import com.tydic.agreement.atom.api.AgrAgreementStatusChangeAtomService;
import com.tydic.agreement.atom.bo.AgrAgreementStatusChangeAtomReqBO;
import com.tydic.agreement.atom.bo.AgrAgreementStatusChangeAtomRspBO;
import com.tydic.agreement.constants.AgrCommConstant;
import com.tydic.agreement.dao.AgreementMapper;
import com.tydic.agreement.po.AgreementPO;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AgrContractSyncAgreementSkuStatusConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(AgrContractSyncAgreementSkuStatusConsumer.class);
    @Autowired
    private AgreementMapper agreementMapper;
    @Autowired
    private AgrAgreementStatusChangeAtomService agrAgreementStatusChangeAtomService;
    @Autowired
    private AgrSyncAgreementSkuFromContractAbilityService agrSyncAgreementSkuFromContractAbilityService;
    private static final int freeze = 0;
    private static final int pass = 1;
    private static final int reject = 2;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        AgrAgreementStatusChangeAtomRspBO atomRspBO;
        log.error("\u5408\u540c\u505c\u7528\u540c\u6b65\u534f\u8bae\u5165\u53c2:" + JSON.toJSONString((Object)message.getContent()));
        JSONObject jsonObject = (JSONObject)JSON.parseObject((String)message.getContent(), JSONObject.class);
        Long agreementId = jsonObject.getLong("agrId");
        Long contractId = jsonObject.getLong("contractId");
        Integer dealType = jsonObject.getInteger("dealType");
        if (agreementId == null) {
            log.error("\u5408\u540c\u505c\u7528\u540c\u6b65\u534f\u8bae\u5165\u53c2ID\u4e3a\u7a7a");
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        if (dealType == null) {
            log.error("\u5408\u540c\u505c\u7528\u540c\u6b65\u534f\u8bae\u5165\u53c2\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a");
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        if (contractId == null) {
            log.error("\u5408\u540c\u505c\u7528\u540c\u6b65\u534f\u8bae\u5165\u53c2\u5408\u540cID\u4e3a\u7a7a");
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        AgreementPO agreementPO = new AgreementPO();
        agreementPO.setAgreementId(agreementId);
        agreementPO.setIsDelete(AgrCommConstant.IsDelete.NORMAL);
        AgreementPO agreement = this.agreementMapper.getModelBy(agreementPO);
        if (agreement == null) {
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        HashSet<Long> agreementIds = new HashSet<Long>();
        agreementIds.add(agreement.getAgreementId());
        AgrAgreementStatusChangeAtomReqBO atomReqBO = new AgrAgreementStatusChangeAtomReqBO();
        atomReqBO.setAgreementIds(agreementIds);
        atomReqBO.setAgreementStatusPre(agreement.getAgreementStatus());
        agreementPO.setContractId(contractId);
        int update = this.agreementMapper.updateByConditions(agreementPO);
        if (update < 0) {
            log.error("\u5408\u540c\u505c\u7528\u540c\u6b65\u534f\u8bae\u5931\u8d25:\u66f4\u65b0\u534f\u8bae\u5408\u540cID\u5931\u8d25");
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        if (dealType.equals(1)) {
            atomReqBO.setAgreementStatusPost(AgrCommConstant.AgreementStatus.CONTRACT_CONFIRM);
            AgrSyncAgreementSkuFromContractReqBO agrSyncAgreementSkuFromContractReqBO = new AgrSyncAgreementSkuFromContractReqBO();
            agrSyncAgreementSkuFromContractReqBO.setAgreementId(agreementId);
            agrSyncAgreementSkuFromContractReqBO.setContractId(contractId);
            AgrSyncAgreementSkuFromContractRspBO agrSyncAgreementSkuFromContractRspBO = this.agrSyncAgreementSkuFromContractAbilityService.syncAgreementSku(agrSyncAgreementSkuFromContractReqBO);
            if (!"0000".equals(agrSyncAgreementSkuFromContractRspBO.getRespCode())) {
                log.error("\u5408\u540c\u505c\u7528\u540c\u6b65\u534f\u8bae\u5931\u8d25:{}", (Object)agrSyncAgreementSkuFromContractRspBO.getRespDesc());
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
        }
        if (dealType.equals(0)) {
            atomReqBO.setAgreementStatusPost(AgrCommConstant.AgreementStatus.FROZEN);
            agreementPO.setAgreementPreStatus(agreement.getAgreementStatus());
            this.agreementMapper.updateByCondition(agreementPO);
        }
        if (dealType.equals(2)) {
            atomReqBO.setAgreementStatusPost(agreement.getAgreementStatus());
        }
        if (!"0000".equals((atomRspBO = this.agrAgreementStatusChangeAtomService.updateAgreementStatus(atomReqBO)).getRespCode())) {
            log.error("\u5408\u540c\u534f\u8bae\u64cd\u4f5c\u5931\u8d25:" + atomRspBO.getRespDesc());
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }
}

