/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.base.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class HttpsUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpsUtil.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private static int CONNECTION_TIMEOUT = 10000;
    private static int READ_TIMEOUT = 30000;

    public static String buildQuery(Map params, String charset) throws Exception {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuffer query = new StringBuffer();
        Set entries = params.entrySet();
        Iterator it = entries.iterator();
        boolean hasParam = false;
        while (it.hasNext()) {
            String value;
            Map.Entry entry = it.next();
            String name = (String)entry.getKey();
            if (StringUtils.isEmpty((Object)new String[]{name, value = (String)entry.getValue()})) continue;
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            query.append(name).append("=").append(value);
        }
        System.out.println("query==>" + query);
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8bf7\u6c42\u53c2\u6570==>{}", (Object)query);
        }
        return query.toString();
    }

    public static String doPost(String url, Map params, String charset, int connectTimeout, int readTimeout) throws Exception {
        String ctype = "application/x-www-form-urlencoded;charset=" + charset;
        String query = HttpsUtil.buildQuery(params, charset);
        byte[] content = new byte[]{};
        if (query != null) {
            content = query.getBytes(charset);
        }
        return HttpsUtil.doPost(url, ctype, content, connectTimeout, readTimeout);
    }

    private static HttpsURLConnection getConnection(URL url, String method, String ctype) throws IOException {
        HttpsURLConnection conn = null;
        conn = (HttpsURLConnection)url.openConnection();
        conn.setRequestMethod(method);
        conn.setDoInput(true);
        if ("POST".equals(method)) {
            conn.setDoOutput(true);
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, String ctype, byte[] content, int connectTimeout, int readTimeout) throws IOException, KeyManagementException, NoSuchAlgorithmException {
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, new TrustManager[]{new TrustAnyTrustManager()}, new SecureRandom());
        HttpsURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            conn = HttpsUtil.getConnection(new URL(url), "POST", ctype);
            System.setProperty("sun.net.client.defaultConnectTimeout", String.valueOf(connectTimeout));
            System.setProperty("sun.net.client.defaultReadTimeout", String.valueOf(readTimeout));
            out = conn.getOutputStream();
            out.write(content);
            out.flush();
            rsp = HttpsUtil.getResponseAsString(conn);
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("msg==>{}", (Object)rsp);
            }
            System.out.println("msg==>" + rsp);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    private static String getResponseCharset(String ctype) {
        String charset = "UTF-8";
        if (!StringUtils.isEmpty((Object)ctype)) {
            for (String param : ctype.split(";")) {
                if (!(param = param.trim()).startsWith("charset")) continue;
                String[] pair = param.split("=", 2);
                if (pair.length != 2 || StringUtils.isEmpty((Object)pair[1])) break;
                charset = pair[1].trim();
                break;
            }
        }
        return charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStreamAsString(InputStream stream, String charset) throws IOException {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, charset));
            StringWriter writer = new StringWriter();
            char[] chars = new char[65];
            int count = 0;
            while ((count = reader.read(chars)) > 0) {
                writer.write(chars, 0, count);
            }
            String string = writer.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    protected static String getResponseAsString(HttpURLConnection conn) throws IOException {
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("ResponseCode==>{}", (Object)conn.getResponseCode());
        }
        System.out.println("ResponseCode==>" + conn.getResponseCode());
        String charset = HttpsUtil.getResponseCharset(conn.getContentType());
        InputStream es = conn.getErrorStream();
        if (es == null) {
            InputStream input = conn.getInputStream();
            return HttpsUtil.getStreamAsString(input, charset);
        }
        String msg = HttpsUtil.getStreamAsString(es, charset);
        if (StringUtils.isEmpty((Object)msg)) {
            throw new IOException(conn.getResponseCode() + ":" + conn.getResponseMessage());
        }
        return msg;
    }

    private static class TrustAnyHostnameVerifier
    implements HostnameVerifier {
        private TrustAnyHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    private static class TrustAnyTrustManager
    implements X509TrustManager {
        private TrustAnyTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

