/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.base.utils;

import java.math.BigDecimal;
import java.util.regex.Pattern;

public class MoneyUtil {
    private static final Pattern AMOUNT_PATTERN = Pattern.compile("^(0|[1-9]\\d{0,11})\\.(\\d\\d)$");
    private static final char[] RMB_NUMS = "\u96f6\u58f9\u8d30\u53c1\u8086\u4f0d\u9646\u67d2\u634c\u7396".toCharArray();
    private static final String[] UNITS = new String[]{"\u5143", "\u89d2", "\u5206", "\u5143\u6574"};
    private static final String[] U1 = new String[]{"", "\u62fe", "\u4f70", "\u4edf"};
    private static final String[] U2 = new String[]{"", "\u4e07", "\u4ebf"};
    private static final String VER = "0123456789.";

    public static BigDecimal l4B(Long fee) {
        if (fee == null) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(new BigDecimal(fee.toString()).divide(new BigDecimal("10000"), 4, 4).stripTrailingZeros().toPlainString());
    }

    public static BigDecimal l2B(Long fee) {
        if (fee == null) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(new BigDecimal(fee.toString()).divide(new BigDecimal("10000"), 2, 4).stripTrailingZeros().toPlainString());
    }

    public static BigDecimal b2B(BigDecimal fee) {
        if (fee == null) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(fee.divide(new BigDecimal("10000"), 10, 4).stripTrailingZeros().toPlainString());
    }

    public static BigDecimal b8B(BigDecimal fee) {
        if (fee == null) {
            return BigDecimal.ZERO;
        }
        return fee.setScale(8, 4).stripTrailingZeros();
    }

    public static Long b2L(BigDecimal fee) {
        if (fee == null) {
            return 0L;
        }
        return fee.multiply(new BigDecimal("10000")).longValue();
    }

    public static String convert(BigDecimal numberOfMoney) throws IllegalArgumentException {
        String amount = numberOfMoney.setScale(2, 4).toPlainString();
        if ("0".equals(numberOfMoney.stripTrailingZeros().toPlainString())) {
            return RMB_NUMS[0] + UNITS[0];
        }
        if (null == amount || amount.equals("") || amount.trim().equals("")) {
            throw new IllegalArgumentException("\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (char m : amount.toCharArray()) {
            if (VER.indexOf(m) > -1) continue;
            throw new IllegalArgumentException("\u91d1\u989d\u4e0d\u6b63\u786e");
        }
        if (amount.split("\\.")[0].length() > 12) {
            throw new IllegalArgumentException("\u91d1\u989d\u4e0d\u6b63\u786e");
        }
        if (amount.indexOf(".") <= -1) {
            return MoneyUtil.integer2rmb(amount) + UNITS[0] + UNITS[3];
        }
        StringBuffer stringBuffer = new StringBuffer(MoneyUtil.integer2rmb(amount.split("\\.")[0]));
        if (amount.split("\\.")[1].equals("0") || amount.split("\\.")[1].equals("00")) {
            return stringBuffer.append(UNITS[3]).toString();
        }
        if (amount.split("\\.").length == 0 || amount.split("\\.")[1].length() == 0) {
            throw new IllegalArgumentException("\u91d1\u989d\u4e0d\u6b63\u786e");
        }
        stringBuffer.append(UNITS[0]);
        stringBuffer.append(MoneyUtil.fraction2rmb(amount.split("\\.")[1]));
        return stringBuffer.toString();
    }

    private static String fraction2rmb(String fraction) {
        if (fraction.length() == 0 || fraction.length() > 2) {
            throw new IllegalArgumentException("\u91d1\u989d\u4e0d\u6b63\u786e");
        }
        if (fraction.length() == 1) {
            return RMB_NUMS[fraction.charAt(0) - 48] + (fraction.charAt(0) > '0' ? UNITS[1] : "");
        }
        if (fraction.length() == 2) {
            return RMB_NUMS[fraction.charAt(0) - 48] + (fraction.charAt(0) > '0' ? UNITS[1] : "") + (fraction.charAt(1) >= '0' ? RMB_NUMS[fraction.charAt(1) - 48] + UNITS[2] : "");
        }
        return "";
    }

    private static String integer2rmb(String integer) {
        StringBuilder buffer = new StringBuilder();
        int i = integer.length() - 1;
        int j = 0;
        while (i >= 0) {
            char n = integer.charAt(i);
            if (n == '0') {
                if (i < integer.length() - 1 && integer.charAt(i + 1) != '0') {
                    buffer.append(RMB_NUMS[0]);
                }
                if (j % 4 == 0 && (i > 0 && integer.charAt(i - 1) != '0' || i > 1 && integer.charAt(i - 2) != '0' || i > 2 && integer.charAt(i - 3) != '0')) {
                    buffer.append(U2[j / 4]);
                }
            } else {
                if (j % 4 == 0) {
                    buffer.append(U2[j / 4]);
                }
                buffer.append(U1[j % 4]);
                buffer.append(RMB_NUMS[n - 48]);
            }
            --i;
            ++j;
        }
        return buffer.reverse().toString();
    }
}

