/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.busicommon.order.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.busicommon.order.api.CceOrderDownloadService;
import com.tydic.dyc.busicommon.order.bo.CceOrderDownloadReqBO;
import com.tydic.dyc.busicommon.order.bo.CceOrderDownloadRspBO;
import com.tydic.dyc.busicommon.order.bo.OrderDownloadBO;
import com.tydic.uoc.common.ability.api.PebExtSalesSingleDetailsListQueryAbilityService;
import com.tydic.uoc.common.ability.bo.PebExtChildOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.PebExtOrderItemAbilityBO;
import com.tydic.uoc.common.ability.bo.PebExtSalesSingleDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.PebExtSalesSingleDetailsListQueryRspBO;
import com.tydic.uoc.common.ability.bo.PebExtUpperOrderAbilityBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CceOrderDownloadServiceImpl
implements CceOrderDownloadService {
    @Autowired
    private PebExtSalesSingleDetailsListQueryAbilityService pebExtSalesSingleDetailsListQueryAbilityService;
    @Value(value="${uoc.auth.cgld:cgld}")
    private String purCgld;
    @Value(value="${uoc.auth.yw:yw}")
    private String yw;

    public CceOrderDownloadRspBO download(CceOrderDownloadReqBO reqBO) {
        PebExtSalesSingleDetailsListQueryReqBO pebExtSalesSingleDetailsListQueryReqBO = this.bulid(reqBO);
        if (pebExtSalesSingleDetailsListQueryReqBO == null) {
            throw new ZTBusinessException("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u4e0b\u8f7d\u83dc\u5355");
        }
        PebExtSalesSingleDetailsListQueryRspBO queryRspBO = this.pebExtSalesSingleDetailsListQueryAbilityService.getPebExtSalesSingleDetailsListQuery(pebExtSalesSingleDetailsListQueryReqBO);
        if (!"0000".equals(queryRspBO.getRespCode())) {
            throw new ZTBusinessException(queryRspBO.getRespDesc());
        }
        CceOrderDownloadRspBO rspBO = new CceOrderDownloadRspBO();
        if (CollectionUtils.isEmpty((Collection)queryRspBO.getRows())) {
            rspBO.setPageNo(Integer.valueOf(reqBO.getPageNo()));
            rspBO.setRows(new ArrayList());
            rspBO.setRecordsTotal(Integer.valueOf(0));
            rspBO.setPageSize(Integer.valueOf(reqBO.getPageSize()));
            rspBO.setTotal(Integer.valueOf(0));
        } else {
            ArrayList<OrderDownloadBO> list = new ArrayList<OrderDownloadBO>();
            this.result(queryRspBO, list, reqBO.getExportType(), reqBO.getExportFlag());
            rspBO.setPageNo(Integer.valueOf(reqBO.getPageNo()));
            rspBO.setRows(list);
            rspBO.setRecordsTotal(Integer.valueOf(queryRspBO.getRecordsTotal()));
            rspBO.setPageSize(Integer.valueOf(reqBO.getPageSize()));
            rspBO.setTotal(Integer.valueOf(queryRspBO.getTotal()));
        }
        return rspBO;
    }

    private void result(PebExtSalesSingleDetailsListQueryRspBO rspBO, List<OrderDownloadBO> list, Integer exportType, Integer exportFlag) {
        if (exportType == 1) {
            for (PebExtUpperOrderAbilityBO abilityBO : rspBO.getRows()) {
                OrderDownloadBO downloadBO = new OrderDownloadBO();
                this.mainOrder(downloadBO, abilityBO, exportFlag);
                downloadBO.setOrganizationName(((PebExtOrderItemAbilityBO)((PebExtChildOrderAbilityBO)abilityBO.getChildOrderList().get(0)).getOrderItemList().get(0)).getOrganizationId() + "-" + ((PebExtOrderItemAbilityBO)((PebExtChildOrderAbilityBO)abilityBO.getChildOrderList().get(0)).getOrderItemList().get(0)).getOrganizationName());
                list.add(downloadBO);
            }
        } else {
            for (PebExtUpperOrderAbilityBO abilityBO : rspBO.getRows()) {
                for (PebExtOrderItemAbilityBO itemAbilityBO : ((PebExtChildOrderAbilityBO)abilityBO.getChildOrderList().get(0)).getOrderItemList()) {
                    OrderDownloadBO downloadBO = new OrderDownloadBO();
                    this.item(downloadBO, exportFlag, itemAbilityBO);
                    this.mainOrder(downloadBO, abilityBO, exportFlag);
                    list.add(downloadBO);
                }
            }
        }
    }

    private void mainOrder(OrderDownloadBO downloadBO, PebExtUpperOrderAbilityBO abilityBO, Integer exportFlag) {
        PebExtChildOrderAbilityBO child = (PebExtChildOrderAbilityBO)abilityBO.getChildOrderList().get(0);
        downloadBO.setSaleVoucherNo(child.getSaleVoucherNo());
        downloadBO.setPSaleVoucherNo(abilityBO.getSaleVoucherNo());
        downloadBO.setCrateOperName(child.getCreateOperNo() + "-" + abilityBO.getCreateOperName());
        downloadBO.setCratePurCompany(child.getCompanyNo() + "-" + child.getCompanyName());
        downloadBO.setCreateTime(child.getCreateTime());
        downloadBO.setPurCompany(child.getPurCompanyNo() + "-" + child.getPurCompanyName());
        downloadBO.setSupName(child.getSupNum() + "-" + abilityBO.getSupName());
        downloadBO.setPayTypeStr(child.getPayTypeStr());
        downloadBO.setProtocolName(child.getProtocolName());
        downloadBO.setPlaAgreementCode(child.getPlaAgreementCode());
        if (exportFlag == 3 || exportFlag == 4) {
            downloadBO.setSaleFeeMoney(child.getPurchaseFeeMoney());
        } else {
            downloadBO.setSaleFeeMoney(child.getSaleFeeMoney());
        }
        downloadBO.setBuynerName(child.getBuynerNo() + "-" + child.getBuynerName());
        downloadBO.setPurTypeStr(child.getPurTypeStr());
        downloadBO.setSaleStateStr(child.getSaleStateStr());
        downloadBO.setPayStatusStr(child.getPayStatusStr());
        downloadBO.setErpStatusStr(child.getErpStatusStr());
        downloadBO.setReceiver(child.getReceiver());
        downloadBO.setReceivePhone(child.getReceivePhone());
        downloadBO.setContactCompany(child.getContactCompany());
        downloadBO.setContactAddress(child.getContactProvinceName() + child.getContactCityName() + child.getContactCountyName() + child.getContactTown() + child.getContactAddress());
        downloadBO.setOrderDesc(child.getOrderDesc());
        downloadBO.setOutOrderNo(child.getOutOrderId());
        downloadBO.setVendorOrderTypeStr(child.getVendorOrderTypeStr());
        downloadBO.setAdminConfrimId(child.getAdminConfrimId());
        downloadBO.setAdminConfrimName(child.getAdminConfrimName());
        downloadBO.setAdminConfrimNo(child.getAdminConfrimNo());
        downloadBO.setJcHtBh(child.getJcHtBh());
    }

    private void item(OrderDownloadBO downloadBO, Integer exportFlag, PebExtOrderItemAbilityBO abilityBO) {
        downloadBO.setOrganizationName(abilityBO.getOrganizationId() + "-" + abilityBO.getOrganizationName());
        downloadBO.setSkuCode(abilityBO.getSkuCode());
        downloadBO.setSkuName(abilityBO.getSkuName());
        downloadBO.setSkuMaterialId(abilityBO.getSkuMaterialId());
        downloadBO.setSkuMaterialLongDesc(abilityBO.getSkuMaterialLongDesc());
        downloadBO.setSpec(abilityBO.getSpec());
        downloadBO.setModel(abilityBO.getModel());
        downloadBO.setUnitName(abilityBO.getUnitName());
        downloadBO.setMaterialBj(abilityBO.getMaterialBj());
        downloadBO.setSkuMaterialRemark(abilityBO.getSkuMaterialRemark());
        downloadBO.setZijsyq(abilityBO.getZijsyq());
        downloadBO.setPlanItemNo(abilityBO.getPlanItemNo());
        downloadBO.setPurchaseCount(abilityBO.getPurchaseCount());
        if (exportFlag == 3 || exportFlag == 4) {
            downloadBO.setSkuSellingPrice(abilityBO.getPurchasingPrice());
            downloadBO.setSkuSaleFeeMoney(abilityBO.getPurchaseFeeMoney());
        } else {
            downloadBO.setSkuSellingPrice(abilityBO.getSellingPrice());
            downloadBO.setSkuSaleFeeMoney(abilityBO.getSaleFeeMoney());
        }
        downloadBO.setTax(abilityBO.getTax());
        downloadBO.setWarehouseStatus(abilityBO.getWarehouseStatus());
        downloadBO.setOutSkuId(abilityBO.getOutSkuId());
        downloadBO.setPlanItemCode(abilityBO.getPlanItemCode());
        downloadBO.setPlanItemName(abilityBO.getPlanItemName());
    }

    private PebExtSalesSingleDetailsListQueryReqBO bulid(CceOrderDownloadReqBO reqBO) {
        String jsonReq = JSONObject.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        PebExtSalesSingleDetailsListQueryReqBO pebExtSalesSingleDetailsListQueryReqBO = (PebExtSalesSingleDetailsListQueryReqBO)JSON.parseObject((String)jsonReq, PebExtSalesSingleDetailsListQueryReqBO.class);
        if (reqBO.getExportFlag() == 1) {
            Integer isQryMenu = 1;
            if (!CollectionUtils.isEmpty((Collection)reqBO.getAuthPermission()) && isQryMenu.equals(reqBO.getIsQryMenu())) {
                if (reqBO.getAuthPermission().contains(this.purCgld)) {
                    pebExtSalesSingleDetailsListQueryReqBO.setIsDeptAuth(Integer.valueOf(1));
                    pebExtSalesSingleDetailsListQueryReqBO.setIsControlPermission(Boolean.valueOf(false));
                }
                if (reqBO.getAuthPermission().contains(this.yw)) {
                    pebExtSalesSingleDetailsListQueryReqBO.setIsControlPermission(Boolean.valueOf(false));
                    pebExtSalesSingleDetailsListQueryReqBO.setIsDeptAuth(Integer.valueOf(0));
                    pebExtSalesSingleDetailsListQueryReqBO.setIsAll(Integer.valueOf(1));
                }
            }
            return pebExtSalesSingleDetailsListQueryReqBO;
        }
        if (reqBO.getExportFlag() == 2) {
            ArrayList<Long> list;
            pebExtSalesSingleDetailsListQueryReqBO.setIsControlPermission(Boolean.valueOf(true));
            if (reqBO.getIsProfessionalOrgExt().equals("0") && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)reqBO.getOrderSourceList()) && !((String)reqBO.getOrderSourceList().get(0)).equals("2")) {
                pebExtSalesSingleDetailsListQueryReqBO.setSynergismIdYy(reqBO.getMemIdIn().toString());
                pebExtSalesSingleDetailsListQueryReqBO.setIsControlPermission(Boolean.valueOf(false));
            }
            if (reqBO.getCreateCompanyId() != null) {
                list = new ArrayList<Long>();
                list.add(reqBO.getCreateCompanyId());
                pebExtSalesSingleDetailsListQueryReqBO.setCreateCompanyId(list);
            }
            if (reqBO.getPurCompanyId() != null) {
                list = new ArrayList();
                list.add(reqBO.getPurCompanyId());
                pebExtSalesSingleDetailsListQueryReqBO.setPurCompanyId(list);
            }
            return pebExtSalesSingleDetailsListQueryReqBO;
        }
        if (reqBO.getExportFlag() == 3) {
            ArrayList<Long> list;
            pebExtSalesSingleDetailsListQueryReqBO.setIsControlPermission(Boolean.valueOf(true));
            if (reqBO.getIsProfessionalOrgExt().equals("0") && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)reqBO.getOrderSourceList()) && !((String)reqBO.getOrderSourceList().get(0)).equals("2")) {
                pebExtSalesSingleDetailsListQueryReqBO.setSynergismIdYy(reqBO.getMemIdIn().toString());
                pebExtSalesSingleDetailsListQueryReqBO.setIsControlPermission(Boolean.valueOf(false));
            }
            if (reqBO.getCreateCompanyId() != null) {
                list = new ArrayList<Long>();
                list.add(reqBO.getCreateCompanyId());
                pebExtSalesSingleDetailsListQueryReqBO.setCreateCompanyId(list);
            }
            if (reqBO.getPurCompanyId() != null) {
                list = new ArrayList();
                list.add(reqBO.getPurCompanyId());
                pebExtSalesSingleDetailsListQueryReqBO.setPurCompanyId(list);
            }
            return pebExtSalesSingleDetailsListQueryReqBO;
        }
        if (reqBO.getExportFlag() == 4) {
            pebExtSalesSingleDetailsListQueryReqBO.setSupNo(String.valueOf(reqBO.getSupId()));
            if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderType())) {
                pebExtSalesSingleDetailsListQueryReqBO.setOrderType(reqBO.getOrderType());
            } else if (!CollectionUtils.isEmpty((Collection)reqBO.getOrderSourceList())) {
                pebExtSalesSingleDetailsListQueryReqBO.setOrderSourceList(reqBO.getOrderSourceList());
            } else {
                ArrayList<String> orderSourceList = new ArrayList<String>();
                orderSourceList.add("3");
                orderSourceList.add("1");
                pebExtSalesSingleDetailsListQueryReqBO.setOrderSourceList(orderSourceList);
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getIsIntelligentFront())) {
                pebExtSalesSingleDetailsListQueryReqBO.setGoodsType(null);
                pebExtSalesSingleDetailsListQueryReqBO.setOrderType(null);
                pebExtSalesSingleDetailsListQueryReqBO.setOrderSourceList(null);
                pebExtSalesSingleDetailsListQueryReqBO.setIsControlPermission(Boolean.valueOf(false));
            }
            return pebExtSalesSingleDetailsListQueryReqBO;
        }
        return null;
    }
}

