/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.busicommon.common.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.utils.HttpUtil;
import com.tydic.dyc.busicommon.common.api.DycCommonStatisticalDataService;
import com.tydic.dyc.busicommon.common.bo.CommonStatisticalDataReqBO;
import com.tydic.dyc.busicommon.common.bo.CommonStatisticalDataRspBO;
import com.tydic.fsc.common.ability.api.FscPayBillStatisticalAbilityService;
import com.tydic.fsc.common.ability.bo.FscPayBillStatisticalAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPayBillStatisticalAbilityRspBO;
import com.tydic.uoc.common.ability.api.PebExtSalesSingleDetailsListQueryAbilityService;
import java.util.Calendar;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DycCommonStatisticalDataServiceImpl
implements DycCommonStatisticalDataService {
    private static final Logger log = LoggerFactory.getLogger(DycCommonStatisticalDataServiceImpl.class);
    @Value(value="${statistical.data.url}")
    private String url;
    @Autowired
    private PebExtSalesSingleDetailsListQueryAbilityService pebExtSalesSingleDetailsListQueryAbilityService;
    @Autowired
    private FscPayBillStatisticalAbilityService fscPayBillStatisticalAbilityService;
    @Value(value="${first.count:0}")
    private Integer firstCount;

    public CommonStatisticalDataRspBO getStatisticalData(CommonStatisticalDataReqBO reqBO) {
        String rspStr = "";
        CommonStatisticalDataRspBO rspBO = new CommonStatisticalDataRspBO();
        try {
            rspStr = HttpUtil.doPost((String)this.url, (String)"{}");
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u62a5\u9519" + e);
            rspBO.setSuccess(false);
            rspBO.setCode("0");
            rspBO.setMessage("\u67e5\u8be2\u975e\u62db\u6570\u636e\u8fd4\u56de\u62a5\u6587\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)rspStr)) {
            rspBO.setSuccess(false);
            rspBO.setCode("0");
            rspBO.setMessage("\u67e5\u8be2\u975e\u62db\u6570\u636e\u8fd4\u56de\u62a5\u6587\u4e3a\u7a7a");
        }
        return this.resolveRsp(rspStr);
    }

    private CommonStatisticalDataRspBO resolveRsp(String rspStr) {
        JSONObject jsonObject;
        try {
            jsonObject = JSONObject.parseObject((String)rspStr);
        }
        catch (Exception e) {
            CommonStatisticalDataRspBO rspBO = new CommonStatisticalDataRspBO();
            rspBO.setSuccess(false);
            rspBO.setCode("0");
            rspBO.setMessage("\u67e5\u8be2\u975e\u62db\u6570\u636e\u8fd4\u56de\u62a5\u6587\u4e3a\u7a7a");
            return rspBO;
        }
        if (jsonObject.get((Object)"success") == null) {
            CommonStatisticalDataRspBO rspBO = new CommonStatisticalDataRspBO();
            rspBO.setCode("0");
            rspBO.setSuccess(false);
            rspBO.setMessage("\u67e5\u8be2\u975e\u62db\u6570\u636e\u8fd4\u56de\u62a5\u6587\u4e3a\u7a7a");
            return rspBO;
        }
        if (((Boolean)jsonObject.get((Object)"success")).booleanValue()) {
            FscPayBillStatisticalAbilityReqBO queryReqBO = new FscPayBillStatisticalAbilityReqBO();
            Calendar calendar = Calendar.getInstance();
            queryReqBO.setCreateTimeEff(calendar.get(1) + "-01-01 00:00:00");
            queryReqBO.setCreateTimeExp(calendar.get(1) + "-12-31 23:59:59");
            CommonStatisticalDataRspBO rspBO = (CommonStatisticalDataRspBO)JSONObject.parseObject((String)rspStr, CommonStatisticalDataRspBO.class);
            log.error("\u8c03\u7528\u7ed3\u7b97\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)queryReqBO));
            FscPayBillStatisticalAbilityRspBO queryRspBO = this.fscPayBillStatisticalAbilityService.qryPayBillStatistical(queryReqBO);
            log.error("\u8c03\u7528\u7ed3\u7b97\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)queryRspBO));
            if (!"0000".equals(queryRspBO.getRespCode())) {
                rspBO.getData().setTradingCount(this.firstCount);
                rspBO.setCode("0");
                rspBO.setSuccess(false);
                rspBO.setMessage("\u8c03\u7528\u7ed3\u7b97\u62a5\u6587\u4e3a\u7a7a");
            } else if (queryRspBO.getStatisticalCount() == null) {
                rspBO.getData().setTradingCount(this.firstCount);
            } else {
                rspBO.getData().setTradingCount(Integer.valueOf(queryRspBO.getStatisticalCount() + this.firstCount));
            }
            return rspBO;
        }
        CommonStatisticalDataRspBO rspBO = new CommonStatisticalDataRspBO();
        rspBO.setSuccess(false);
        rspBO.setCode("0");
        rspBO.setMessage("\u8c03\u7528\u7ed3\u7b97\u62a5\u6587\u4e3a\u7a7a");
        return rspBO;
    }
}

