/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.busicommon.store.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.busicommon.store.api.DycMmcSaveShopInfoService;
import com.tydic.dyc.busicommon.store.bo.DycMmcSaveShopInfoReqBO;
import com.tydic.dyc.busicommon.store.bo.DycMmcSaveShopInfoRspBO;
import com.tydic.dyc.busicommon.store.bo.DycMmcShopAccessoryBO;
import com.tydic.dyc.busicommon.store.bo.DycMmcShopBO;
import com.tydic.dyc.busicommon.store.bo.DycMmcShopContactsBO;
import com.tydic.dyc.busicommon.store.bo.DycMmcSupplierSalesCategoryBO;
import com.tydic.mmc.ability.api.MmcSaveShopInfoAbilityService;
import com.tydic.mmc.ability.bo.MmcSaveShopInfoAbilityReqBO;
import com.tydic.mmc.ability.bo.MmcSaveShopInfoAbilityRspBO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DycMmcSaveShopInfoServiceImpl
implements DycMmcSaveShopInfoService {
    private static final Logger log = LoggerFactory.getLogger(DycMmcSaveShopInfoServiceImpl.class);
    @Autowired
    private MmcSaveShopInfoAbilityService mmcSaveShopInfoAbilityService;

    public DycMmcSaveShopInfoRspBO saveShopInfo(DycMmcSaveShopInfoReqBO dycMmcSaveShopInfoReqBO) {
        this.validate(dycMmcSaveShopInfoReqBO);
        log.info("\u5e97\u94fa\u5e94\u7528\u5e97\u94fa\u4fe1\u606f\u4fdd\u5b58\u5165\u53c2\uff1a" + dycMmcSaveShopInfoReqBO);
        MmcSaveShopInfoAbilityReqBO centerReqBO = (MmcSaveShopInfoAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)dycMmcSaveShopInfoReqBO), MmcSaveShopInfoAbilityReqBO.class);
        centerReqBO.setSupplierId(dycMmcSaveShopInfoReqBO.getOrgId());
        centerReqBO.setSupplierName(dycMmcSaveShopInfoReqBO.getOrgName());
        MmcSaveShopInfoAbilityRspBO centerRspBO = this.mmcSaveShopInfoAbilityService.saveShopInfo(centerReqBO);
        if (!centerRspBO.getRespCode().equals("0000")) {
            throw new ZTBusinessException(centerRspBO.getRespDesc());
        }
        return (DycMmcSaveShopInfoRspBO)JSON.parseObject((String)JSON.toJSONString((Object)centerRspBO), DycMmcSaveShopInfoRspBO.class);
    }

    private void validate(DycMmcSaveShopInfoReqBO dycMmcSaveShopInfoReqBO) {
        Boolean flag;
        if (dycMmcSaveShopInfoReqBO.getShopId() == null) {
            log.info("\u5e97\u94fa\u4fe1\u606f\u65b0\u589e");
            flag = true;
        } else {
            log.info("\u5e97\u94fa\u4fe1\u606f\u4fee\u6539");
            flag = false;
        }
        if (dycMmcSaveShopInfoReqBO.getUserId() == null) {
            throw new ZTBusinessException("\u5e97\u94fa\u5e94\u7528\u5e97\u94fa\u4fe1\u606f\u4fdd\u5b58-userId\u6ce8\u5165\u5931\u8d25");
        }
        if (dycMmcSaveShopInfoReqBO.getUserName() == null) {
            throw new ZTBusinessException("\u5e97\u94fa\u5e94\u7528\u5e97\u94fa\u4fe1\u606f\u4fdd\u5b58-userName\u6ce8\u5165\u5931\u8d25");
        }
        if (dycMmcSaveShopInfoReqBO.getMmcShopBO() == null) {
            throw new ZTBusinessException("\u5e97\u94fa\u5e94\u7528\u5e97\u94fa\u4fe1\u606f\u4fdd\u5b58-mmcShopBO\u4e0d\u80fd\u4e3anull");
        }
        this.validateShop(dycMmcSaveShopInfoReqBO.getMmcShopBO(), flag);
        if (flag.booleanValue()) {
            this.validateShopAccessory(dycMmcSaveShopInfoReqBO.getMmcShopAccessoryBOs());
            this.validateShopContacts(dycMmcSaveShopInfoReqBO.getMmcShopContactsBOs());
            this.validateSupplierSalesCategory(dycMmcSaveShopInfoReqBO.getMmcSupplierSalesCategoryBOs());
        }
    }

    private void validateShop(DycMmcShopBO dycMmcShopBO, Boolean flag) {
        if (dycMmcShopBO.getShopName() == null || dycMmcShopBO.getShopName() == "") {
            throw new ZTBusinessException("\u5e97\u94fa\u5e94\u7528\u5e97\u94fa\u4fe1\u606f\u4fdd\u5b58-dycMmcShopBO-shopName\u4e0d\u80fd\u4e3anull");
        }
        if (dycMmcShopBO.getShopAddress() == null || dycMmcShopBO.getShopAddress() == "") {
            throw new ZTBusinessException("\u5e97\u94fa\u5e94\u7528\u5e97\u94fa\u4fe1\u606f\u4fdd\u5b58-dycMmcShopBO-shopAddress\u4e0d\u80fd\u4e3anull");
        }
        if (dycMmcShopBO.getShopDescribe() == null || dycMmcShopBO.getShopDescribe() == "") {
            throw new ZTBusinessException("\u5e97\u94fa\u5e94\u7528\u5e97\u94fa\u4fe1\u606f\u4fdd\u5b58-dycMmcShopBO-shopDescribe\u4e0d\u80fd\u4e3anull");
        }
        if (dycMmcShopBO.getShopWebsite() == null || dycMmcShopBO.getShopWebsite() == "") {
            throw new ZTBusinessException("\u5e97\u94fa\u5e94\u7528\u5e97\u94fa\u4fe1\u606f\u4fdd\u5b58-dycMmcShopBO-shopWebsite\u4e0d\u80fd\u4e3anull");
        }
        if (dycMmcShopBO.getShopLogoUrl() == null || dycMmcShopBO.getShopLogoUrl() == "") {
            throw new ZTBusinessException("\u5e97\u94fa\u5e94\u7528\u5e97\u94fa\u4fe1\u606f\u4fdd\u5b58-dycMmcShopBO-shopLogoUrl\u4e0d\u80fd\u4e3anull");
        }
        if (dycMmcShopBO.getShipSignUrl() == null || dycMmcShopBO.getShipSignUrl() == "") {
            throw new ZTBusinessException("\u5e97\u94fa\u5e94\u7528\u5e97\u94fa\u4fe1\u606f\u4fdd\u5b58-dycMmcShopBO-shipSignUrl\u4e0d\u80fd\u4e3anull");
        }
        if (dycMmcShopBO.getCreateDeptId() == null && flag.booleanValue()) {
            throw new ZTBusinessException("\u5e97\u94fa\u5e94\u7528\u5e97\u94fa\u4fe1\u606f\u4fdd\u5b58-dycMmcShopBO-createDeptId\u4e0d\u80fd\u4e3anull");
        }
        if ((dycMmcShopBO.getCreateDeptName() == null || dycMmcShopBO.getCreateDeptName() == "") && flag.booleanValue()) {
            throw new ZTBusinessException("\u5e97\u94fa\u5e94\u7528\u5e97\u94fa\u4fe1\u606f\u4fdd\u5b58-dycMmcShopBO-createDeptName\u4e0d\u80fd\u4e3anull");
        }
        if (dycMmcShopBO.getCreateUserId() == null && flag.booleanValue()) {
            throw new ZTBusinessException("\u5e97\u94fa\u5e94\u7528\u5e97\u94fa\u4fe1\u606f\u4fdd\u5b58-dycMmcShopBO-createUserId\u4e0d\u80fd\u4e3anull");
        }
        if ((dycMmcShopBO.getCreateUserName() == null || dycMmcShopBO.getCreateUserName() == "") && flag.booleanValue()) {
            throw new ZTBusinessException("\u5e97\u94fa\u5e94\u7528\u5e97\u94fa\u4fe1\u606f\u4fdd\u5b58-dycMmcShopBO-createUserName\u4e0d\u80fd\u4e3anull");
        }
        if (dycMmcShopBO.getUpdateUserId() == null && !flag.booleanValue()) {
            throw new ZTBusinessException("\u5e97\u94fa\u5e94\u7528\u5e97\u94fa\u4fe1\u606f\u4fdd\u5b58-dycMmcShopBO-updateUserId\u4e0d\u80fd\u4e3anull");
        }
        if (!(dycMmcShopBO.getUpdateUserName() != null && dycMmcShopBO.getUpdateUserName() != "" || flag.booleanValue())) {
            throw new ZTBusinessException("\u5e97\u94fa\u5e94\u7528\u5e97\u94fa\u4fe1\u606f\u4fdd\u5b58-dycMmcShopBO-updateUserName\u4e0d\u80fd\u4e3anull");
        }
    }

    private void validateShopAccessory(List<DycMmcShopAccessoryBO> list) {
        if (list == null || list.size() <= 0) {
            throw new ZTBusinessException("\u5e97\u94fa\u5e94\u7528\u5e97\u94fa\u4fe1\u606f\u4fdd\u5b58-mmcShopAccessoryBOs\u4e0d\u80fd\u4e3anull");
        }
        for (DycMmcShopAccessoryBO dycMmcShopAccessoryBO : list) {
            if (dycMmcShopAccessoryBO.getAccessoryName() == null || dycMmcShopAccessoryBO.getAccessoryName() == "") {
                throw new ZTBusinessException("\u5e97\u94fa\u5e94\u7528\u5e97\u94fa\u4fe1\u606f\u4fdd\u5b58-dycMmcShopAccessoryBO-accessoryName\u4e0d\u80fd\u4e3anull");
            }
            if (dycMmcShopAccessoryBO.getAccessoryUrl() == null || dycMmcShopAccessoryBO.getAccessoryUrl() == "") {
                throw new ZTBusinessException("\u5e97\u94fa\u5e94\u7528\u5e97\u94fa\u4fe1\u606f\u4fdd\u5b58-dycMmcShopAccessoryBO-accessoryUrl\u4e0d\u80fd\u4e3anull");
            }
            if (dycMmcShopAccessoryBO.getAccessorySerial() != null) continue;
            throw new ZTBusinessException("\u5e97\u94fa\u5e94\u7528\u5e97\u94fa\u4fe1\u606f\u4fdd\u5b58-dycMmcShopAccessoryBO-accessorySerial\u4e0d\u80fd\u4e3anull");
        }
    }

    private void validateShopContacts(List<DycMmcShopContactsBO> list) {
        if (list == null || list.size() <= 0) {
            throw new ZTBusinessException("\u5e97\u94fa\u5e94\u7528\u5e97\u94fa\u4fe1\u606f\u4fdd\u5b58-mmcShopContactsBOs\u4e0d\u80fd\u4e3anull");
        }
        for (DycMmcShopContactsBO dycMmcShopContactsBO : list) {
            if (dycMmcShopContactsBO.getContractName() != null && dycMmcShopContactsBO.getContractName() != "") continue;
            throw new ZTBusinessException("\u5e97\u94fa\u5e94\u7528\u5e97\u94fa\u4fe1\u606f\u4fdd\u5b58-dycMmcShopContactsBO-contractName\u4e0d\u80fd\u4e3anull");
        }
    }

    private void validateSupplierSalesCategory(List<DycMmcSupplierSalesCategoryBO> list) {
        if (list == null || list.size() <= 0) {
            throw new ZTBusinessException("\u5e97\u94fa\u5e94\u7528\u5e97\u94fa\u4fe1\u606f\u4fdd\u5b58-mmcSupplierSalesCategoryBOs\u4e0d\u80fd\u4e3anull");
        }
        for (DycMmcSupplierSalesCategoryBO dycMmcSupplierSalesCategoryBO : list) {
            if (dycMmcSupplierSalesCategoryBO.getItemCatId() == null) {
                throw new ZTBusinessException("\u5e97\u94fa\u5e94\u7528\u5e97\u94fa\u4fe1\u606f\u4fdd\u5b58-dycMmcSupplierSalesCategoryBO-itemCatId\u4e0d\u80fd\u4e3anull");
            }
            if (dycMmcSupplierSalesCategoryBO.getItemCatName() != null && dycMmcSupplierSalesCategoryBO.getItemCatName() != "") continue;
            throw new ZTBusinessException("\u5e97\u94fa\u5e94\u7528\u5e97\u94fa\u4fe1\u606f\u4fdd\u5b58-dycMmcSupplierSalesCategoryBO-itemCatName\u4e0d\u80fd\u4e3anull");
        }
    }
}

