/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.user.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.dyc.common.user.api.DycOrgImportService;
import com.tydic.dyc.common.user.bo.DycOrgImportBo;
import com.tydic.dyc.common.user.bo.DycOrgImportReqBo;
import com.tydic.dyc.common.user.bo.DycOrgImportRspBo;
import com.tydic.dyc.common.util.BatchImportUtils;
import com.tydic.umc.general.ability.api.CnncUmcFileImpLogAbilityService;
import com.tydic.umc.general.ability.api.DictionaryAbilityService;
import com.tydic.umc.general.ability.api.UmcDycEnterpriseOrgQryListPageAbilityService;
import com.tydic.umc.general.ability.bo.BusinessChangeFileAnnoxBO;
import com.tydic.umc.general.ability.bo.CnncUmcFileImpLogAbilityReqBO;
import com.tydic.umc.general.ability.bo.CnncUmcFileImpLogAbilityRspBO;
import com.tydic.umc.general.ability.bo.CnncUmcFileImpLogDetailBO;
import com.tydic.umc.general.ability.bo.QueryDictionaryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcDycEnterpriseOrgQryListPageAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcDycEnterpriseOrgQryListPageAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycOrgImportServiceImpl
implements DycOrgImportService {
    private static final Logger log = LoggerFactory.getLogger(DycOrgImportServiceImpl.class);
    @Autowired
    private UmcDycEnterpriseOrgQryListPageAbilityService umcDycEnterpriseOrgQryListPageAbilityService;
    @Autowired
    private CnncUmcFileImpLogAbilityService cnncUmcFileImpLogAbilityService;
    @Autowired
    private DictionaryAbilityService dictionaryAbilityService;
    private static final int size = 3000;
    @Autowired
    private CacheClient cacheClient;

    public DycOrgImportRspBo dealOrgImport(DycOrgImportReqBo reqBo) {
        List<Map<String, Object>> importDataMap;
        DycOrgImportRspBo rspBo = new DycOrgImportRspBo();
        int titleLine = 6;
        int rowsLine = 8;
        QueryDictionaryAbilityReqBO queryDictionaryAbilityReqBO = new QueryDictionaryAbilityReqBO();
        queryDictionaryAbilityReqBO.setPcode("ORG_RANG_IMPOT_TITLE");
        Map titleMap = this.dictionaryAbilityService.queryBypCodeBackMap(queryDictionaryAbilityReqBO);
        if (!CollectionUtils.isEmpty((Map)titleMap)) {
            titleLine = Integer.valueOf((String)Lists.newArrayList(titleMap.keySet()).get(0));
        }
        queryDictionaryAbilityReqBO.setPcode("ORG_RANG_IMPOT_ROWS");
        Map rowsMap = this.dictionaryAbilityService.queryBypCodeBackMap(queryDictionaryAbilityReqBO);
        if (!CollectionUtils.isEmpty((Map)rowsMap)) {
            rowsLine = Integer.valueOf((String)Lists.newArrayList(rowsMap.keySet()).get(0));
        }
        ArrayList<String> title = new ArrayList<String>();
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        try {
            BatchImportUtils<DycOrgImportBo> batchImportUtils = new BatchImportUtils<DycOrgImportBo>(title, data, DycOrgImportBo.class);
            batchImportUtils.batchImport(reqBo.getImportUrl(), titleLine, rowsLine, 3000);
            importDataMap = batchImportUtils.getImportDataMaps();
            log.debug("\u6587\u4ef6\u6570\u636e\u884c------------------------------------" + ((Object)data).toString() + "---------------------------------------------------------------");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u5bfc\u5165\u89e3\u6790\u6587\u4ef6\u6570\u636e\u5931\u8d25:{}", (Object)e.toString());
            throw new ZTBusinessException("\u5bfc\u5165\u89e3\u6790\u6587\u4ef6\u6570\u636e\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(importDataMap)) {
            throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u6570\u636e");
        }
        Object importCache = this.cacheClient.get("org_import_" + reqBo.getImportId());
        List cacheOrgCodes = new ArrayList();
        if (importCache != null) {
            cacheOrgCodes = JSONObject.parseArray((String)JSONObject.toJSONString((Object)importCache), String.class);
        }
        log.debug("\u8bfb\u53d6\u7ed3\u679c\uff1a" + importDataMap);
        ArrayList<DycOrgImportBo> importBos = new ArrayList<DycOrgImportBo>();
        HashSet<String> orgCodes = new HashSet<String>();
        for (Map<String, Object> map : importDataMap) {
            Iterator<Map<String, Object>> codeObj = map.get("orgCode");
            if (ObjectUtil.isEmpty((Object)codeObj) || "null".equals(codeObj)) {
                map.put("impRemark", "\u5355\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                map.put("impResult", "1");
                continue;
            }
            Object nameObj = map.get("orgName");
            if (ObjectUtil.isEmpty((Object)nameObj) || "null".equals(nameObj)) {
                map.put("impRemark", "\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                map.put("impResult", "1");
                continue;
            }
            if (cacheOrgCodes.contains(codeObj.toString())) {
                map.put("impRemark", "\u5355\u4f4d\u5df2\u5bfc\u5165\uff01");
                map.put("impResult", "1");
                continue;
            }
            if (codeObj.toString().endsWith(".0")) {
                codeObj = codeObj.toString().substring(0, codeObj.toString().length() - 2);
            }
            map.put("orgCode", codeObj);
            orgCodes.add(codeObj.toString());
        }
        if (!CollectionUtils.isEmpty(orgCodes)) {
            UmcDycEnterpriseOrgQryListPageAbilityReqBO umcDycEnterpriseOrgQryListPageAbilityReqBO = new UmcDycEnterpriseOrgQryListPageAbilityReqBO();
            umcDycEnterpriseOrgQryListPageAbilityReqBO.setOrgCodeList((List)Lists.newArrayList(orgCodes));
            umcDycEnterpriseOrgQryListPageAbilityReqBO.setIsBusiOrg(reqBo.getIsBusiOrg());
            umcDycEnterpriseOrgQryListPageAbilityReqBO.setPageNo(Integer.valueOf(1));
            umcDycEnterpriseOrgQryListPageAbilityReqBO.setPageSize(Integer.valueOf(3000));
            UmcDycEnterpriseOrgQryListPageAbilityRspBO umcDycEnterpriseOrgQryListPageAbilityRspBO = this.umcDycEnterpriseOrgQryListPageAbilityService.qryEnterpriseOrgListPage(umcDycEnterpriseOrgQryListPageAbilityReqBO);
            if ("0000".equals(umcDycEnterpriseOrgQryListPageAbilityRspBO.getRespCode())) {
                if (CollectionUtils.isEmpty((Collection)umcDycEnterpriseOrgQryListPageAbilityRspBO.getRows())) {
                    for (Map<String, Object> map : importDataMap) {
                        map.put("impRemark", "\u5355\u4f4d\u7f16\u7801\u586b\u5199\u9519\u8bef");
                        map.put("impResult", "1");
                    }
                } else {
                    List qryResultBos = JSONObject.parseArray((String)JSONObject.toJSONString((Object)umcDycEnterpriseOrgQryListPageAbilityRspBO.getRows()), DycOrgImportBo.class);
                    Map<String, DycOrgImportBo> qryResultMap = qryResultBos.stream().collect(Collectors.toMap(a -> a.getOrgCode(), a -> a, (first, second) -> first));
                    for (Map<String, Object> map : importDataMap) {
                        if (!map.get("impResult").toString().equals("0")) continue;
                        if (!qryResultMap.containsKey(map.get("orgCode").toString())) {
                            map.put("impRemark", "\u672a\u67e5\u8be2\u5230\u8be5\u5355\u4f4d,\u5355\u4f4d\u7f16\u7801\u586b\u5199\u9519\u8bef");
                            map.put("impResult", "1");
                            continue;
                        }
                        importBos.add(qryResultMap.get(map.get("orgCode").toString()));
                    }
                }
            } else {
                for (Map<String, Object> map : importDataMap) {
                    map.put("impRemark", "\u4f1a\u5458\u5355\u4f4d\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff01" + umcDycEnterpriseOrgQryListPageAbilityRspBO.getRespDesc());
                    map.put("impResult", "1");
                }
            }
        }
        Long failedImportCounts = importDataMap.size() - importBos.size();
        Long sucessImportCounts = importBos.size();
        CnncUmcFileImpLogAbilityRspBO cnncUmcFileImpLogAbilityRspBO = this.dofileImpLogAdd(this.exportImportFeedBackResults(importDataMap), reqBo.getMemIdIn(), sucessImportCounts, failedImportCounts);
        rspBo.setImpId(cnncUmcFileImpLogAbilityRspBO.getImpId());
        rspBo.setRows(importBos);
        if (!CollectionUtils.isEmpty(importBos)) {
            List importCodes = importBos.stream().map(a -> a.getOrgCode()).collect(Collectors.toList());
            this.cacheClient.set("org_import_" + reqBo.getImportId(), importCodes, DycOrgImportServiceImpl.getExpireSeconds(3600, 1));
        }
        return rspBo;
    }

    public static void main(String[] args) {
        try {
            ArrayList<String> title = new ArrayList<String>();
            ArrayList<List<String>> data = new ArrayList<List<String>>();
            BatchImportUtils<DycOrgImportBo> batchImportUtils = new BatchImportUtils<DycOrgImportBo>(title, data, DycOrgImportBo.class);
            batchImportUtils.batchImport("", 7, 9, 3000);
            List<Map<String, Object>> importDataMap = batchImportUtils.getImportDataMaps();
            System.out.println(importDataMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getExpireSeconds(int radix, int range) {
        return radix * (new Random().nextInt(range) + 1);
    }

    private List<Map<String, Object>> exportImportFeedBackResults(List<Map<String, Object>> importDataMap) {
        ArrayList<Map<String, Object>> exportData = new ArrayList<Map<String, Object>>();
        int index = 1;
        for (Map<String, Object> mapData : importDataMap) {
            LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>();
            item.put("\u5e8f\u53f7", index);
            item.put("\u5355\u4f4d\u7f16\u7801", mapData.get("orgCode"));
            item.put("\u5355\u4f4d\u540d\u79f0", mapData.get("orgName"));
            if (mapData.get("impResult") != null && Integer.parseInt(mapData.get("impResult").toString()) == 0) {
                item.put("\u5bfc\u5165\u7ed3\u679c", "\u6210\u529f");
                item.put("\u5931\u8d25\u539f\u56e0", "");
            } else if (mapData.get("impResult") != null && Integer.parseInt(mapData.get("impResult").toString()) == 1) {
                item.put("\u5bfc\u5165\u7ed3\u679c", "\u5931\u8d25");
                item.put("\u5931\u8d25\u539f\u56e0", mapData.get("impRemark"));
            } else {
                item.put("\u5bfc\u5165\u7ed3\u679c", "\u5bfc\u5165\u5f02\u5e38");
            }
            exportData.add(item);
            ++index;
        }
        return exportData;
    }

    private CnncUmcFileImpLogAbilityRspBO dofileImpLogAdd(List<Map<String, Object>> exportData, Long memIdIn, Long sucessImportCounts, Long failedImportCounts) {
        CnncUmcFileImpLogAbilityReqBO cnncUmcFileImpLogAbilityReqBO = new CnncUmcFileImpLogAbilityReqBO();
        cnncUmcFileImpLogAbilityReqBO.setMemIdIn(memIdIn);
        cnncUmcFileImpLogAbilityReqBO.setSuccessCount(sucessImportCounts);
        cnncUmcFileImpLogAbilityReqBO.setFailureCount(failedImportCounts);
        cnncUmcFileImpLogAbilityReqBO.setImpCount(Long.valueOf(sucessImportCounts + failedImportCounts));
        cnncUmcFileImpLogAbilityReqBO.setImpRemark("");
        cnncUmcFileImpLogAbilityReqBO.setImpResult(Integer.valueOf(0));
        cnncUmcFileImpLogAbilityReqBO.setOutImpId(Long.valueOf(10001L));
        cnncUmcFileImpLogAbilityReqBO.setImpType("ORG_RANGE_IMPORT");
        this.createDataJson(cnncUmcFileImpLogAbilityReqBO, exportData);
        log.info("--\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u5bfc\u5165\u8bb0\u5f55\u670d\u52a1\u5165\u53c2\u4e3a:" + JSON.toJSONString((Object)cnncUmcFileImpLogAbilityReqBO));
        CnncUmcFileImpLogAbilityRspBO cnncUmcFileImpLogAbilityRspBO = this.cnncUmcFileImpLogAbilityService.fileImpLogAdd(cnncUmcFileImpLogAbilityReqBO);
        log.info("--\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u5bfc\u5165\u8bb0\u5f55\u670d\u52a1\u51fa\u53c2\u4e3a:" + JSON.toJSONString((Object)cnncUmcFileImpLogAbilityRspBO));
        return cnncUmcFileImpLogAbilityRspBO;
    }

    private void createDataJson(CnncUmcFileImpLogAbilityReqBO cnncUmcFileImpLogAbilityReqBO, List<Map<String, Object>> exportData) {
        ArrayList<BusinessChangeFileAnnoxBO> fileUrlList = new ArrayList<BusinessChangeFileAnnoxBO>();
        BusinessChangeFileAnnoxBO annoxBO = new BusinessChangeFileAnnoxBO();
        annoxBO.setName("");
        annoxBO.setPath("");
        fileUrlList.add(annoxBO);
        cnncUmcFileImpLogAbilityReqBO.setFileUrl(fileUrlList);
        StringBuilder headBuilder = new StringBuilder();
        if (exportData.size() > 0) {
            boolean firstRow = true;
            ArrayList<CnncUmcFileImpLogDetailBO> logDetailBOS = new ArrayList<CnncUmcFileImpLogDetailBO>();
            for (Map<String, Object> row : exportData) {
                CnncUmcFileImpLogDetailBO detailBO = new CnncUmcFileImpLogDetailBO();
                StringBuilder builder = new StringBuilder();
                Iterator<Map.Entry<String, Object>> it = row.entrySet().iterator();
                int size = row.size();
                int count = 1;
                while (it.hasNext()) {
                    Map.Entry<String, Object> entry = it.next();
                    if (firstRow) {
                        if (count == size) {
                            firstRow = false;
                            headBuilder.append((Object)entry.getKey());
                        } else {
                            headBuilder.append((Object)entry.getKey()).append("##");
                        }
                    }
                    builder.append(StringUtils.isBlank((CharSequence)entry.getValue().toString()) ? " " : entry.getValue());
                    if (count != size) {
                        builder.append("##");
                    }
                    ++count;
                }
                detailBO.setDataJson(builder.toString());
                if (row.get("\u5bfc\u5165\u7ed3\u679c").toString().equals("\u6210\u529f")) {
                    detailBO.setStatus(Integer.valueOf(0));
                } else {
                    detailBO.setStatus(Integer.valueOf(1));
                    detailBO.setFailureReasons(row.get("\u5931\u8d25\u539f\u56e0").toString());
                }
                logDetailBOS.add(detailBO);
            }
            cnncUmcFileImpLogAbilityReqBO.setLogDetails(logDetailBOS);
            cnncUmcFileImpLogAbilityReqBO.setDataColumns(headBuilder.toString());
        }
    }
}

