/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.util;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.common.util.ErrorCode;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class SecurityUtil {
    public static String encryptAES(String content, String secretKey) {
        SecurityUtil.checkParam(content, secretKey);
        String encryptResultStr = SecurityUtil.encrypt(content, secretKey);
        encryptResultStr = SecurityUtil.ebotongEncrypto(encryptResultStr);
        return encryptResultStr;
    }

    public static String decryptAES(String encryptResultStr, String secretKey) {
        SecurityUtil.checkParam(encryptResultStr, secretKey);
        try {
            String decrpt = SecurityUtil.ebotongDecrypto(encryptResultStr);
            byte[] decryptFrom = SecurityUtil.hexToByteArray(decrpt);
            byte[] decryptResult = SecurityUtil.decrypt(decryptFrom, secretKey);
            return new String(decryptResult);
        }
        catch (Exception e) {
            throw new ZTBusinessException(ErrorCode.CONTENT_EMPTY_ERROR.getMsg());
        }
    }

    private static void checkParam(String encryptResultStr, String secretKey) {
        if (SecurityUtil.isBlank(encryptResultStr)) {
            throw new ZTBusinessException(ErrorCode.CONTENT_EMPTY_ERROR.getMsg());
        }
        if (secretKey.length() != 32 || !secretKey.matches("^[a-z0-9A-Z]+$")) {
            throw new ZTBusinessException(ErrorCode.SECRET_KEY_ERROR.getMsg());
        }
    }

    private static String encrypt(String content, String password) {
        try {
            byte[] raw = password.getBytes("UTF-8");
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, skeySpec);
            byte[] byteRresult = cipher.doFinal(content.getBytes("UTF-8"));
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < byteRresult.length; ++i) {
                String hex = Integer.toHexString(byteRresult[i] & 0xFF);
                if (hex.length() == 1) {
                    hex = '0' + hex;
                }
                sb.append(hex.toUpperCase());
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new ZTBusinessException(ErrorCode.CONTENT_ENCODE_ERROR.getMsg());
        }
    }

    private static byte[] decrypt(byte[] content, String password) {
        try {
            byte[] raw = password.getBytes("UTF-8");
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(2, skeySpec);
            byte[] result = cipher.doFinal(content);
            return result;
        }
        catch (Exception e) {
            throw new ZTBusinessException(ErrorCode.SECRET_DECODE_ERROR.getMsg());
        }
    }

    private static byte[] hexToByteArray(String inHex) {
        byte[] result;
        int hexlen = inHex.length();
        if (hexlen % 2 == 1) {
            result = new byte[++hexlen / 2];
            inHex = "0" + inHex;
        } else {
            result = new byte[hexlen / 2];
        }
        int j = 0;
        for (int i = 0; i < hexlen; i += 2) {
            result[j] = SecurityUtil.hexToByte(inHex.substring(i, i + 2));
            ++j;
        }
        return result;
    }

    private static byte hexToByte(String inHex) {
        return (byte)Integer.parseInt(inHex, 16);
    }

    private static String ebotongEncrypto(String str) {
        String result = str;
        if (str != null && str.length() > 0) {
            try {
                byte[] encodeByte = str.getBytes("UTF-8");
                result = Base64.getEncoder().encodeToString(encodeByte);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result.replaceAll("\r\n", "").replaceAll("\r", "").replaceAll("\n", "");
    }

    private static String ebotongDecrypto(String str) {
        byte[] encodeByte = Base64.getDecoder().decode(str);
        return new String(encodeByte);
    }

    private static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

