/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.user.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.authority.busi.api.SelectUserByLoginNameService;
import com.tydic.authority.busi.bo.SelectUserByLoginNameReqBO;
import com.tydic.authority.busi.bo.SelectUserByLoginNameRspBO;
import com.tydic.dyc.common.user.api.ComAuthLoginService;
import com.tydic.dyc.common.user.bo.ComAuthLoginReqBO;
import com.tydic.dyc.common.util.EncodingUtils;
import com.tydic.dyc.common.util.SecurityUtil;
import com.tydic.dyc.common.util.SignUtil;
import com.tydic.umc.general.ability.api.UmcLoginAbilityService;
import com.tydic.umc.general.ability.bo.UmcLoginExpTimeAbilityReqBO;
import com.tydic.umc.security.jwt.UmcJwt;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jose4j.keys.AesKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ComAuthLoginServiceImpl
implements ComAuthLoginService {
    private static final Logger log = LoggerFactory.getLogger(ComAuthLoginServiceImpl.class);
    @Value(value="${jwt.signingKey:4Qy93T0Cea_s5J1IM8d_NZknAKVka_d7p_Inkm1WMckboJWBbte9JuxuUIaYgUg72WDwYhwGrqWKeW1ba6OVVQ}")
    private String jwtSigningKey;
    @Value(value="${jwt.encryptionKey:SCohMtxkDqIt8v0VR5FVK2g8CT8DlxYy7cXO43ypMJo}")
    private String jwtEncryptionKey;
    @Autowired
    private UmcLoginAbilityService umcLoginAbilityService;
    @Autowired
    private SelectUserByLoginNameService selectUserByLoginNameService;
    @Value(value="${zm.index:http://172.20.9.251/}")
    private String url;
    private static final String USERNAME_KEY = "sub";
    @Value(value="${zm.authUser.key:csb48SawbCCFFdYDG5KmjinTdREKGKEQ}")
    private String key;

    public void authLogin(String ticket, HttpServletResponse response, HttpServletRequest request) {
        log.error("jwt\u5bc6\u6587" + ticket);
        String user = this.parseTicket(ticket);
        JSONObject jsonObject = JSONObject.parseObject((String)user);
        String erpCode = jsonObject.getString(USERNAME_KEY);
        HashMap<String, Long> payload = new HashMap<String, Long>();
        Date date = new Date();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)erpCode)) {
            throw new ZTBusinessException("erp\u5458\u5de5\u7f16\u53f7\u4e3a\u7a7a!");
        }
        SelectUserByLoginNameReqBO userByLoginNameReqBO = new SelectUserByLoginNameReqBO();
        userByLoginNameReqBO.setUsername(erpCode);
        SelectUserByLoginNameRspBO userLoginDetailBO = this.selectUserByLoginNameService.selectUserByLoginNameNoAuth(userByLoginNameReqBO);
        if (userLoginDetailBO == null) {
            throw new ZTBusinessException("\u7528\u6237\u4e0d\u5b58\u5728!");
        }
        payload.put("userId", userLoginDetailBO.getUserId());
        payload.put("iat", date.getTime());
        String token = UmcJwt.createToken(payload);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)token)) {
            throw new ZTBusinessException("\u6388\u6743\u5931\u8d25");
        }
        UmcLoginExpTimeAbilityReqBO abilityReq = new UmcLoginExpTimeAbilityReqBO();
        abilityReq.setToken(token);
        Cookie cookie = new Cookie("auth-token", token);
        cookie.setPath("/");
        response.addCookie(cookie);
        this.umcLoginAbilityService.updateLoginExpTime(abilityReq);
        try {
            response.sendRedirect(this.url);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String parseTicket(String ticket) {
        String clearJwt = null;
        if (StringUtils.hasText((String)ticket)) {
            if (StringUtils.hasText((String)this.jwtSigningKey)) {
                try {
                    AesKey signingKey = new AesKey(this.jwtSigningKey.getBytes(StandardCharsets.UTF_8));
                    byte[] encoded = EncodingUtils.verifyJwsSignature((Key)signingKey, ticket.getBytes(StandardCharsets.UTF_8));
                    if (encoded != null && encoded.length > 0) {
                        String encodedObj = new String(encoded, StandardCharsets.UTF_8);
                        if (StringUtils.hasText((String)this.jwtEncryptionKey)) {
                            Key encryptionKey = EncodingUtils.generateJsonWebKey(this.jwtEncryptionKey);
                            clearJwt = EncodingUtils.decryptJwtValue(encryptionKey, encodedObj);
                        }
                        clearJwt = encodedObj;
                    }
                    throw new ZTBusinessException("jwt\u7b7e\u540d\u4e0d\u901a\u8fc7");
                }
                catch (Exception e) {
                    log.error("jwt\u7b7e\u540d\u6216\u8005\u89e3\u5bc6\u4e0d\u6b63\u786e", (Throwable)e);
                    throw new ZTBusinessException("jwt\u7b7e\u540d\u6216\u8005\u89e3\u5bc6\u4e0d\u6b63\u786e:" + e.getMessage());
                }
            } else {
                try {
                    PlainJWT plainJWT = PlainJWT.parse((String)ticket);
                    JWTClaimsSet jwtClaimsSet = plainJWT.getJWTClaimsSet();
                    clearJwt = jwtClaimsSet.toString();
                }
                catch (Exception e) {
                    log.error("jwt\u89e3\u6790\u5f02\u5e38", (Throwable)e);
                    throw new ZTBusinessException("jwt\u89e3\u6790\u5f02\u5e38:" + e.getMessage());
                }
            }
        }
        return clearJwt;
    }

    public JSONObject authUser(ComAuthLoginReqBO apiPushDTO, HttpServletRequest request) {
        JSONObject jsonObject = new JSONObject();
        log.error("\u8ba4\u8bc1\u4e2d\u5fc3\u63a8\u9001\u7528\u6237:" + apiPushDTO);
        try {
            Map paramMap = (Map)JSONObject.parseObject((String)JSON.toJSONString((Object)apiPushDTO), Map.class);
            String url = request.getRequestURL().toString();
            String method = request.getMethod();
            String newSign = SignUtil.getSign(apiPushDTO.getAppId(), Long.parseLong(apiPushDTO.getTimestamp()), this.key, url, method, paramMap);
            jsonObject.put("newSign", (Object)newSign);
            String result = SecurityUtil.decryptAES(apiPushDTO.getSyncData(), this.key);
            jsonObject.put("result", (Object)result);
            jsonObject.put("code", (Object)1000);
            jsonObject.put("msg", (Object)"\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u89e3\u5bc6\u8ba4\u8bc1\u4e2d\u5fc3\u63a8\u9001\u7528\u6237\u62a5\u9519" + e);
            jsonObject.put("code", (Object)1);
            jsonObject.put("msg", (Object)("\u89e3\u5bc6\u5931\u8d25:" + e.getMessage()));
        }
        return jsonObject;
    }
}

