/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.user.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.base.utils.HttpUtil;
import com.tydic.dyc.common.user.api.DycUmcMemQrySupplierWaitDoneService;
import com.tydic.dyc.common.user.bo.DycUmcMemQrySupplierWaitDoneBO;
import com.tydic.dyc.common.user.bo.DycUmcMemQrySupplierWaitDoneReqBO;
import com.tydic.dyc.common.user.bo.DycUmcMemQrySupplierWaitDoneRspBO;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DycUmcMemQrySupplierWaitDoneServiceImpl
implements DycUmcMemQrySupplierWaitDoneService {
    private static final Logger log = LoggerFactory.getLogger(DycUmcMemQrySupplierWaitDoneServiceImpl.class);
    @Value(value="${supplier.wait.done.notice.url}")
    private String supplierWaitDoneNoticeUrl;
    @Value(value="${supplier.wait.done.quote.url}")
    private String supplierWaitDoneQuoteUrl;
    @Value(value="${supplier.wait.done.clarified.url}")
    private String supplierWaitDoneClarifiedUrl;
    private String successCode = "true";

    public DycUmcMemQrySupplierWaitDoneRspBO qrySupplierWaitDone(DycUmcMemQrySupplierWaitDoneReqBO reqBO) {
        DycUmcMemQrySupplierWaitDoneRspBO rspBO = new DycUmcMemQrySupplierWaitDoneRspBO();
        if (StringUtils.isEmpty((CharSequence)reqBO.getWaitDoneCode())) {
            throw new ZTBusinessException("\u8bf7\u4f20\u5165\u8981\u67e5\u8be2\u7684\u5f85\u529e\u7c7b\u578b");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getAccountName())) {
            throw new ZTBusinessException("\u8bf7\u4f20\u5165\u8981\u67e5\u8be2\u7684\u7528\u6237\u8d26\u53f7");
        }
        StringBuffer url = new StringBuffer();
        url = reqBO.getWaitDoneCode().equals("notice") ? new StringBuffer(this.supplierWaitDoneNoticeUrl) : (reqBO.getWaitDoneCode().equals("quote") ? new StringBuffer(this.supplierWaitDoneQuoteUrl) : new StringBuffer(this.supplierWaitDoneClarifiedUrl));
        if (reqBO.getPageNo() == null) {
            reqBO.setPageNo(Integer.valueOf(1));
        }
        if (reqBO.getPageSize() == null) {
            reqBO.setPageSize(Integer.valueOf(999));
        }
        url.append("?");
        url.append("accountName=" + reqBO.getAccountName());
        url.append("&companyName=" + reqBO.getAccountName());
        url.append("&pageNo=" + reqBO.getPageNo());
        url.append("&pageSize=" + reqBO.getPageSize());
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getBusinessName())) {
            url.append("&businessName=" + reqBO.getBusinessName());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getBusinessCode())) {
            url.append("&businessCode=" + reqBO.getBusinessCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getBusinessNo())) {
            url.append("&businessNo=" + reqBO.getBusinessNo());
        }
        try {
            String returnString = HttpUtil.doGet((String)url.toString());
            JSONObject jsonObject = JSONObject.parseObject((String)returnString);
            if (this.successCode.equals(jsonObject.getString("success"))) {
                String jsonArrayString = jsonObject.getString("data");
                if (StringUtils.isNotEmpty((CharSequence)jsonArrayString)) {
                    final SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                    List data = JSONObject.parseArray((String)jsonArrayString, DycUmcMemQrySupplierWaitDoneBO.class);
                    data.sort(new Comparator<DycUmcMemQrySupplierWaitDoneBO>(){

                        @Override
                        public int compare(DycUmcMemQrySupplierWaitDoneBO o1, DycUmcMemQrySupplierWaitDoneBO o2) {
                            Date o1Date = null;
                            Date o2Date = null;
                            try {
                                o1Date = sdf.parse(o1.getStopTime());
                                o2Date = sdf.parse(o2.getStopTime());
                                if (o1Date.after(o2Date)) {
                                    return 1;
                                }
                                return -1;
                            }
                            catch (Exception e) {
                                o1Date = new Date(o1.getStopTime());
                                o2Date = new Date(o2.getStopTime());
                                if (o1Date.after(o2Date)) {
                                    return 1;
                                }
                                return -1;
                            }
                        }
                    });
                    rspBO.setData(data);
                    rspBO.setRecordsTotal(Integer.valueOf(data.size()));
                }
            } else {
                log.error("\u79fb\u52a8\u7aef\u4f9b\u5e94\u5546\u67e5\u8be2\u4ee3\u529e\u67e5\u8be2\u5916\u90e8\u63a5\u53e3\u5931\u8d25" + jsonObject.getString("message"));
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5916\u90e8\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38" + e.getMessage());
        }
        return rspBO;
    }
}

