/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.user.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.base.utils.HttpUtil;
import com.tydic.dyc.common.user.api.UmcMemEstoreWaitDoneBriefQryService;
import com.tydic.dyc.common.user.bo.UmcMemEstoreWaitDoneBriefListReqBO;
import com.tydic.dyc.common.user.bo.UmcMemEstoreWaitDoneBriefListRspBO;
import com.tydic.dyc.common.user.bo.UmcMemEstoreWaitDoneBriefReqBO;
import com.tydic.dyc.common.user.bo.UmcMemEstoreWaitDoneBriefRspBO;
import com.tydic.dyc.common.user.bo.UmcMemEstoreWaitDoneBriefTaskBO;
import com.tydic.dyc.common.user.bo.UmcMemEstoreWaitDoneBriefTaskListBO;
import com.tydic.dyc.common.user.bo.ValueSource;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class UmcMemEstoreWaitDoneBriefQryServiceImpl
implements UmcMemEstoreWaitDoneBriefQryService {
    private static final Logger log = LoggerFactory.getLogger(UmcMemEstoreWaitDoneBriefQryServiceImpl.class);
    @Value(value="${operation.brief.url}")
    private String operationBriefUrl;

    public UmcMemEstoreWaitDoneBriefRspBO qry(UmcMemEstoreWaitDoneBriefReqBO reqBO) {
        UmcMemEstoreWaitDoneBriefRspBO rspBO = new UmcMemEstoreWaitDoneBriefRspBO();
        if (StringUtils.isEmpty((CharSequence)reqBO.getFlowCode())) {
            throw new ZTBusinessException("\u8bf7\u4f20\u5165flowCode");
        }
        if (reqBO.getPageNo() == null) {
            reqBO.setPageNo(Integer.valueOf(1));
        }
        if (reqBO.getPageSize() == null) {
            reqBO.setPageSize(Integer.valueOf(9999));
        }
        StringBuffer url = new StringBuffer(this.operationBriefUrl);
        url.append("?");
        url.append("userId=" + reqBO.getUsername());
        url.append("&flowCode=" + reqBO.getFlowCode());
        url.append("&pageNo=" + reqBO.getPageNo());
        url.append("&pageSize=" + reqBO.getPageSize());
        url.append("&platform=DKPORTAL");
        String returnString = HttpUtil.doGet((String)url.toString());
        rspBO = this.resolveRsp(returnString);
        return rspBO;
    }

    public UmcMemEstoreWaitDoneBriefListRspBO qryList(UmcMemEstoreWaitDoneBriefListReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getFlowCodes())) {
            throw new ZTBusinessException("\u8bf7\u4f20\u5165flowCode");
        }
        UmcMemEstoreWaitDoneBriefListRspBO rspBO = new UmcMemEstoreWaitDoneBriefListRspBO();
        String successCode = "true";
        ArrayList<UmcMemEstoreWaitDoneBriefTaskListBO> briefs = new ArrayList<UmcMemEstoreWaitDoneBriefTaskListBO>();
        for (String flowCode : reqBO.getFlowCodes()) {
            StringBuffer url = new StringBuffer(this.operationBriefUrl);
            url.append("?");
            url.append("userId=" + reqBO.getUsername());
            url.append("&flowCode=" + flowCode);
            url.append("&pageNo=1");
            url.append("&pageSize=9999");
            url.append("&platform=DKPORTAL");
            String returnString = HttpUtil.doGet((String)url.toString());
            JSONObject jsonObject = JSONObject.parseObject((String)returnString);
            UmcMemEstoreWaitDoneBriefTaskListBO taskListBO = new UmcMemEstoreWaitDoneBriefTaskListBO();
            taskListBO.setFlowCode(flowCode);
            if (successCode.equals(jsonObject.getString("success"))) {
                String dataString = jsonObject.getString("data");
                JSONObject dataObject = JSONObject.parseObject((String)dataString);
                String totalRecord = dataObject.getString("totalRecord");
                taskListBO.setTotalRecord(Integer.valueOf(Integer.parseInt(totalRecord)));
                int total = Integer.parseInt(totalRecord);
                if (total > 0) {
                    JSONArray dataListObject = dataObject.getJSONArray("data");
                    ArrayList<UmcMemEstoreWaitDoneBriefTaskBO> briefTaskBOS = new ArrayList<UmcMemEstoreWaitDoneBriefTaskBO>();
                    if (dataListObject != null && dataListObject.size() > 0) {
                        for (int i = 0; i < dataListObject.size(); ++i) {
                            JSONObject jsonObject1 = dataListObject.getJSONObject(i);
                            String jsonStr = this.toParseObject(jsonObject1, UmcMemEstoreWaitDoneBriefTaskBO.class);
                            UmcMemEstoreWaitDoneBriefTaskBO briefTaskBO = (UmcMemEstoreWaitDoneBriefTaskBO)JSONObject.parseObject((String)jsonStr, UmcMemEstoreWaitDoneBriefTaskBO.class);
                            briefTaskBOS.add(briefTaskBO);
                        }
                    }
                    taskListBO.setBriefs(briefTaskBOS);
                }
            } else {
                taskListBO.setCode("false");
                log.error(flowCode + "\u5f85\u529e\u67e5\u8be2\u5916\u90e8\u63a5\u53e3\u5931\u8d25");
            }
            briefs.add(taskListBO);
        }
        rspBO.setBriefs(briefs);
        return rspBO;
    }

    private UmcMemEstoreWaitDoneBriefRspBO resolveRsp(String returnString) {
        UmcMemEstoreWaitDoneBriefRspBO rspBO = new UmcMemEstoreWaitDoneBriefRspBO();
        String successCode = "true";
        JSONObject jsonObject = JSONObject.parseObject((String)returnString);
        if (successCode.equals(jsonObject.getString("success"))) {
            String dataString = jsonObject.getString("data");
            JSONObject dataObject = JSONObject.parseObject((String)dataString);
            String totalRecord = dataObject.getString("totalRecord");
            int total = Integer.parseInt(totalRecord);
            try {
                rspBO.setPageNo(Integer.valueOf(dataObject.getString("page")));
                rspBO.setPageSize(Integer.valueOf(dataObject.getString("pageSize")));
                rspBO.setTotalPage(Integer.valueOf(dataObject.getString("totalPage")));
            }
            catch (Exception e) {
                log.error("\u5c01\u88c5\u9875\u6570\u76f8\u5173\u4fe1\u606f\u62a5\u9519");
            }
            if (total > 0) {
                JSONArray dataListObject = dataObject.getJSONArray("data");
                ArrayList<UmcMemEstoreWaitDoneBriefTaskBO> briefs = new ArrayList<UmcMemEstoreWaitDoneBriefTaskBO>();
                if (dataListObject != null && dataListObject.size() > 0) {
                    for (int i = 0; i < dataListObject.size(); ++i) {
                        JSONObject jsonObject1 = dataListObject.getJSONObject(i);
                        String jsonStr = this.toParseObject(jsonObject1, UmcMemEstoreWaitDoneBriefTaskBO.class);
                        UmcMemEstoreWaitDoneBriefTaskBO briefTaskBO = (UmcMemEstoreWaitDoneBriefTaskBO)JSONObject.parseObject((String)jsonStr, UmcMemEstoreWaitDoneBriefTaskBO.class);
                        briefs.add(briefTaskBO);
                    }
                }
                if (!CollectionUtils.isEmpty(briefs)) {
                    briefs.sort(new Comparator<UmcMemEstoreWaitDoneBriefTaskBO>(){

                        @Override
                        public int compare(UmcMemEstoreWaitDoneBriefTaskBO o1, UmcMemEstoreWaitDoneBriefTaskBO o2) {
                            if (o1.getFlowCreateTime().after(o2.getFlowCreateTime())) {
                                return 1;
                            }
                            return -1;
                        }
                    });
                }
                rspBO.setBriefs(briefs);
            }
            rspBO.setTotalRecord(Integer.valueOf(total));
        } else {
            log.error("\u67e5\u8be2\u5f85\u529e\u7b80\u7565\u4fe1\u606f\u5931\u8d25" + jsonObject.getString("message"));
        }
        return rspBO;
    }

    public String toParseObject(JSONObject jsonObject, Class<?> clazz) {
        Field[] fieldList;
        JSONObject resultJson = new JSONObject();
        for (Field field : fieldList = clazz.getDeclaredFields()) {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            String valueSource = "";
            Object fieldValue = "";
            if (!ObjectUtils.isEmpty((Object)field.getAnnotation(ValueSource.class))) {
                valueSource = field.getAnnotation(ValueSource.class).source();
            }
            try {
                if (!StringUtils.isEmpty((CharSequence)valueSource)) {
                    JSONObject object = new JSONObject((Map)jsonObject);
                    if (valueSource.contains(".")) {
                        String[] list;
                        for (String key : list = valueSource.split("\\.")) {
                            object = object.getJSONObject(key);
                        }
                    } else {
                        object = object.getJSONObject(valueSource);
                    }
                    fieldValue = this.resolveFieldValue(field, object);
                } else {
                    fieldValue = this.resolveFieldValue(field, jsonObject);
                }
            }
            catch (Exception e) {
                log.error("\u5b57\u6bb5[" + field.getName() + "]\u83b7\u53d6\u503c\u5931\u8d25\uff01");
            }
            resultJson.put(field.getName(), fieldValue);
        }
        return JSONObject.toJSONString((Object)resultJson);
    }

    public Object resolveFieldValue(Field field, JSONObject jsonObject) {
        String fieldType = field.getType().getName();
        String fieldName = field.getName();
        if (!ObjectUtils.isEmpty((Object)field.getAnnotation(ValueSource.class)) && !StringUtils.isEmpty((CharSequence)field.getAnnotation(ValueSource.class).name())) {
            fieldName = field.getAnnotation(ValueSource.class).name();
        }
        if ("java.lang.String".equals(fieldType)) {
            return jsonObject.getString(fieldName);
        }
        if ("java.util.Date".equals(fieldType)) {
            if (StringUtils.isNotEmpty((CharSequence)jsonObject.getString(fieldName))) {
                return jsonObject.getDate(fieldName);
            }
            return null;
        }
        if ("java.lang.Integer".equals(fieldType)) {
            if (StringUtils.isNotEmpty((CharSequence)jsonObject.getString(fieldName))) {
                return jsonObject.getInteger(fieldName);
            }
            return null;
        }
        if ("java.math.BigDecimal".equals(fieldType)) {
            if (StringUtils.isNotEmpty((CharSequence)jsonObject.getString(fieldName))) {
                return jsonObject.getBigDecimal(fieldName);
            }
            return null;
        }
        if ("java.util.Date".equals(fieldType)) {
            if (StringUtils.isNotEmpty((CharSequence)jsonObject.getString(fieldName))) {
                return jsonObject.getDate(fieldName);
            }
            return null;
        }
        return jsonObject.getString(fieldName);
    }
}

