/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.communal.controller;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.base.annotation.JsonBusiResponseBody;
import com.tydic.dyc.base.utils.HttpsUtil;
import com.tydic.dyc.common.communal.api.CnncCommonThirdBindAddService;
import com.tydic.dyc.common.communal.api.CnncCommonThirdBindDeleteService;
import com.tydic.dyc.common.communal.api.CnncCommonThirdBindQryListPageService;
import com.tydic.dyc.common.communal.bo.CnncCommonQueryWxOpenIdQrCodeReqBO;
import com.tydic.dyc.common.communal.bo.CnncCommonQueryWxOpenIdQrCodeRspBO;
import com.tydic.dyc.common.communal.bo.CnncCommonQueryWxQrCodeRspBO;
import com.tydic.dyc.common.communal.bo.CnncCommonThirdBindAddReqBO;
import com.tydic.dyc.common.communal.bo.CnncCommonThirdBindAddRspBO;
import com.tydic.dyc.common.communal.bo.CnncCommonThirdBindDeleteReqBO;
import com.tydic.dyc.common.communal.bo.CnncCommonThirdBindDeleteRspBO;
import com.tydic.dyc.common.communal.bo.CnncCommonThirdBindQryListPageReqBO;
import com.tydic.dyc.common.communal.bo.CnncCommonThirdBindQryListPageRspBO;
import com.tydic.umc.constants.UmcEnumConstant;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/dyc/common/"})
public class CnncCommonThirdBindController {
    private static String wxOpenIdBackUrl = "/dyc/common/noauth/thirdBindWxOpenId";
    @Autowired
    private CnncCommonThirdBindQryListPageService cnncCommonThirdBindQryListPageService;
    @Autowired
    private CnncCommonThirdBindAddService cnncCommonThirdBindAddService;
    @Autowired
    private CnncCommonThirdBindDeleteService cnncCommonThirdBindDeleteService;
    @Value(value="${WX_GZH_QR_CODE_URL:https://ego.chinacoal.com/static/img/u822.0d647759.png}")
    private String WX_GZH_QR_CODE_URL;
    @Value(value="${WX_GZH_ID:wxb70d3f4c615ec202}")
    private String WX_GZH_ID;
    @Value(value="${WX_GZH_SECRET:d9ef2291572a11240cf0d5397aeb7623}")
    private String WX_GZH_SECRET;
    @Value(value="${WX_GZH_REDIRECT_DOMAIN:https://ego.chinacoal.com}")
    private String WX_GZH_REDIRECT_DOMAIN;

    @PostMapping(value={"/noauth/getThirdBindWxQrCode"})
    @JsonBusiResponseBody
    public CnncCommonQueryWxQrCodeRspBO getThirdBindWxQrCode() {
        CnncCommonQueryWxQrCodeRspBO rspBO = new CnncCommonQueryWxQrCodeRspBO();
        if ("-1".equals(this.WX_GZH_QR_CODE_URL)) {
            rspBO.setCode("8888");
            rspBO.setMessage("\u83b7\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u4e8c\u7ef4\u7801\u9519\u8bef");
        } else {
            rspBO.setQrCodeUrl(this.WX_GZH_QR_CODE_URL);
            rspBO.setCode("0000");
        }
        return rspBO;
    }

    @RequestMapping(value={"/getOpenId"})
    @JsonBusiResponseBody
    public CnncCommonQueryWxOpenIdQrCodeRspBO getOpenId(@RequestBody CnncCommonQueryWxOpenIdQrCodeReqBO reqBO) {
        String wxOpenIdAccessTokenUrl = "https://api.weixin.qq.com/sns/jscode2session?appid=" + this.WX_GZH_ID + "&secret=" + this.WX_GZH_SECRET + "&js_code=" + reqBO.getCode() + "&grant_type=authorization_code";
        HashMap param = new HashMap();
        CnncCommonQueryWxOpenIdQrCodeRspBO rspBO = new CnncCommonQueryWxOpenIdQrCodeRspBO();
        try {
            String result = HttpsUtil.doPost((String)wxOpenIdAccessTokenUrl, param, (String)"utf-8", (int)10000, (int)30000);
            rspBO.setResult(result);
        }
        catch (Exception e) {
            throw new ZTBusinessException(e.getMessage());
        }
        return rspBO;
    }

    @PostMapping(value={"/getThirdBindWxOpenIdQrCode"})
    @JsonBusiResponseBody
    public CnncCommonQueryWxOpenIdQrCodeRspBO getThirdBindWxOpenIdQrCode(CnncCommonQueryWxOpenIdQrCodeReqBO reqBO) {
        CnncCommonQueryWxOpenIdQrCodeRspBO rspBO = new CnncCommonQueryWxOpenIdQrCodeRspBO();
        String wxOpenIdQrCodeUrl = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=WX_GZH_ID&redirect_uri=WX_REDIRECT_URI&response_type=code&scope=snsapi_base&state=WX_REDIRECT_PARAM#wechat_redirect";
        try {
            wxOpenIdQrCodeUrl = wxOpenIdQrCodeUrl.replaceAll("WX_GZH_ID", this.WX_GZH_ID);
            String url = this.WX_GZH_REDIRECT_DOMAIN + wxOpenIdBackUrl;
            wxOpenIdQrCodeUrl = wxOpenIdQrCodeUrl.replaceAll("WX_REDIRECT_URI", URLEncoder.encode(url, "GBK"));
            wxOpenIdQrCodeUrl = wxOpenIdQrCodeUrl.replaceAll("WX_REDIRECT_PARAM", reqBO.getMemIdIn().toString());
        }
        catch (UnsupportedEncodingException e) {
            rspBO.setCode("8888");
            return rspBO;
        }
        rspBO.setQrCodeUrl(wxOpenIdQrCodeUrl);
        rspBO.setCode("0000");
        return rspBO;
    }

    @GetMapping(value={"/noauth/thirdBindWxOpenId"})
    @JsonBusiResponseBody
    public ModelAndView thirdBindWxOpenId(@RequestParam(value="code") String code, @RequestParam(value="state") String state) {
        CnncCommonThirdBindAddReqBO reqBO = new CnncCommonThirdBindAddReqBO();
        String wxOpenIdAccessTokenUrl = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=WX_GZH_ID&secret=WX_GZH_SECRET&code=WX_ACCESS_CODE&grant_type=authorization_code";
        try {
            wxOpenIdAccessTokenUrl = wxOpenIdAccessTokenUrl.replaceAll("WX_GZH_ID", this.WX_GZH_ID);
            wxOpenIdAccessTokenUrl = wxOpenIdAccessTokenUrl.replaceAll("WX_GZH_SECRET", this.WX_GZH_SECRET);
            wxOpenIdAccessTokenUrl = wxOpenIdAccessTokenUrl.replaceAll("WX_ACCESS_CODE", code);
            HashMap param = new HashMap();
            JSONObject rspJson = JSONObject.parseObject((String)HttpsUtil.doPost((String)wxOpenIdAccessTokenUrl, param, (String)"utf-8", (int)10000, (int)30000));
            reqBO.setAuthId(rspJson.getString("openid"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getAuthId())) {
            return new ModelAndView("forward:/bindFail.html");
        }
        reqBO.setMemId(Long.valueOf(Long.parseLong(state)));
        reqBO.setAuthType(UmcEnumConstant.ThirdAuthType.WX_APP.getCode());
        CnncCommonThirdBindAddRspBO rspBO = this.cnncCommonThirdBindAddService.addThirdBind(reqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            return new ModelAndView("forward:/bindFail.html");
        }
        return new ModelAndView("forward:/bindSuccess.html");
    }

    @RequestMapping(value={"/addThirdBind"})
    @JsonBusiResponseBody
    public CnncCommonThirdBindAddRspBO thirdBindWxOpenId(@RequestBody CnncCommonThirdBindAddReqBO reqBO) {
        reqBO.setMemId(reqBO.getMemId());
        reqBO.setAuthType(UmcEnumConstant.ThirdAuthType.WX_XCX.getCode());
        return this.cnncCommonThirdBindAddService.addThirdBind(reqBO);
    }

    @PostMapping(value={"/queryThirdBindListPage"})
    @JsonBusiResponseBody
    public CnncCommonThirdBindQryListPageRspBO queryThirdBindListPage(CnncCommonThirdBindQryListPageReqBO reqBO) {
        return this.cnncCommonThirdBindQryListPageService.qryThirdBindListPage(reqBO);
    }

    @PostMapping(value={"/deleteThirdBind"})
    @JsonBusiResponseBody
    public CnncCommonThirdBindDeleteRspBO deleteThirdBind(CnncCommonThirdBindDeleteReqBO reqBO) {
        return this.cnncCommonThirdBindDeleteService.deleteThirdBind(reqBO);
    }
}

