/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.communal.controller;

import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.annotation.CustomResponseBody;
import com.tydic.dyc.base.annotation.JsonBusiResponseBody;
import com.tydic.dyc.common.user.api.ComAuthLoginService;
import com.tydic.dyc.common.user.bo.ComAuthLoginReqBO;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dyc/common"})
public class ComAuthLoginController {
    private static final Logger log = LoggerFactory.getLogger(ComAuthLoginController.class);
    @Autowired
    private ComAuthLoginService comAuthLoginService;
    @Value(value="${zb.zbIndex}")
    private String zbIndex;
    @Value(value="${zb.zbLogin}")
    private String zbLogin;

    @RequestMapping(value={"noauth/authLogin"})
    @JsonBusiResponseBody
    public void authLogin(@RequestParam(value="ticket") String ticket, HttpServletResponse response, HttpServletRequest request) {
        this.comAuthLoginService.authLogin(ticket, response, request);
    }

    @RequestMapping(value={"noauth/authUser"})
    @CustomResponseBody
    public JSONObject authUser(@RequestBody ComAuthLoginReqBO req, HttpServletRequest request) {
        return this.comAuthLoginService.authUser(req, request);
    }

    @RequestMapping(value={"/sendZb"})
    @CustomResponseBody
    public void sendZb(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String token = request.getHeader("auth-token");
        log.error("\u4e0e\u7528\u6237token:" + token);
        if (StringUtils.isBlank((CharSequence)token)) {
            response.sendRedirect(this.zbIndex);
        } else {
            response.setHeader("token", token);
            this.zbLogin = this.zbLogin + "?token=" + token;
            response.sendRedirect(this.zbLogin);
        }
    }
}

