/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.communal.controller;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.dyc.base.annotation.JsonBusiResponseBody;
import com.tydic.dyc.common.communal.bo.ComPesCommonOssUploadReqBO;
import com.tydic.dyc.common.communal.bo.ComPesCommonOssUploadRspBO;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dyc/common/communal/ossUpload"})
public class ComPesCommonOssUploadController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean isDebugEnable = this.logger.isDebugEnabled();
    public static final String RSP_CODE_SUCCESS = "0000";
    public static final String RSP_CODE_FAILURE = "8888";
    public static final String RSP_CODE_OSS_UOLOAD_FAILURE = "0010";
    public static final String OSS_SERVER_URL = "https://dev-zhongtai.oss-cn-beijing.aliyuncs.com/";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Autowired
    private FileClient fileClient;
    @Value(value="${file.name.Illegal:html,jsp}")
    private String fileNameIllegal;
    @Value(value="${file.name.Illegal.type:html,jsp}")
    private String fileIllegalType;

    @PostMapping(value={"/fileUpload"})
    @JsonBusiResponseBody
    public ComPesCommonOssUploadRspBO queryData(ComPesCommonOssUploadReqBO reqBO) {
        ComPesCommonOssUploadRspBO rspBO;
        if (this.isDebugEnable) {
            this.logger.debug("oss\u6587\u4ef6\u4e0a\u4f20\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (!(rspBO = this.validateParam(reqBO)).getRespCode().equals(RSP_CODE_SUCCESS)) {
            return rspBO;
        }
        try {
            byte[] b = reqBO.getInput().getBytes();
            ByteArrayInputStream input = new ByteArrayInputStream(b);
            String fileName = UUID.randomUUID() + "." + StringUtils.substringAfterLast((String)reqBO.getInput().getOriginalFilename(), (String)".");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String uploadPath = sdf.format(new Date());
            rspBO.setFilePath(fileName);
            String[] allFileNameIllegal = null;
            if (!StringUtils.isEmpty((CharSequence)this.fileNameIllegal) && StringUtils.isNotBlank((CharSequence)reqBO.getInput().getOriginalFilename()) && (allFileNameIllegal = this.fileNameIllegal.split(",")).length > 0) {
                for (String illegal : allFileNameIllegal) {
                    if (!reqBO.getInput().getOriginalFilename().toLowerCase().contains(illegal.toLowerCase())) continue;
                    throw new ZTBusinessException("\u4e0a\u4f20\u6587\u4ef6\u5305\u542b\u975e\u6cd5\u5b57\u7b26");
                }
            }
            String[] allfileIllegalType = null;
            String fileType = reqBO.getInput().getContentType();
            if (!StringUtils.isEmpty((CharSequence)this.fileIllegalType) && StringUtils.isNotBlank((CharSequence)fileType) && (allfileIllegalType = this.fileIllegalType.split(",")).length > 0) {
                for (String illegal : allfileIllegalType) {
                    if (!fileType.toLowerCase().equals(illegal.toLowerCase())) continue;
                    throw new ZTBusinessException("\u4e0a\u4f20\u6587\u4ef6\u7c7b\u578b\u4e0d\u5408\u6cd5");
                }
            }
            String result = this.fileClient.uploadFileByInputStream(uploadPath, fileName, (InputStream)input);
            rspBO.setFilePath(OSS_SERVER_URL + result);
            rspBO.setFileClientType(fileType);
            rspBO.setRespCode(RSP_CODE_SUCCESS);
            rspBO.setRespDesc("oss\u6587\u4ef6\u4e0a\u4f20\u670d\u52a1\u5668\u6210\u529f");
        }
        catch (Exception e) {
            this.logger.error("oss\u6587\u4ef6\u4e0a\u4f20\u670d\u52a1\u5668\u5931\u8d25", (Throwable)e);
            rspBO.setRespCode(RSP_CODE_OSS_UOLOAD_FAILURE);
            rspBO.setRespDesc("oss\u6587\u4ef6\u4e0a\u4f20\u670d\u52a1\u5668\u5931\u8d25" + e.getMessage());
        }
        return rspBO;
    }

    private ComPesCommonOssUploadRspBO validateParam(ComPesCommonOssUploadReqBO reqBO) {
        ComPesCommonOssUploadRspBO rspBO = new ComPesCommonOssUploadRspBO();
        rspBO.setRespCode(RSP_CODE_SUCCESS);
        rspBO.setRespDesc("oss\u6587\u4ef6\u4e0a\u4f20\u670d\u52a1\u5fc5\u4f20\u53c2\u6570-");
        if (null == reqBO.getInput()) {
            rspBO.setRespCode(RSP_CODE_FAILURE);
            rspBO.setRespDesc(rspBO.getRespDesc() + "-\u6587\u4ef6\u3010input\u3011");
        }
        return rspBO;
    }
}

