/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.communal.controller;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsConfig;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.ohaotian.plugin.file.fastdfs.FastdfsUtil;
import com.ohaotian.plugin.file.util.FileUtils;
import com.tydic.dyc.base.annotation.JsonBusiResponseBody;
import com.tydic.dyc.common.communal.bo.ComUocFileAppBO;
import com.tydic.dyc.common.communal.bo.ComUocFileUploadAppReqBO;
import com.tydic.dyc.common.communal.bo.ComUocFileUploadAppRspBO;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/dyc/common/communal"})
public class ComUocFileUpLoadController {
    private static final Logger log = LoggerFactory.getLogger(ComUocFileUpLoadController.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(ComUocFileUpLoadController.class);
    @Autowired
    private FileClient fileClient;
    private static final String PATH = "dyc-common/";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${oss.accessUrl}")
    private String accessUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    @Value(value="${file.name.Illegal:html,jsp}")
    private String fileNameIllegal;
    @Value(value="${file.name.Illegal.type:html,jsp}")
    private String fileIllegalType;
    @Value(value="${plugin.file.blackType:exe;bat;js;html;dll;jsp;}")
    private String fileUploadBlackType;
    @Autowired
    private FastdfsConfig fastdfsConfig;

    @PostMapping(value={"/noauth/fileGeneration/upload"})
    @JsonBusiResponseBody
    public ComUocFileUploadAppRspBO uploadByNoauth(MultipartFile[] files) {
        return this.upload(files);
    }

    @PostMapping(value={"/fileGeneration/upload"})
    @JsonBusiResponseBody
    public ComUocFileUploadAppRspBO upload(MultipartFile[] files) {
        if (files == null || files.length == 0) {
            log.info("\u4e0a\u4f20\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\uff01");
            return null;
        }
        ArrayList<ComUocFileAppBO> list = new ArrayList<ComUocFileAppBO>();
        for (MultipartFile file : files) {
            InputStream inputStream = null;
            try {
                inputStream = file.getInputStream();
                String fileName = file.getOriginalFilename();
                String suffix = fileName.substring(fileName.lastIndexOf("."));
                byte[] bytes = new byte[inputStream.available()];
                inputStream.read(bytes);
                ComUocFileAppBO comUocFileAppBO = new ComUocFileAppBO();
                comUocFileAppBO.setFile(bytes);
                comUocFileAppBO.setFileName(fileName);
                comUocFileAppBO.setFileType(suffix);
                String[] allFileNameIllegal = null;
                if (!StringUtils.isEmpty((CharSequence)this.fileNameIllegal) && StringUtils.isNotBlank((CharSequence)fileName) && (allFileNameIllegal = this.fileNameIllegal.split(",")).length > 0) {
                    for (String illegal : allFileNameIllegal) {
                        if (!fileName.toLowerCase().contains(illegal.toLowerCase())) continue;
                        throw new ZTBusinessException("\u4e0a\u4f20\u6587\u4ef6\u5305\u542b\u975e\u6cd5\u5b57\u7b26");
                    }
                }
                String[] allfileIllegalType = null;
                String fileType = file.getContentType();
                if (!StringUtils.isEmpty((CharSequence)this.fileIllegalType) && StringUtils.isNotBlank((CharSequence)fileType) && (allfileIllegalType = this.fileIllegalType.split(",")).length > 0) {
                    for (String illegal : allfileIllegalType) {
                        if (!fileType.toLowerCase().equals(illegal.toLowerCase())) continue;
                        throw new ZTBusinessException("\u4e0a\u4f20\u6587\u4ef6\u7c7b\u578b\u4e0d\u5408\u6cd5");
                    }
                }
                list.add(comUocFileAppBO);
            }
            catch (Exception e) {
                throw new ZTBusinessException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25:" + e.getMessage());
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.debug("\u6587\u4ef6\u4e0a\u4f20\u5173\u95ed\u6d41\u5931\u8d25");
                }
            }
        }
        ComUocFileUploadAppReqBO reqBO = new ComUocFileUploadAppReqBO();
        reqBO.setFiles(list);
        return this.upload(reqBO);
    }

    private ComUocFileUploadAppRspBO upload(ComUocFileUploadAppReqBO reqBO) {
        ArrayList fileList = new ArrayList();
        for (ComUocFileAppBO file : reqBO.getFiles()) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(file.getFile());
            String fileDir = UUID.randomUUID().toString().replaceAll("-", "");
            String fileName = file.getFileName();
            String path = "";
            if ("FASTDFS".equals(this.fileType)) {
                try {
                    byte[] bytes = FileUtils.input2byte((InputStream)inputStream);
                    String fileExtName = FileUtils.ext((String)fileName);
                    String result = FileUtils.getType((byte[])bytes);
                    if (!(!this.fileUploadBlackType.contains(result) || "mp4".equals(fileExtName) || "json".equals(fileExtName) || "txt".equals(fileExtName) || "p12".equals(fileExtName) || "pfx".equals(fileExtName) || "cer".equals(fileExtName))) {
                        log.info("\u67e5\u8be2\u62a5\u9519\u539f\u56e0bytes\uff1a" + result);
                        log.info("\u67e5\u8be2\u62a5\u9519\u539f\u56e0fileExtName\uff1a" + fileExtName);
                        log.info("\u67e5\u8be2\u62a5\u9519\u539f\u56e0\uff1a" + this.fileUploadBlackType);
                        throw new ZTBusinessException("\u7981\u6b62\u4e0a\u4f20\u8be5\u6587\u4ef6\uff0c\u8bf7\u66f4\u6362\u540e\u91cd\u65b0\u4e0a\u4f20");
                    }
                    FastdfsFileInfo fileInfo = FastdfsUtil.uploadFile((String)fileName, (FastdfsConfig)this.fastdfsConfig, (InputStream)new ByteArrayInputStream(bytes), (String)(PATH + fileDir));
                    path = FastdfsFileInfo.toFilePath((FastdfsFileInfo)fileInfo);
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    path = this.fileClient.uploadFileByInputStream(PATH + fileDir, fileName, (InputStream)inputStream);
                }
            } else {
                path = this.fileClient.uploadFileByInputStream(PATH + fileDir, fileName, (InputStream)inputStream);
            }
            String fileUrl = null;
            String innerFileUrl = null;
            if ("OSS".equals(this.fileType)) {
                innerFileUrl = this.accessUrl + path;
                fileUrl = this.ossFileUrl + path;
            } else if ("FASTDFS".equals(this.fileType)) {
                FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
                innerFileUrl = "http://" + this.fastdfsTrackerServers.substring(0, this.fastdfsTrackerServers.indexOf(":") + 1) + this.fastdfsHttpTrackerHttpPort + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
                fileUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            } else {
                throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", file.getFileName());
            map.put("url", fileUrl);
            map.put("innerUrl", innerFileUrl);
            fileList.add(map);
        }
        ComUocFileUploadAppRspBO rspBO = new ComUocFileUploadAppRspBO();
        rspBO.setFileList(fileList);
        return rspBO;
    }
}

