/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.contract.controller;

import com.tydic.dyc.base.annotation.JsonBusiResponseBody;
import com.tydic.dyc.contract.api.DycContractItemChangeQueryService;
import com.tydic.dyc.contract.bo.DycContractItemChangeQueryReqBO;
import com.tydic.dyc.contract.bo.DycContractItemChangeQueryRspBO;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dyc/contract"})
public class DycContractItemChangeQueryController {
    @Autowired
    private DycContractItemChangeQueryService dycContractItemChangeQueryService;
    @Autowired
    private HttpServletRequest request;

    @PostMapping(value={"/contractItemChangeQuery"})
    @JsonBusiResponseBody
    public DycContractItemChangeQueryRspBO contractItemChangeQuery(@RequestBody DycContractItemChangeQueryReqBO reqBO) {
        reqBO.setAuthToken(this.request.getHeader("auth-token"));
        return this.dycContractItemChangeQueryService.contractItemChangeQuery(reqBO);
    }

    @PostMapping(value={"/noauth/contractItemChangeQuery"})
    @JsonBusiResponseBody
    public DycContractItemChangeQueryRspBO contractItemChangeExport(@RequestBody DycContractItemChangeQueryReqBO reqBO) {
        DycContractItemChangeQueryRspBO rspBO = this.dycContractItemChangeQueryService.contractItemChangeQuery(reqBO);
        if (!CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            rspBO.getRows().forEach(e -> {
                if (e.getTaxAmount() == null) {
                    e.setTaxAmount(BigDecimal.ZERO);
                }
                e.setTaxAmount(e.getTaxAmount().setScale(2, 4));
                if (e.getNotIncludingTaxAmount() == null) {
                    e.setNotIncludingTaxAmount(BigDecimal.ZERO);
                }
                e.setNotIncludingTaxAmount(e.getNotIncludingTaxAmount().setScale(2, 4));
                if (e.getTax() == null) {
                    e.setTax(BigDecimal.ZERO);
                }
                if (e.getRate() != null) {
                    e.setRateStr(e.getRate() + "%");
                } else {
                    e.setRateStr("0%");
                }
                if (e.getAddRate() != null) {
                    e.setAddRateStr(e.getAddRate() + "%");
                } else {
                    e.setAddRateStr("0%");
                }
                if (!StringUtils.isEmpty((Object)e.getNeedArriveTime())) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    String format = null;
                    try {
                        format = sdf.format(sdf.parse(e.getNeedArriveTime()));
                    }
                    catch (ParseException ex) {
                        ex.printStackTrace();
                    }
                    e.setNeedArriveTimeStr(format);
                    e.setNeedArriveTime(format);
                }
                e.setTax(e.getTax().setScale(2, 4));
            });
        }
        return rspBO;
    }
}

