/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.contract.controller;

import com.tydic.dyc.base.annotation.JsonBusiResponseBody;
import com.tydic.dyc.contract.api.DycContractPurchasePlanItemQueryAbilityService;
import com.tydic.dyc.contract.api.DycContractQryComparePriceAbilityService;
import com.tydic.dyc.contract.api.DycContractQueryContractItemService;
import com.tydic.dyc.contract.bo.DycContractPurchasePlanItemQueryAbilityReqBO;
import com.tydic.dyc.contract.bo.DycContractPurchasePlanItemQueryAbilityRspBO;
import com.tydic.dyc.contract.bo.DycContractQryComparePriceAbilityReqBO;
import com.tydic.dyc.contract.bo.DycContractQryComparePriceAbilityRspBO;
import com.tydic.dyc.contract.bo.DycContractQueryContractItemReqBO;
import com.tydic.dyc.contract.bo.DycContractQueryContractItemRspBO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dyc/contract"})
public class DycContractQueryContractItemController {
    private static final Logger log = LoggerFactory.getLogger(DycContractQueryContractItemController.class);
    @Autowired
    private DycContractQueryContractItemService dycContractQueryContractItemService;
    @Autowired
    private DycContractPurchasePlanItemQueryAbilityService dycContractPurchasePlanItemQueryAbilityService;
    @Autowired
    private DycContractQryComparePriceAbilityService dycContractQryComparePriceAbilityService;
    @Autowired
    private HttpServletRequest request;

    @PostMapping(value={"contractItemQuery"})
    @JsonBusiResponseBody
    public DycContractQueryContractItemRspBO contractItemQuery(@RequestBody DycContractQueryContractItemReqBO dycContractQueryContractItemReqBO) {
        dycContractQueryContractItemReqBO.setAuthToken(this.request.getHeader("auth-token"));
        return this.dycContractQueryContractItemService.contractItemQuery(dycContractQueryContractItemReqBO);
    }

    @PostMapping(value={"/noauth/contractItemQuery"})
    @JsonBusiResponseBody
    public DycContractQueryContractItemRspBO contractItemQueryNoauth(@RequestBody DycContractQueryContractItemReqBO dycContractQueryContractItemReqBO) {
        DycContractQueryContractItemRspBO rspBO = this.dycContractQueryContractItemService.contractItemQuery(dycContractQueryContractItemReqBO);
        if (!CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            rspBO.getRows().forEach(e -> {
                if (e.getTaxAmount() == null) {
                    e.setTaxAmount(BigDecimal.ZERO);
                }
                e.setTaxAmount(e.getTaxAmount().setScale(2, 4));
                if (e.getNotIncludingTaxAmount() == null) {
                    e.setNotIncludingTaxAmount(BigDecimal.ZERO);
                }
                e.setNotIncludingTaxAmount(e.getNotIncludingTaxAmount().setScale(2, 4));
                if (e.getTax() == null) {
                    e.setTax(BigDecimal.ZERO);
                }
                if (e.getRate() != null) {
                    e.setRateStr(e.getRate() + "%");
                } else {
                    e.setRateStr("0%");
                }
                if (e.getAddRate() != null) {
                    e.setAddRateStr(e.getAddRate() + "%");
                } else {
                    e.setAddRateStr("0%");
                }
                if (e.getNeedArriveTime() != null) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    String format = sdf.format(e.getNeedArriveTime());
                    e.setNeedArriveTimeStr(format);
                }
                e.setTax(e.getTax().setScale(2, 4));
            });
        }
        return rspBO;
    }

    @PostMapping(value={"/contractPurchasePlanItemQuery"})
    @JsonBusiResponseBody
    public DycContractPurchasePlanItemQueryAbilityRspBO contractPurchasePlanItemQuery(@RequestBody DycContractPurchasePlanItemQueryAbilityReqBO reqBO) {
        return this.dycContractPurchasePlanItemQueryAbilityService.qry(reqBO);
    }

    @PostMapping(value={"/qryComparePrice"})
    @JsonBusiResponseBody
    public DycContractQryComparePriceAbilityRspBO qryComparePrice(@RequestBody DycContractQryComparePriceAbilityReqBO reqBO) {
        return this.dycContractQryComparePriceAbilityService.qryComparePrice(reqBO);
    }
}

