/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.contract.controller;

import com.tydic.dyc.base.annotation.JsonBusiResponseBody;
import com.tydic.dyc.contract.api.DycContractEffectWayLogQueryAbilityService;
import com.tydic.dyc.contract.api.DycContractQueryLongTermContractListService;
import com.tydic.dyc.contract.bo.DycContractEffectWayLogQueryAbilityReqBO;
import com.tydic.dyc.contract.bo.DycContractEffectWayLogQueryAbilityRspBO;
import com.tydic.dyc.contract.bo.DycContractLongTermContractInfoBO;
import com.tydic.dyc.contract.bo.DycContractQueryLongTermContractListReqBO;
import com.tydic.dyc.contract.bo.DycContractQueryLongTermContractListRspBO;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dyc/contract"})
public class DycContractQueryLongTermContractListController {
    private static final Logger log = LoggerFactory.getLogger(DycContractQueryLongTermContractListController.class);
    @Autowired
    private DycContractQueryLongTermContractListService dycContractQueryLongTermContractListService;
    @Autowired
    private DycContractEffectWayLogQueryAbilityService dycContractEffectWayLogQueryAbilityService;

    @PostMapping(value={"/queryLongTermContractList"})
    @JsonBusiResponseBody
    public DycContractQueryLongTermContractListRspBO queryLongTermContractList(@RequestBody DycContractQueryLongTermContractListReqBO reqBO) {
        return this.dycContractQueryLongTermContractListService.queryLongTermContractList(reqBO);
    }

    @PostMapping(value={"/noauth/queryLongTermContractList"})
    @JsonBusiResponseBody
    public DycContractQueryLongTermContractListRspBO queryLongTermContractListNoauth(@RequestBody DycContractQueryLongTermContractListReqBO reqBO) {
        DycContractQueryLongTermContractListRspBO dycContractQueryLongTermContractListRspBO = this.dycContractQueryLongTermContractListService.queryLongTermContractList(reqBO);
        if (!CollectionUtils.isEmpty((Collection)dycContractQueryLongTermContractListRspBO.getRows())) {
            for (DycContractLongTermContractInfoBO row : dycContractQueryLongTermContractListRspBO.getRows()) {
                if (reqBO.getIsPurchaser() != null && reqBO.getIsPurchaser() == 1 && row.getContractType() == 10) {
                    row.setContractStatusStr(row.getPurchaseContractStatusStr());
                }
                if (reqBO.getIsDevCompany() != null && reqBO.getIsDevCompany() == 1 && row.getContractType() == 20) {
                    row.setContractStatusStr(row.getPurchaseContractStatusStr());
                }
                if (row.getTotalTaxAmount() != null) {
                    row.setTotalTaxAmount(row.getTotalTaxAmount().setScale(2, 4));
                }
                if (row.getTotalAmountExcludingTax() == null) continue;
                row.setTotalAmountExcludingTax(row.getTotalAmountExcludingTax().setScale(2, 4));
            }
        }
        return dycContractQueryLongTermContractListRspBO;
    }

    @PostMapping(value={"/qryContractEffectWayLog"})
    @JsonBusiResponseBody
    public DycContractEffectWayLogQueryAbilityRspBO qryContractEffectWayLog(@RequestBody DycContractEffectWayLogQueryAbilityReqBO reqBO) {
        return this.dycContractEffectWayLogQueryAbilityService.qryContractEffectWayLog(reqBO);
    }
}

