/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.mall.ability.bo;

import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Value;

public class MoneyUtils {
    @Value(value="${CALCULATION_TYPE}")
    private static String calculationType;

    public static BigDecimal yuanToFen(BigDecimal sourceFee) {
        return MoneyUtils.unitConvert(sourceFee, MoneyUnit.YUAN, MoneyUnit.FEN);
    }

    public static BigDecimal yuanToFen(Long sourceFee) {
        return MoneyUtils.yuanToFen(new BigDecimal(sourceFee));
    }

    public static BigDecimal yuanToFen(String sourceFee) {
        return MoneyUtils.yuanToFen(new BigDecimal(sourceFee));
    }

    public static long yuanToFenToLong(BigDecimal sourceFee) {
        return MoneyUtils.yuanToFen(sourceFee).longValue();
    }

    public static BigDecimal yuanToHao(BigDecimal sourceFee) {
        return MoneyUtils.unitConvert(sourceFee, MoneyUnit.YUAN, MoneyUnit.HAO);
    }

    public static BigDecimal yuanToHao(Long sourceFee) {
        return MoneyUtils.yuanToHao(new BigDecimal(sourceFee));
    }

    public static BigDecimal yuanToHao(String sourceFee) {
        return MoneyUtils.yuanToHao(new BigDecimal(sourceFee));
    }

    public static long yuanToHaoToLong(BigDecimal sourceFee) {
        return MoneyUtils.yuanToHao(sourceFee).longValue();
    }

    public static Long yuanToHaoToLongObj(BigDecimal sourceFee) {
        return Long.parseLong(MoneyUtils.yuanToHao(sourceFee).toString());
    }

    public static Long yuanToHaoToLongObj(Long sourceFee) {
        return MoneyUtils.yuanToHao(sourceFee).longValue();
    }

    public static BigDecimal fenToYuan(BigDecimal sourceFee) {
        return MoneyUtils.unitConvert(sourceFee, MoneyUnit.FEN, MoneyUnit.YUAN);
    }

    public static BigDecimal fenToYuan(Long sourceFee) {
        return MoneyUtils.fenToYuan(new BigDecimal(sourceFee));
    }

    public static BigDecimal fenToYuan(String sourceFee) {
        return MoneyUtils.fenToYuan(new BigDecimal(sourceFee));
    }

    public static String fenToYuanToString(BigDecimal sourceFee) {
        return MoneyUtils.fenToYuan(sourceFee).toString();
    }

    public static BigDecimal fenToHao(BigDecimal sourceFee) {
        return MoneyUtils.unitConvert(sourceFee, MoneyUnit.FEN, MoneyUnit.HAO);
    }

    public static BigDecimal fenToHao(Long sourceFee) {
        return MoneyUtils.fenToHao(new BigDecimal(sourceFee));
    }

    public static BigDecimal fenToHao(String sourceFee) {
        return MoneyUtils.fenToHao(new BigDecimal(sourceFee));
    }

    public static Long fenToHaoToLong(BigDecimal sourceFee) {
        return MoneyUtils.fenToHao(sourceFee).longValue();
    }

    public static BigDecimal haoToYuan(BigDecimal sourceFee) {
        return MoneyUtils.unitConvert(sourceFee, MoneyUnit.HAO, MoneyUnit.YUAN);
    }

    public static BigDecimal haoToYuan(Long sourceFee) {
        return MoneyUtils.haoToYuan(new BigDecimal(sourceFee));
    }

    public static BigDecimal haoToYuan(String sourceFee) {
        return MoneyUtils.haoToYuan(new BigDecimal(sourceFee));
    }

    public static String haoToYuanToString(BigDecimal sourceFee) {
        return MoneyUtils.haoToYuan(sourceFee).toString();
    }

    public static BigDecimal haoToFen(BigDecimal sourceFee) {
        return MoneyUtils.unitConvert(sourceFee, MoneyUnit.HAO, MoneyUnit.FEN);
    }

    public static BigDecimal haoToFen(Long sourceFee) {
        return MoneyUtils.haoToFen(new BigDecimal(sourceFee));
    }

    public static BigDecimal haoToFen(String sourceFee) {
        return MoneyUtils.haoToFen(new BigDecimal(sourceFee));
    }

    public static Long haoToFenToLong(BigDecimal sourceFee) {
        return MoneyUtils.haoToFen(sourceFee).longValue();
    }

    private static BigDecimal unitConvert(BigDecimal sourceFee, MoneyUnit sourceUnit, MoneyUnit targetUnit) {
        if (sourceFee == null) {
            throw new IllegalArgumentException("\u91d1\u989d\u8f6c\u6362\u5931\u8d25\uff0c\u5165\u53c2\u6e90\u91d1\u989d\u4e0d\u80fd\u4e3a null !");
        }
        return sourceFee.multiply(new BigDecimal(sourceUnit.getTimes())).divide(new BigDecimal(targetUnit.getTimes()), 2, 4);
    }

    public static BigDecimal calculate2Decimals(BigDecimal number) {
        try {
            if ("1".equals(calculationType)) {
                return number.setScale(2, 0);
            }
            if ("2".equals(calculationType)) {
                return number.setScale(2, 1);
            }
            if ("3".equals(calculationType)) {
                return number.setScale(2, 4);
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("\u6570\u636e\u8f6c\u6362\u5f02\u5e38");
        }
        return number;
    }

    public static BigDecimal l4B(Long fee) {
        if (fee == null) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(new BigDecimal(fee.toString()).divide(new BigDecimal("10000"), 4, 4).stripTrailingZeros().toPlainString());
    }

    public static BigDecimal l4B(BigDecimal fee) {
        if (fee == null) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(fee.divide(new BigDecimal("10000"), 4, 4).stripTrailingZeros().toPlainString());
    }

    public static BigDecimal l2B(Long fee) {
        if (fee == null) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(new BigDecimal(fee.toString()).divide(new BigDecimal("10000"), 2, 4).stripTrailingZeros().toPlainString());
    }

    private static enum MoneyUnit {
        YUAN("10000"),
        JIAO("1000"),
        FEN("100"),
        LI("10"),
        HAO("1");

        private String times;

        private MoneyUnit(String times) {
            this.times = times;
        }

        public String getTimes() {
            return this.times;
        }
    }
}

