package com.tydic.dyc.base.bo;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.ArrayList;
import java.util.List;

/**
 * 描述：翻页出参基类-领域+小N服务
 * 翻页接口写法举例：
 * BasePageRspBo<XServiceRspBo> xxxMethod(XServiceRspBo reqBo);
 * XxxRspBo extends BasePageRspBo<XxxRspDataBo>
 * @author tgy
 * @date 2022/2/13 16:29
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class BasePageRspBo<T> extends BaseRspBo {
    private static final long serialVersionUID = 2883203059565679798L;

    @DocField("翻页数据")
    private List<T> rows = new ArrayList<>();

    @DocField("总条数")
    private int recordsTotal;

    @DocField("总页数")
    private int total;

    @DocField("页码")
    private int pageNo;
}