package com.tydic.dyc.base.bo;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 标题:会员基类，简版字段
 * 说明:
 * 时间:2022/8/1 15:39
 * 作者:田桂银
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class UmcSimpleReqBo extends BaseReqBo {
    private static final long serialVersionUID = -5650790231926572234L;
    //重构会员中心基类 开始
    /**
     * 用户ID，custIdIn:userId,是一对多关系
     */
    private Long userIdIn;
    /**
     * 客户ID
     */
    private Long custIdIn;
    /**
     * 客户名称
     */
    private String custNameIn;
    /**
     * 主客户ID
     */
    private Long mainCustIdIn;
    /**
     * 客户类型 1外部个人 2外部企业 3内部个人用户 4内部企业用户
     */
    private String custTypeIn;
    /**
     * 公司ID
     */
    private Long companyIdIn;
    /**
     * 公司名称
     */
    private Long companyNameIn;
    /**
     * 拥有身份列表
     */
    private List<String> tagListIn;
    /**
     * 机构树路径
     */
    private String orgTreePathIn;
    /**
     * 机构ID
     */
    private Long orgIdIn;
    /**
     * 机构名称
     */
    private String orgNameIn;
    /**
     * 管理机构列表
     */
    private List<Long> mgOrgIdsIn;
    //重构会员中心基类 结束


    /**
     * 用户id，不需要前端传入，会员中心注入
     */
    private Long userId;
    /**
     * 用户名称，不需要前端传入，会员中心注入
     */
    private String name;
    /**
     * 用户登陆名称，不需要前端传入，会员中心注入
     */
    private String username;

    private String orgPath;
    /**
     * 会员机构id，不需要前端传入，会员中心注入
     */
    private Long orgId;

    /**
     * 所属公司id,不需要前端传入
     */
    private Long companyId;

    /**
     * 所属公司名称
     */
    private String companyName;
    /**
     * 采购账套编号
     */
    private Long purchaserAccountUser;

    /**
     * 组织机构类型
     */
    private String isprofess;

    /*** 供应商名称*/
    private String supName;

    /**
     * 会员ID
     */
    private Long memId;
    /**
     * 会员
     */
    private Long memIdIn;

    /**
     * 机构ID List
     * 只有机构管理员才有
     */
    private List<Long> mgOrgIdsExt;
    /**
     * 账号类型
     * 0 运营单位
     * 1 采购单位
     * 2 供应商
     */
    private String isProfessionalOrgExt;
    /**
     * 供应商ID
     */
    private Long supId;

    /**
     * 租户ID
     */
    private String tenantId;
}


