package com.tydic.dyc.base.events;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.UUID;

/**
 * 标题：类名称:Event
 * 说明：事件消息类，通过配置完成实例化
 * 时间：2022/3/1 10:37 AM
 * 作者 @author hegy2017
 */
@ToString
@Data
public class Event implements Serializable {
    private static final long serialVersionUID = 233883566919631677L;
    /**
     * 事件id
     */
    public final UUID id = UUID.randomUUID();

    /**
     * 事件创建时间
     */
    public final Date created = new Date();

    /**
     * 事件编码
     */
    public String code;


    /**
     * 事件的模块，比如UCC，UOC
     */
    public String model;

    /**
     * 事件参数
     */
    public Map<String, Object> paramMap;


    @Override
    public boolean equals(Object obj) {
        Event s = (Event) obj;
        return code.equals(s.code);
    }

    @Override
    public int hashCode() {
        String in = code;
        return in.hashCode();
    }
}
