package com.tydic.dyc.base.utils;

import com.alibaba.fastjson.JSON;

import java.util.List;

/**
 * 标题:JUtil
 * 说明:json util对象转换工具
 * 时间:2022/3/15 20:48
 * 作者:田桂银
 */
public class JUtil {


    /**
     * 描述: 转换应用层入参对象为中心层入参对象
     *
     * @param reqBo 应用层入参对象实例
     * @param clazz 中心层入参对象Class类型
     * @return T
     * @author tgy
     * @date 2021/3/31 15:21
     */
    public static <T> T js(Object reqBo, Class<T> clazz) {
        return JSON.parseObject(JSON.toJSONString(reqBo), clazz);
    }

    /**
     * 描述:list对象互转
     *
     * @return java.util.List<T>
     * @author tgy
     * @date 2022/2/22 16:26
     */
    public static <T> List<T> jsl(List<?> reqBo, Class<T> clazz) {
        return JSON.parseArray(JSON.toJSONString(reqBo), clazz);
    }

    /**
     * JSON字符串转对象
     *
     * @param jsonStr
     * @param clazz
     * @param <T>
     * @return
     */
    public static <T> T jss(String jsonStr, Class<T> clazz) {
        return JSON.parseObject(jsonStr, clazz);
    }
    /**
     * 描述:list对象互转
     *
     * @return java.util.List<T>
     * @author tgy
     * @date 2022/2/22 16:26
     */
    public static <T> List<T> jsl(Object reqBo, Class<T> clazz) {
        return JSON.parseArray(JSON.toJSONString(reqBo), clazz);
    }

}


