/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.plugin.encoded.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.cfc.ability.api.CfcBuyerAbbreviationConfigQryAbilityService;
import com.tydic.cfc.ability.api.CfcCommonConfigParamQryListDetailAbilityService;
import com.tydic.cfc.ability.api.CfcEncodedRuleCheckExtAbilityService;
import com.tydic.cfc.ability.api.CfcEncodedRuleQryDetailAbilityService;
import com.tydic.cfc.ability.api.CfcEncodedRuleSelectCodeAbilityService;
import com.tydic.cfc.ability.api.CfcUniteParamQryListPageAbilityService;
import com.tydic.cfc.ability.bo.CfcBuyerAbbreviationConfigBO;
import com.tydic.cfc.ability.bo.CfcBuyerAbbreviationConfigQryAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcBuyerAbbreviationConfigQryAbilityRspBO;
import com.tydic.cfc.ability.bo.CfcCommonConfigParamBO;
import com.tydic.cfc.ability.bo.CfcCommonConfigParamQryListDetailReqBO;
import com.tydic.cfc.ability.bo.CfcCommonConfigParamQryListDetailRspBO;
import com.tydic.cfc.ability.bo.CfcEncodedRuleBO;
import com.tydic.cfc.ability.bo.CfcEncodedRuleCheckExtAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcEncodedRuleCheckExtAbilityRspBO;
import com.tydic.cfc.ability.bo.CfcEncodedRuleSelectCodeAbilityReqBo;
import com.tydic.cfc.ability.bo.CfcEncodedRuleSelectCodeAbilityRspBo;
import com.tydic.cfc.ability.bo.CfcUniteParamQryListPageAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcUniteParamQryListPageAbilityRspBO;
import com.tydic.plugin.encoded.constant.CfcEncodedOrderTypeEnum;
import com.tydic.plugin.encoded.constant.CfcEncodedSupplierEnum;
import com.tydic.plugin.encoded.dao.CfcEncodedSerialGenerateMapper;
import com.tydic.plugin.encoded.dao.CfcEncodedSerialMapper;
import com.tydic.plugin.encoded.dao.po.CfcEncodedSerialGeneratePO;
import com.tydic.plugin.encoded.dao.po.CfcEncodedSerialPO;
import com.tydic.plugin.encoded.exception.CfcEncodedPluginBusinessException;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialServiceRspBO;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service(value="cfcEncodedSerialGetService")
public class CfcEncodedSerialGetServiceImpl
implements CfcEncodedSerialGetService {
    private static final Logger log = LoggerFactory.getLogger(CfcEncodedSerialGetServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(CfcEncodedSerialGetServiceImpl.class);
    @Autowired
    private CfcEncodedRuleSelectCodeAbilityService cfcEncodedRuleSelectCodeAbilityService;
    @Autowired
    private CfcEncodedRuleQryDetailAbilityService cfcEncodedRuleQryDetailAbilityService;
    @Autowired
    private CfcEncodedSerialMapper cfcEncodedSerialMapper;
    @Autowired
    private CfcEncodedSerialGenerateMapper cfcEncodedSerialGenerateMapper;
    @Autowired
    private CfcBuyerAbbreviationConfigQryAbilityService cfcBuyerAbbreviationConfigQryAbilityService;
    @Autowired
    private CfcUniteParamQryListPageAbilityService cfcUniteParamQryListPageAbilityService;
    @Autowired
    private CfcEncodedRuleCheckExtAbilityService cfcEncodedRuleCheckExtAbilityService;
    @Autowired
    private CfcCommonConfigParamQryListDetailAbilityService cfcCommonConfigParamQryListDetailAbilityService;
    @Resource
    private CacheClient cacheService;
    @Autowired
    private DataSourceTransactionManager dataSourceTransactionManager;
    private static final String BUYER_SHORT_NAME = "BUYER_SHORT_NAME";
    private static final String ORDER_TYPE = "ORDER_TYPE";
    private static final String SUPPLIER = "SUPPLIER";
    private static final String CHANGE_ENCODED = "change_encoded";

    @Override
    @Transactional
    public CfcEncodedSerialGetServiceRspBO getEncodedSerial(CfcEncodedSerialGetServiceReqBO reqBO) {
        CfcEncodedSerialServiceRspBO cfcEncodedSerialServiceRspBO;
        CfcEncodedSerialGetServiceRspBO rspBO = new CfcEncodedSerialGetServiceRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        try {
            cfcEncodedSerialServiceRspBO = this.transaction(reqBO);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            if ("\u6821\u9a8c\u63a5\u53e3\u7684\u8c03\u7528".equals(e.getMessage())) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
                return rspBO;
            }
            cfcEncodedSerialServiceRspBO = this.transaction(reqBO);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.getMessage());
        }
        rspBO.setSerialNoList(cfcEncodedSerialServiceRspBO.getSerialNoList());
        return rspBO;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public CfcEncodedSerialServiceRspBO getSerial(CfcEncodedSerialGetServiceReqBO reqBO) {
        String list;
        CfcUniteParamQryListPageAbilityRspBO cfcUniteParamQryListPageAbilityRspBO;
        CfcUniteParamQryListPageAbilityReqBO cfcUniteParamQryListPageAbilityReqBO;
        String replaceGeneratePrefix;
        String replaceGeneratePrefix2;
        String instance;
        Object replaceGeneratePrefix3;
        int result;
        log.info("\u83b7\u53d6\u7f16\u7801\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        CfcEncodedSerialServiceRspBO rspBO = new CfcEncodedSerialServiceRspBO();
        this.validParam(reqBO);
        Map<Long, Integer> restartMap = this.changeValid(reqBO);
        CfcEncodedSerialPO esParam = new CfcEncodedSerialPO();
        esParam.setCenter(reqBO.getCenter());
        esParam.setEncodedRuleCode(reqBO.getEncodedRuleCode());
        esParam.setEffFlag("1");
        if (reqBO.getOrgId() != null) {
            CfcEncodedRuleCheckExtAbilityReqBO ruleCheckExtAbilityReqBO = new CfcEncodedRuleCheckExtAbilityReqBO();
            ruleCheckExtAbilityReqBO.setCenter(reqBO.getCenter());
            ruleCheckExtAbilityReqBO.setEncodedRuleCode(reqBO.getEncodedRuleCode());
            ruleCheckExtAbilityReqBO.setOrgId(reqBO.getOrgId());
            CfcEncodedRuleCheckExtAbilityRspBO checkRspBO = this.cfcEncodedRuleCheckExtAbilityService.encodedRuleCheck(ruleCheckExtAbilityReqBO);
            if (checkRspBO.getRespCode().equals("0000") && checkRspBO.getIfExist().booleanValue()) {
                esParam.setOrgId(reqBO.getOrgId());
            }
        }
        List<CfcEncodedSerialPO> cfcEncodedSerialPOS = this.cfcEncodedSerialMapper.getList(esParam);
        List<CfcEncodedSerialPO> validList = new ArrayList<CfcEncodedSerialPO>();
        ArrayList<Long> invalidIds = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty(cfcEncodedSerialPOS)) {
            for (CfcEncodedSerialPO itemPO : cfcEncodedSerialPOS) {
                String effDate = this.composeEffDate(itemPO);
                if (StringUtils.isEmpty((CharSequence)effDate)) continue;
                if ("none".equals(effDate) || effDate.equals(itemPO.getEffDate())) {
                    validList.add(itemPO);
                    continue;
                }
                invalidIds.add(itemPO.getId());
            }
        }
        log.info("\u67e5\u8be2\u672c\u4e2d\u5fc3\u5e93\uff0c\u6839\u636e\u751f\u6548\u7c7b\u578b\u8fc7\u6ee4\u5f97\u5230\u7684\u6709\u6548\u5217\u8868\uff1a{}", (Object)JSON.toJSONString(validList));
        if (!CollectionUtils.isEmpty(invalidIds) && (result = this.cfcEncodedSerialMapper.updateInvalidBatch(invalidIds)) < 1) {
            throw new CfcEncodedPluginBusinessException("8888", "\u66f4\u65b0\u5931\u6548\u7f16\u7801\u5e8f\u5217\u72b6\u6001\u5931\u8d25");
        }
        Boolean hasQueriedCfc = false;
        if (CollectionUtils.isEmpty(validList)) {
            log.info("=== \u6839\u636e\u751f\u6548\u7c7b\u578b\u8fc7\u6ee4\u540e\uff0c\u6709\u6548\u5217\u8868\u4e3a\u7a7a\uff0c\u51c6\u5907\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3");
            hasQueriedCfc = true;
            esParam.setOrgId(reqBO.getOrgId());
            validList.addAll(this.getAllEncodedSerialPO(esParam));
            int insertFlag = this.cfcEncodedSerialMapper.insertBatch(validList);
            if (insertFlag < 1) {
                throw new CfcEncodedPluginBusinessException("8888", "\u66f4\u65b0\u7f16\u7801\u5e8f\u5217\u5931\u8d25");
            }
        }
        CfcEncodedSerialPO cfcEncodedSerialPO = this.filterByRelId(reqBO, validList);
        if (hasQueriedCfc.booleanValue() && ObjectUtils.isEmpty((Object)cfcEncodedSerialPO)) {
            log.info("=== \u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3\u5f97\u5230\u7684\u5217\u8868\u6839\u636e\u5173\u7cfbID\u8fc7\u6ee4\u540e\u5f97\u5230\u7684\u5bf9\u8c61\u4e3a\u7a7a");
            throw new CfcEncodedPluginBusinessException("8888", "\u672a\u83b7\u53d6\u5230\u5173\u8054\u7684\u7f16\u7801\u89c4\u5219");
        }
        if (ObjectUtils.isEmpty((Object)cfcEncodedSerialPO)) {
            log.info("=== \u672c\u4e2d\u5fc3\u6709\u6548\u5217\u8868\u4e0d\u4e3a\u7a7a\uff0c\u4f46\u6839\u636e\u5173\u7cfbID\u8fc7\u6765\u540e\u5f97\u5230\u7684\u5e8f\u5217\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u51c6\u5907\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3");
            esParam.setOrgId(reqBO.getOrgId());
            validList = this.getAllEncodedSerialPO(esParam);
            cfcEncodedSerialPO = this.filterByRelId(reqBO, validList);
            if (ObjectUtils.isEmpty((Object)cfcEncodedSerialPO)) {
                throw new CfcEncodedPluginBusinessException("8888", "\u672a\u83b7\u53d6\u5230\u5173\u8054\u7684\u7f16\u7801\u89c4\u5219");
            }
            int insertFlag = this.cfcEncodedSerialMapper.insert(cfcEncodedSerialPO);
            if (insertFlag < 1) {
                throw new CfcEncodedPluginBusinessException("8888", "\u66f4\u65b0\u5173\u8054\u7684\u7f16\u7801\u5e8f\u5217\u5931\u8d25");
            }
        }
        ArrayList<String> serialNoList = new ArrayList<String>();
        CfcEncodedSerialGeneratePO esgParam = new CfcEncodedSerialGeneratePO();
        String generatePrefix = cfcEncodedSerialPO.getEncodedSerialPrefix();
        if (reqBO.getReplaceJson() != null && reqBO.getReplaceJson().size() > 0) {
            for (Map.Entry itemJson : reqBO.getReplaceJson().entrySet()) {
                String itemJsonKey = "\\$\\{" + (String)itemJson.getKey() + "\\}";
                generatePrefix = generatePrefix.replaceAll(itemJsonKey, itemJson.getValue().toString());
            }
        } else if (!CollectionUtils.isEmpty(reqBO.getReplaceValue())) {
            String sp = "\\$\\{\\w+\\}";
            Pattern p = Pattern.compile(sp);
            Matcher m = p.matcher(generatePrefix);
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (m.find()) {
                if (i >= reqBO.getReplaceValue().size()) continue;
                String key = m.group(0);
                m.appendReplacement(sb, reqBO.getReplaceValue().get(i++));
            }
            m.appendTail(sb);
            generatePrefix = sb.toString();
        }
        esgParam.setSerialId(cfcEncodedSerialPO.getId());
        esgParam.setGeneratePrefix(generatePrefix);
        log.info("=== generatePrefix:{}", (Object)generatePrefix);
        if ("1".equals(reqBO.getContractCodeDiffBuyerFlag()) && "CONTRACT".equals(reqBO.getCenter())) {
            esgParam.setBuyerCode(reqBO.getBuyerCode());
        }
        List<CfcEncodedSerialGeneratePO> esgList = this.cfcEncodedSerialGenerateMapper.getList(esgParam);
        Integer num = reqBO.getNum() != null ? reqBO.getNum() : 1;
        Long esgId = null;
        if (esgList != null && esgList.size() > 0) {
            esgId = esgList.get(0).getId();
            int updateFlag = this.cfcEncodedSerialGenerateMapper.updateGenerateValue(esgId, num);
            if (updateFlag < 1) {
                throw new CfcEncodedPluginBusinessException("8888", "\u66f4\u65b0\u6d41\u6c34\u53f7\u5931\u8d25");
            }
        } else {
            esgId = Sequence.getInstance().nextId();
            esgParam.setId(esgId);
            if (restartMap.get(cfcEncodedSerialPO.getId()) != null) {
                esgParam.setGenerateValue(num + restartMap.get(cfcEncodedSerialPO.getId()));
            } else {
                esgParam.setGenerateValue(num);
            }
            int insertFlag = this.cfcEncodedSerialGenerateMapper.insert(esgParam);
            if (insertFlag < 1) {
                throw new CfcEncodedPluginBusinessException("8888", "\u66f4\u65b0\u6d41\u6c34\u53f7\u5931\u8d25");
            }
        }
        CfcEncodedSerialGeneratePO esgPO = this.cfcEncodedSerialGenerateMapper.selectByPrimaryKey(esgId);
        if (!StringUtils.isEmpty((CharSequence)reqBO.getBuyerCode()) && esgPO.getGeneratePrefix().contains(BUYER_SHORT_NAME)) {
            CfcBuyerAbbreviationConfigQryAbilityReqBO buyerQryReqBO = new CfcBuyerAbbreviationConfigQryAbilityReqBO();
            buyerQryReqBO.setId(reqBO.getBuyerCode());
            buyerQryReqBO.setPageNo(Integer.valueOf(1));
            buyerQryReqBO.setPageSize(Integer.valueOf(10));
            CfcBuyerAbbreviationConfigQryAbilityRspBO buyerQryRspBO = this.cfcBuyerAbbreviationConfigQryAbilityService.qryBuyerAbbreviationConfig(buyerQryReqBO);
            if (buyerQryRspBO.getRespCode().equals("0000") && !CollectionUtils.isEmpty((Collection)buyerQryRspBO.getRows())) {
                String buyerShortName = ((CfcBuyerAbbreviationConfigBO)buyerQryRspBO.getRows().get(0)).getBuyerShortName();
                replaceGeneratePrefix3 = esgPO.getGeneratePrefix().replace(BUYER_SHORT_NAME, buyerShortName);
                esgPO.setGeneratePrefix((String)replaceGeneratePrefix3);
            } else {
                String replaceGeneratePrefix4 = esgPO.getGeneratePrefix().replace(BUYER_SHORT_NAME, "");
                esgPO.setGeneratePrefix(replaceGeneratePrefix4);
            }
        } else if (esgPO.getGeneratePrefix().contains(BUYER_SHORT_NAME)) {
            String replaceGeneratePrefix5 = esgPO.getGeneratePrefix().replace(BUYER_SHORT_NAME, "");
            esgPO.setGeneratePrefix(replaceGeneratePrefix5);
        }
        if (reqBO.getSupplierNo() != null && esgParam.getGeneratePrefix().contains(SUPPLIER)) {
            instance = CfcEncodedSupplierEnum.getInstance(reqBO.getSupplierNo());
            if (instance != null) {
                replaceGeneratePrefix2 = esgPO.getGeneratePrefix().replace(SUPPLIER, instance);
                esgPO.setGeneratePrefix(replaceGeneratePrefix2);
            } else {
                replaceGeneratePrefix2 = esgPO.getGeneratePrefix().replace(SUPPLIER, "");
                esgPO.setGeneratePrefix(replaceGeneratePrefix2);
            }
        } else {
            replaceGeneratePrefix = esgPO.getGeneratePrefix().replace(SUPPLIER, "");
            esgPO.setGeneratePrefix(replaceGeneratePrefix);
        }
        if (reqBO.getOrderType() != null && esgParam.getGeneratePrefix().contains(ORDER_TYPE)) {
            instance = CfcEncodedOrderTypeEnum.getInstance(reqBO.getOrderType());
            if (instance != null) {
                replaceGeneratePrefix2 = esgPO.getGeneratePrefix().replace(ORDER_TYPE, instance);
                esgPO.setGeneratePrefix(replaceGeneratePrefix2);
            } else {
                replaceGeneratePrefix2 = esgPO.getGeneratePrefix().replace(ORDER_TYPE, "");
                esgPO.setGeneratePrefix(replaceGeneratePrefix2);
            }
        } else {
            replaceGeneratePrefix = esgPO.getGeneratePrefix().replace(ORDER_TYPE, "");
            esgPO.setGeneratePrefix(replaceGeneratePrefix);
        }
        if (reqBO.getContractType() != null && esgParam.getGeneratePrefix().contains("CONTRACT_TYPE")) {
            instance = null;
            cfcUniteParamQryListPageAbilityReqBO = new CfcUniteParamQryListPageAbilityReqBO();
            cfcUniteParamQryListPageAbilityReqBO.setCenter("CONTRACT");
            cfcUniteParamQryListPageAbilityReqBO.setGroupCode("CONTRACT_TYPE_CODE");
            log.error("\u67e5\u8be2\u7c7b\u578b\u53c2\u6570\uff1a" + JSONObject.toJSONString((Object)cfcUniteParamQryListPageAbilityReqBO));
            cfcUniteParamQryListPageAbilityRspBO = this.cfcUniteParamQryListPageAbilityService.qryUniteParamListPage(cfcUniteParamQryListPageAbilityReqBO);
            log.error("\u67e5\u8be2\u7c7b\u578b\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)cfcUniteParamQryListPageAbilityRspBO));
            if (!CollectionUtils.isEmpty((Collection)cfcUniteParamQryListPageAbilityRspBO.getRows())) {
                for (JSONObject jsonObject : cfcUniteParamQryListPageAbilityRspBO.getRows()) {
                    if (jsonObject.get((Object)"contractType") == null || StringUtils.isBlank((CharSequence)(list = jsonObject.get((Object)"contractType").toString())) || !list.contains(reqBO.getContractType())) continue;
                    instance = (String)jsonObject.get((Object)"code");
                    break;
                }
            } else {
                throw new CfcEncodedPluginBusinessException("8888", "\u8bf7\u7ef4\u62a4\u5408\u540c\u7c7b\u578b\u540e\u521b\u5efa\u5408\u540c");
            }
            if (instance != null) {
                replaceGeneratePrefix3 = esgPO.getGeneratePrefix().replace("CONTRACT_TYPE", instance);
                esgPO.setGeneratePrefix((String)replaceGeneratePrefix3);
            } else {
                replaceGeneratePrefix3 = esgPO.getGeneratePrefix().replace("CONTRACT_TYPE", "");
                esgPO.setGeneratePrefix((String)replaceGeneratePrefix3);
            }
        } else {
            replaceGeneratePrefix = esgPO.getGeneratePrefix().replace("CONTRACT_TYPE", "");
            esgPO.setGeneratePrefix(replaceGeneratePrefix);
        }
        if (reqBO.getMaterialCatalog() != null && esgParam.getGeneratePrefix().contains("CONTRACT_MATERIAL_CATALOG")) {
            instance = null;
            cfcUniteParamQryListPageAbilityReqBO = new CfcUniteParamQryListPageAbilityReqBO();
            cfcUniteParamQryListPageAbilityReqBO.setCenter("CONTRACT");
            cfcUniteParamQryListPageAbilityReqBO.setGroupCode("CONTRACT_CATALOG_CODE");
            cfcUniteParamQryListPageAbilityRspBO = this.cfcUniteParamQryListPageAbilityService.qryUniteParamListPage(cfcUniteParamQryListPageAbilityReqBO);
            if (!CollectionUtils.isEmpty((Collection)cfcUniteParamQryListPageAbilityRspBO.getRows())) {
                for (JSONObject jsonObject : cfcUniteParamQryListPageAbilityRspBO.getRows()) {
                    if (jsonObject.get((Object)"contractMaterialCatalog") == null || StringUtils.isBlank((CharSequence)(list = jsonObject.get((Object)"contractMaterialCatalog").toString())) || !list.contains(reqBO.getMaterialCatalog())) continue;
                    instance = (String)jsonObject.get((Object)"code");
                    break;
                }
            } else {
                throw new CfcEncodedPluginBusinessException("8888", "\u8bf7\u7ef4\u62a4\u5408\u540c\u7269\u8d44\u5206\u7c7b\u540e\u521b\u5efa\u5408\u540c");
            }
            if (instance != null) {
                replaceGeneratePrefix3 = esgPO.getGeneratePrefix().replace("CONTRACT_MATERIAL_CATALOG", instance);
                esgPO.setGeneratePrefix((String)replaceGeneratePrefix3);
            } else {
                replaceGeneratePrefix3 = esgPO.getGeneratePrefix().replace("CONTRACT_MATERIAL_CATALOG", "");
                esgPO.setGeneratePrefix((String)replaceGeneratePrefix3);
            }
        } else {
            replaceGeneratePrefix = esgPO.getGeneratePrefix().replace("CONTRACT_MATERIAL_CATALOG", "");
            esgPO.setGeneratePrefix(replaceGeneratePrefix);
        }
        if (reqBO.getContractClass() != null && esgParam.getGeneratePrefix().contains("CONTRACT_CLASS")) {
            instance = null;
            cfcUniteParamQryListPageAbilityReqBO = new CfcUniteParamQryListPageAbilityReqBO();
            cfcUniteParamQryListPageAbilityReqBO.setCenter("CONTRACT");
            cfcUniteParamQryListPageAbilityReqBO.setBusiType(reqBO.getContractClass());
            cfcUniteParamQryListPageAbilityReqBO.setGroupCode("CONTRACT_CLASS_CODE");
            cfcUniteParamQryListPageAbilityRspBO = this.cfcUniteParamQryListPageAbilityService.qryUniteParamListPage(cfcUniteParamQryListPageAbilityReqBO);
            if (!CollectionUtils.isEmpty((Collection)cfcUniteParamQryListPageAbilityRspBO.getRows())) {
                for (JSONObject jsonObject : cfcUniteParamQryListPageAbilityRspBO.getRows()) {
                    if (jsonObject.get((Object)"contractClass") == null || StringUtils.isBlank((CharSequence)(list = jsonObject.get((Object)"contractClass").toString())) || !list.contains(reqBO.getContractClass())) continue;
                    instance = (String)jsonObject.get((Object)"code");
                    break;
                }
            } else {
                throw new CfcEncodedPluginBusinessException("8888", "\u8bf7\u7ef4\u62a4\u5408\u540c\u4e1a\u52a1\u7c7b\u578b\u540e\u521b\u5efa\u5408\u540c");
            }
            if (instance != null) {
                replaceGeneratePrefix3 = esgPO.getGeneratePrefix().replace("CONTRACT_CLASS", instance);
                esgPO.setGeneratePrefix((String)replaceGeneratePrefix3);
            } else {
                replaceGeneratePrefix3 = esgPO.getGeneratePrefix().replace("CONTRACT_CLASS", "");
                esgPO.setGeneratePrefix((String)replaceGeneratePrefix3);
            }
        } else {
            replaceGeneratePrefix = esgPO.getGeneratePrefix().replace("CONTRACT_CLASS", "");
            esgPO.setGeneratePrefix(replaceGeneratePrefix);
        }
        if (reqBO.getOrgTreePath() != null && esgParam.getGeneratePrefix().contains("CONTRACT_ORG_CODE")) {
            instance = null;
            CfcCommonConfigParamQryListDetailReqBO cfcCommonConfigParamQryListDetailReqBO = new CfcCommonConfigParamQryListDetailReqBO();
            cfcCommonConfigParamQryListDetailReqBO.setCenter("CONTRACT");
            cfcCommonConfigParamQryListDetailReqBO.setGroupCode("ORG_CODE");
            cfcCommonConfigParamQryListDetailReqBO.setPageNo(Integer.valueOf(-1));
            CfcCommonConfigParamQryListDetailRspBO cfcCommonConfigParamQryListDetailRspBO = this.cfcCommonConfigParamQryListDetailAbilityService.qryConfigParamList(cfcCommonConfigParamQryListDetailReqBO);
            if (CollectionUtils.isEmpty((Collection)cfcCommonConfigParamQryListDetailRspBO.getRows())) {
                throw new CfcEncodedPluginBusinessException("8888", "\u8bf7\u7ef4\u62a4\u5408\u540c\u90e8\u95e8\u7f16\u7801\u540e\u521b\u5efa\u5408\u540c");
            }
            for (CfcCommonConfigParamBO cfcCommonConfigParamBO : cfcCommonConfigParamQryListDetailRspBO.getRows()) {
                if (!reqBO.getOrgTreePath().contains(cfcCommonConfigParamBO.getRelId())) continue;
                instance = cfcCommonConfigParamBO.getParamCode();
                break;
            }
            if (instance != null) {
                replaceGeneratePrefix3 = esgPO.getGeneratePrefix().replace("CONTRACT_ORG_CODE", instance);
                esgPO.setGeneratePrefix((String)replaceGeneratePrefix3);
            } else {
                replaceGeneratePrefix3 = esgPO.getGeneratePrefix().replace("CONTRACT_ORG_CODE", "5");
                esgPO.setGeneratePrefix((String)replaceGeneratePrefix3);
            }
        } else {
            replaceGeneratePrefix = esgPO.getGeneratePrefix().replace("CONTRACT_ORG_CODE", "5");
            esgPO.setGeneratePrefix(replaceGeneratePrefix);
        }
        if (!StringUtils.isBlank((CharSequence)reqBO.getMemId()) && esgParam.getGeneratePrefix().contains("CONTRACT_MEM_CODE")) {
            CfcCommonConfigParamQryListDetailReqBO cfcCommonConfigParamQryListDetailReqBO = new CfcCommonConfigParamQryListDetailReqBO();
            cfcCommonConfigParamQryListDetailReqBO.setCenter("CONTRACT");
            cfcCommonConfigParamQryListDetailReqBO.setGroupCode("MEM_CODE");
            cfcCommonConfigParamQryListDetailReqBO.setRelId(reqBO.getMemId());
            cfcCommonConfigParamQryListDetailReqBO.setPageNo(Integer.valueOf(-1));
            CfcCommonConfigParamQryListDetailRspBO cfcCommonConfigParamQryListDetailRspBO = this.cfcCommonConfigParamQryListDetailAbilityService.qryConfigParamList(cfcCommonConfigParamQryListDetailReqBO);
            if (CollectionUtils.isEmpty((Collection)cfcCommonConfigParamQryListDetailRspBO.getRows())) {
                throw new CfcEncodedPluginBusinessException("8888", "\u8bf7\u7ef4\u62a4\u5408\u540c\u4e1a\u52a1\u5458\u7f16\u53f7\u540e\u521b\u5efa\u5408\u540c");
            }
            String instance2 = ((CfcCommonConfigParamBO)cfcCommonConfigParamQryListDetailRspBO.getRows().get(0)).getParamCode();
            if (instance2 != null) {
                replaceGeneratePrefix3 = esgPO.getGeneratePrefix().replace("CONTRACT_MEM_CODE", instance2);
                esgPO.setGeneratePrefix((String)replaceGeneratePrefix3);
            } else {
                replaceGeneratePrefix3 = esgPO.getGeneratePrefix().replace("CONTRACT_MEM_CODE", "");
                esgPO.setGeneratePrefix((String)replaceGeneratePrefix3);
            }
        } else {
            replaceGeneratePrefix = esgPO.getGeneratePrefix().replace("CONTRACT_MEM_CODE", "");
            esgPO.setGeneratePrefix(replaceGeneratePrefix);
        }
        log.info("\u4e0a\u7ea7\u7f16\u7801\u4e3a\uff1a" + reqBO.getReplaceValue());
        for (int i = num - 1; i >= 0; --i) {
            String serialNo = new String();
            if (!CollectionUtils.isEmpty(reqBO.getReplaceValue()) && reqBO.isReplaceValueFlag()) {
                generatePrefix = reqBO.getReplaceValue().get(0);
                log.info("\u6839\u636e\u4e0a\u7ea7\u7f16\u7801\u91cd\u65b0\u5b9a\u4e49\u524d\u7f00:" + generatePrefix);
                serialNo = generatePrefix + String.format("%0" + cfcEncodedSerialPO.getEncodedSerialDigit() + "d", esgPO.getGenerateValue() - i);
            } else {
                log.info("\u7f16\u7801\u89c4\u5219\u524d\u7f00:" + esgPO.getGeneratePrefix());
                serialNo = esgPO.getGeneratePrefix() + String.format("%0" + cfcEncodedSerialPO.getEncodedSerialDigit() + "d", esgPO.getGenerateValue() - i);
            }
            serialNoList.add(serialNo);
        }
        if (reqBO.getIsCheckCall() != null && reqBO.getIsCheckCall() == 1) {
            throw new CfcEncodedPluginBusinessException("7777", "\u6821\u9a8c\u63a5\u53e3\u7684\u8c03\u7528");
        }
        rspBO.setSerialNoList(serialNoList);
        rspBO.setCfcEncodedSerialPO(cfcEncodedSerialPO);
        rspBO.setCfcEncodedSerialGeneratePO(esgPO);
        return rspBO;
    }

    private CfcEncodedSerialPO filterByRelId(CfcEncodedSerialGetServiceReqBO reqBO, List<CfcEncodedSerialPO> validList) {
        CfcEncodedSerialPO cfcEncodedSerialPO = null;
        int extendLength = -1;
        for (CfcEncodedSerialPO itemPO : validList) {
            if (StringUtils.isBlank((CharSequence)reqBO.getRelId())) {
                if (!StringUtils.isBlank((CharSequence)itemPO.getRelId())) continue;
                cfcEncodedSerialPO = itemPO;
                break;
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getRelType())) {
                reqBO.setRelType("org");
            }
            if (StringUtils.isBlank((CharSequence)itemPO.getRelId())) {
                if (cfcEncodedSerialPO != null) continue;
                cfcEncodedSerialPO = itemPO;
                continue;
            }
            if ("1".equals(reqBO.getExtendFlag())) {
                if (!reqBO.getRelId().contains(itemPO.getRelId()) || !reqBO.getRelType().equals(itemPO.getRelType())) continue;
                String[] ids = reqBO.getRelId().split("-");
                for (int i = 0; i < ids.length; ++i) {
                    if (!ids[i].equals(itemPO.getRelId()) || i <= extendLength) continue;
                    extendLength = i;
                    cfcEncodedSerialPO = itemPO;
                }
                continue;
            }
            if (!reqBO.getRelId().equals(itemPO.getRelId()) || !reqBO.getRelType().equals(itemPO.getRelType())) continue;
            cfcEncodedSerialPO = itemPO;
            break;
        }
        return cfcEncodedSerialPO;
    }

    private Map<Long, Integer> changeValid(CfcEncodedSerialGetServiceReqBO reqBO) {
        LOGGER.info("=============\u7f16\u7801\u53d8\u66f4\u6821\u9a8c\u5f00\u59cb==============");
        HashMap<Long, Integer> restartMap = new HashMap<Long, Integer>();
        String changeRedisKey = "change_encoded_" + reqBO.getCenter();
        LOGGER.info("\u7f16\u7801\u53d8\u66f4     changeRedisKey : {}", (Object)changeRedisKey);
        HashMap<String, List<CfcEncodedSerialPO>> map = new HashMap<String, List<CfcEncodedSerialPO>>();
        Object changeRedisObject = this.cacheService.get(changeRedisKey);
        JSONArray jsonArray = null;
        if (changeRedisObject != null) {
            jsonArray = JSONArray.parseArray((String)changeRedisObject.toString());
            this.cacheService.delete(changeRedisKey);
        } else {
            jsonArray = new JSONArray();
        }
        if (jsonArray != null && jsonArray.size() > 0) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                CfcEncodedRuleSelectCodeAbilityReqBo cfcEncodedRuleQryDetailAbilityReqBO = new CfcEncodedRuleSelectCodeAbilityReqBo();
                cfcEncodedRuleQryDetailAbilityReqBO.setId(jsonObject.getLong("id"));
                cfcEncodedRuleQryDetailAbilityReqBO.setOrgId(reqBO.getOrgId());
                CfcEncodedRuleSelectCodeAbilityRspBo cfcEncodedRuleSelectCodeAbilityRspBo = this.cfcEncodedRuleSelectCodeAbilityService.selectEncodedRuleDetail(cfcEncodedRuleQryDetailAbilityReqBO);
                if (!"0000".equals(cfcEncodedRuleSelectCodeAbilityRspBo.getRespCode())) {
                    throw new CfcEncodedPluginBusinessException(cfcEncodedRuleSelectCodeAbilityRspBo.getRespCode(), cfcEncodedRuleSelectCodeAbilityRspBo.getRespDesc());
                }
                CfcEncodedRuleBO cfcEncodedRuleBO = null;
                if (!CollectionUtils.isEmpty((Collection)cfcEncodedRuleSelectCodeAbilityRspBo.getEncodedRuleList())) {
                    cfcEncodedRuleBO = (CfcEncodedRuleBO)cfcEncodedRuleSelectCodeAbilityRspBo.getEncodedRuleList().get(0);
                }
                LOGGER.info("\u7f16\u7801\u53d8\u66f4     cfcEncodedRuleBO : {}", (Object)JSONObject.toJSONString(cfcEncodedRuleBO));
                List<CfcEncodedSerialPO> cfcEncodedSerialPOS = (List<CfcEncodedSerialPO>)map.get(cfcEncodedRuleBO.getEncodedRuleCode());
                if (CollectionUtils.isEmpty((Collection)cfcEncodedSerialPOS)) {
                    CfcEncodedSerialPO esParam = new CfcEncodedSerialPO();
                    esParam.setCenter(cfcEncodedRuleBO.getCenter());
                    esParam.setEncodedRuleCode(cfcEncodedRuleBO.getEncodedRuleCode());
                    esParam.setEffFlag("1");
                    if (reqBO.getOrgId() != null) {
                        CfcEncodedRuleCheckExtAbilityReqBO ruleCheckExtAbilityReqBO = new CfcEncodedRuleCheckExtAbilityReqBO();
                        ruleCheckExtAbilityReqBO.setCenter(reqBO.getCenter());
                        ruleCheckExtAbilityReqBO.setEncodedRuleCode(reqBO.getEncodedRuleCode());
                        ruleCheckExtAbilityReqBO.setOrgId(reqBO.getOrgId());
                        CfcEncodedRuleCheckExtAbilityRspBO checkRspBO = this.cfcEncodedRuleCheckExtAbilityService.encodedRuleCheck(ruleCheckExtAbilityReqBO);
                        if (checkRspBO.getRespCode().equals("0000") && checkRspBO.getIfExist().booleanValue()) {
                            esParam.setOrgId(reqBO.getOrgId());
                        }
                    }
                    cfcEncodedSerialPOS = this.cfcEncodedSerialMapper.getList(esParam);
                }
                if (CollectionUtils.isEmpty((Collection)cfcEncodedSerialPOS)) continue;
                LOGGER.info("\u7f16\u7801\u53d8\u66f4     encodedSerialPOMap : {}", (Object)JSONObject.toJSONString((Object)cfcEncodedSerialPOS));
                CfcEncodedSerialPO insertPO = new CfcEncodedSerialPO();
                BeanUtils.copyProperties((Object)cfcEncodedRuleBO, (Object)insertPO);
                insertPO.setId(Sequence.getInstance().nextId());
                insertPO.setEncodedSerialPrefix(cfcEncodedRuleBO.getEncodedSerialPrefix());
                insertPO.setEncodedSerialDigit(cfcEncodedRuleBO.getEncodedSerialDigit());
                insertPO.setEffFlag("1");
                insertPO.setEffType(cfcEncodedRuleBO.getEffType());
                insertPO.setEffDate(this.composeEffDate(insertPO));
                insertPO.setRelType(cfcEncodedRuleBO.getRelType());
                insertPO.setRelId(cfcEncodedRuleBO.getRelId());
                CfcEncodedSerialPO restartPO = null;
                int currentValidNum = 0;
                if (!CollectionUtils.isEmpty(cfcEncodedSerialPOS)) {
                    for (CfcEncodedSerialPO itemPO : cfcEncodedSerialPOS) {
                        String effDate;
                        int operateFlag = 0;
                        if (StringUtils.isBlank((CharSequence)itemPO.getRelId()) && StringUtils.isBlank((CharSequence)insertPO.getRelId())) {
                            operateFlag = this.cfcEncodedSerialMapper.updateInvalid(itemPO.getId());
                        }
                        if (!StringUtils.isBlank((CharSequence)itemPO.getRelId()) && itemPO.getRelId().equals(insertPO.getRelId())) {
                            operateFlag = this.cfcEncodedSerialMapper.updateInvalid(itemPO.getId());
                        }
                        if ((effDate = this.composeEffDate(itemPO)) != null && ("".equals(effDate) || effDate.equals(itemPO.getEffDate()))) {
                            if ("1".equals(jsonObject.getString("restartFlag")) && operateFlag > 0) {
                                restartPO = itemPO;
                            }
                            ++currentValidNum;
                        }
                        LOGGER.info("\u7f16\u7801\u53d8\u66f4     updateInvalid : {}", (Object)operateFlag);
                    }
                }
                if (currentValidNum <= 0) continue;
                int operateFlag = this.cfcEncodedSerialMapper.insert(insertPO);
                LOGGER.info("\u7f16\u7801\u53d8\u66f4     insert : {}", (Object)operateFlag);
                cfcEncodedSerialPOS.add(insertPO);
                map.put(cfcEncodedRuleBO.getEncodedRuleCode(), cfcEncodedSerialPOS);
                if (restartPO == null) continue;
                CfcEncodedSerialGeneratePO esgParam = new CfcEncodedSerialGeneratePO();
                esgParam.setSerialId(restartPO.getId());
                List<CfcEncodedSerialGeneratePO> esgList = this.cfcEncodedSerialGenerateMapper.getList(esgParam);
                if (CollectionUtils.isEmpty(esgList) || esgList.size() != 1) continue;
                restartMap.put(insertPO.getId(), esgList.get(0).getGenerateValue());
            }
        }
        return restartMap;
    }

    private String composeEffDate(CfcEncodedSerialPO cfcEncodedSerialPO) {
        if ("none".equals(cfcEncodedSerialPO.getEffType())) {
            return "none";
        }
        if ("date".equals(cfcEncodedSerialPO.getEffType())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            return df.format(LocalDateTime.now());
        }
        if ("year".equals(cfcEncodedSerialPO.getEffType())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy");
            return df.format(LocalDateTime.now());
        }
        if ("month".equals(cfcEncodedSerialPO.getEffType())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("MM");
            return df.format(LocalDateTime.now());
        }
        if ("day".equals(cfcEncodedSerialPO.getEffType())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("dd");
            return df.format(LocalDateTime.now());
        }
        if ("shotYear".equals(cfcEncodedSerialPO.getEffType())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy");
            return df.format(LocalDateTime.now()).substring(2);
        }
        return null;
    }

    private List<CfcEncodedSerialPO> getAllEncodedSerialPO(CfcEncodedSerialPO esPO) {
        CfcEncodedRuleSelectCodeAbilityReqBo cfcEncodedRuleSelectCodeAbilityReqBo = new CfcEncodedRuleSelectCodeAbilityReqBo();
        cfcEncodedRuleSelectCodeAbilityReqBo.setCenter(esPO.getCenter());
        cfcEncodedRuleSelectCodeAbilityReqBo.setEncodedRuleCode(esPO.getEncodedRuleCode());
        cfcEncodedRuleSelectCodeAbilityReqBo.setOrgId(esPO.getOrgId());
        CfcEncodedRuleSelectCodeAbilityRspBo cfcEncodedRuleSelectCodeAbilityRspBo = this.cfcEncodedRuleSelectCodeAbilityService.selectEncodedRuleDetail(cfcEncodedRuleSelectCodeAbilityReqBo);
        if (!"0000".equals(cfcEncodedRuleSelectCodeAbilityRspBo.getRespCode())) {
            throw new CfcEncodedPluginBusinessException(cfcEncodedRuleSelectCodeAbilityRspBo.getRespCode(), cfcEncodedRuleSelectCodeAbilityRspBo.getRespDesc());
        }
        List encodedRuleList = cfcEncodedRuleSelectCodeAbilityRspBo.getEncodedRuleList();
        ArrayList<CfcEncodedSerialPO> addList = new ArrayList<CfcEncodedSerialPO>();
        for (CfcEncodedRuleBO encodedRuleBO : encodedRuleList) {
            CfcEncodedSerialPO insertPO = new CfcEncodedSerialPO();
            BeanUtils.copyProperties((Object)esPO, (Object)insertPO);
            insertPO.setId(Sequence.getInstance().nextId());
            insertPO.setEncodedSerialPrefix(encodedRuleBO.getReplaceEncodedSerialPrefix());
            insertPO.setEncodedSerialDigit(encodedRuleBO.getEncodedSerialDigit());
            insertPO.setEffFlag("1");
            insertPO.setEffType(encodedRuleBO.getEffType());
            insertPO.setEffDate(this.composeEffDate(insertPO));
            insertPO.setRelType(encodedRuleBO.getRelType());
            insertPO.setRelId(encodedRuleBO.getRelId());
            if (encodedRuleBO.getIsExtRule().booleanValue()) {
                insertPO.setOrgId(esPO.getOrgId());
            } else {
                insertPO.setOrgId(null);
            }
            addList.add(insertPO);
        }
        log.info("===\u8c03\u7528\u914d\u7f6e\u4e2d\u5fc3\uff0c\u7f16\u7801\uff1a{}\uff0c \u7f16\u7801\u89c4\u5219\u96c6\u5408\uff1a{}", (Object)esPO.getEncodedRuleCode(), addList);
        return addList;
    }

    private void validParam(CfcEncodedSerialGetServiceReqBO reqBO) {
        if (reqBO == null) {
            throw new CfcEncodedPluginBusinessException("8888", "\u7f16\u7801\u89c4\u5219\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getCenter())) {
            throw new CfcEncodedPluginBusinessException("8888", "\u7f16\u7801\u89c4\u5219\u6240\u5c5e\u4e2d\u5fc3\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getEncodedRuleCode())) {
            throw new CfcEncodedPluginBusinessException("8888", "\u7f16\u7801\u89c4\u5219\u7f16\u7801\u4e3a\u7a7a");
        }
    }

    private CfcEncodedSerialServiceRspBO transaction(CfcEncodedSerialGetServiceReqBO reqBO) {
        CfcEncodedSerialServiceRspBO cfcEncodedSerialServiceRspBO;
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        TransactionStatus status = this.dataSourceTransactionManager.getTransaction((TransactionDefinition)def);
        try {
            cfcEncodedSerialServiceRspBO = this.getSerial(reqBO);
            this.dataSourceTransactionManager.commit(status);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dataSourceTransactionManager.rollback(status);
            if ("\u6821\u9a8c\u63a5\u53e3\u7684\u8c03\u7528".equals(e.getMessage())) {
                throw new CfcEncodedPluginBusinessException("8888", e.getMessage());
            }
            throw new CfcEncodedPluginBusinessException("8888", "\u66f4\u65b0\u7f16\u7801\u5e8f\u5217\u5931\u8d25:" + e.getMessage());
        }
        return cfcEncodedSerialServiceRspBO;
    }
}

