/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.plugin.encoded.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.cfc.ability.api.CfcEncodedRuleSelectCodeAbilityService;
import com.tydic.cfc.ability.bo.CfcEncodedRuleBO;
import com.tydic.cfc.ability.bo.CfcEncodedRuleSelectCodeAbilityReqBo;
import com.tydic.cfc.ability.bo.CfcEncodedRuleSelectCodeAbilityRspBo;
import com.tydic.plugin.encoded.dao.CfcEncodedSerialGenerateMapper;
import com.tydic.plugin.encoded.dao.CfcEncodedSerialMapper;
import com.tydic.plugin.encoded.dao.po.CfcEncodedSerialGeneratePO;
import com.tydic.plugin.encoded.dao.po.CfcEncodedSerialPO;
import com.tydic.plugin.encoded.exception.CfcEncodedPluginBusinessException;
import com.tydic.plugin.encoded.service.CfcEncodedSerialMqSyncService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialMqSyncServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialMqSyncServiceRspBO;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="cfcEncodedSerialMqSyncService")
public class CfcEncodedSerialMqSyncServiceImpl
implements CfcEncodedSerialMqSyncService {
    private static final Logger log = LoggerFactory.getLogger(CfcEncodedSerialMqSyncServiceImpl.class);
    @Autowired
    private CfcEncodedRuleSelectCodeAbilityService cfcEncodedRuleSelectCodeAbilityService;
    @Autowired
    private CfcEncodedSerialMapper cfcEncodedSerialMapper;
    @Autowired
    private CfcEncodedSerialGenerateMapper cfcEncodedSerialGenerateMapper;

    @Override
    public CfcEncodedSerialMqSyncServiceRspBO syncMqEncodedSerial(CfcEncodedSerialMqSyncServiceReqBO reqBO) {
        this.syncMethod(reqBO);
        return new CfcEncodedSerialMqSyncServiceRspBO();
    }

    private void syncMethod(CfcEncodedSerialMqSyncServiceReqBO reqBO) {
        if (!StringUtils.isEmpty((CharSequence)reqBO.getRestartFlag()) && "3".equals(reqBO.getRestartFlag())) {
            this.deleteEncodeRule(reqBO);
        }
        CfcEncodedRuleSelectCodeAbilityReqBo cfcEncodedRuleQryDetailAbilityReqBO = new CfcEncodedRuleSelectCodeAbilityReqBo();
        cfcEncodedRuleQryDetailAbilityReqBO.setId(reqBO.getId());
        CfcEncodedRuleSelectCodeAbilityRspBo cfcEncodedRuleSelectCodeAbilityRspBo = this.cfcEncodedRuleSelectCodeAbilityService.selectEncodedRuleDetail(cfcEncodedRuleQryDetailAbilityReqBO);
        if (!"0000".equals(cfcEncodedRuleSelectCodeAbilityRspBo.getRespCode())) {
            throw new CfcEncodedPluginBusinessException(cfcEncodedRuleSelectCodeAbilityRspBo.getRespCode(), cfcEncodedRuleSelectCodeAbilityRspBo.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)cfcEncodedRuleSelectCodeAbilityRspBo.getEncodedRuleList())) {
            throw new CfcEncodedPluginBusinessException("8888", "\u8c03\u7528\u914d\u7f6e\u4e2d\u5fc3\u7f16\u7801\u89c4\u5219\u67e5\u8be2\u63a5\u53e3\u83b7\u53d6\u5230\u7684\u89c4\u5219\u5217\u8868\u4e3a\u7a7a");
        }
        CfcEncodedRuleBO cfcEncodedRuleBO = (CfcEncodedRuleBO)cfcEncodedRuleSelectCodeAbilityRspBo.getEncodedRuleList().get(0);
        log.info("--------- \u7f16\u7801\u5165\u53c2\uff1acfcEncodedRuleBO:" + cfcEncodedRuleBO.toString());
        boolean isNeedReset = this.checkDuplicateCode(cfcEncodedRuleBO);
        if (isNeedReset) {
            log.info("--------- \u6b64\u65f6\u662f\u4e00\u4e2a\u65b0\u7684\u7f16\u7801 ---------");
            CfcEncodedSerialPO esParam = new CfcEncodedSerialPO();
            esParam.setCenter(cfcEncodedRuleBO.getCenter());
            esParam.setEncodedRuleCode(cfcEncodedRuleBO.getEncodedRuleCode());
            esParam.setEffFlag("1");
            if (!StringUtils.isEmpty((CharSequence)cfcEncodedRuleBO.getRelId())) {
                esParam.setRelId(cfcEncodedRuleBO.getRelId());
            }
            List<CfcEncodedSerialPO> cfcEncodedSerialPOS = this.cfcEncodedSerialMapper.getList(esParam);
            CfcEncodedSerialPO insertPO = new CfcEncodedSerialPO();
            BeanUtils.copyProperties((Object)cfcEncodedRuleBO, (Object)insertPO);
            insertPO.setId(Sequence.getInstance().nextId());
            insertPO.setEncodedSerialPrefix(cfcEncodedRuleBO.getReplaceEncodedSerialPrefix());
            insertPO.setEncodedSerialDigit(cfcEncodedRuleBO.getEncodedSerialDigit());
            insertPO.setEffFlag("1");
            insertPO.setEffType(cfcEncodedRuleBO.getEffType());
            insertPO.setEffDate(this.composeEffDate(insertPO));
            insertPO.setRelType(cfcEncodedRuleBO.getRelType());
            insertPO.setRelId(cfcEncodedRuleBO.getRelId());
            Boolean isInsertNewSerial = true;
            if (!CollectionUtils.isEmpty(cfcEncodedSerialPOS)) {
                isInsertNewSerial = this.dealOldSerial(cfcEncodedSerialPOS, insertPO, reqBO.getRestartFlag());
            }
            if (isInsertNewSerial.booleanValue()) {
                this.cfcEncodedSerialMapper.insert(insertPO);
                cfcEncodedSerialPOS.add(insertPO);
            }
        }
    }

    private boolean checkDuplicateCode(CfcEncodedRuleBO cfcEncodedRuleBO) {
        if (!StringUtils.isEmpty((CharSequence)cfcEncodedRuleBO.getEncodedSerialPrefix())) {
            return true;
        }
        CfcEncodedSerialPO checkEncodedParam = new CfcEncodedSerialPO();
        checkEncodedParam.setCenter(cfcEncodedRuleBO.getCenter());
        checkEncodedParam.setEncodedRuleCode(cfcEncodedRuleBO.getEncodedRuleCode());
        checkEncodedParam.setEncodedSerialPrefix(cfcEncodedRuleBO.getEncodedSerialPrefix());
        checkEncodedParam.setEncodedSerialDigit(cfcEncodedRuleBO.getEncodedSerialDigit());
        checkEncodedParam.setEffType(cfcEncodedRuleBO.getEffType());
        checkEncodedParam.setEffDate(this.composeEffDate(checkEncodedParam));
        List<CfcEncodedSerialPO> checkEncodedSerialPOS = this.cfcEncodedSerialMapper.getList(checkEncodedParam);
        if (CollectionUtils.isEmpty(checkEncodedSerialPOS)) {
            return true;
        }
        if (!"1".equals(checkEncodedSerialPOS.get(0).getEffFlag())) {
            CfcEncodedSerialPO esParam = new CfcEncodedSerialPO();
            esParam.setCenter(cfcEncodedRuleBO.getCenter());
            esParam.setEncodedRuleCode(cfcEncodedRuleBO.getEncodedRuleCode());
            esParam.setEffFlag("1");
            List<CfcEncodedSerialPO> cfcEncodedSerialPOS = this.cfcEncodedSerialMapper.getList(esParam);
            if (!CollectionUtils.isEmpty(cfcEncodedSerialPOS)) {
                if (!StringUtils.isBlank((CharSequence)cfcEncodedRuleBO.getRelId())) {
                    for (CfcEncodedSerialPO cfcEncodedSerialPO : cfcEncodedSerialPOS) {
                        if (StringUtils.isBlank((CharSequence)cfcEncodedSerialPO.getRelId()) || !cfcEncodedSerialPO.getRelId().equals(cfcEncodedRuleBO.getRelId())) continue;
                        this.cfcEncodedSerialMapper.updateInvalid(cfcEncodedSerialPO.getId());
                    }
                } else {
                    for (CfcEncodedSerialPO cfcEncodedSerialPO : cfcEncodedSerialPOS) {
                        if (!StringUtils.isBlank((CharSequence)cfcEncodedSerialPO.getRelId())) continue;
                        this.cfcEncodedSerialMapper.updateInvalid(cfcEncodedSerialPO.getId());
                    }
                }
            }
            this.cfcEncodedSerialMapper.updateEffective(checkEncodedSerialPOS.get(0).getId());
        }
        log.info("\u4fee\u6539\u7684\u7f16\u7801Id\uff1a{}", (Object)checkEncodedSerialPOS.get(0).getId());
        return false;
    }

    private void deleteEncodeRule(CfcEncodedSerialMqSyncServiceReqBO reqBO) {
        CfcEncodedSerialPO serialPo = new CfcEncodedSerialPO();
        serialPo.setRelId(reqBO.getRelId());
        serialPo.setCenter(reqBO.getCenter());
        serialPo.setEncodedRuleCode(reqBO.getEncodedRuleCode());
        serialPo.setEffFlag("1");
        List<CfcEncodedSerialPO> serialList = this.cfcEncodedSerialMapper.getList(serialPo);
        if (CollectionUtils.isEmpty(serialList)) {
            throw new CfcEncodedPluginBusinessException("8888", "\u6839\u636e\u5165\u53c2\u6ca1\u6709\u5728\u672c\u4e2d\u5fc3\u67e5\u8be2\u5230\u9700\u8981\u5220\u9664\u7684\u7f16\u7801\u89c4\u5219\uff1a" + JSON.toJSONString((Object)reqBO));
        }
        this.cfcEncodedSerialMapper.updateInvalid(serialList.get(0).getId());
    }

    private Boolean dealOldSerial(List<CfcEncodedSerialPO> cfcEncodedSerialPOS, CfcEncodedSerialPO insertPO, String restartFlag) {
        Boolean isInsertNewSerial = false;
        for (CfcEncodedSerialPO itemPO : cfcEncodedSerialPOS) {
            int updateOldFlag = 0;
            if (StringUtils.isBlank((CharSequence)itemPO.getRelId()) && StringUtils.isBlank((CharSequence)insertPO.getRelId())) {
                updateOldFlag = this.cfcEncodedSerialMapper.updateInvalid(itemPO.getId());
            }
            if (!StringUtils.isBlank((CharSequence)itemPO.getRelId()) && itemPO.getRelId().equals(insertPO.getRelId())) {
                updateOldFlag = this.cfcEncodedSerialMapper.updateInvalid(itemPO.getId());
            }
            if (updateOldFlag <= 0) continue;
            isInsertNewSerial = true;
            String effDate = this.composeEffDate(itemPO);
            if (StringUtils.isEmpty((CharSequence)effDate)) continue;
            CfcEncodedSerialGeneratePO esgParam = new CfcEncodedSerialGeneratePO();
            esgParam.setSerialId(itemPO.getId());
            List<CfcEncodedSerialGeneratePO> esgList = this.cfcEncodedSerialGenerateMapper.getList(esgParam);
            if (CollectionUtils.isEmpty(esgList)) continue;
            Boolean isResetGenerateValue = true;
            if (!"1".equals(restartFlag) && itemPO.getEncodedSerialPrefix().equals(insertPO.getEncodedSerialPrefix()) && itemPO.getEncodedSerialDigit().equals(insertPO.getEncodedSerialDigit())) {
                isResetGenerateValue = false;
            }
            if (isResetGenerateValue.booleanValue()) {
                CfcEncodedSerialGeneratePO newGeneratePo = new CfcEncodedSerialGeneratePO();
                newGeneratePo.setId(Sequence.getInstance().nextId());
                newGeneratePo.setSerialId(insertPO.getId());
                newGeneratePo.setGeneratePrefix(insertPO.getEncodedSerialPrefix());
                newGeneratePo.setGenerateValue(1);
                this.cfcEncodedSerialGenerateMapper.insert(newGeneratePo);
                continue;
            }
            esgList.forEach(item -> {
                item.setId(Sequence.getInstance().nextId());
                item.setSerialId(insertPO.getId());
            });
            this.cfcEncodedSerialGenerateMapper.insertBatch(esgList);
        }
        return isInsertNewSerial;
    }

    private String composeEffDate(CfcEncodedSerialPO cfcEncodedSerialPO) {
        if ("none".equals(cfcEncodedSerialPO.getEffType())) {
            return "none";
        }
        if ("date".equals(cfcEncodedSerialPO.getEffType())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            return df.format(LocalDateTime.now());
        }
        if ("year".equals(cfcEncodedSerialPO.getEffType())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy");
            return df.format(LocalDateTime.now());
        }
        if ("month".equals(cfcEncodedSerialPO.getEffType())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("MM");
            return df.format(LocalDateTime.now());
        }
        if ("day".equals(cfcEncodedSerialPO.getEffType())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("dd");
            return df.format(LocalDateTime.now());
        }
        if ("shotYear".equals(cfcEncodedSerialPO.getEffType())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy");
            return df.format(LocalDateTime.now()).substring(2);
        }
        return null;
    }
}

