/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.contract.ability.ContractApprovalPrintAbilityService;
import com.tydic.contract.ability.ContractChangeDetailQueryAbilityService;
import com.tydic.contract.ability.ContractDetailQueryAbilityService;
import com.tydic.contract.ability.ContractQryAuditLogAbilityService;
import com.tydic.contract.ability.bo.ContractApprovalPrintAbilityReqBo;
import com.tydic.contract.ability.bo.ContractApprovalPrintAbilityRspBo;
import com.tydic.contract.ability.bo.ContractChangeDetailQueryAbilityReqBO;
import com.tydic.contract.ability.bo.ContractChangeDetailQueryAbilityRspBO;
import com.tydic.contract.ability.bo.ContractDetailQueryAbilityReqBO;
import com.tydic.contract.ability.bo.ContractDetailQueryAbilityRspBO;
import com.tydic.contract.ability.bo.ContractQryAuditLogAbilityReqBO;
import com.tydic.contract.ability.bo.ContractQryAuditLogAbilityRspBO;
import com.tydic.contract.ability.bo.ContractQryAuditLogBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.utils.DateUtils;
import com.tydic.contract.utils.PdfUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractApprovalPrintAbilityService"})
public class ContractApprovalPrintAbilityServiceImpl
implements ContractApprovalPrintAbilityService {
    private static final Logger log = LoggerFactory.getLogger(ContractApprovalPrintAbilityServiceImpl.class);
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Autowired
    private FileClient fileClient;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    public static final String FILE_TYPE_OSS = "OSS";
    public static final String FILE_TYPE_FASTDFS = "FASTDFS";
    private static final String PATH = "contract/pdf";
    @Autowired
    private ContractQryAuditLogAbilityService contractQryAuditLogAbilityService;
    @Autowired
    private ContractDetailQueryAbilityService contractDetailQueryAbilityService;
    @Autowired
    private ContractChangeDetailQueryAbilityService contractChangeDetailQueryAbilityService;

    @PostMapping(value={"printContractApproval"})
    public ContractApprovalPrintAbilityRspBo printContractApproval(@RequestBody ContractApprovalPrintAbilityReqBo reqBo) {
        ContractChangeDetailQueryAbilityRspBO contractChangeDetailQueryAbilityRspBO;
        ContractChangeDetailQueryAbilityReqBO contractChangeDetailQueryAbilityReqBO;
        ContractDetailQueryAbilityReqBO contractDetailQueryAbilityReqBO;
        BaseFont baseFont;
        ContractApprovalPrintAbilityRspBo rspBo = new ContractApprovalPrintAbilityRspBo();
        Document document = new Document(PageSize.A4.rotate(), -75.0f, -75.0f, 15.0f, 40.0f);
        PdfWriter pdfWriter = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        try {
            baseFont = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u5b9a\u4e49\u5b57\u4f53\u51fa\u9519");
        }
        Font titleFont = new Font(baseFont, 16.0f, 1);
        Font contentFont = new Font(baseFont, 9.0f, 0);
        int COLUMNS = 24;
        document.open();
        LinkedList<PdfPTable> tableList = new LinkedList<PdfPTable>();
        ContractDetailQueryAbilityRspBO contractDetailQueryAbilityRspBO = new ContractDetailQueryAbilityRspBO();
        if (reqBo.getContractId() != null) {
            contractDetailQueryAbilityReqBO = new ContractDetailQueryAbilityReqBO();
            contractDetailQueryAbilityReqBO.setContractId(reqBo.getContractId());
            contractDetailQueryAbilityRspBO = this.contractDetailQueryAbilityService.contractDetailQuery(contractDetailQueryAbilityReqBO);
        }
        if (reqBo.getUpdateApplyId() != null) {
            contractChangeDetailQueryAbilityReqBO = new ContractChangeDetailQueryAbilityReqBO();
            contractChangeDetailQueryAbilityReqBO.setUpdateApplyId(reqBo.getUpdateApplyId());
            contractChangeDetailQueryAbilityRspBO = this.contractChangeDetailQueryAbilityService.contractChangeDetailQuery(contractChangeDetailQueryAbilityReqBO);
            BeanUtils.copyProperties((Object)contractChangeDetailQueryAbilityRspBO, (Object)contractDetailQueryAbilityRspBO);
        }
        if (reqBo.getPurchaseApprovalId() != null) {
            contractDetailQueryAbilityReqBO = new ContractDetailQueryAbilityReqBO();
            contractDetailQueryAbilityReqBO.setContractId(reqBo.getPurchaseApprovalId());
            contractDetailQueryAbilityRspBO = this.contractDetailQueryAbilityService.contractDetailQuery(contractDetailQueryAbilityReqBO);
        }
        if (reqBo.getPurchaseUpdateApplyId() != null) {
            contractChangeDetailQueryAbilityReqBO = new ContractChangeDetailQueryAbilityReqBO();
            contractChangeDetailQueryAbilityReqBO.setUpdateApplyId(reqBo.getPurchaseUpdateApplyId());
            contractChangeDetailQueryAbilityRspBO = this.contractChangeDetailQueryAbilityService.contractChangeDetailQuery(contractChangeDetailQueryAbilityReqBO);
            BeanUtils.copyProperties((Object)contractChangeDetailQueryAbilityRspBO, (Object)contractDetailQueryAbilityRspBO);
        }
        ContractQryAuditLogAbilityReqBO contractQryAuditLogAbilityReqBO = new ContractQryAuditLogAbilityReqBO();
        BeanUtils.copyProperties((Object)reqBo, (Object)contractQryAuditLogAbilityReqBO);
        if (reqBo.getUpdateApplyId() != null) {
            contractQryAuditLogAbilityReqBO.setObjId(String.valueOf(reqBo.getUpdateApplyId()));
            contractQryAuditLogAbilityReqBO.setObjType(Integer.valueOf(1));
            contractQryAuditLogAbilityReqBO.setOrgId(reqBo.getOrgId());
            contractQryAuditLogAbilityReqBO.setType(Integer.valueOf(2));
        } else {
            contractQryAuditLogAbilityReqBO.setObjId(String.valueOf(reqBo.getContractId()));
            contractQryAuditLogAbilityReqBO.setObjType(Integer.valueOf(1));
            contractQryAuditLogAbilityReqBO.setOrgId(reqBo.getOrgId());
            contractQryAuditLogAbilityReqBO.setType(Integer.valueOf(1));
        }
        ContractQryAuditLogAbilityRspBO contractQryAuditLogAbilityRspBO = this.contractQryAuditLogAbilityService.qryAuditLog(contractQryAuditLogAbilityReqBO);
        List auditLogs = contractQryAuditLogAbilityRspBO.getRows();
        String titleStr = "";
        titleStr = ContractConstant.ContractType.SALE_CONTRACT.equals(contractDetailQueryAbilityRspBO.getContractType()) || ContractConstant.ContractType.ORDER_CONTRACT.equals(contractDetailQueryAbilityRspBO.getContractType()) ? "\u9500\u552e\u5408\u540c\u4f1a\u7b7e\u5355" : (ContractConstant.ContractType.OTHER_LONG_TERM_PRICING_CONTRACT.equals(contractDetailQueryAbilityRspBO.getContractType()) || ContractConstant.ContractType.OTHER_PROMPT_CONTRACT.equals(contractDetailQueryAbilityRspBO.getContractType()) ? "\u5176\u4ed6\u5408\u540c\u4f1a\u7b7e\u5355" : "\u91c7\u8d2d\u5408\u540c\u4f1a\u7b7e\u5355");
        PdfPTable titleTable = new PdfPTable(24);
        tableList.add(titleTable);
        PdfUtil.addCellToTable(titleTable, titleStr, titleFont, 1, 5, Float.valueOf(50.0f), 24, null);
        PdfPTable pdfPTable2 = new PdfPTable(3);
        tableList.add(pdfPTable2);
        PdfUtil.addCellToTable(pdfPTable2, "\u5408\u540c\u4fe1\u606f", contentFont, 0, 4, Float.valueOf(30.0f), 3, null);
        PdfPTable pdfPTable3 = new PdfPTable(24);
        tableList.add(pdfPTable3);
        PdfUtil.addCellToTable(pdfPTable3, "\u4e70\u65b9\u5408\u540c\u7f16\u53f7\uff1a", contentFont, 0, 4, Float.valueOf(30.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable3, this.convertNullToString(contractDetailQueryAbilityRspBO.getContractCode()), contentFont, 0, 4, Float.valueOf(30.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable3, "\u5356\u65b9\u5408\u540c\u7f16\u53f7\uff1a", contentFont, 0, 4, Float.valueOf(30.0f), 3, 2);
        PdfUtil.addCellToTable(pdfPTable3, this.convertNullToString(contractDetailQueryAbilityRspBO.getSaleContractCode()), contentFont, 0, 4, Float.valueOf(30.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable3, "\u5408\u540c\u540d\u79f0\uff1a", contentFont, 0, 4, Float.valueOf(30.0f), 3, 2);
        PdfUtil.addCellToTable(pdfPTable3, this.convertNullToString(contractDetailQueryAbilityRspBO.getContractName()), contentFont, 0, 4, Float.valueOf(30.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable3, "\u5408\u540c\u7c7b\u578b\uff1a", contentFont, 0, 4, Float.valueOf(30.0f), 3, 2);
        PdfUtil.addCellToTable(pdfPTable3, this.convertNullToString(contractDetailQueryAbilityRspBO.getContractTypeStr()), contentFont, 0, 4, Float.valueOf(30.0f), 3, null);
        PdfPTable pdfPTable4 = new PdfPTable(24);
        tableList.add(pdfPTable4);
        PdfUtil.addCellToTable(pdfPTable4, "\u4e70\u53d7\u4eba", contentFont, 0, 4, Float.valueOf(30.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable4, this.convertNullToString(contractDetailQueryAbilityRspBO.getBuyerName()), contentFont, 0, 4, Float.valueOf(30.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable4, "\u51fa\u5356\u4eba", contentFont, 0, 4, Float.valueOf(30.0f), 3, 2);
        PdfUtil.addCellToTable(pdfPTable4, this.convertNullToString(contractDetailQueryAbilityRspBO.getSupplierName()), contentFont, 0, 4, Float.valueOf(30.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable4, "\u5408\u540c\u91d1\u989d", contentFont, 0, 4, Float.valueOf(30.0f), 3, 2);
        PdfUtil.addCellToTable(pdfPTable4, this.convertNullToString(contractDetailQueryAbilityRspBO.getContractAmount()), contentFont, 0, 4, Float.valueOf(30.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable4, "\u4ed8\u6b3e\u65b9\u5f0f", contentFont, 0, 4, Float.valueOf(30.0f), 3, 2);
        PdfUtil.addCellToTable(pdfPTable4, this.convertNullToString(contractDetailQueryAbilityRspBO.getPayTypeStr()), contentFont, 0, 4, Float.valueOf(30.0f), 3, null);
        PdfPTable pdfPTable5 = new PdfPTable(24);
        tableList.add(pdfPTable5);
        PdfUtil.addCellToTable(pdfPTable5, "\u65b0\u4f9b\u5e94\u5546", contentFont, 0, 4, Float.valueOf(30.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable5, this.convertNullToString(contractDetailQueryAbilityRspBO.getIsNewSupplierStr()), contentFont, 0, 4, Float.valueOf(50.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable5, "\u65b0\u54c1\u724c", contentFont, 0, 4, Float.valueOf(30.0f), 3, 2);
        PdfUtil.addCellToTable(pdfPTable5, this.convertNullToString(contractDetailQueryAbilityRspBO.getIsNewBrandStr()), contentFont, 0, 4, Float.valueOf(50.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable5, "\u5236\u5355\u4eba", contentFont, 0, 4, Float.valueOf(30.0f), 3, 2);
        PdfUtil.addCellToTable(pdfPTable5, this.convertNullToString(contractDetailQueryAbilityRspBO.getCreateUserName()), contentFont, 0, 4, Float.valueOf(50.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable5, "\u5236\u5355\u5355\u4f4d", contentFont, 0, 4, Float.valueOf(30.0f), 3, 2);
        PdfUtil.addCellToTable(pdfPTable5, this.convertNullToString(contractDetailQueryAbilityRspBO.getCreateDeptName()), contentFont, 0, 4, Float.valueOf(50.0f), 3, null);
        PdfPTable pdfPTable6 = new PdfPTable(8);
        tableList.add(pdfPTable6);
        PdfUtil.addCellToTable(pdfPTable6, "\u91c7\u8d2d\u65b9\u5f0f", contentFont, 0, 4, Float.valueOf(30.0f), 3, 2);
        PdfUtil.addCellToTable(pdfPTable6, this.convertNullToString(contractDetailQueryAbilityRspBO.getPurchaseTypeStr()), contentFont, 0, 4, Float.valueOf(30.0f), 3, null);
        PdfPTable pdfPTable7 = new PdfPTable(3);
        tableList.add(pdfPTable7);
        PdfUtil.addCellToTable(pdfPTable7, "\u4f1a\u7b7e\u8bb0\u5f55", contentFont, 0, 4, Float.valueOf(30.0f), 3, null);
        PdfPTable pdfPTable8 = new PdfPTable(20);
        tableList.add(pdfPTable8);
        PdfUtil.addCellToTable(pdfPTable8, "\u5e8f\u53f7", contentFont, 0, 4, Float.valueOf(30.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u59d3\u540d", contentFont, 0, 4, Float.valueOf(30.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u6240\u5c5e\u7ec4\u7ec7\u673a\u6784", contentFont, 0, 4, Float.valueOf(30.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u4e1a\u52a1\u884c\u4e3a", contentFont, 0, 4, Float.valueOf(30.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u5ba1\u6279\u610f\u89c1", contentFont, 0, 4, Float.valueOf(30.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u64cd\u4f5c\u65f6\u95f4", contentFont, 0, 4, Float.valueOf(30.0f), 3, null);
        PdfUtil.addCellToTable(pdfPTable8, "\u5386\u65f6", contentFont, 0, 4, Float.valueOf(30.0f), 3, null);
        if (!CollectionUtils.isEmpty((Collection)auditLogs)) {
            for (int i = auditLogs.size() - 1; i >= 0; --i) {
                String audit = ((ContractQryAuditLogBO)auditLogs.get(i)).getAudit();
                if (!"\u63d0\u4ea4".equals(audit) && !"\u8d77\u8349".equals(audit)) continue;
                int num = 1;
                for (int j = i; j < auditLogs.size(); ++j) {
                    PdfPTable pdfPTableI = new PdfPTable(20);
                    tableList.add(pdfPTableI);
                    PdfUtil.addCellToTable(pdfPTableI, String.valueOf(num++), contentFont, 0, 4, Float.valueOf(30.0f), 3, null);
                    PdfUtil.addCellToTable(pdfPTableI, this.convertNullToString(((ContractQryAuditLogBO)auditLogs.get(j)).getOperName()), contentFont, 0, 4, Float.valueOf(30.0f), 3, null);
                    PdfUtil.addCellToTable(pdfPTableI, this.convertNullToString(((ContractQryAuditLogBO)auditLogs.get(j)).getOperDept()), contentFont, 0, 4, Float.valueOf(30.0f), 3, null);
                    PdfUtil.addCellToTable(pdfPTableI, this.convertNullToString(((ContractQryAuditLogBO)auditLogs.get(j)).getAudit()), contentFont, 0, 4, Float.valueOf(30.0f), 3, null);
                    PdfUtil.addCellToTable(pdfPTableI, this.convertNullToString(((ContractQryAuditLogBO)auditLogs.get(j)).getAuditAdvice()), contentFont, 0, 4, Float.valueOf(30.0f), 3, null);
                    String dealTime = "";
                    if (((ContractQryAuditLogBO)auditLogs.get(j)).getDealTime() != null) {
                        dealTime = DateUtils.dateToStr(((ContractQryAuditLogBO)auditLogs.get(j)).getDealTime());
                    }
                    PdfUtil.addCellToTable(pdfPTableI, this.convertNullToString(dealTime), contentFont, 0, 4, Float.valueOf(30.0f), 3, null);
                    PdfUtil.addCellToTable(pdfPTableI, this.convertNullToString(((ContractQryAuditLogBO)auditLogs.get(j)).getProcessTimeStr()), contentFont, 0, 4, Float.valueOf(30.0f), 3, null);
                }
                break;
            }
        }
        PdfUtil.addTableListToDoc(document, tableList);
        document.close();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        String fileName = "\u96c6\u91c7\u5408\u540c\u4f1a\u7b7e\u5355" + System.currentTimeMillis() + ".pdf";
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        String exportUrl = null;
        if (FILE_TYPE_OSS.equals(this.fileType)) {
            exportUrl = this.ossFileUrl + path;
        } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            exportUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u8be5\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        rspBo.setPrintUrl(exportUrl);
        try {
            Thread.sleep(1500L);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return rspBo;
    }

    private String convertNullToString(Object obj) {
        if (obj == null) {
            return "";
        }
        return String.valueOf(obj);
    }
}

