/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.ContractDownloadSignDocumentAbilityService;
import com.tydic.contract.ability.ContractHandReplaceCAZipAbilityService;
import com.tydic.contract.ability.bo.ContractDownloadSignDocumentAbilityReqBO;
import com.tydic.contract.ability.bo.ContractDownloadSignDocumentAbilityRspBO;
import com.tydic.contract.ability.bo.ContractHandReplaceCAZipReqBO;
import com.tydic.contract.ability.bo.ContractRspBaseBO;
import com.tydic.contract.atom.InterFaceContractGetEnvelopesDetailAtomService;
import com.tydic.contract.atom.InterFaceContractSignAccessTokenCreateAtomService;
import com.tydic.contract.atom.bo.EnvelopeContentAtomBO;
import com.tydic.contract.atom.bo.InterFaceContractGetEnvelopesDetailAtomReqBO;
import com.tydic.contract.atom.bo.InterFaceContractGetEnvelopesDetailAtomRspBO;
import com.tydic.contract.atom.bo.InterFaceContractSignAccessTokenCreateAtomReqBO;
import com.tydic.contract.atom.bo.InterFaceContractSignAccessTokenCreateAtomRspBO;
import com.tydic.contract.dao.CContractSignFileMapper;
import com.tydic.contract.dao.CContractSignInitiatorInfoMapper;
import com.tydic.contract.dao.ContractAccessoryMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.CContractSignFilePO;
import com.tydic.contract.po.CContractSignInitiatorInfoPO;
import com.tydic.contract.po.ContractAccessoryPo;
import com.tydic.contract.po.ContractInfoPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractHandReplaceCAZipAbilityService"})
public class ContractHandReplaceCAZipAbilityServiceImpl
implements ContractHandReplaceCAZipAbilityService {
    private static final Logger log = LoggerFactory.getLogger(ContractHandReplaceCAZipAbilityServiceImpl.class);
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private InterFaceContractSignAccessTokenCreateAtomService interFaceContractSignAccessTokenCreateAtomService;
    @Autowired
    private CContractSignInitiatorInfoMapper cContractSignInitiatorInfoMapper;
    @Autowired
    private InterFaceContractGetEnvelopesDetailAtomService interFaceContractGetEnvelopesDetailAtomService;
    @Autowired
    private CContractSignFileMapper cContractSignFileMapper;
    @Autowired
    private ContractDownloadSignDocumentAbilityService contractDownloadSignDocumentAbilityService;
    @Autowired
    private ContractAccessoryMapper contractAccessoryMapper;

    @PostMapping(value={"handReplaceCAZip"})
    public ContractRspBaseBO handReplaceCAZip(@RequestBody ContractHandReplaceCAZipReqBO reqBO) {
        ContractRspBaseBO rspBaseBO = new ContractRspBaseBO();
        List<Object> contractInfoList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getContractId())) {
            contractInfoList = this.contractInfoMapper.getListByContractIds(reqBO.getContractId());
        } else if (!CollectionUtils.isEmpty((Collection)reqBO.getContractCode())) {
            contractInfoList = this.contractInfoMapper.getListByContractCodes(reqBO.getContractCode());
        } else {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(contractInfoList)) {
            throw new ZTBusinessException("\u67e5\u8be2\u5408\u540c\u4e3a\u7a7a");
        }
        Set collect = contractInfoList.stream().map(ContractInfoPO::getSignInitiatorInfoSocCreCode).collect(Collectors.toSet());
        ArrayList<String> socCreCodes = new ArrayList<String>(collect);
        List<CContractSignInitiatorInfoPO> signInitiatorInfoPOS = this.cContractSignInitiatorInfoMapper.selectBySocCreCodes(socCreCodes);
        if (CollectionUtils.isEmpty(signInitiatorInfoPOS)) {
            throw new ZTBusinessException("\u53d1\u8d77\u65b9\u4fe1\u606f\u67e5\u8be2\u4e3a\u7a7a\uff01");
        }
        Map<String, List<CContractSignInitiatorInfoPO>> socCreCodeMap = signInitiatorInfoPOS.stream().collect(Collectors.groupingBy(CContractSignInitiatorInfoPO::getSocCreCode));
        for (ContractInfoPO contractInfoPO : contractInfoList) {
            if (!socCreCodeMap.keySet().contains(contractInfoPO.getSignInitiatorInfoSocCreCode())) {
                log.error("\u5408\u540cid\uff1a" + contractInfoPO.getContractId() + "\u5bf9\u5e94\u53d1\u8d77\u65b9\u4fe1\u606f\u6ca1\u6709\u67e5\u8be2\u5230");
                continue;
            }
            CContractSignInitiatorInfoPO signInitiatorInfoPO = socCreCodeMap.get(contractInfoPO.getSignInitiatorInfoSocCreCode()).get(0);
            if (StringUtils.isEmpty((Object)signInitiatorInfoPO.getClientId()) || StringUtils.isEmpty((Object)signInitiatorInfoPO.getSecret())) {
                log.error("\u5408\u540cid\uff1a" + contractInfoPO.getContractId() + "\u5bf9\u5e94\u53d1\u8d77\u65b9\u4fe1\u606f\u4e2d\u7684\u5e94\u7528(clientId&&secret)\u4e3a\u7a7a");
                continue;
            }
            String accessToken = this.getAccessToken(signInitiatorInfoPO.getClientId(), signInitiatorInfoPO.getSecret());
            InterFaceContractGetEnvelopesDetailAtomReqBO atomReqBO = new InterFaceContractGetEnvelopesDetailAtomReqBO();
            atomReqBO.setEnvelopeId(contractInfoPO.getEnvelopeId());
            atomReqBO.setAccessToken(accessToken);
            InterFaceContractGetEnvelopesDetailAtomRspBO atomRspBO = this.interFaceContractGetEnvelopesDetailAtomService.getEnvelopesDetail(atomReqBO);
            if ("0000".equals(atomRspBO.getRespCode())) {
                if (atomRspBO.getEnvelopeBasicInfo() == null) {
                    throw new ZTBusinessException("\u4fe1\u5c01\u57fa\u672c\u4fe1\u606f\u4e3a\u7a7a");
                }
                CContractSignFilePO qryPo = new CContractSignFilePO();
                qryPo.setEnvelopeId(contractInfoPO.getEnvelopeId());
                List<CContractSignFilePO> signFilePOList = this.cContractSignFileMapper.queryAllByCondition(qryPo);
                if (CollectionUtils.isEmpty(signFilePOList)) continue;
                this.replaceFile(contractInfoPO.getEnvelopeId(), accessToken, atomRspBO.getEnvelopeContents(), signFilePOList);
                continue;
            }
            log.error("\u5408\u540cid\uff1a" + contractInfoPO.getContractId() + "\u67e5\u8be2\u4fe1\u5c01\u5931\u8d25");
        }
        return rspBaseBO;
    }

    public void replaceFile(Long envelopeId, String accessToken, List<EnvelopeContentAtomBO> envelopeContents, List<CContractSignFilePO> signFilePOList) {
        log.error("\u4fe1\u5c01\u8fd4\u56de\u9644\u4ef6\u4fe1\u606f\uff1a" + JSON.toJSONString(envelopeContents));
        if (!CollectionUtils.isEmpty(envelopeContents)) {
            Map<Long, CContractSignFilePO> signFileMap = signFilePOList.stream().collect(Collectors.toMap(CContractSignFilePO::getFileId, bo -> bo, (k1, k2) -> k1));
            for (EnvelopeContentAtomBO envelopeContent : envelopeContents) {
                ContractDownloadSignDocumentAbilityReqBO signDocumentAbilityReqBO = new ContractDownloadSignDocumentAbilityReqBO();
                signDocumentAbilityReqBO.setEnvelopeId(envelopeId);
                signDocumentAbilityReqBO.setAccessToken(accessToken);
                signDocumentAbilityReqBO.setFileId(envelopeContent.getId());
                ContractDownloadSignDocumentAbilityRspBO contractDownloadSignDocumentAbilityRspBO = this.contractDownloadSignDocumentAbilityService.downloadSignDocument(signDocumentAbilityReqBO);
                if ("0000".equals(contractDownloadSignDocumentAbilityRspBO.getRespCode())) {
                    String fileUrl = contractDownloadSignDocumentAbilityRspBO.getFileUrl();
                    if (signFileMap.get(envelopeContent.getFileId()) == null) continue;
                    CContractSignFilePO cContractSignFilePO = signFileMap.get(envelopeContent.getFileId());
                    if (cContractSignFilePO.getFileType() == 1 || cContractSignFilePO.getFileType() == 3) {
                        ContractInfoPO updatePO = new ContractInfoPO();
                        updatePO.setContractId(cContractSignFilePO.getRelateId());
                        if (cContractSignFilePO.getFileType() == 1) {
                            updatePO.setContractDocUrl(fileUrl);
                        }
                        if (cContractSignFilePO.getFileType() == 3) {
                            updatePO.setItemPdfAccessoryUrl(fileUrl);
                        }
                        this.contractInfoMapper.updateContract(updatePO);
                        continue;
                    }
                    if (cContractSignFilePO.getFileType() == 2) {
                        ContractAccessoryPo updatePo = new ContractAccessoryPo();
                        updatePo.setAcceessoryId(cContractSignFilePO.getRelateId());
                        updatePo.setAcceessoryUrl(fileUrl);
                        this.contractAccessoryMapper.updateByPrimaryKeySelective(updatePo);
                        continue;
                    }
                    throw new ZTBusinessException("\u9644\u4ef6\u7c7b\u578b\u4e0d\u7b26\u5408");
                }
                throw new ZTBusinessException(contractDownloadSignDocumentAbilityRspBO.getRespDesc());
            }
        } else {
            throw new ZTBusinessException("\u4fe1\u5c01\u9644\u4ef6\u8fd4\u56de\u4e3a\u7a7a");
        }
    }

    private String getAccessToken(String clientId, String secret) {
        String accessToken = null;
        InterFaceContractSignAccessTokenCreateAtomReqBO signAccessTokenCreateAtomReqBO = new InterFaceContractSignAccessTokenCreateAtomReqBO();
        signAccessTokenCreateAtomReqBO.setClientId(clientId);
        signAccessTokenCreateAtomReqBO.setSecret(secret);
        InterFaceContractSignAccessTokenCreateAtomRspBO signAccessTokenCreateAtomRspBO = this.interFaceContractSignAccessTokenCreateAtomService.signAccessTokenCreate(signAccessTokenCreateAtomReqBO);
        if (!"0000".equals(signAccessTokenCreateAtomRspBO.getRespCode())) {
            throw new ZTBusinessException(signAccessTokenCreateAtomRspBO.getRespDesc());
        }
        accessToken = signAccessTokenCreateAtomRspBO.getAccessToken();
        return accessToken;
    }
}

