/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.ContractHtQryListAbilityService;
import com.tydic.contract.ability.bo.ContractHtItemQryListAbilityBO;
import com.tydic.contract.ability.bo.ContractHtItemQryListAbilityReqBO;
import com.tydic.contract.ability.bo.ContractHtItemQryListAbilityRspBO;
import com.tydic.contract.ability.bo.ContractHtQryListAbilityBO;
import com.tydic.contract.ability.bo.ContractHtQryListAbilityReqBO;
import com.tydic.contract.ability.bo.ContractHtQryListAbilityRspBO;
import com.tydic.contract.dao.CRelBuySaleContractMapper;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.CRelBuySaleContractPO;
import com.tydic.contract.po.ContractInfoItemPO;
import com.tydic.contract.po.ContractInfoPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractHtQryListAbilityService"})
public class ContractHtQryListAbilityServiceImpl
implements ContractHtQryListAbilityService {
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private CRelBuySaleContractMapper cRelBuySaleContractMapper;
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;

    @PostMapping(value={"qryHTList"})
    public ContractHtQryListAbilityRspBO qryHTList(@RequestBody ContractHtQryListAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getContractIds())) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<ContractInfoPO> contractInfoPOS = this.contractInfoMapper.getListByContractIds(reqBO.getContractIds());
        Map<Object, Object> contractIdMap = new HashMap();
        if (!CollectionUtils.isEmpty(contractInfoPOS)) {
            contractIdMap = contractInfoPOS.stream().collect(Collectors.toMap(ContractInfoPO::getContractId, o -> o));
        }
        ArrayList<ContractHtQryListAbilityBO> infoList = new ArrayList<ContractHtQryListAbilityBO>();
        for (Long contractId : reqBO.getContractIds()) {
            ContractHtQryListAbilityBO bo = new ContractHtQryListAbilityBO();
            bo.setContractId(contractId);
            if (contractIdMap.containsKey(contractId)) {
                bo.setContractCode(((ContractInfoPO)contractIdMap.get(contractId)).getContractCode());
                bo.setOutContractId(((ContractInfoPO)contractIdMap.get(contractId)).getOutContractId());
                bo.setOutContractUuId(((ContractInfoPO)contractIdMap.get(contractId)).getOutContractUuId());
            }
            infoList.add(bo);
        }
        ContractHtQryListAbilityRspBO rspBO = new ContractHtQryListAbilityRspBO();
        rspBO.setInfoList(infoList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"qryHtItemList"})
    public ContractHtItemQryListAbilityRspBO qryHtItemList(@RequestBody ContractHtItemQryListAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getItemIdList())) {
            throw new ZTBusinessException("\u5165\u53c2[itemIdList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<CRelBuySaleContractPO> relBuySaleContractPOS = this.cRelBuySaleContractMapper.getListBuySaleItemIds(reqBO.getItemIdList());
        HashMap<Long, Long> saleItemIdMap = new HashMap<Long, Long>();
        if (!CollectionUtils.isEmpty(relBuySaleContractPOS)) {
            for (CRelBuySaleContractPO relBuySaleContractPO : relBuySaleContractPOS) {
                saleItemIdMap.put(relBuySaleContractPO.getSaleItemId(), relBuySaleContractPO.getBuyItemId());
                reqBO.getItemIdList().add(relBuySaleContractPO.getBuyItemId());
            }
        }
        Map<Object, Object> itemIdMap = new HashMap();
        List<ContractInfoItemPO> contractInfoItemPOS = this.contractInfoItemMapper.selectListByItemIds(reqBO.getItemIdList());
        if (!CollectionUtils.isEmpty(contractInfoItemPOS)) {
            itemIdMap = contractInfoItemPOS.stream().filter(e -> !StringUtils.isEmpty((Object)e.getOutItemId())).collect(Collectors.toMap(ContractInfoItemPO::getItemId, ContractInfoItemPO::getOutItemId));
        }
        ArrayList<ContractHtItemQryListAbilityBO> itemList = new ArrayList<ContractHtItemQryListAbilityBO>();
        for (Long itemId : reqBO.getItemIdList()) {
            ContractHtItemQryListAbilityBO bo = new ContractHtItemQryListAbilityBO();
            bo.setItemId(itemId);
            String outItemId = null;
            outItemId = saleItemIdMap.containsKey(itemId) ? (String)itemIdMap.get(saleItemIdMap.get(itemId)) : (String)itemIdMap.get(itemId);
            bo.setOutItemId(outItemId);
            itemList.add(bo);
        }
        ContractHtItemQryListAbilityRspBO rspBO = new ContractHtItemQryListAbilityRspBO();
        rspBO.setItemList(itemList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

