/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.ContractSaveStockTempAbilityService;
import com.tydic.contract.ability.ContractWmsStockListQryAbilityService;
import com.tydic.contract.ability.bo.ContractSaveStockTempReqBo;
import com.tydic.contract.ability.bo.ContractSaveStockTempReqBoMaterialList;
import com.tydic.contract.ability.bo.ContractSaveStockTempRspBo;
import com.tydic.contract.busi.ContractSaveStockTempBusiService;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.umc.general.ability.api.UmcEnterpriseQryListAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgDetailBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseQryListAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseQryListAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractSaveStockTempAbilityService"})
public class ContractSaveStockTempAbilityServiceImpl
implements ContractSaveStockTempAbilityService {
    @Autowired
    private ContractSaveStockTempBusiService contractSaveStockTempBusiService;
    @Autowired
    private ContractWmsStockListQryAbilityService contractWmsStockListQryAbilityService;
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private UmcEnterpriseQryListAbilityService umcEnterpriseQryListAbilityService;
    private static final Integer purchaseOrgIdIndex = 1;
    private static final Integer supplierCodeIndex = 2;

    @PostMapping(value={"saveStockTemp"})
    public ContractSaveStockTempRspBo saveStockTemp(@RequestBody ContractSaveStockTempReqBo reqBo) {
        this.checkReqBO(reqBo);
        return this.contractSaveStockTempBusiService.saveStockTemp(reqBo);
    }

    private void checkReqBO(ContractSaveStockTempReqBo reqBo) {
        if (reqBo == null) {
            throw new RuntimeException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getContractId() == null) {
            throw new ZTBusinessException("\u5165\u53c2[contractId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getTempId() == null) {
            throw new ZTBusinessException("\u5165\u53c2[tempId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getIsQryAllAdd() == null || reqBo.getIsQryAllAdd() != 1) {
            if (CollectionUtils.isEmpty((Collection)reqBo.getMaterialList())) {
                throw new RuntimeException("\u5165\u53c2[materialList]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            for (ContractSaveStockTempReqBoMaterialList bo : reqBo.getMaterialList()) {
                if (bo.getItemId() == null) {
                    throw new ZTBusinessException("\u5165\u53c2[materialList.itemId]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isEmpty((Object)bo.getErpOrgId())) {
                    throw new ZTBusinessException("\u5165\u53c2[materialList.erpOrgId]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isEmpty((Object)bo.getSupplierCode())) {
                    throw new ZTBusinessException("\u5165\u53c2[materialList.supplierCode]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isEmpty((Object)bo.getSupplierName())) {
                    throw new ZTBusinessException("\u5165\u53c2[materialList.supplierName]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isEmpty((Object)bo.getWarehouseCode())) {
                    throw new ZTBusinessException("\u5165\u53c2[materialList.warehouseCode]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (bo.getSafeNum() == null) {
                    throw new ZTBusinessException("\u5165\u53c2[materialList.safeNum]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (bo.getLimitNum() == null) {
                    throw new ZTBusinessException("\u5165\u53c2[materialList.limitNum]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (bo.getTempId() != null) continue;
                throw new ZTBusinessException("\u5165\u53c2[materialList.tempId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }

    private Map<Integer, String> getErpOrgCode(Long contractId) {
        String purchaseOrgId = null;
        String supplierCode = null;
        ContractInfoPO contractInfoPO = this.contractInfoMapper.selectByPrimaryKey(contractId);
        if (contractInfoPO == null) {
            throw new ZTBusinessException("\u5408\u540c\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isEmpty((Object)contractInfoPO.getBuyerNo())) {
            throw new ZTBusinessException("\u4e70\u53d7\u4eba\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)contractInfoPO.getSupplierId())) {
            throw new ZTBusinessException("\u4f9b\u5e94\u5546id\u4e3a\u7a7a");
        }
        ArrayList<String> buyerNoList = new ArrayList<String>();
        buyerNoList.add(contractInfoPO.getBuyerNo());
        ArrayList<Long> supplierIdList = new ArrayList<Long>();
        supplierIdList.add(contractInfoPO.getSupplierId());
        UmcEnterpriseQryListAbilityReqBO abilityReqBO = new UmcEnterpriseQryListAbilityReqBO();
        abilityReqBO.setOrgCodeWebList(buyerNoList);
        abilityReqBO.setOrgIdWebList(supplierIdList);
        UmcEnterpriseQryListAbilityRspBO abilityRspBO = this.umcEnterpriseQryListAbilityService.qryList(abilityReqBO);
        if (!"0000".equals(abilityRspBO.getRespCode())) {
            throw new ZTBusinessException("\u67e5\u8be2erp\u7f16\u7801\u4fe1\u606f\u5931\u8d25" + abilityRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)abilityRspBO.getRows())) {
            throw new ZTBusinessException("\u67e5\u8be2erp\u7f16\u7801\u4fe1\u606f\u7ed3\u679c\u4e3a\u7a7a");
        }
        Map<Long, UmcEnterpriseOrgDetailBO> orgIdMap = abilityRspBO.getRows().stream().collect(Collectors.toMap(UmcEnterpriseOrgDetailBO::getOrgId, o -> o));
        Map<String, UmcEnterpriseOrgDetailBO> orgCodeMap = abilityRspBO.getRows().stream().collect(Collectors.toMap(UmcEnterpriseOrgDetailBO::getOrgCode, o -> o));
        if (orgIdMap.containsKey(contractInfoPO.getSupplierId())) {
            supplierCode = orgIdMap.get(contractInfoPO.getSupplierId()).getErpOrgCode();
        }
        if (StringUtils.isEmpty(supplierCode)) {
            throw new ZTBusinessException("\u5408\u540c\u4f9b\u5e94\u5546\u673a\u6784\u4fe1\u606f\u672a\u5b58\u5728erp\u5355\u4f4d\u7f16\u7801\u8bf7\u8054\u7cfb\u7ef4\u62a4");
        }
        if (orgCodeMap.containsKey(contractInfoPO.getBuyerNo())) {
            purchaseOrgId = orgCodeMap.get(contractInfoPO.getBuyerNo()).getErpOrgCode();
        }
        if (StringUtils.isEmpty(purchaseOrgId)) {
            throw new ZTBusinessException("\u5408\u540c\u4e70\u53d7\u4eba\u6784\u4fe1\u606f\u672a\u5b58\u5728erp\u5355\u4f4d\u7f16\u7801\u8bf7\u8054\u7cfb\u7ef4\u62a4");
        }
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(purchaseOrgIdIndex, purchaseOrgId);
        map.put(supplierCodeIndex, supplierCode);
        return map;
    }
}

