/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.contract.ability.ContractWorkbenchStageAbilityService;
import com.tydic.contract.ability.bo.ContractWorkbenchStageAbilityReqBO;
import com.tydic.contract.ability.bo.ContractWorkbenchStageAbilityRspBO;
import com.tydic.contract.ability.bo.ContractWorkbenchStageBO;
import com.tydic.contract.ability.bo.ContractWorkbenchStageItemBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.dao.UocOrdTaskMapper;
import com.tydic.contract.po.ContractInfoItemPO;
import com.tydic.contract.po.UocOrdTaskPo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractWorkbenchStageAbilityService"})
public class ContractWorkbenchStageAbilityServiceImpl
implements ContractWorkbenchStageAbilityService {
    private static final Logger log = LoggerFactory.getLogger(ContractWorkbenchStageAbilityServiceImpl.class);
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;
    @Autowired
    private UocOrdTaskMapper uocOrdTaskMapper;
    private static final List<Integer> approvalPassList = Arrays.asList(ContractConstant.ContractStatus.CONTRACT_PENDING_SUBMISSION, ContractConstant.ContractStatus.CONTRACT_FIRST_PARTY_WAIT_SIGNATURE, ContractConstant.ContractStatus.CONTRACT_SECOND_PARTY_WAIT_SIGNATURE, ContractConstant.ContractStatus.CONTRACT_THIRD_PARTY_WAIT_SIGNATURE, ContractConstant.ContractStatus.CONTRACT_STATUS_CHANGE_APPLY, ContractConstant.ContractStatus.CONTRACT_STATUS_CHANGE_APPROVAL_OK, ContractConstant.ContractStatus.CONTRACT_STATUS_ABOLISH, ContractConstant.ContractStatus.CONTRACT_STATUS_APPROVAL, ContractConstant.ContractStatus.CONTRACT_STATUS_FAILUSER);

    @PostMapping(value={"qryContractStage"})
    public ContractWorkbenchStageAbilityRspBO qryContractStage(@RequestBody ContractWorkbenchStageAbilityReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getPackId())) {
            throw new BusinessException("8888", "\u5165\u53c2 packId \u4e0d\u80fd\u4e3a\u7a7a");
        }
        ContractWorkbenchStageAbilityRspBO rspBO = new ContractWorkbenchStageAbilityRspBO();
        rspBO.setRespCode("0000");
        ContractInfoItemPO record = new ContractInfoItemPO();
        record.setPackId(reqBO.getPackId());
        record.setLimit(10);
        List<ContractInfoItemPO> list = this.contractInfoItemMapper.getListLimit(record);
        if (!CollectionUtil.isEmpty(list)) {
            List approvalPassList;
            Map<Long, ContractInfoItemPO> contractListMap = list.stream().collect(Collectors.toMap(ContractInfoItemPO::getContractId, o -> o));
            List rows = list.stream().map(e -> {
                ContractWorkbenchStageBO workbenchStageBO = new ContractWorkbenchStageBO();
                workbenchStageBO.setItemCode(e.getContractCode());
                workbenchStageBO.setItemName(e.getContractName());
                workbenchStageBO.setContractId(e.getContractId());
                return workbenchStageBO;
            }).collect(Collectors.toList());
            ArrayList<Object> excludeList = new ArrayList<Object>();
            ArrayList<Long> approvalQryLogList = new ArrayList<Long>();
            List<Object> effectiveIds = new ArrayList();
            List<Object> approvalIds = new ArrayList();
            List effectiveList = list.stream().filter(e -> !ObjectUtil.isEmpty((Object)e.getContractEffectiveDate())).collect(Collectors.toList());
            if (!CollectionUtil.isEmpty(effectiveList)) {
                effectiveIds = effectiveList.stream().map(ContractInfoItemPO::getContractId).collect(Collectors.toList());
                excludeList.addAll(effectiveIds);
                approvalQryLogList.addAll(effectiveIds);
            }
            if (!CollectionUtil.isEmpty(approvalPassList = list.stream().filter(e -> approvalPassList.contains(e.getContractStatus()) && ObjectUtil.isEmpty((Object)e.getContractEffectiveDate())).collect(Collectors.toList()))) {
                approvalIds = approvalPassList.stream().map(ContractInfoItemPO::getContractId).collect(Collectors.toList());
                excludeList.addAll(approvalIds);
                approvalQryLogList.addAll(approvalIds);
            }
            Map<Object, Object> taskPoMap = new HashMap();
            if (!CollectionUtil.isEmpty(approvalQryLogList)) {
                UocOrdTaskPo taskPo = new UocOrdTaskPo();
                taskPo.setOrderIdList(approvalQryLogList);
                List<UocOrdTaskPo> taskPoList = this.uocOrdTaskMapper.getDoneList(taskPo);
                if (!CollectionUtil.isEmpty(taskPoList)) {
                    taskPoMap = taskPoList.stream().collect(Collectors.toMap(UocOrdTaskPo::getOrderId, o -> o));
                }
            }
            for (ContractWorkbenchStageBO row : rows) {
                ArrayList<ContractWorkbenchStageItemBO> contractWorkbenchStageItemBOS = new ArrayList<ContractWorkbenchStageItemBO>();
                UocOrdTaskPo ordTaskPo = (UocOrdTaskPo)taskPoMap.get(row.getContractId());
                ContractWorkbenchStageAbilityServiceImpl.getCreateStage(row, contractListMap, contractWorkbenchStageItemBOS);
                if (effectiveIds.contains(row.getContractId())) {
                    this.getApprovalStage(row, contractListMap, contractWorkbenchStageItemBOS, ordTaskPo, true);
                    this.getEffectiveState(row, contractListMap, contractWorkbenchStageItemBOS, true);
                } else if (approvalIds.contains(row.getContractId())) {
                    this.getApprovalStage(row, contractListMap, contractWorkbenchStageItemBOS, ordTaskPo, true);
                    this.getEffectiveState(row, contractListMap, contractWorkbenchStageItemBOS, false);
                } else {
                    this.getApprovalStage(row, contractListMap, contractWorkbenchStageItemBOS, ordTaskPo, false);
                    this.getEffectiveState(row, contractListMap, contractWorkbenchStageItemBOS, false);
                }
                row.setStageItemList(contractWorkbenchStageItemBOS);
            }
            rspBO.setRows(rows);
        }
        log.info("\u67e5\u8be2\u51fa\u53c2 {}", (Object)JSON.toJSONString((Object)rspBO));
        return rspBO;
    }

    private void getEffectiveState(ContractWorkbenchStageBO row, Map<Long, ContractInfoItemPO> contractListMap, List<ContractWorkbenchStageItemBO> contractWorkbenchStageItemBOS, Boolean flag) {
        ContractInfoItemPO contract = contractListMap.get(row.getContractId());
        ContractWorkbenchStageItemBO workbenchStageItemBO = new ContractWorkbenchStageItemBO();
        workbenchStageItemBO.setStageItemCode(ContractConstant.ContractWorkbenchEnum.CONTRACT_EFFECTIVE.getCode());
        workbenchStageItemBO.setStageItemName(ContractConstant.ContractWorkbenchEnum.CONTRACT_EFFECTIVE.getTitle());
        workbenchStageItemBO.setSort(ContractConstant.ContractWorkbenchEnum.CONTRACT_EFFECTIVE.getSort());
        if (flag.booleanValue()) {
            workbenchStageItemBO.setStageOperName(contract.getCreateUserName());
            workbenchStageItemBO.setStageOperTime(contract.getContractEffectiveDate());
            workbenchStageItemBO.setCompleteFlag(Integer.valueOf(1));
        } else {
            workbenchStageItemBO.setCompleteFlag(Integer.valueOf(0));
        }
        contractWorkbenchStageItemBOS.add(workbenchStageItemBO);
    }

    private void getApprovalStage(ContractWorkbenchStageBO row, Map<Long, ContractInfoItemPO> contractListMap, List<ContractWorkbenchStageItemBO> contractWorkbenchStageItemBOS, UocOrdTaskPo ordTaskPo, Boolean flag) {
        ContractWorkbenchStageItemBO workbenchStageItemBO = new ContractWorkbenchStageItemBO();
        workbenchStageItemBO.setStageItemCode(ContractConstant.ContractWorkbenchEnum.CONTRACT_APPROVAL.getCode());
        workbenchStageItemBO.setStageItemName(ContractConstant.ContractWorkbenchEnum.CONTRACT_APPROVAL.getTitle());
        workbenchStageItemBO.setSort(ContractConstant.ContractWorkbenchEnum.CONTRACT_APPROVAL.getSort());
        if (flag.booleanValue()) {
            workbenchStageItemBO.setStageOperTime(ordTaskPo.getFinishTime());
            workbenchStageItemBO.setStageOperName("\u9a73\u56de");
            if (0 == ordTaskPo.getAuditResult()) {
                workbenchStageItemBO.setStageOperName("\u901a\u8fc7");
            }
            workbenchStageItemBO.setCompleteFlag(Integer.valueOf(1));
        } else {
            workbenchStageItemBO.setCompleteFlag(Integer.valueOf(0));
        }
        contractWorkbenchStageItemBOS.add(workbenchStageItemBO);
    }

    private static void getCreateStage(ContractWorkbenchStageBO row, Map<Long, ContractInfoItemPO> contractListMap, List<ContractWorkbenchStageItemBO> contractWorkbenchStageItemBOS) {
        ContractInfoItemPO contract = contractListMap.get(row.getContractId());
        ContractWorkbenchStageItemBO workbenchStageItemBO = new ContractWorkbenchStageItemBO();
        workbenchStageItemBO.setStageItemCode(ContractConstant.ContractWorkbenchEnum.CONTRACT_CREATE.getCode());
        workbenchStageItemBO.setStageItemName(ContractConstant.ContractWorkbenchEnum.CONTRACT_CREATE.getTitle());
        workbenchStageItemBO.setSort(ContractConstant.ContractWorkbenchEnum.CONTRACT_CREATE.getSort());
        workbenchStageItemBO.setStageOperName(contract.getCreateUserName());
        workbenchStageItemBO.setStageOperTime(contract.getCreateTime());
        workbenchStageItemBO.setCompleteFlag(Integer.valueOf(1));
        contractWorkbenchStageItemBOS.add(workbenchStageItemBO);
    }
}

