/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.atom.ContractUpdateOrderStatusAtomService;
import com.tydic.contract.atom.bo.ContractUpdateOrderStatusAtomBO;
import com.tydic.contract.atom.bo.ContractUpdateOrderStatusAtomReqBO;
import com.tydic.contract.atom.bo.ContractUpdateOrderStatusAtomRspBO;
import com.tydic.contract.dao.CContractOrderInfoMapper;
import com.tydic.contract.po.CContractOrderInfoPO;
import com.tydic.uoc.common.ability.api.PebUpdateOrderAbilityService;
import com.tydic.uoc.common.ability.bo.PebUpdateOrderReqBO;
import com.tydic.uoc.common.ability.bo.PebUpdateOrderRspBO;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ContractUpdateOrderStatusAtomServiceImpl
implements ContractUpdateOrderStatusAtomService {
    private static final Logger log = LoggerFactory.getLogger(ContractUpdateOrderStatusAtomServiceImpl.class);
    @Autowired
    private PebUpdateOrderAbilityService pebUpdateOrderAbilityService;
    @Autowired
    private CContractOrderInfoMapper cContractOrderInfoMapper;

    @Override
    public ContractUpdateOrderStatusAtomRspBO updateOrderStatus(ContractUpdateOrderStatusAtomReqBO reqBO) {
        ContractUpdateOrderStatusAtomRspBO rspBO = new ContractUpdateOrderStatusAtomRspBO();
        if (!CollectionUtils.isEmpty(reqBO.getUpdateBOS())) {
            List<Long> qryOrderIds = reqBO.getUpdateBOS().stream().filter(e -> e.getSaleVoucherId() == null).map(ContractUpdateOrderStatusAtomBO::getOrderId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(qryOrderIds)) {
                CContractOrderInfoPO searchPO = new CContractOrderInfoPO();
                searchPO.setOrderIds(qryOrderIds);
                List<CContractOrderInfoPO> orderInfoPOS = this.cContractOrderInfoMapper.getList(searchPO);
                Map<Long, Long> orderIdMap = orderInfoPOS.stream().filter(e -> e.getOrderId() != null && e.getSaleVoucherId() != null).collect(Collectors.toMap(CContractOrderInfoPO::getOrderId, CContractOrderInfoPO::getSaleVoucherId));
                reqBO.getUpdateBOS().stream().filter(e -> e.getSaleVoucherId() == null).forEach(e -> e.setSaleVoucherId((Long)orderIdMap.get(e.getOrderId())));
            }
            log.info("\u5360\u7528\u8ba2\u5355\u7684\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)reqBO));
            for (ContractUpdateOrderStatusAtomBO updateBO : reqBO.getUpdateBOS()) {
                PebUpdateOrderReqBO pebUpdateOrderReqBO = new PebUpdateOrderReqBO();
                pebUpdateOrderReqBO.setOrderId(updateBO.getOrderId());
                pebUpdateOrderReqBO.setSaleVoucherId(updateBO.getSaleVoucherId());
                pebUpdateOrderReqBO.setType(updateBO.getType());
                pebUpdateOrderReqBO.setContractId(reqBO.getContractId());
                pebUpdateOrderReqBO.setContractNo(reqBO.getContractCode());
                pebUpdateOrderReqBO.setContractName(reqBO.getContractName());
                PebUpdateOrderRspBO pebUpdateOrderRspBO = this.pebUpdateOrderAbilityService.updateHt(pebUpdateOrderReqBO);
                if ("0000".equals(pebUpdateOrderRspBO.getRespCode())) continue;
                throw new ZTBusinessException("\u5360\u7528\u8ba2\u5355\u5931\u8d25,\u8ba2\u5355id\uff1a" + updateBO.getOrderId());
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

