/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.atom.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.bo.ContractWmsReplenishmentQryRspBoMaterialList;
import com.tydic.contract.ability.bo.ContractWmsReplenishmentRspBo;
import com.tydic.contract.atom.ContractWmsReplenishmentQryAtomService;
import com.tydic.contract.atom.bo.ContractWmsReplenishmentQryAtomReqBo;
import com.tydic.contract.atom.bo.ContractWmsReplenishmentQryAtomRspBo;
import com.tydic.contract.utils.HttpUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ContractWmsReplenishmentQryAtomServiceImpl
implements ContractWmsReplenishmentQryAtomService {
    private static final Logger log = LoggerFactory.getLogger(ContractWmsReplenishmentQryAtomServiceImpl.class);
    @Value(value="${WMS_REPLENISHMENT_URL}")
    private String wmsReplenishmentUrl;
    @Value(value="${WMS_REPLENISHMENT_KEY}")
    private String wmsReplenishmentKey;

    @Override
    public ContractWmsReplenishmentQryAtomRspBo qryWmsReplenishmentList(ContractWmsReplenishmentQryAtomReqBo reqBo) {
        ContractWmsReplenishmentQryAtomRspBo rspBO = new ContractWmsReplenishmentQryAtomRspBo();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        JSONObject reqJsonObject = new JSONObject();
        reqJsonObject.put("key", this.wmsReplenishmentKey);
        reqJsonObject.put("data", reqBo);
        String reqStr = JSONObject.toJSONString((Object)reqJsonObject);
        try {
            log.info("\u67e5\u8be2WMS\u5f85\u8865\u8d27\u63a5\u53e3\u5165\u53c2" + reqStr);
            String rspStr = HttpUtil.doPost(this.wmsReplenishmentUrl, reqStr, null);
            log.info("\u67e5\u8be2WMS\u5f85\u8865\u8d27\u63a5\u53e3\u51fa\u53c2" + rspStr);
            rspBO.setRspStr(rspStr);
            this.resolveRsp(rspStr, rspBO);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u67e5\u8be2WMS\u5f85\u8865\u8d27\u63a5\u53e3\u5f02\u5e38" + e.getMessage());
            return rspBO;
        }
        rspBO.setPageNo(reqBo.getPageNo());
        rspBO.setTotal(rspBO.getRecordsTotal() / reqBo.getPageSize() == 0 ? rspBO.getRecordsTotal() / reqBo.getPageSize() : rspBO.getRecordsTotal() / reqBo.getPageSize() + 1);
        return rspBO;
    }

    private void resolveRsp(String rspStr, ContractWmsReplenishmentQryAtomRspBo rspBO) {
        JSONObject jsonObject;
        try {
            if (StringUtils.isEmpty((Object)rspStr)) {
                throw new ZTBusinessException("\u67e5\u8be2WMS\u5f85\u8865\u8d27\u63a5\u53e3\u8fd4\u56de\u62a5\u6587\u4e3a\u7a7a");
            }
            jsonObject = JSONObject.parseObject((String)rspStr);
        }
        catch (Exception e) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u67e5\u8be2WMS\u5f85\u8865\u8d27\u63a5\u53e3\u8fd4\u56de\u62a5\u6587\u4e3a\u7a7a");
            return;
        }
        String code = jsonObject.getString("code");
        if (code == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u67e5\u8be2WMS\u5f85\u8865\u8d27\u63a5\u53e3\u8fd4\u56de\u72b6\u6001\u62a5\u6587\u4e3a\u7a7a");
            return;
        }
        if (!"200".equals(code)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u67e5\u8be2WMS\u5f85\u8865\u8d27\u63a5\u53e3\u8fd4\u56de\u72b6\u6001\u4e3a\u5931\u8d25:" + jsonObject.get((Object)"code") + "," + jsonObject.get((Object)"msg"));
            return;
        }
        JSONArray jsonArray = jsonObject.getJSONArray("rows");
        if (jsonArray == null || jsonArray.isEmpty()) {
            rspBO.setRows(new ArrayList());
            rspBO.setTotal(0);
            rspBO.setPageNo(1);
            rspBO.setRecordsTotal(0);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u67e5\u8be2WMS\u5f85\u8865\u8d27\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        List wmsList = JSONObject.parseArray((String)jsonArray.toString(), ContractWmsReplenishmentRspBo.class);
        if (CollectionUtil.isEmpty((Collection)wmsList)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u67e5\u8be2WMS\u5f85\u8865\u8d27\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        ArrayList<ContractWmsReplenishmentQryRspBoMaterialList> materialList = new ArrayList<ContractWmsReplenishmentQryRspBoMaterialList>();
        for (ContractWmsReplenishmentRspBo wmsBo : wmsList) {
            ContractWmsReplenishmentQryRspBoMaterialList row = new ContractWmsReplenishmentQryRspBoMaterialList();
            row.setWmsId(wmsBo.getId());
            row.setOrganizationId(wmsBo.getErpOrgId());
            row.setOrganizationCode(wmsBo.getErpOrgCode());
            row.setOrganizationName(wmsBo.getErpOrgName());
            row.setSupplierErpCode(wmsBo.getSupplierCode());
            row.setSupplierName(wmsBo.getSupplierName());
            row.setWarehouseId(wmsBo.getWarehouseId());
            row.setWarehouseCode(wmsBo.getWarehouseCode());
            row.setWarehouseName(wmsBo.getWarehouseName());
            row.setWarehouseAddress(wmsBo.getAddress());
            row.setLinkMan(wmsBo.getLinkMan());
            row.setLinkPhone(wmsBo.getLinkPhone());
            row.setMaterialCode(wmsBo.getMatCode());
            row.setMaterialDesc(wmsBo.getMatDesc());
            row.setUnit(wmsBo.getUnitName());
            row.setLimitNum(wmsBo.getMaxStockQty() != null ? wmsBo.getMaxStockQty() : new BigDecimal(0));
            row.setSafeNum(wmsBo.getSafeStockQty() != null ? wmsBo.getSafeStockQty() : new BigDecimal(0));
            row.setRepertoryNum(wmsBo.getQty() != null ? wmsBo.getQty() : new BigDecimal(0));
            row.setStockPendingNum(new BigDecimal(0));
            row.setSuggestNum(row.getSafeNum().subtract(row.getRepertoryNum()));
            materialList.add(row);
        }
        rspBO.setRows(materialList);
        rspBO.setRecordsTotal(Integer.valueOf(jsonObject.getString("total")));
    }
}

