/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.atom.InterFaceContractCancelSignatureAtomService;
import com.tydic.contract.atom.InterFaceContractGetEnvelopesDetailAtomService;
import com.tydic.contract.atom.InterFaceContractSignAccessTokenCreateAtomService;
import com.tydic.contract.atom.bo.InterFaceContractCancelSignatureAtomReqBO;
import com.tydic.contract.atom.bo.InterFaceContractCancelSignatureAtomRspBO;
import com.tydic.contract.atom.bo.InterFaceContractGetEnvelopesDetailAtomReqBO;
import com.tydic.contract.atom.bo.InterFaceContractGetEnvelopesDetailAtomRspBO;
import com.tydic.contract.atom.bo.InterFaceContractSignAccessTokenCreateAtomReqBO;
import com.tydic.contract.atom.bo.InterFaceContractSignAccessTokenCreateAtomRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractPushLogMapper;
import com.tydic.contract.po.ContractPushLogPO;
import com.tydic.contract.utils.HttpUtil;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class InterFaceContractCancelSignatureAtomServiceImpl
implements InterFaceContractCancelSignatureAtomService {
    private static final Logger log = LoggerFactory.getLogger(InterFaceContractCancelSignatureAtomServiceImpl.class);
    @Value(value="${CONTRACT_ENVELOPES_REVOKE_URL}")
    private String contractEnvelopesRevokeUrl;
    @Autowired
    private InterFaceContractSignAccessTokenCreateAtomService interFaceContractSignAccessTokenCreateAtomService;
    @Autowired
    private InterFaceContractGetEnvelopesDetailAtomService interFaceContractGetEnvelopesDetailAtomService;
    @Autowired
    private ContractPushLogMapper contractPushLogMapper;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InterFaceContractCancelSignatureAtomRspBO cancelSignature(InterFaceContractCancelSignatureAtomReqBO reqBO) {
        InterFaceContractCancelSignatureAtomRspBO rspBO = new InterFaceContractCancelSignatureAtomRspBO();
        InterFaceContractGetEnvelopesDetailAtomReqBO atomReqBO = new InterFaceContractGetEnvelopesDetailAtomReqBO();
        atomReqBO.setEnvelopeId(reqBO.getEnvelopeId());
        try {
            String accessToken = this.getAccessToken(reqBO.getClientId(), reqBO.getSecret());
            atomReqBO.setAccessToken(accessToken);
            InterFaceContractGetEnvelopesDetailAtomRspBO atomRspBO = this.interFaceContractGetEnvelopesDetailAtomService.getEnvelopesDetail(atomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) return rspBO;
            if (atomRspBO.getEnvelopeBasicInfo() == null) {
                throw new ZTBusinessException("\u4fe1\u5c01\u57fa\u672c\u4fe1\u606f\u4e3a\u7a7a");
            }
            if (ContractConstant.ContractSignatureEnvelopeStatus.WAITING_TO_SIGN.equals(atomRspBO.getEnvelopeBasicInfo().getStatus())) {
                JSONObject body = new JSONObject();
                body.put("envelopeId", (Object)reqBO.getEnvelopeId());
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("ESB-Authorization", (Object)accessToken);
                ContractPushLogPO insertContractPushLogPO = new ContractPushLogPO();
                insertContractPushLogPO.setId(Sequence.getInstance().nextId());
                insertContractPushLogPO.setCreateTime(new Date());
                insertContractPushLogPO.setReqJson(body.toJSONString());
                insertContractPushLogPO.setType(2);
                String result = HttpUtil.doPost(this.contractEnvelopesRevokeUrl, body.toJSONString(), jsonObject.toJSONString());
                log.info("\u8c03\u7528\u5916\u90e8\u64a4\u9500\u63a5\u53e3\u8fd4\u56de\u62a5\u6587\uff1a" + result);
                insertContractPushLogPO.setRspJson(result);
                this.contractPushLogMapper.insert(insertContractPushLogPO);
                if (StringUtils.isEmpty((Object)result)) {
                    throw new ZTBusinessException("\u62a5\u6587\u8fd4\u56de\u4e3a\u7a7a");
                }
                JSONObject resultObject = null;
                try {
                    resultObject = JSONObject.parseObject((String)result);
                }
                catch (Exception e) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u8c03\u7528\u7b7e\u7ae0\u64a4\u9500\u8fd4\u56de\u72b6\u6001\u62a5\u6587\u4e3a\u7a7a");
                    return rspBO;
                }
                if (resultObject.get((Object)"code") == null) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u8c03\u7528\u7b7e\u7ae0\u64a4\u9500\u8fd4\u56de\u72b6\u6001\u62a5\u6587\u4e3a\u7a7a");
                    if (!StringUtils.isEmpty((Object)resultObject.getString("message"))) {
                        if (!"null".equals(resultObject.getString("message"))) return rspBO;
                    }
                    resultObject.getString("resultMessage");
                    if (StringUtils.isEmpty((Object)resultObject.getString("resultMessage"))) return rspBO;
                    String resultMessage = resultObject.getString("resultMessage");
                    int i = resultMessage.indexOf("{");
                    if (i == -1) return rspBO;
                    JSONObject jsonObject1 = JSONObject.parseObject((String)resultMessage.substring(i));
                    rspBO.setRespDesc(jsonObject1.getString("message"));
                    return rspBO;
                }
                if ("200".equals(resultObject.getString("code"))) {
                    rspBO.setRespCode("0000");
                    rspBO.setRespDesc("\u6210\u529f");
                    return rspBO;
                }
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(jsonObject.getString("message"));
                if (!StringUtils.isEmpty((Object)jsonObject.getString("message"))) {
                    if (!"null".equals(jsonObject.getString("message"))) return rspBO;
                }
                rspBO.setRespDesc(jsonObject.getString("resultMessage"));
                return rspBO;
            }
            if (ContractConstant.ContractSignatureEnvelopeStatus.SIGNED_SUCCESS.equals(atomRspBO.getEnvelopeBasicInfo().getStatus())) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u8be5\u5408\u540c\u7684\u5b9e\u9645\u7b7e\u7ae0\u72b6\u6001\u5904\u4e8e\uff1a\u5df2\u5b8c\u7ed3\uff0c\u4e0d\u53ef\u4ee5\u8fdb\u884c\u64a4\u9500\u64cd\u4f5c\uff01");
                return rspBO;
            }
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5408\u540c\u7684\u5b9e\u9645\u7b7e\u7ae0\u72b6\u6001\uff0c\u672a\u5b8c\u7ed3\u624d\u53ef\u64a4\u9500");
            return rspBO;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rspBO;
    }

    private String getAccessToken(String clientId, String secret) {
        String accessToken = null;
        InterFaceContractSignAccessTokenCreateAtomReqBO signAccessTokenCreateAtomReqBO = new InterFaceContractSignAccessTokenCreateAtomReqBO();
        signAccessTokenCreateAtomReqBO.setClientId(clientId);
        signAccessTokenCreateAtomReqBO.setSecret(secret);
        InterFaceContractSignAccessTokenCreateAtomRspBO signAccessTokenCreateAtomRspBO = this.interFaceContractSignAccessTokenCreateAtomService.signAccessTokenCreate(signAccessTokenCreateAtomReqBO);
        log.info("\u8c03\u7528\u7535\u5b50\u7b7e\u7ae0\u7684\u6388\u6743accessToken\u670d\u52a1:" + JSON.toJSONString((Object)((Object)signAccessTokenCreateAtomRspBO)));
        if (!"0000".equals(signAccessTokenCreateAtomRspBO.getRespCode())) {
            throw new ZTBusinessException(signAccessTokenCreateAtomRspBO.getRespDesc());
        }
        accessToken = signAccessTokenCreateAtomRspBO.getAccessToken();
        return accessToken;
    }
}

