/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.ability.bo.ContractErpImportInfoAddAbilityReqBO;
import com.tydic.contract.ability.bo.ContractErpImportInfoAddAbilityRspBO;
import com.tydic.contract.busi.ContractErpImportInfoAddBusiService;
import com.tydic.contract.dao.CContractErpImportInfoMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.CContractErpImportInfoPO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.utils.ExcelUtils;
import com.tydic.contract.utils.HttpUtil;
import com.tydic.uac.exception.BusinessException;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgDetailBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgListByErpOrgCodesReqBO;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.entity.ContentType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ContractErpImportInfoAddBusiServiceImpl
implements ContractErpImportInfoAddBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractErpImportInfoAddBusiServiceImpl.class);
    @Autowired
    private CContractErpImportInfoMapper cContractErpImportInfoMapper;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;
    private Sequence uccBatchSequence = Sequence.getInstance();
    @Autowired
    private ContractInfoMapper contractInfoMapper;

    @Override
    public ContractErpImportInfoAddAbilityRspBO addErpImportInfo(ContractErpImportInfoAddAbilityReqBO reqBO) {
        ArrayList<String> title = new ArrayList<String>();
        JSONObject data = new JSONObject();
        try {
            File file = new File(System.getProperty("user.dir") + "/temporaryfile/content.xlsx");
            File fileParent = file.getParentFile();
            if (!fileParent.exists()) {
                fileParent.mkdirs();
            }
            HttpUtil.httpDownload(reqBO.getUrl(), file.getAbsolutePath());
            FileInputStream fileInputStream = new FileInputStream(file);
            MockMultipartFile multipartFile = new MockMultipartFile(file.getName(), file.getName(), ContentType.APPLICATION_OCTET_STREAM.toString(), (InputStream)fileInputStream);
            this.getExcelDateByImport((MultipartFile)multipartFile, data, title);
            HttpUtil.deleteFile("temporaryfile/" + file.getName());
        }
        catch (Exception e2) {
            throw new BusinessException("6018", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38: " + e2);
        }
        if (CollectionUtils.isEmpty(title)) {
            throw new BusinessException("6018", "\u6587\u4ef6\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Map)data)) {
            throw new BusinessException("6018", "\u6587\u4ef6\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List<CContractErpImportInfoPO> cContractErpImportInfoPOList = this.getCContractErpImportInfoPOList(data);
        log.debug("\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u6570\u636e\u957f\u5ea6\uff1a" + cContractErpImportInfoPOList.size());
        if (!CollectionUtils.isEmpty(cContractErpImportInfoPOList)) {
            List<String> contractCodes = cContractErpImportInfoPOList.stream().map(CContractErpImportInfoPO::getContractCode).collect(Collectors.toList());
            List busiOrgCodes = cContractErpImportInfoPOList.stream().map(CContractErpImportInfoPO::getBusiOrgCode).collect(Collectors.toList());
            Map<String, String> orgNames = null;
            if (!CollectionUtils.isEmpty(busiOrgCodes)) {
                UmcEnterpriseOrgListByErpOrgCodesReqBO umcEnterpriseOrgListByErpOrgCodesReqBO = new UmcEnterpriseOrgListByErpOrgCodesReqBO();
                umcEnterpriseOrgListByErpOrgCodesReqBO.setErpOrgCodes(busiOrgCodes);
                List umcEnterpriseOrgDetailBOS = this.umcEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgListByErpOrgCodes(umcEnterpriseOrgListByErpOrgCodesReqBO);
                orgNames = umcEnterpriseOrgDetailBOS.stream().collect(Collectors.toMap(UmcEnterpriseOrgDetailBO::getErpOrgCode, UmcEnterpriseOrgDetailBO::getOrgName));
            }
            List<ContractInfoPO> oldPOS = this.contractInfoMapper.getListByContractCodes(contractCodes);
            List<Object> oldcontractCodes = new ArrayList();
            Map<Object, Object> contractCodeMap = new HashMap();
            if (!CollectionUtils.isEmpty(oldPOS)) {
                oldcontractCodes = oldPOS.stream().map(ContractInfoPO::getContractCode).collect(Collectors.toList());
                contractCodeMap = oldPOS.stream().collect(Collectors.groupingBy(ContractInfoPO::getContractCode));
            }
            HashSet<String> insertContractCodes = new HashSet<String>();
            Date nowDate = new Date();
            for (CContractErpImportInfoPO po : cContractErpImportInfoPOList) {
                String insertCode;
                List buynerErpNos;
                po.setId(this.uccBatchSequence.nextId());
                po.setSyncStatus(0);
                po.setUpdateTime(new Date());
                if (reqBO.getUserId() != null) {
                    po.setCreateUserId(reqBO.getUserId().toString());
                }
                po.setCreateUserCode(reqBO.getUsername());
                po.setCreateUserName(reqBO.getName());
                if (reqBO.getOrgIdIn() != null) {
                    po.setCreateCompanyId(reqBO.getOrgIdIn().toString());
                }
                po.setCreateCompanyCode(reqBO.getOrgCodeIn());
                po.setCreateCompanyName(reqBO.getOrgName());
                po.setCreateTime(nowDate);
                if (contractCodeMap.keySet().contains(po.getContractCode()) && (buynerErpNos = ((List)contractCodeMap.get(po.getContractCode())).stream().filter(e -> !StringUtils.isEmpty((Object)e.getBuynerErpNo())).map(ContractInfoPO::getBuynerErpNo).collect(Collectors.toList())).contains(po.getBusiOrgCode())) {
                    po.setSyncStatus(2);
                    po.setSyncRemark("\u8be5\u534f\u8bae\u5728\u6613\u8d2d\u5df2\u5b58\u5728");
                }
                if (null != orgNames) {
                    po.setExtField1(orgNames.get(po.getBusiOrgCode()));
                }
                if (insertContractCodes.contains(insertCode = po.getContractCode() + po.getBusiOrgCode())) {
                    po.setSyncStatus(2);
                    po.setSyncRemark("\u540c\u6279\u6b21\u6570\u636e\u91cd\u590d\u7684\u7f16\u53f7");
                    continue;
                }
                insertContractCodes.add(insertCode);
            }
            this.cContractErpImportInfoMapper.insertBatch(cContractErpImportInfoPOList);
        }
        ContractErpImportInfoAddAbilityRspBO rspBO = new ContractErpImportInfoAddAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private List<CContractErpImportInfoPO> getCContractErpImportInfoPOList(JSONObject excel) {
        JSONArray excelJSON = excel.getJSONArray("excelJSON");
        ArrayList<CContractErpImportInfoPO> cContractErpImportInfoPOList = new ArrayList<CContractErpImportInfoPO>();
        Iterator iterator = excelJSON.iterator();
        while (iterator.hasNext()) {
            CContractErpImportInfoPO cContractErpImportInfoPO = new CContractErpImportInfoPO();
            JSONObject next = (JSONObject)iterator.next();
            cContractErpImportInfoPO.setContractCode(next.getString("\u534f\u8bae\u7f16\u53f7"));
            cContractErpImportInfoPO.setBusiOrgCode(next.getString("\u4e1a\u52a1\u5b9e\u4f53\u7f16\u53f7"));
            if (StringUtils.isEmpty((Object)cContractErpImportInfoPO.getContractCode())) {
                throw new ZTBusinessException("\u534f\u8bae\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)cContractErpImportInfoPO.getBusiOrgCode())) {
                throw new ZTBusinessException("\u4e1a\u52a1\u5b9e\u4f53\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            cContractErpImportInfoPOList.add(cContractErpImportInfoPO);
        }
        return cContractErpImportInfoPOList;
    }

    private void getExcelDateByImport(MultipartFile multipartFile, JSONObject jsonData, List<String> title) {
        try {
            Cell cell;
            ExcelUtils.checkExcelVaild(multipartFile);
            Workbook workbook = ExcelUtils.getWorkbok(multipartFile);
            Sheet sheet = workbook.getSheetAt(0);
            int rowLength = sheet.getLastRowNum();
            Row row = sheet.getRow(0);
            int colLength = row.getLastCellNum();
            for (int i = 0; i < colLength; ++i) {
                cell = row.getCell(i);
                if (cell == null) continue;
                cell.setCellType(CellType.STRING);
                title.add(cell.getStringCellValue());
            }
            JSONArray jsonArray = new JSONArray();
            jsonData.put("excelJSON", (Object)jsonArray);
            for (int i = 1; i <= rowLength; ++i) {
                row = sheet.getRow(i);
                JSONObject rowJson = new JSONObject();
                for (int j = 0; j < colLength; ++j) {
                    cell = row.getCell(j);
                    if (cell == null) continue;
                    rowJson.put(title.get(j), (Object)ContractErpImportInfoAddBusiServiceImpl.getCellValueByCell(cell));
                }
                jsonArray.add((Object)rowJson);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCellValueByCell(Cell cell) {
        if (cell == null || cell.toString().trim().equals("")) {
            return "";
        }
        String cellValue = "";
        CellType cellTypeEnum = cell.getCellTypeEnum();
        switch (cellTypeEnum) {
            case NUMERIC: {
                short format = cell.getCellStyle().getDataFormat();
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    SimpleDateFormat sdf = null;
                    if (format == 20 || format == 32) {
                        sdf = new SimpleDateFormat("HH:mm");
                    } else if (format == 14 || format == 31 || format == 57 || format == 58) {
                        sdf = new SimpleDateFormat("yyyy-MM-dd");
                        double value = cell.getNumericCellValue();
                        Date date = DateUtil.getJavaDate((double)value);
                        cellValue = sdf.format(date);
                    } else {
                        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    }
                    try {
                        cellValue = sdf.format(cell.getDateCellValue());
                        break;
                    }
                    catch (Exception e) {
                        try {
                            throw new Exception("exception on get date data !".concat(e.toString()));
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                            break;
                        }
                    }
                    finally {
                        sdf = null;
                    }
                }
                BigDecimal bd = new BigDecimal(cell.getNumericCellValue() + "");
                cellValue = bd.stripTrailingZeros().toPlainString();
                break;
            }
            case STRING: {
                cellValue = cell.getStringCellValue();
                break;
            }
            case BOOLEAN: {
                cellValue = cell.getBooleanCellValue() + "";
                break;
            }
            default: {
                cellValue = "UNKNOW VALUE";
            }
        }
        return cellValue;
    }
}

